/*
 * Decompiled with CFR 0.152.
 */
package jcckit;

import java.io.FileWriter;
import jcckit.data.DataPlot;
import jcckit.graphic.ClippingRectangle;
import jcckit.plot.PlotCanvas;
import jcckit.renderer.SVGRenderer;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;
import jcckit.util.Format;
import jcckit.util.PropertiesBasedConfigData;

public class SVGPlotter {
    private static final Format HEADER_FORMAT = new Format("<?xml version='1.0' encoding='ISO-8859-1'?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">\n<svg viewBox='%9.7g %9.7g %9.7g %9.7g' preserveAspectRatio='x");

    public static String makeSVG(PlotCanvas canvas, String renderer) {
        ClippingRectangle paper = canvas.getPaper();
        double w = paper.getMaxX() - paper.getMinX();
        double h = paper.getMaxY() - paper.getMinY();
        StringBuffer buffer = new StringBuffer(HEADER_FORMAT.form(new double[]{paper.getMinX(), -paper.getMaxY(), w, h}));
        buffer.append(SVGPlotter.mapAnchor(canvas.getHorizontalAnchor().getFactor())).append('Y').append(SVGPlotter.mapAnchor(2 - canvas.getVerticalAnchor().getFactor())).append("'>\n");
        canvas.getPlot().getCompletePlot().renderWith(((SVGRenderer)Factory.create(renderer)).init(buffer, 1, Math.sqrt(w * w + h * h)));
        buffer.append("</svg>\n");
        return new String(buffer);
    }

    private static String mapAnchor(int anchorFactor) {
        return anchorFactor == 0 ? "Min" : (anchorFactor == 1 ? "Mid" : "Max");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            SVGPlotter.showUsageAndExit();
        }
        int index = 0;
        String propFileName = args[0];
        String outputFileName = null;
        if (propFileName.equals("-o")) {
            if (args.length > 2) {
                outputFileName = args[1];
                propFileName = args[2];
            } else {
                SVGPlotter.showUsageAndExit();
            }
            index += 2;
        }
        propFileName = args[index];
        String renderer = "jcckit.renderer.SVGRenderer";
        if (propFileName.equals("-r")) {
            if (args.length > index + 2) {
                renderer = args[++index];
                propFileName = args[++index];
            } else {
                SVGPlotter.showUsageAndExit();
            }
        }
        ConfigParameters config = new ConfigParameters(new PropertiesBasedConfigData(propFileName));
        PlotCanvas plotCanvas = new PlotCanvas(config);
        plotCanvas.connect(DataPlot.create(config));
        String output = SVGPlotter.makeSVG(plotCanvas, renderer);
        if (outputFileName == null) {
            System.out.println(output);
        } else {
            FileWriter writer = new FileWriter(outputFileName);
            writer.write(output, 0, output.length());
            writer.close();
        }
    }

    private static void showUsageAndExit() {
        System.out.println("Usage: java jcckit.SVGPlotter [-o <output file>] [-r <renderer class>] <properties file>");
        System.exit(1);
    }
}

