/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    private double[][] L;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix Arg) {
        double[][] A = Arg.getArray();
        this.n = Arg.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = Arg.getColumnDimension() == this.n;
        for (int j = 0; j < this.n; ++j) {
            double[] Lrowj = this.L[j];
            double d = 0.0;
            for (int k = 0; k < j; ++k) {
                double[] Lrowk = this.L[k];
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += Lrowk[i] * Lrowj[i];
                }
                Lrowj[k] = s = (A[j][k] - s) / this.L[k][k];
                d += s * s;
                this.isspd &= A[k][j] == A[j][k];
            }
            this.isspd &= (d = A[j][j] - d) > 0.0;
            this.L[j][j] = Math.sqrt(Math.max(d, 0.0));
            for (int k = j + 1; k < this.n; ++k) {
                this.L[j][k] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public Matrix solve(Matrix B) {
        int j;
        if (B.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] X = B.getArrayCopy();
        int nx = B.getColumnDimension();
        for (int k = 0; k < this.n; ++k) {
            for (int i = k + 1; i < this.n; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.L[i][k];
                }
            }
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
        }
        for (int k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.L[k][i];
                }
            }
        }
        return new Matrix(X, this.n, nx);
    }
}

