/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix A) {
        this.LU = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        for (int j = 0; j < this.n; ++j) {
            int k;
            for (int i = 0; i < this.m; ++i) {
                LUcolj[i] = this.LU[i][j];
            }
            int i = 0;
            while (i < this.m) {
                double[] LUrowi = this.LU[i];
                int kmax = Math.min(i, j);
                double s = 0.0;
                for (k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n = i++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (int i2 = j + 1; i2 < this.m; ++i2) {
                if (!(Math.abs(LUcolj[i2]) > Math.abs(LUcolj[p]))) continue;
                p = i2;
            }
            if (p != j) {
                for (int k2 = 0; k2 < this.n; ++k2) {
                    double t = this.LU[p][k2];
                    this.LU[p][k2] = this.LU[j][k2];
                    this.LU[j][k2] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.m & this.LU[j][j] != 0.0)) continue;
            for (int i3 = j + 1; i3 < this.m; ++i3) {
                double[] dArray = this.LU[i3];
                int n = j;
                dArray[n] = dArray[n] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] L = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                L[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return X;
    }

    public Matrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] U = X.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                U[i][j] = i <= j ? this.LU[i][j] : 0.0;
            }
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            p[i] = this.piv[i];
        }
        return p;
    }

    public double[] getDoublePivot() {
        double[] vals = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            vals[i] = this.piv[i];
        }
        return vals;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getColumnDimension();
        Matrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        double[][] X = Xmat.getArray();
        for (int k = 0; k < this.n; ++k) {
            for (int i = k + 1; i < this.n; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        for (int k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.LU[k][k];
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.LU[i][k];
                }
            }
        }
        return Xmat;
    }
}

