/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class SingularValueDecomposition
implements Serializable {
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(Matrix Arg) {
        int i;
        int i2;
        int j;
        int i3;
        int i4;
        int i5;
        double[][] A = Arg.getArrayCopy();
        this.m = Arg.getRowDimension();
        this.n = Arg.getColumnDimension();
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        for (int k = 0; k < Math.max(nct, nrt); ++k) {
            int i6;
            if (k < nct) {
                this.s[k] = 0.0;
                for (int i7 = k; i7 < this.m; ++i7) {
                    this.s[k] = Maths.hypot(this.s[k], A[i7][k]);
                }
                if (this.s[k] != 0.0) {
                    if (A[k][k] < 0.0) {
                        this.s[k] = -this.s[k];
                    }
                    for (i6 = k; i6 < this.m; ++i6) {
                        double[] dArray = A[i6];
                        int n = k;
                        dArray[n] = dArray[n] / this.s[k];
                    }
                    double[] dArray = A[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k] = -this.s[k];
            }
            for (int j2 = k + 1; j2 < this.n; ++j2) {
                if (k < nct & this.s[k] != 0.0) {
                    double t = 0.0;
                    for (i5 = k; i5 < this.m; ++i5) {
                        t += A[i5][k] * A[i5][j2];
                    }
                    t = -t / A[k][k];
                    for (i4 = k; i4 < this.m; ++i4) {
                        double[] dArray = A[i4];
                        int n = j2;
                        dArray[n] = dArray[n] + t * A[i4][k];
                    }
                }
                e[j2] = A[k][j2];
            }
            if (wantu & k < nct) {
                for (i6 = k; i6 < this.m; ++i6) {
                    this.U[i6][k] = A[i6][k];
                }
            }
            if (k >= nrt) continue;
            e[k] = 0.0;
            for (i6 = k + 1; i6 < this.n; ++i6) {
                e[k] = Maths.hypot(e[k], e[i6]);
            }
            if (e[k] != 0.0) {
                if (e[k + 1] < 0.0) {
                    e[k] = -e[k];
                }
                i3 = k + 1;
                while (i3 < this.n) {
                    int n = i3++;
                    e[n] = e[n] / e[k];
                }
                int n = k + 1;
                e[n] = e[n] + 1.0;
            }
            e[k] = -e[k];
            if (k + 1 < this.m & e[k] != 0.0) {
                for (i3 = k + 1; i3 < this.m; ++i3) {
                    work[i3] = 0.0;
                }
                for (j = k + 1; j < this.n; ++j) {
                    for (i4 = k + 1; i4 < this.m; ++i4) {
                        int n = i4;
                        work[n] = work[n] + e[j] * A[i4][j];
                    }
                }
                for (int j3 = k + 1; j3 < this.n; ++j3) {
                    double t = -e[j3] / e[k + 1];
                    for (i2 = k + 1; i2 < this.m; ++i2) {
                        double[] dArray = A[i2];
                        int n = j3;
                        dArray[n] = dArray[n] + t * work[i2];
                    }
                }
            }
            if (!wantv) continue;
            for (i3 = k + 1; i3 < this.n; ++i3) {
                this.V[i3][k] = e[i3];
            }
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            for (int j4 = nct; j4 < nu; ++j4) {
                for (i3 = 0; i3 < this.m; ++i3) {
                    this.U[i3][j4] = 0.0;
                }
                this.U[j4][j4] = 1.0;
            }
            for (int k = nct - 1; k >= 0; --k) {
                if (this.s[k] != 0.0) {
                    for (j = k + 1; j < nu; ++j) {
                        double t = 0.0;
                        for (i = k; i < this.m; ++i) {
                            t += this.U[i][k] * this.U[i][j];
                        }
                        t = -t / this.U[k][k];
                        for (i2 = k; i2 < this.m; ++i2) {
                            double[] dArray = this.U[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t * this.U[i2][k];
                        }
                    }
                    for (i4 = k; i4 < this.m; ++i4) {
                        this.U[i4][k] = -this.U[i4][k];
                    }
                    this.U[k][k] = 1.0 + this.U[k][k];
                    for (int i8 = 0; i8 < k - 1; ++i8) {
                        this.U[i8][k] = 0.0;
                    }
                    continue;
                }
                for (i5 = 0; i5 < this.m; ++i5) {
                    this.U[i5][k] = 0.0;
                }
                this.U[k][k] = 1.0;
            }
        }
        if (wantv) {
            for (int k = this.n - 1; k >= 0; --k) {
                if (k < nrt & e[k] != 0.0) {
                    for (int j5 = k + 1; j5 < nu; ++j5) {
                        double t = 0.0;
                        for (int i9 = k + 1; i9 < this.n; ++i9) {
                            t += this.V[i9][k] * this.V[i9][j5];
                        }
                        t = -t / this.V[k + 1][k];
                        for (i = k + 1; i < this.n; ++i) {
                            double[] dArray = this.V[i];
                            int n = j5;
                            dArray[n] = dArray[n] + t * this.V[i][k];
                        }
                    }
                }
                for (i3 = 0; i3 < this.n; ++i3) {
                    this.V[i3][k] = 0.0;
                }
                this.V[k][k] = 1.0;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        block35: while (p > 0) {
            int kase;
            int k;
            for (k = p - 2; k >= -1 && k != -1; --k) {
                if (!(Math.abs(e[k]) <= eps * (Math.abs(this.s[k]) + Math.abs(this.s[k + 1])))) continue;
                e[k] = 0.0;
                break;
            }
            if (k == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k && ks != k; --ks) {
                    double t = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(this.s[ks]) <= eps * t)) continue;
                    this.s[ks] = 0.0;
                    break;
                }
                if (ks == k) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k = ks;
                }
            }
            ++k;
            switch (kase) {
                case 1: {
                    int i10;
                    double sn;
                    double cs;
                    double t;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j6 = p - 2; j6 >= k; --j6) {
                        t = Maths.hypot(this.s[j6], f);
                        cs = this.s[j6] / t;
                        sn = f / t;
                        this.s[j6] = t;
                        if (j6 != k) {
                            f = -sn * e[j6 - 1];
                            e[j6 - 1] = cs * e[j6 - 1];
                        }
                        if (!wantv) continue;
                        for (i10 = 0; i10 < this.n; ++i10) {
                            t = cs * this.V[i10][j6] + sn * this.V[i10][p - 1];
                            this.V[i10][p - 1] = -sn * this.V[i10][j6] + cs * this.V[i10][p - 1];
                            this.V[i10][j6] = t;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i10;
                    double sn;
                    double cs;
                    double t;
                    double f = e[k - 1];
                    e[k - 1] = 0.0;
                    for (int j7 = k; j7 < p; ++j7) {
                        t = Maths.hypot(this.s[j7], f);
                        cs = this.s[j7] / t;
                        sn = f / t;
                        this.s[j7] = t;
                        f = -sn * e[j7];
                        e[j7] = cs * e[j7];
                        if (!wantu) continue;
                        for (i10 = 0; i10 < this.m; ++i10) {
                            t = cs * this.U[i10][j7] + sn * this.U[i10][k - 1];
                            this.U[i10][k - 1] = -sn * this.U[i10][j7] + cs * this.U[i10][k - 1];
                            this.U[i10][j7] = t;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k])), Math.abs(e[k]));
                    double sp = this.s[p - 1] / scale;
                    double spm1 = this.s[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.s[k] / scale;
                    double ek = e[k] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j8 = k; j8 < p - 1; ++j8) {
                        int i11;
                        double t = Maths.hypot(f, g);
                        double cs = f / t;
                        double sn = g / t;
                        if (j8 != k) {
                            e[j8 - 1] = t;
                        }
                        f = cs * this.s[j8] + sn * e[j8];
                        e[j8] = cs * e[j8] - sn * this.s[j8];
                        g = sn * this.s[j8 + 1];
                        this.s[j8 + 1] = cs * this.s[j8 + 1];
                        if (wantv) {
                            for (i11 = 0; i11 < this.n; ++i11) {
                                t = cs * this.V[i11][j8] + sn * this.V[i11][j8 + 1];
                                this.V[i11][j8 + 1] = -sn * this.V[i11][j8] + cs * this.V[i11][j8 + 1];
                                this.V[i11][j8] = t;
                            }
                        }
                        t = Maths.hypot(f, g);
                        cs = f / t;
                        sn = g / t;
                        this.s[j8] = t;
                        f = cs * e[j8] + sn * this.s[j8 + 1];
                        this.s[j8 + 1] = -sn * e[j8] + cs * this.s[j8 + 1];
                        g = sn * e[j8 + 1];
                        e[j8 + 1] = cs * e[j8 + 1];
                        if (!wantu || j8 >= this.m - 1) continue;
                        for (i11 = 0; i11 < this.m; ++i11) {
                            t = cs * this.U[i11][j8] + sn * this.U[i11][j8 + 1];
                            this.U[i11][j8 + 1] = -sn * this.U[i11][j8] + cs * this.U[i11][j8 + 1];
                            this.U[i11][j8] = t;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k] <= 0.0) {
                        double d = this.s[k] = this.s[k] < 0.0 ? -this.s[k] : 0.0;
                        if (wantv) {
                            for (int i12 = 0; i12 <= pp; ++i12) {
                                this.V[i12][k] = -this.V[i12][k];
                            }
                        }
                    }
                    while (k < pp && !(this.s[k] >= this.s[k + 1])) {
                        int i13;
                        double t = this.s[k];
                        this.s[k] = this.s[k + 1];
                        this.s[k + 1] = t;
                        if (wantv && k < this.n - 1) {
                            for (i13 = 0; i13 < this.n; ++i13) {
                                t = this.V[i13][k + 1];
                                this.V[i13][k + 1] = this.V[i13][k];
                                this.V[i13][k] = t;
                            }
                        }
                        if (wantu && k < this.m - 1) {
                            for (i13 = 0; i13 < this.m; ++i13) {
                                t = this.U[i13][k + 1];
                                this.U[i13][k + 1] = this.U[i13][k];
                                this.U[i13][k] = t;
                            }
                        }
                        ++k;
                    }
                    iter = 0;
                    --p;
                    break;
                }
            }
        }
    }

    public Matrix getU() {
        return new Matrix(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public Matrix getS() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] S = X.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                S[i][j] = 0.0;
            }
            S[i][i] = this.s[i];
        }
        return X;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > tol)) continue;
            ++r;
        }
        return r;
    }
}

