/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.AbstractGDS;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBDriver;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;
import org.firebirdsql.jdbc.FirebirdDriver;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractDriver
implements FirebirdDriver {
    private static final Logger log;
    public static final String CHARSET = "charSet";
    public static final String USE_TRANSLATION = "useTranslation";
    public static final String USER = "user";
    public static final String USER_NAME = "user_name";
    public static final String PASSWORD = "password";
    public static final String DATABASE = "database";
    public static final String BLOB_BUFFER_LENGTH = "blob_buffer_length";
    public static final String TPB_MAPPING = "tpb_mapping";
    private Map mcfToDataSourceMap = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public Connection connect(String url, Properties originalInfo) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        GDSType type = GDSFactory.getTypeForProtocol(url);
        if (type == null) {
            return null;
        }
        try {
            if (originalInfo == null) {
                originalInfo = new Properties();
            }
            HashMap normalizedInfo = FBDriverPropertyManager.normalize(url, originalInfo);
            int qMarkIndex = url.indexOf(63);
            if (qMarkIndex != -1) {
                url = url.substring(0, qMarkIndex);
            }
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
            String databaseURL = GDSFactory.getDatabasePath(type, url);
            mcf.setDatabase(databaseURL);
            for (Map.Entry entry : normalizedInfo.entrySet()) {
                mcf.setNonStandardProperty((String)entry.getKey(), (String)entry.getValue());
            }
            FBConnectionHelper.processTpbMapping(mcf.getGDS(), mcf, originalInfo);
            mcf = mcf.canonicalize();
            FBDataSource dataSource = this.createDataSource(mcf);
            return dataSource.getConnection(mcf.getUserName(), mcf.getPassword());
        }
        catch (ResourceException resex) {
            throw new FBSQLException(resex);
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FBDataSource createDataSource(FBManagedConnectionFactory mcf) throws ResourceException {
        FBDataSource dataSource = null;
        Map map = this.mcfToDataSourceMap;
        synchronized (map) {
            dataSource = (FBDataSource)this.mcfToDataSourceMap.get(mcf);
            if (dataSource == null) {
                dataSource = (FBDataSource)mcf.createConnectionFactory();
                this.mcfToDataSourceMap.put(mcf, dataSource);
            }
        }
        return dataSource;
    }

    @Override
    public FirebirdConnection connect(FirebirdConnectionProperties properties) throws SQLException {
        GDSType type = GDSType.getType(properties.getType());
        if (type == null) {
            type = ((AbstractGDS)GDSFactory.getDefaultGDS()).getType();
        }
        try {
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(type);
            mcf = mcf.canonicalize();
            FBDataSource dataSource = this.createDataSource(mcf);
            return (FirebirdConnection)dataSource.getConnection(mcf.getUserName(), mcf.getPassword());
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public FirebirdConnectionProperties newConnectionProperties() {
        return new FBConnectionProperties();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        Set protocols = GDSFactory.getSupportedProtocols();
        for (String protocol : protocols) {
            if (!url.startsWith(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return FBDriverPropertyManager.getDriverPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    static {
        block2: {
            log = LoggerFactory.getLogger(AbstractDriver.class, false);
            try {
                DriverManager.registerDriver(new FBDriver());
            }
            catch (Exception ex) {
                if (log == null) break block2;
                log.error("Could not register with driver manager", ex);
            }
        }
    }
}

