/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.resource.ResourceException;
import org.firebirdsql.jca.FirebirdLocalTransaction;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class InternalTransactionCoordinator
implements FBObjectListener.StatementListener,
FBObjectListener.BlobListener,
Synchronizable {
    private AbstractTransactionCoordinator coordinator;

    public InternalTransactionCoordinator() {
    }

    @Override
    public Object getSynchronizationObject() throws SQLException {
        if (this.coordinator instanceof AutoCommitCoordinator) {
            return this.coordinator.getConnection();
        }
        return new Object();
    }

    public InternalTransactionCoordinator(AbstractTransactionCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executionStarted(AbstractStatement stmt) throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.coordinator.executionStarted(stmt);
        }
    }

    @Override
    public AbstractConnection getConnection() throws SQLException {
        return this.coordinator.getConnection();
    }

    @Override
    public void statementClosed(AbstractStatement stmt) throws SQLException {
        this.coordinator.statementClosed(stmt);
    }

    @Override
    public void statementCompleted(AbstractStatement stmt) throws SQLException {
        this.statementCompleted(stmt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statementCompleted(AbstractStatement stmt, boolean success) throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.coordinator.statementCompleted(stmt, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executionCompleted(FirebirdBlob blob) throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.coordinator.executionCompleted(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executionStarted(FirebirdBlob blob) throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.coordinator.executionStarted(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureTransaction() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.coordinator.ensureTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.coordinator.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.coordinator.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoordinator(AbstractTransactionCoordinator coordinator) throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            if (this.coordinator != null) {
                this.coordinator.completeStatements(AbstractStatement.CompletionReason.COMMIT);
                coordinator.setStatements(this.coordinator.getStatements());
            }
            this.coordinator = coordinator;
        }
    }

    public static class MetaDataTransactionCoordinator
    extends AbstractTransactionCoordinator {
        private InternalTransactionCoordinator tc;

        public MetaDataTransactionCoordinator(InternalTransactionCoordinator tc) {
            super(((InternalTransactionCoordinator)tc).coordinator.connection, ((InternalTransactionCoordinator)tc).coordinator.connection.getLocalTransaction());
            this.tc = tc;
        }

        public MetaDataTransactionCoordinator() {
            super(null, null);
        }

        @Override
        public void ensureTransaction() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void commit() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rollback() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void executionStarted(AbstractStatement stmt) throws SQLException {
            if (this.tc == null) {
                return;
            }
            this.tc.ensureTransaction();
        }

        @Override
        public void statementClosed(AbstractStatement stmt) throws SQLException {
            if (this.tc == null) {
                return;
            }
            stmt.completeStatement();
            ((InternalTransactionCoordinator)this.tc).coordinator.connection.notifyStatementClosed(stmt);
        }

        @Override
        public void statementCompleted(AbstractStatement stmt) throws SQLException {
            this.statementCompleted(stmt, true);
        }

        @Override
        public void statementCompleted(AbstractStatement stmt, boolean success) throws SQLException {
            if (this.connection == null) {
                return;
            }
            if (!this.connection.getAutoCommit()) {
                return;
            }
            try {
                if (!this.localTransaction.inTransaction()) {
                    return;
                }
                if (success) {
                    this.localTransaction.commit();
                } else {
                    this.localTransaction.rollback();
                }
            }
            catch (ResourceException ex) {
                try {
                    if (this.localTransaction.inTransaction()) {
                        this.localTransaction.rollback();
                    }
                }
                catch (ResourceException ex1) {
                    throw new FBSQLException(ex1);
                }
                throw new FBSQLException(ex);
            }
        }

        @Override
        public void executionCompleted(FirebirdBlob blob) throws SQLException {
        }

        @Override
        public void executionStarted(FirebirdBlob blob) throws SQLException {
        }
    }

    public static class ManagedTransactionCoordinator
    extends LocalTransactionCoordinator {
        public ManagedTransactionCoordinator(AbstractConnection connection) {
            super(connection, null);
        }

        protected void completeStatements() throws SQLException {
            SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
            Object[] statementsToComplete = this.statements.toArray();
            for (int i = 0; i < statementsToComplete.length; ++i) {
                AbstractStatement statement = (AbstractStatement)statementsToComplete[i];
                try {
                    statement.completeStatement();
                    continue;
                }
                catch (SQLException ex) {
                    chain.append(ex);
                }
            }
            this.statements.clear();
            if (chain.hasException()) {
                throw chain.getException();
            }
        }

        @Override
        public void ensureTransaction() throws SQLException {
        }

        @Override
        public void executionStarted(AbstractStatement stmt) throws SQLException {
        }

        @Override
        public void commit() throws SQLException {
        }

        @Override
        public void rollback() throws SQLException {
        }

        @Override
        public void executionStarted(FirebirdBlob blob) throws SQLException {
        }
    }

    public static class LocalTransactionCoordinator
    extends AbstractTransactionCoordinator {
        public LocalTransactionCoordinator(AbstractConnection connection, FirebirdLocalTransaction localTransaction) {
            super(connection, localTransaction);
        }

        @Override
        public void ensureTransaction() throws SQLException {
            try {
                if (!this.localTransaction.inTransaction()) {
                    this.localTransaction.begin();
                }
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }

        @Override
        public void commit() throws SQLException {
            try {
                if (this.localTransaction.inTransaction()) {
                    this.localTransaction.commit();
                }
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }

        @Override
        public void rollback() throws SQLException {
            try {
                if (this.localTransaction.inTransaction()) {
                    this.localTransaction.rollback();
                }
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }

        @Override
        public void executionStarted(AbstractStatement stmt) throws SQLException {
            this.ensureTransaction();
        }

        @Override
        public void statementClosed(AbstractStatement stmt) throws SQLException {
            stmt.completeStatement();
            this.connection.notifyStatementClosed(stmt);
        }

        @Override
        public void statementCompleted(AbstractStatement stmt) throws SQLException {
        }

        @Override
        public void statementCompleted(AbstractStatement stmt, boolean success) throws SQLException {
        }

        @Override
        public void executionCompleted(FirebirdBlob blob) throws SQLException {
        }

        @Override
        public void executionStarted(FirebirdBlob blob) throws SQLException {
            this.ensureTransaction();
        }
    }

    public static class AutoCommitCoordinator
    extends AbstractTransactionCoordinator {
        public AutoCommitCoordinator(AbstractConnection connection, FirebirdLocalTransaction localTransaction) {
            super(connection, localTransaction);
        }

        @Override
        public void executionStarted(AbstractStatement stmt) throws SQLException {
            ArrayList tempList = new ArrayList(this.statements);
            SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
            Iterator iter = tempList.iterator();
            while (iter.hasNext()) {
                AbstractStatement tempStatement = (AbstractStatement)iter.next();
                if (tempStatement == stmt) {
                    iter.remove();
                    continue;
                }
                try {
                    tempStatement.completeStatement(AbstractStatement.CompletionReason.COMMIT);
                }
                catch (SQLException e) {
                    chain.append(e);
                }
            }
            this.statements.removeAll(tempList);
            if (chain.hasException()) {
                throw chain.getException();
            }
            if (!this.statements.contains(stmt)) {
                this.statements.add(stmt);
            }
            this.ensureTransaction();
        }

        @Override
        public void ensureTransaction() throws SQLException {
            try {
                if (!this.localTransaction.inTransaction()) {
                    this.localTransaction.begin();
                }
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }

        @Override
        public void statementClosed(AbstractStatement stmt) throws SQLException {
            stmt.completeStatement();
            this.connection.notifyStatementClosed(stmt);
        }

        @Override
        public void statementCompleted(AbstractStatement stmt) throws SQLException {
            this.statementCompleted(stmt, true);
        }

        @Override
        public void statementCompleted(AbstractStatement stmt, boolean success) throws SQLException {
            this.statements.remove(stmt);
            try {
                if (!this.localTransaction.inTransaction()) {
                    return;
                }
                if (success) {
                    this.localTransaction.commit();
                } else {
                    this.localTransaction.rollback();
                }
            }
            catch (ResourceException ex) {
                try {
                    if (this.localTransaction.inTransaction()) {
                        this.localTransaction.rollback();
                    }
                }
                catch (ResourceException ex1) {
                    throw new FBSQLException(ex1);
                }
                throw new FBSQLException(ex);
            }
        }

        @Override
        public void executionCompleted(FirebirdBlob blob) throws SQLException {
        }

        @Override
        public void executionStarted(FirebirdBlob blob) throws SQLException {
            this.ensureTransaction();
        }

        @Override
        public void commit() throws SQLException {
            throw new FBSQLException("Calling commit() in auto-commit mode is not allowed.");
        }

        @Override
        public void rollback() throws SQLException {
            throw new FBSQLException("Calling rollback() in auto-commit mode is not allowed.");
        }
    }

    public static abstract class AbstractTransactionCoordinator
    implements FBObjectListener.StatementListener,
    FBObjectListener.BlobListener {
        protected FirebirdLocalTransaction localTransaction;
        protected AbstractConnection connection;
        protected Collection statements = new ArrayList();

        protected AbstractTransactionCoordinator(AbstractConnection connection, FirebirdLocalTransaction localTransaction) {
            this.localTransaction = localTransaction;
            this.connection = connection;
        }

        @Override
        public AbstractConnection getConnection() throws SQLException {
            return this.connection;
        }

        protected Collection getStatements() {
            return this.statements;
        }

        protected void setStatements(Collection statements) {
            this.statements.addAll(statements);
        }

        protected void completeStatements(AbstractStatement.CompletionReason reason) throws SQLException {
            SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
            Object[] statementsToComplete = this.statements.toArray();
            for (int i = 0; i < statementsToComplete.length; ++i) {
                AbstractStatement statement = (AbstractStatement)statementsToComplete[i];
                try {
                    statement.completeStatement(reason);
                    continue;
                }
                catch (SQLException ex) {
                    chain.append(ex);
                }
            }
            this.statements.clear();
            try {
                if (this.localTransaction.inTransaction()) {
                    this.localTransaction.commit();
                }
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
            if (chain.hasException()) {
                throw chain.getException();
            }
        }

        public abstract void ensureTransaction() throws SQLException;

        public abstract void commit() throws SQLException;

        public abstract void rollback() throws SQLException;
    }
}

