/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdStatement;
import org.firebirdsql.pool.PingablePooledConnection;
import org.firebirdsql.pool.PooledConnectionQueue;
import org.firebirdsql.pool.XPreparedStatementModel;

class FBPooledConnection
extends PingablePooledConnection
implements XAConnection {
    private FBManagedConnection managedConnection;
    private FBManagedConnectionEvetListener listener = new FBManagedConnectionEvetListener();

    public FBPooledConnection(FBManagedConnection managedConnection, FBConnectionRequestInfo cri, boolean statementPooling, int maxStatements, boolean keepStatements, PooledConnectionQueue owningQueue) throws SQLException, ResourceException {
        super((Connection)managedConnection.getConnection(null, cri), statementPooling, maxStatements, keepStatements, owningQueue);
        this.managedConnection = managedConnection;
        this.managedConnection.addConnectionEventListener(this.listener);
    }

    protected FBPooledConnection(FBManagedConnection managedConnection, FBConnectionRequestInfo cri, String pingStatement, int pingInterval, boolean statementPooling, int maxStatements, boolean keepStatements, PooledConnectionQueue owningQueue) throws SQLException, ResourceException {
        super((Connection)managedConnection.getConnection(null, cri), pingStatement, pingInterval, statementPooling, maxStatements, keepStatements, owningQueue);
        this.managedConnection = managedConnection;
        this.managedConnection.addConnectionEventListener(this.listener);
    }

    @Override
    protected void configureConnectionDefaults(Connection connection) throws SQLException {
        if (!this.managedConnection.isManagedEnvironment()) {
            connection.setAutoCommit(true);
        }
        connection.setReadOnly(false);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.managedConnection.getXAResource();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        try {
            this.managedConnection.destroy();
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public void statementClosed(XPreparedStatementModel key, Object proxy) throws SQLException {
        FirebirdStatement fbStmt;
        ResultSet rs;
        if (proxy instanceof FirebirdStatement && (rs = (fbStmt = (FirebirdStatement)proxy).getCurrentResultSet()) != null) {
            rs.close();
        }
        super.statementClosed(key, proxy);
    }

    void setManagedEnvironment(boolean managedEnvironment) throws SQLException {
        try {
            this.managedConnection.setManagedEnvironment(managedEnvironment);
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    private static class FBManagedConnectionEvetListener
    implements ConnectionEventListener {
        private FBManagedConnectionEvetListener() {
        }

        @Override
        public void connectionClosed(ConnectionEvent event) {
            block2: {
                PrintWriter externalLog = ((FBManagedConnection)event.getSource()).getLogWriter();
                try {
                    ((FBManagedConnection)event.getSource()).destroy();
                }
                catch (ResourceException e) {
                    if (externalLog == null) break block2;
                    externalLog.println("Exception closing unmanaged connection: " + e);
                }
            }
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            block2: {
                PrintWriter externalLog = ((FBManagedConnection)event.getSource()).getLogWriter();
                try {
                    ((FBManagedConnection)event.getSource()).destroy();
                }
                catch (ResourceException e) {
                    if (externalLog == null) break block2;
                    externalLog.println("Exception closing unmanaged connection: " + e);
                }
            }
        }

        @Override
        public void localTransactionCommitted(ConnectionEvent event) {
        }

        @Override
        public void localTransactionRolledback(ConnectionEvent event) {
        }

        @Override
        public void localTransactionStarted(ConnectionEvent event) {
        }
    }
}

