/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.apps;

import edu.uml.giro.gambit.apps.GambitAppSettings;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.reports.Reports;
import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.api.UserRole;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseContents;
import edu.uml.lgdc.database.DatabaseFarm;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.commandlineparams.CommandLineParam;
import edu.uml.lgdc.project.commandlineparams.SharedResourcesDir;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class GambitCoefOutput {
    public static final String INI_FILE_NAME = "GambitCoeffsOutput.ini";
    public static final String VERSION = "GAMBIT Database Text File Output v0.1";
    private static Application application = Application.get("GambitExplorer_UserApp");
    private static ApplicationPassport appPassport = null;
    private static GambitAppSettings settings = null;
    static TimeScale startDate = null;
    static TimeScale stopDate = null;
    protected static GambitCore gambitCore;
    protected static Reports reports;

    static {
        settings = new GambitAppSettings(INI_FILE_NAME);
        appPassport = new ApplicationPassport(application, UserRole.BROWSER, true, 0, null);
        DBConnect gambitDb = new DBConnect(settings.getDatabaseConnectionSettings().getConnectionRequisites("GAMBIT-DB"), DatabaseContents.IRTAM.getId(), 0);
        DatabaseFarm farm = new DatabaseFarm();
        farm.addConnect(gambitDb);
        farm.activateDefaultConnections();
        LgdcRegistry.addDatabaseFarm(appPassport, farm);
        gambitCore = new GambitCore(appPassport, GambitCoefOutput.settings.gambitCoreSettings);
        reports = new Reports(gambitCore, settings, appPassport.getUserCredentials());
    }

    public GambitCoefOutput() {
        System.out.println(VERSION);
        System.out.println("Online with Gambit Database at " + LgdcRegistry.lookupDatabaseFarm(application, DatabaseContents.IRTAM).getActiveDatabaseConnect(DatabaseContents.IRTAM).getRequisites().getURL());
        System.out.println("Run coefficient output from " + startDate.toString() + " to " + stopDate.toString());
        TimeScale tov = gambitCore.getDefaultTimeGrid().snapToClosestGrid(startDate);
        PrintWriter writer = null;
        while (!tov.after(stopDate)) {
            System.out.println("Reading GAMBIT record for " + tov.toHumanUT() + "...");
            gambitCore.setTimeOfValidity(tov, 3, gambitCore.getGambitDatabaseReader().getBestAvailableVersions());
            String subfolder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + "COEFFS_" + tov.toFormatUT("yyyy") + File.separator;
            File checkDir = new File(subfolder);
            if (!checkDir.exists()) {
                checkDir.mkdir();
            }
            if (!(checkDir = new File(subfolder = String.valueOf(subfolder) + tov.toFormatUT("yyyy_MM_dd") + File.separator)).exists()) {
                checkDir.mkdir();
            }
            CharChoice[] charChoiceArray = CharChoice.values();
            int n = charChoiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CharChoice cc = charChoiceArray[n2];
                if (CharChoice.isAssimilatedChar(cc)) {
                    String filename = String.valueOf(subfolder) + "IRTAM_" + cc.getName4char() + "_COEFFS_" + gambitCore.getTimeOfValidity().toFilenameAternative() + ".ASC";
                    try {
                        writer = new PrintWriter(filename);
                        reports.writeCoeffs(GambitCoefOutput.gambitCore.getChars()[cc.getIndex()].weather, writer, VERSION, appPassport.getUserCredentials());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            tov.add(12, gambitCore.getDefaultTimeGrid().getTimeStep_min());
        }
        LgdcRegistry.releaseAllResources();
        System.out.println("\nFinished.");
    }

    public static void main(String[] args) {
        CommandLineParam commandLineParam = new CommandLineParam(args);
        String errMsg = commandLineParam.checkParams(GambitConstants.KEYS, GambitConstants.KEY_TYPES, true);
        if (errMsg != null) {
            System.out.println(errMsg);
            System.exit(1);
        }
        if (!SharedResourcesDir.readAndSet(commandLineParam)) {
            Console.showError(SharedResourcesDir.getErrMsg());
            System.exit(1);
        }
        try {
            TimeScale[] timeRange = GambitConstants.getTimePeriod(commandLineParam);
            startDate = timeRange[0];
            stopDate = timeRange[1];
            if (startDate == null || stopDate == null) {
                Console.showError("illegal time-range format");
                System.exit(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GambitCoefOutput grex = new GambitCoefOutput();
    }
}

