/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.apps;

import edu.uml.giro.gambit.apps.GambitAppSettings;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.core.LocalDataOneSiteAllTimes;
import edu.uml.giro.gambit.database.MadrigalClient;
import edu.uml.giro.gambit.display.Chart;
import edu.uml.giro.gambit.display.ChartCurves;
import edu.uml.giro.gambit.display.DisplayDataBuilder;
import edu.uml.giro.gambit.display.GambitLayers;
import edu.uml.giro.gambit.display.MinMaxForDisplay;
import edu.uml.giro.gambit.display.WWindowManager;
import edu.uml.giro.gambit.gui.ChartIconSelectHandler;
import edu.uml.giro.gambit.gui.ConsoleFrame;
import edu.uml.giro.gambit.gui.FlatWorldPanel;
import edu.uml.giro.gambit.gui.GAMBITExplorerControlPanel;
import edu.uml.giro.gambit.reports.Reports;
import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.api.UserCredentials;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.database.DatabaseContents;
import edu.uml.lgdc.database.DatabaseFarm;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.commandlineparams.CommandLineParam;
import edu.uml.lgdc.project.commandlineparams.SharedResourcesDir;
import edu.uml.lgdc.time.TimeScale;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.layermanager.ElevationModelManagerPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GambitUserApp
extends ApplicationTemplate {
    private static JFrame consoleFrame;
    protected static Application application;
    protected static ApplicationPassport appPassport;
    protected static GambitAppSettings gambitAppSettings;
    private static final String INI_FILE_NAME = "Gambit_UserApp.ini";

    static {
        gambitAppSettings = null;
    }

    public static void setupParams() {
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLatitude", (Object)0);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialLongitude", (Object)0);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.InitialAltitude", (Object)5.0E7);
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.GlobeClassName", (Object)EarthFlat.class.getName());
        Configuration.setValue((String)"gov.nasa.worldwind.avkey.ViewClassName", (Object)FlatOrbitView.class.getName());
    }

    private static JFrame getConsoleFrame() {
        JFrame frame = new JFrame();
        frame.add((Component)new JLabel(" Output:"), "North");
        JTextArea ta = new JTextArea();
        final ConsoleFrame console = new ConsoleFrame(ta, 100);
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                console.clear();
            }
        });
        frame.add((Component)clear, "South");
        PrintStream ps = new PrintStream(console);
        System.setOut(ps);
        System.setErr(ps);
        frame.add(new JScrollPane(ta));
        frame.setSize(600, 600);
        frame.setVisible(false);
        frame.setDefaultCloseOperation(1);
        return frame;
    }

    protected static void initConsole() {
        consoleFrame = GambitUserApp.getConsoleFrame();
    }

    public static void main(String[] args) {
        CommandLineParam commandLineParam = new CommandLineParam(args);
        String errMsg = commandLineParam.checkParams(GambitConstants.KEYS, GambitConstants.KEY_TYPES, true);
        if (errMsg != null) {
            System.err.println(errMsg);
            System.exit(1);
        }
        if (!SharedResourcesDir.readAndSet(commandLineParam)) {
            Console.showError(SharedResourcesDir.getErrMsg());
            System.exit(1);
        }
        GambitUserApp.setupParams();
        try {
            GambitUserApp.start((String)"Global Assimilative Model of Bottomside Ionosphere Timeline", AppFrame.class);
            GambitUserApp.initConsole();
        }
        catch (UnsatisfiedLinkError e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "", 1);
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        GambitLayers gambitLayers;
        protected GAMBITExplorerControlPanel controlPanel;
        private FlatWorldPanel flatWorldPanel;
        private ChartIconSelectHandler reportIconSelectHandler = new ChartIconSelectHandler(core.getTimeOfValidity(), this);
        private WWIcon highlightIcon;
        protected static GambitCore core;
        protected static Reports reports;

        static {
            gambitAppSettings = new GambitAppSettings(String.valueOf(GambitConstants.USER_FOLDER) + GambitUserApp.INI_FILE_NAME);
            MinMaxForDisplay.putUserSettings(gambitAppSettings.getGambitColorscaleSettings());
            LgdcRegistry.setDbErrorHandlingMode(3);
            Map<ApplicationPassport, DatabaseFarm> existingFarms = LgdcRegistry.getDatabaseFarms(Application.GAMBIT_EXPLORER_MASTERAPP);
            if (existingFarms.size() > 0) {
                application = Application.GAMBIT_EXPLORER_MASTERAPP;
            } else {
                application = Application.GAMBIT_EXPLORER_USERAPP;
                UserCredentials userCreds = new UserCredentials();
                LgdcRegistry.setDbErrorHandlingMode(1);
                try {
                    File gambitInfoFile = new File(new File(GambitConstants.USER_FOLDER), "gambit_info.txt");
                    File guestInfoFile = new File(new File(GambitConstants.USER_FOLDER), "guest_info.txt");
                    userCreds.read(application, guestInfoFile, gambitInfoFile);
                    Console.showMsg("Starting login to LGDC Registry...");
                    LgdcRegistry.buildDatabaseFarmsByUrl(application, userCreds, "GX.User 1.3F", System.getProperty("os.name"));
                    Console.showMsg("Database farm built.");
                    Map<ApplicationPassport, DatabaseFarm> allFarms = LgdcRegistry.getDatabaseFarms(Application.GAMBIT_EXPLORER_USERAPP);
                    Console.showMsg("Total database farms for " + (Object)((Object)application) + ": " + allFarms.size());
                    for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : allFarms.entrySet()) {
                        appPassport = oneFarm.getKey();
                        DatabaseFarm farm = oneFarm.getValue();
                        if (!farm.isAvailable(DatabaseContents.IRTAM)) continue;
                        MadrigalClient.setUserCredentials(userCreds);
                        Console.showMsg("Activating default connections of the farm...");
                        farm.activateDefaultConnections();
                        int index = farm.getActiveDatabaseIndex(DatabaseContents.IRTAM);
                        if (index != -1) {
                            Console.showMsg("IRTAM content is active.");
                            continue;
                        }
                        Console.showError("Could not activate connection to GAMBIT Database");
                    }
                }
                catch (FileNotFoundException e1) {
                    throw new RuntimeException("No configuration files found with user/guest credentials: " + e1.getMessage());
                }
                catch (SQLException e2) {
                    throw new RuntimeException("SQL exception while connecting to the farm: " + e2.getMessage());
                }
                if (appPassport == null) {
                    throw new RuntimeException("Unable to authenticate access to any GAMBIT database; quitting now");
                }
            }
            core = new GambitCore(appPassport, GambitUserApp.gambitAppSettings.gambitCoreSettings);
            reports = new Reports(core, gambitAppSettings, appPassport.getUserCredentials());
        }

        public AppFrame() {
            super(true, true, false);
            this.setSize(1280, 720);
            WWindowManager.removeUnusedLayers(this);
            WWindowManager.turnOffScaleBar(this);
            WWindowManager.turnOffWorldMap(this);
            this.gambitLayers = new GambitLayers(this.getWwd(), core, GambitUserApp.gambitAppSettings.gambitDisplaySettings);
            reports.setFrame(this);
            JPanel controls = new JPanel();
            controls.setLayout(new BoxLayout(controls, 1));
            controls.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
            JPanel logoPanel = new JPanel();
            JLabel logoLabel = new JLabel();
            logoLabel.setIcon(new ImageIcon(AppFrame.class.getResource("RTAM-logo.gif")));
            this.removeElevationControlPanel((JPanel)this.getLayerPanel());
            this.removeFlatWorldPanel(this.getControlPanel());
            this.controlPanel = new GAMBITExplorerControlPanel(this, this.gambitLayers, core, gambitAppSettings);
            controls.add(this.controlPanel);
            this.flatWorldPanel = new FlatWorldPanel(this.getWwd());
            this.gambitLayers.setCurrentViewType(WWindowManager.setFlatView(this, this.flatWorldPanel));
            controls.add(this.flatWorldPanel);
            this.getWwd().addSelectListener((SelectListener)this.reportIconSelectHandler);
            this.getControlPanel().add((Component)controls, "North");
            this.getControlPanel().add((Component)logoPanel, "South");
            TimeScale initialTime = GambitUserApp.gambitAppSettings.querySettings.getStartTime();
            if (initialTime == null) {
                initialTime = TimeScale.parseNoException("2015.03.17T23:45");
            }
            core.setTimeOfValidity(initialTime, 16, core.getGambitDatabaseReader().getBestAvailableVersions());
            this.controlPanel.setDate(core.getTimeOfValidity());
            core.setCurrentMapChoice(MapChoice.FOF2_CLIMATE);
            this.gambitLayers.refreshMagneticEquatorLayer(core.getTimeOfValidity());
            this.gambitLayers.refreshSolarTerminatorLayer(core.getTimeOfValidity(), 1);
            this.gambitLayers.buildDataRenderables(core.getTimeOfValidity(), null, 1);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    LgdcRegistry.releaseAllResources();
                    gambitAppSettings.getOptionsIO().save();
                }
            });
        }

        private void removeFlatWorldPanel(JPanel controlPanel) {
            Component[] componentList;
            Component[] componentArray = componentList = controlPanel.getComponents();
            int n = componentList.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof gov.nasa.worldwindx.examples.FlatWorldPanel) {
                    controlPanel.remove(c);
                }
                ++n2;
            }
        }

        private void removeElevationControlPanel(JPanel controlPanel) {
            Component[] componentList;
            Component[] componentArray = componentList = controlPanel.getComponents();
            int n = componentList.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof ElevationModelManagerPanel) {
                    controlPanel.remove(c);
                }
                ++n2;
            }
        }

        public void setConsoleFrameVisible(boolean flag) {
            consoleFrame.setVisible(flag);
        }

        public boolean isMasterAccess() {
            return false;
        }

        public void showIcons(HashMap<String, String[]> controlSites) {
            TimeScale time = core.getTimeOfValidity();
            if (!core.getTimeOfValidity().equals(time)) {
                int databaseMode = 0;
                if (GambitUserApp.gambitAppSettings.gambitCoreSettings.isDownloadObservations()) {
                    databaseMode += 2;
                }
                if (GambitUserApp.gambitAppSettings.gambitCoreSettings.isDownloadGlobalWeather()) {
                    ++databaseMode;
                }
                if (GambitUserApp.gambitAppSettings.gambitCoreSettings.isDownloadLocalWeather()) {
                    databaseMode += 32;
                }
                core.setTimeOfValidity(time, databaseMode += 16, AppFrame.core.VERSIONS);
            }
            this.reportIconSelectHandler.update(time, this.highlightIcon);
            DisplayDataBuilder.fillSiteAttributes(core.getLocalData(core.getCurrentSitesChoice().getCC()));
            this.gambitLayers.redrawReportIconLayer(time);
        }

        public GambitLayers getGambitLayers() {
            return this.gambitLayers;
        }

        public void removeReportIconLayer() {
            this.gambitLayers.removeIconLayer();
        }

        public void showWWdCapture(TimeScale time) {
            WWindowManager.makeWwdCapture(this.getWwd(), "temp_LT", time, null, true, null, 0, 0, 0);
            try {
                JFrame frame = new JFrame(){
                    private Image backgroundImage = ImageIO.read(new File(String.valueOf(GambitConstants.MOVIES_OUTPUT_FOLDER) + "temp_LT"));

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        g.drawImage(this.backgroundImage, 0, 0, null);
                    }
                };
                frame.setSize(((Component)this.getWwd()).getSize());
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
            catch (HeadlessException headlessException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void updateChartsTime(TimeScale timeOfValidity) {
            this.reportIconSelectHandler.update(timeOfValidity, this.highlightIcon);
        }

        public void showChart(TimeScale time, int stationIndex, String title) {
            CharChoice cc = core.getCurrentSitesChoice().getCC();
            LocalDataOneSiteAllTimes site = AppFrame.core.getLocalData((CharChoice)cc).sites[stationIndex];
            ChartCurves plotData = DisplayDataBuilder.prepareChartCurves(AppFrame.core.getLocalData((CharChoice)cc).sites[stationIndex], gambitAppSettings.getGambitChartSettings());
            double yMax = gambitAppSettings.getGambitChartYmaxSettings().getYmax(cc);
            double yMin = gambitAppSettings.getGambitChartYminSettings().getYmin(cc);
            Chart reportplotMulti = new Chart(core, cc, stationIndex, plotData, core.getLocalData(cc).getTimeGrid().getUTs(), time, site.getLocation(), yMin, yMax, true, String.valueOf(cc.getName()) + " " + cc.getUnits());
            reportplotMulti.plot(true, title);
            this.getWwd().redraw();
        }

        public Reports getReports() {
            return reports;
        }
    }
}

