/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.coefficients;

import edu.uml.giro.gambit.coefficients.Coefficients;
import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.lgdc.format.FC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.MissingResourceException;

public abstract class Coefficients2D
extends Coefficients<double[][]> {
    double[][] coeffs = null;

    @Override
    public double[][] get() {
        return this.coeffs;
    }

    @Override
    public void put(double[][] coeffs) {
        this.coeffs = coeffs;
    }

    public void putOne(int i, int j, double value) {
        this.coeffs[i][j] = value;
    }

    public double[][] clone() {
        if (this.coeffs == null) {
            return null;
        }
        double[][] newc = new double[this.coeffs.length][this.coeffs[0].length];
        int i = 0;
        while (i < this.coeffs.length) {
            int j = 0;
            while (j < this.coeffs[i].length) {
                newc[i][j] = this.coeffs[i][j];
                ++j;
            }
            ++i;
        }
        return newc;
    }

    @Override
    public void reset() {
        if (this.coeffs != null) {
            int i = 0;
            while (i < this.coeffs.length) {
                int j = 0;
                while (j < this.coeffs[i].length) {
                    this.coeffs[i][j] = 0.0;
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void exportCoefficientsToTextFile(PrintWriter writer) {
        int count = 0;
        int i = 0;
        while (i < this.coeffs.length) {
            int j = 0;
            while (j < this.coeffs[i].length) {
                writer.write(" " + FC.DoubleToString(this.coeffs[i][j], 15, 8));
                if (++count == 4) {
                    writer.write("\n");
                    count = 0;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public ByteArrayInputStream toInputStream() {
        if (this.coeffs == null) {
            throw new MissingResourceException("Call to build a coefficients input stream without coefficients", this.getClass().getName(), null);
        }
        if (this.basis == null) {
            throw new MissingResourceException("Call to build a coefficients input stream without basis", this.getClass().getName(), null);
        }
        ExpansionBasis2D basis2d = (ExpansionBasis2D)this.basis;
        ByteArrayOutputStream byteAOS = new ByteArrayOutputStream(basis2d.getCompactSpatialBasisLength() * basis2d.getTemporalBasisLength() * 8);
        try {
            DataOutputStream out = new DataOutputStream(byteAOS);
            int iSpatial = 0;
            while (iSpatial < basis2d.getCompactSpatialBasisLength()) {
                int iDiurnal = 0;
                while (iDiurnal < basis2d.getTemporalBasisLength()) {
                    out.writeDouble(this.coeffs[iSpatial][iDiurnal]);
                    ++iDiurnal;
                }
                ++iSpatial;
            }
            return new ByteArrayInputStream(byteAOS.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void loadFromInputStream(InputStream is) {
        if (this.basis == null) {
            throw new MissingResourceException("Call to load coefficients from input stream without basis", this.getClass().getName(), null);
        }
        ExpansionBasis2D basis2d = (ExpansionBasis2D)this.basis;
        if (this.coeffs == null || this.coeffs.length != basis2d.getCompactSpatialBasisLength() || this.coeffs[0].length != basis2d.getTemporalBasisLength()) {
            this.coeffs = new double[basis2d.getCompactSpatialBasisLength()][basis2d.getTemporalBasisLength()];
        }
        try {
            DataInputStream in = new DataInputStream(is);
            int iSpatial = 0;
            while (iSpatial < basis2d.getCompactSpatialBasisLength()) {
                int iDiurnal = 0;
                while (iDiurnal < basis2d.getTemporalBasisLength()) {
                    this.coeffs[iSpatial][iDiurnal] = in.readDouble();
                    ++iDiurnal;
                }
                ++iSpatial;
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

