/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.coefficients;

import edu.uml.giro.gambit.coefficients.Coefficients;
import edu.uml.lgdc.format.FC;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;

public abstract class Coefficients3D
extends Coefficients<double[][][]> {
    double[][][] coeffs = null;

    @Override
    public double[][][] get() {
        return this.coeffs;
    }

    @Override
    public void put(double[][][] coeffs) {
        this.coeffs = coeffs;
    }

    public void putOne(int i, int j, int k, double value) {
        this.coeffs[i][j][k] = value;
    }

    public double[][][] clone() {
        if (this.coeffs == null) {
            return null;
        }
        double[][][] newc = new double[this.coeffs.length][this.coeffs[0].length][this.coeffs[0][0].length];
        int i = 0;
        while (i < this.coeffs.length) {
            int j = 0;
            while (j < this.coeffs[i].length) {
                int k = 0;
                while (j < this.coeffs[i][j].length) {
                    newc[i][j][k] = this.coeffs[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return newc;
    }

    @Override
    public void reset() {
        if (this.coeffs != null) {
            int i = 0;
            while (i < this.coeffs.length) {
                int j = 0;
                while (j < this.coeffs[i].length) {
                    int k = 0;
                    while (j < this.coeffs[i][j].length) {
                        this.coeffs[i][j][k] = 0.0;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void exportCoefficientsToTextFile(PrintWriter writer) {
        int count = 0;
        int i = 0;
        while (i < this.coeffs.length) {
            int j = 0;
            while (j < this.coeffs[i].length) {
                int k = 0;
                while (j < this.coeffs[i][j].length) {
                    writer.write(" " + FC.DoubleToString(this.coeffs[i][j][k], 15, 8));
                    if (++count == 4) {
                        writer.write("\n");
                        count = 0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public ByteArrayInputStream toInputStream() {
        return null;
    }

    @Override
    public void loadFromInputStream(InputStream is) {
    }
}

