/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.coefficients;

import edu.uml.giro.gambit.coefficients.Coefficients2D;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;

public class Coefficients_hmF2
extends Coefficients2D {
    private int monthPrev = -1;
    private double rgPrev = -1.0;

    @Override
    public void loadFromClimateFile(int month, double sunspotNumber) {
        int COEF_LENGTH = 16;
        boolean LOW_R = false;
        boolean HIGH_R = true;
        double d = sunspotNumber = sunspotNumber > 150.0 ? 150.0 : sunspotNumber;
        if (this.basis == null) {
            throw new MissingResourceException("Call to read coefficients from climate file without basis", this.getClass().getName(), null);
        }
        ExpansionBasis2D basis2d = (ExpansionBasis2D)this.basis;
        if (this.coeffs == null || this.coeffs.length != basis2d.getCompactSpatialBasisLength() || this.coeffs[0].length != basis2d.getTemporalBasisLength()) {
            this.coeffs = new double[basis2d.getCompactSpatialBasisLength()][basis2d.getTemporalBasisLength()];
        }
        double[][][] hmF2 = new double[2][basis2d.getCompactSpatialBasisLength()][basis2d.getTemporalBasisLength()];
        if (TimeScale.checkMonth(month)) {
            double rg;
            double d2 = rg = sunspotNumber > 150.0 ? 150.0 : sunspotNumber;
            if (month != this.monthPrev || rg != this.rgPrev) {
                File file = new File(CommonConst.getShareResourcesDir(), String.valueOf(GambitConstants.ARGENTINA_COEFFS_J6_FOLDER) + "uf_uh.grid." + FC.IntegerToString(month, 2, '0') + "." + "asc");
                BufferedReader in = null;
                int iSpatial = 0;
                int iDiurnal = 0;
                int iSolarActivity = 0;
                int iActivity = 0;
                try {
                    try {
                        in = new BufferedReader(new FileReader(file));
                        while (in.ready()) {
                            String line = in.readLine();
                            if (line == null) {
                            } else {
                                int iColumn = 0;
                                while (iColumn < 4) {
                                    if (iActivity == 1) {
                                        hmF2[iSolarActivity][iSpatial][iDiurnal] = Double.valueOf(line.substring(iColumn * 16, (iColumn + 1) * 16));
                                    }
                                    if (++iDiurnal >= basis2d.getTemporalBasisLength()) {
                                        iDiurnal = 0;
                                        if (++iSpatial >= basis2d.getCompactSpatialBasisLength()) {
                                            iSpatial = 0;
                                            ++iSolarActivity;
                                        }
                                    }
                                    ++iColumn;
                                }
                                if (iSolarActivity == 2) {
                                    iSolarActivity = 0;
                                    ++iActivity;
                                }
                                if (iActivity != 2) continue;
                            }
                            break;
                        }
                    }
                    catch (IOException ex) {
                        throw new MissingResourceException("Failed to read coefficients from climate file " + file.getAbsolutePath(), this.getClass().getName(), null);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                double rr2 = rg / 100.0;
                double rr1 = 1.0 - rr2;
                int i = 0;
                while (i < basis2d.getCompactSpatialBasisLength()) {
                    int j = 0;
                    while (j < basis2d.getTemporalBasisLength()) {
                        this.coeffs[i][j] = hmF2[0][i][j] * rr1 + hmF2[1][i][j] * rr2;
                        ++j;
                    }
                    ++i;
                }
                this.monthPrev = month;
                this.rgPrev = rg;
            }
        }
    }
}

