/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.giro.gambit.coefficients.Coefficients_B0;
import edu.uml.giro.gambit.coefficients.Coefficients_B1;
import edu.uml.giro.gambit.coefficients.Coefficients_Custom;
import edu.uml.giro.gambit.coefficients.Coefficients_foF2;
import edu.uml.giro.gambit.coefficients.Coefficients_hmF2;
import edu.uml.giro.gambit.core.AlgorithmVersions;
import edu.uml.giro.gambit.core.Characteristic;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCoreSettings;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.core.Maps;
import edu.uml.giro.gambit.core.SitesChoice;
import edu.uml.giro.gambit.core.TEC;
import edu.uml.giro.gambit.database.MadrigalClient;
import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGallet;
import edu.uml.giro.gambit.expansions.ExpansionBasis_SphericalCapHarmonicsK6;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.giro.gambit.synthesizers.SynthesizerSCH;
import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.datatype.RingBuffer;
import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.GeoMagIndexChoice;
import edu.uml.lgdc.geospace.GeoMagIndexesManager;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.IG12;
import edu.uml.lgdc.geospace.IGSAverageVTECGetter;
import edu.uml.lgdc.geospace.IRIModel;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.geospace.MapTypeChoice;
import edu.uml.lgdc.geospace.PlasmaMath;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.math.Statistic;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.DebugParam;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.util.concurrent.TimeUnit;

public abstract class Core {
    protected TimeScale timeOfValidity = new TimeScale(2011, 8, 1, 0, 0, 0);
    protected TimeScale baselineTime = new TimeScale(2011, 7, 30, 0, 0, 0);
    protected ApplicationPassport appPassport = null;
    protected Characteristic[] chars;
    protected GambitCoreSettings coreSettings;
    protected final EarthGrid defaultEarthGrid = new EarthGrid(46, 45);
    protected final TimeGrid defaultTimeGrid = new TimeGrid();
    private static EarthGrid defaultTecGrid = null;
    public RingBuffer<Maps> mapsTimeline;
    public AlgorithmVersions VERSIONS;
    private TEC tec;
    private TEC tec_bg;
    private Geomap slabThickness;
    private Geomap slabThickness_bg;
    private Geomap tecDeviationMap;
    private Geomap tauDeviationMap;
    private Geomap tecDeviationPercentMap;
    private Geomap tauDeviationPercentMap;
    protected GeoSynthesizer weather_foF2 = null;
    protected GeoSynthesizer climate_foF2 = null;
    protected GeoSynthesizer weather_hmF2 = null;
    protected GeoSynthesizer climate_hmF2 = null;
    protected GeoSynthesizer weather_NmF2 = null;
    protected GeoSynthesizer climate_NmF2 = null;
    protected GeoSynthesizer weather_MUF3000 = null;
    protected GeoSynthesizer climate_MUF3000 = null;
    protected GeoSynthesizer weather_B0 = null;
    protected GeoSynthesizer weather_B1 = null;
    protected GeoSynthesizer climate_custom = null;
    protected IGSAverageVTECGetter avtecGetter = new IGSAverageVTECGetter(GambitConstants.AVTEC_FOLDER);
    protected MapChoice currentMapChoice = MapChoice.FOF2_CLIMATE;
    protected SitesChoice currentSitesChoice = SitesChoice.FOF2_OBSERVATIONS;
    protected MapChoice currentExternalMapChoice = MapChoice.EVTEC_GPS;
    protected boolean highResTecMap = false;

    public Core(GambitCoreSettings settings) {
        this.coreSettings = settings;
        this.chars = new Characteristic[CharChoice.SIZE];
        this.defaultTimeGrid.setNewTimeStep(15);
        this.defaultTimeGrid.setForecastPeriod(this.coreSettings.getForecastPeriod_min());
        this.defaultTimeGrid.setUTs(new TimeScale("1932.01.01"));
        this.mapsTimeline = new RingBuffer<Maps>(Maps.class, TimeUnit.MINUTES, (int)TimeUnit.DAYS.toMinutes(1L), this.defaultTimeGrid.getTimeStep_min(), 0L);
        CharChoice[] charChoiceArray = CharChoice.values();
        int n = charChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CharChoice cc = charChoiceArray[n2];
            switch (cc) {
                case FOF2: {
                    ExpansionBasis_JonesGallet basis_foF2 = new ExpansionBasis_JonesGallet();
                    basis_foF2.setup(6, 8, 11);
                    Coefficients_foF2 coeffs_foF2c = new Coefficients_foF2();
                    coeffs_foF2c.setExpansionBasis(basis_foF2);
                    this.climate_foF2 = new GeoSynthesizer(CharChoice.FOF2, basis_foF2, coeffs_foF2c, null);
                    this.climate_foF2.setTimeGrid(this.defaultTimeGrid);
                    this.climate_foF2.setEarthGrid(this.defaultEarthGrid);
                    Geomap climateMap_foF2 = new Geomap(MapChoice.FOF2_CLIMATE, 999.9);
                    climateMap_foF2.setEarthGrid(this.defaultEarthGrid);
                    LocalData observations_foF2 = new LocalData(CharChoice.FOF2, this.defaultTimeGrid, this.coreSettings);
                    Geomap weatherMap_foF2 = new Geomap(MapChoice.FOF2_WEATHER, 999.9);
                    weatherMap_foF2.setEarthGrid(this.defaultEarthGrid);
                    Geomap deviationMap_foF2 = new Geomap(MapChoice.FOF2_DELTA, 999.9);
                    Geomap deviationMap_foF2_percent = new Geomap(MapChoice.FOF2_DELTA_PERCENT, 999.9);
                    deviationMap_foF2.setEarthGrid(this.defaultEarthGrid);
                    deviationMap_foF2_percent.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.FOF2.getIndex()] = new Characteristic(CharChoice.FOF2, climateMap_foF2, this.climate_foF2, observations_foF2, weatherMap_foF2, this.weather_foF2, deviationMap_foF2, deviationMap_foF2_percent);
                    break;
                }
                case NMF2: {
                    this.climate_NmF2 = new GeoSynthesizer(CharChoice.NMF2, this.climate_foF2.getExpansionBasis(), null, new GeoSynthesizer[]{this.climate_foF2});
                    Geomap climateMap_NmF2 = new Geomap(MapChoice.NMF2_CLIMATE, -1.0);
                    climateMap_NmF2.setEarthGrid(this.defaultEarthGrid);
                    LocalData observations_NmF2 = new LocalData(CharChoice.NMF2, this.defaultTimeGrid, this.coreSettings);
                    Geomap weatherMap_NmF2 = new Geomap(MapChoice.NMF2_WEATHER, -1.0);
                    weatherMap_NmF2.setEarthGrid(this.defaultEarthGrid);
                    Geomap deviationMap_NmF2 = new Geomap(MapChoice.NMF2_DELTA, 9999.0);
                    Geomap deviationMap_NmF2_percent = new Geomap(MapChoice.NMF2_DELTA_PERCENT, 9999.0);
                    deviationMap_NmF2.setEarthGrid(this.defaultEarthGrid);
                    deviationMap_NmF2_percent.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.NMF2.getIndex()] = new Characteristic(CharChoice.NMF2, climateMap_NmF2, this.climate_NmF2, observations_NmF2, weatherMap_NmF2, this.weather_NmF2, deviationMap_NmF2, deviationMap_NmF2_percent);
                    break;
                }
                case HMF2: {
                    ExpansionBasis_JonesGallet basis_hmF2 = new ExpansionBasis_JonesGallet();
                    basis_hmF2.setup(6, 8, 11);
                    Coefficients_hmF2 coeffs_hmF2c = new Coefficients_hmF2();
                    coeffs_hmF2c.setExpansionBasis(basis_hmF2);
                    this.climate_hmF2 = new GeoSynthesizer(CharChoice.HMF2, basis_hmF2, coeffs_hmF2c, null);
                    this.climate_hmF2.setTimeGrid(this.defaultTimeGrid);
                    this.climate_hmF2.setEarthGrid(this.defaultEarthGrid);
                    Geomap climateMap_hmF2 = new Geomap(MapChoice.HMF2_CLIMATE, 9999.0);
                    climateMap_hmF2.setEarthGrid(this.defaultEarthGrid);
                    LocalData observations_hmF2 = new LocalData(CharChoice.HMF2, this.defaultTimeGrid, this.coreSettings);
                    Geomap weatherMap_hmF2 = new Geomap(MapChoice.HMF2_WEATHER, 9999.0);
                    weatherMap_hmF2.setEarthGrid(this.defaultEarthGrid);
                    Geomap deviationMap_hmF2 = new Geomap(MapChoice.HMF2_DELTA, 9999.0);
                    Geomap deviationMap_hmF2_percent = new Geomap(MapChoice.HMF2_DELTA_PERCENT, 9999.0);
                    deviationMap_hmF2.setEarthGrid(this.defaultEarthGrid);
                    deviationMap_hmF2_percent.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.HMF2.getIndex()] = new Characteristic(CharChoice.HMF2, climateMap_hmF2, this.climate_hmF2, observations_hmF2, weatherMap_hmF2, this.weather_hmF2, deviationMap_hmF2, deviationMap_hmF2_percent);
                    break;
                }
                case MUF3000: {
                    this.climate_MUF3000 = new GeoSynthesizer(CharChoice.MUF3000, this.climate_foF2.getExpansionBasis(), null, new GeoSynthesizer[]{this.climate_foF2, this.climate_hmF2});
                    this.climate_MUF3000.setIRI(new IRIModel());
                    Geomap climateMap_MUF3000 = new Geomap(MapChoice.MUF3000_CLIMATE, -1.0);
                    climateMap_MUF3000.setEarthGrid(this.defaultEarthGrid);
                    LocalData observations_MUF3000 = new LocalData(CharChoice.MUF3000, this.defaultTimeGrid, this.coreSettings);
                    Geomap weatherMap_MUF3000 = new Geomap(MapChoice.MUF3000_WEATHER, -1.0);
                    weatherMap_MUF3000.setEarthGrid(this.defaultEarthGrid);
                    Geomap deviationMap_MUF3000 = new Geomap(MapChoice.MUF3000_DELTA, 9999.0);
                    Geomap deviationMap_MUF3000_percent = new Geomap(MapChoice.MUF3000_DELTA_PERCENT, 9999.0);
                    deviationMap_MUF3000.setEarthGrid(this.defaultEarthGrid);
                    deviationMap_MUF3000_percent.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.MUF3000.getIndex()] = new Characteristic(CharChoice.MUF3000, climateMap_MUF3000, this.climate_MUF3000, observations_MUF3000, weatherMap_MUF3000, this.weather_MUF3000, deviationMap_MUF3000, deviationMap_MUF3000_percent);
                    break;
                }
                case B0: {
                    ExpansionBasis_SphericalCapHarmonicsK6 basis_B0 = new ExpansionBasis_SphericalCapHarmonicsK6();
                    basis_B0.setSpatialOrder(6);
                    Coefficients_B0 coeffs_B0c = new Coefficients_B0();
                    coeffs_B0c.setExpansionBasis(basis_B0);
                    SynthesizerSCH climate_B0 = new SynthesizerSCH(CharChoice.B0, basis_B0, coeffs_B0c);
                    climate_B0.setTimeGrid(this.defaultTimeGrid);
                    climate_B0.setEarthGrid(this.defaultEarthGrid);
                    Geomap climateMap_B0 = new Geomap(MapChoice.B0_CLIMATE, 9999.0);
                    climateMap_B0.setEarthGrid(this.defaultEarthGrid);
                    LocalData observations_B0 = new LocalData(CharChoice.B0, this.defaultTimeGrid, this.coreSettings);
                    Geomap weatherMap_B0 = new Geomap(MapChoice.B0_WEATHER, 9999.0);
                    weatherMap_B0.setEarthGrid(this.defaultEarthGrid);
                    Geomap deviationMap_B0 = new Geomap(MapChoice.B0_DELTA, 9999.0);
                    Geomap deviationMap_B0_percent = new Geomap(MapChoice.B0_DELTA_PERCENT, 9999.0);
                    deviationMap_B0.setEarthGrid(this.defaultEarthGrid);
                    deviationMap_B0_percent.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.B0.getIndex()] = new Characteristic(CharChoice.B0, climateMap_B0, climate_B0, observations_B0, weatherMap_B0, this.weather_B0, deviationMap_B0, deviationMap_B0_percent);
                    break;
                }
                case B1: {
                    ExpansionBasis_SphericalCapHarmonicsK6 basis_B1 = new ExpansionBasis_SphericalCapHarmonicsK6();
                    basis_B1.setSpatialOrder(6);
                    Coefficients_B1 coeffs_B1c = new Coefficients_B1();
                    coeffs_B1c.setExpansionBasis(basis_B1);
                    SynthesizerSCH climate_B1 = new SynthesizerSCH(CharChoice.B1, basis_B1, coeffs_B1c);
                    climate_B1.setTimeGrid(this.defaultTimeGrid);
                    climate_B1.setEarthGrid(this.defaultEarthGrid);
                    Geomap climateMap_B1 = new Geomap(MapChoice.B1_CLIMATE, 9999.0);
                    climateMap_B1.setEarthGrid(this.defaultEarthGrid);
                    LocalData observations_B1 = new LocalData(CharChoice.B1, this.defaultTimeGrid, this.coreSettings);
                    Geomap weatherMap_B1 = new Geomap(MapChoice.B1_WEATHER, 9999.0);
                    weatherMap_B1.setEarthGrid(this.defaultEarthGrid);
                    Geomap deviationMap_B1 = new Geomap(MapChoice.B1_DELTA, 9999.0);
                    Geomap deviationMap_B1_percent = new Geomap(MapChoice.B1_DELTA_PERCENT, 9999.0);
                    deviationMap_B1.setEarthGrid(this.defaultEarthGrid);
                    deviationMap_B1_percent.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.B1.getIndex()] = new Characteristic(CharChoice.B1, climateMap_B1, climate_B1, observations_B1, weatherMap_B1, this.weather_B1, deviationMap_B1, deviationMap_B1_percent);
                    break;
                }
                case CUSTOM: {
                    ExpansionBasis_JonesGallet basis_custom = new ExpansionBasis_JonesGallet();
                    basis_custom.setup(6, 8, 11);
                    Coefficients_Custom coeffs_custom = new Coefficients_Custom();
                    coeffs_custom.setExpansionBasis(basis_custom);
                    this.climate_custom = new GeoSynthesizer(CharChoice.CUSTOM, basis_custom, coeffs_custom, null);
                    this.climate_custom.setTimeGrid(this.defaultTimeGrid);
                    this.climate_custom.setEarthGrid(this.defaultEarthGrid);
                    Geomap climateMap_custom = new Geomap(MapChoice.CUSTOM_CLIMATE, 999.9);
                    climateMap_custom.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.CUSTOM.getIndex()] = new Characteristic(CharChoice.CUSTOM, climateMap_custom, this.climate_custom, null, null, null, null, null);
                    break;
                }
                case VTEC: {
                    Geomap climateMap_VTEC = new Geomap(MapChoice.VTEC_CLIMATE, -1.0);
                    climateMap_VTEC.setEarthGrid(this.defaultEarthGrid);
                    Geomap weatherMap_VTEC = new Geomap(MapChoice.VTEC_WEATHER, -1.0);
                    weatherMap_VTEC.setEarthGrid(this.defaultEarthGrid);
                    Geomap deviationMap_VTEC = new Geomap(MapChoice.VTEC_DELTA, 9999.0);
                    Geomap deviationMap_VTEC_percent = new Geomap(MapChoice.VTEC_DELTA_PERCENT, 9999.0);
                    deviationMap_VTEC.setEarthGrid(this.defaultEarthGrid);
                    deviationMap_VTEC_percent.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.VTEC.getIndex()] = new Characteristic(CharChoice.VTEC, climateMap_VTEC, null, null, weatherMap_VTEC, null, deviationMap_VTEC, deviationMap_VTEC_percent);
                    break;
                }
                case TAU: {
                    Geomap climateMap_tau = new Geomap(MapChoice.TAU_CLIMATE, 9999.0);
                    climateMap_tau.setEarthGrid(this.defaultEarthGrid);
                    Geomap weatherMap_tau = new Geomap(MapChoice.TAU_WEATHER, 9999.0);
                    weatherMap_tau.setEarthGrid(this.defaultEarthGrid);
                    Geomap deviationMap_tau = new Geomap(MapChoice.TAU_DELTA, 9999.0);
                    Geomap deviationMap_tau_percent = new Geomap(MapChoice.TAU_DELTA_PERCENT, 9999.0);
                    deviationMap_tau.setEarthGrid(this.defaultEarthGrid);
                    deviationMap_tau_percent.setEarthGrid(this.defaultEarthGrid);
                    this.chars[CharChoice.TAU.getIndex()] = new Characteristic(CharChoice.TAU, climateMap_tau, null, null, weatherMap_tau, null, deviationMap_tau, deviationMap_tau_percent);
                    break;
                }
                default: {
                    throw new RuntimeException("design error: overlooked characteristic, " + cc.getName());
                }
            }
            this.chars[cc.getIndex()].reset();
            ++n2;
        }
    }

    private void checkTecEngine() {
        if (defaultTecGrid == null) {
            defaultTecGrid = new EarthGrid(181, 360, 200.0);
        }
        if (this.tec == null) {
            this.tec = new TEC(MapChoice.EVTEC_GPS, -1.0);
            this.tec.setEarthGrid(defaultTecGrid);
        }
        if (this.tec_bg == null) {
            this.tec_bg = new TEC(MapChoice.EVTEC_GPS, -1.0);
            this.tec_bg.setEarthGrid(defaultTecGrid);
        }
        if (this.tecDeviationMap == null) {
            this.tecDeviationMap = new Geomap(MapChoice.EVTEC_GPS_DELTA, -1.0);
            this.tecDeviationMap.setEarthGrid(defaultTecGrid);
        }
        if (this.tecDeviationPercentMap == null) {
            this.tecDeviationPercentMap = new Geomap(MapChoice.EVTEC_GPS_DELTA_PERCENT, -1.0);
            this.tecDeviationPercentMap.setEarthGrid(defaultTecGrid);
        }
        if (this.slabThickness == null) {
            this.slabThickness = new Geomap(MapChoice.ESLAB_THICKNESS, 9999.0);
            this.slabThickness.setEarthGrid(defaultTecGrid);
        }
        if (this.slabThickness_bg == null) {
            this.slabThickness_bg = new Geomap(MapChoice.ESLAB_THICKNESS, 9999.0);
            this.slabThickness_bg.setEarthGrid(defaultTecGrid);
        }
        if (this.tauDeviationMap == null) {
            this.tauDeviationMap = new Geomap(MapChoice.ESLAB_THICKNESS_DELTA, 9999.0);
            this.tauDeviationMap.setEarthGrid(defaultTecGrid);
        }
        if (this.tauDeviationPercentMap == null) {
            this.tauDeviationPercentMap = new Geomap(MapChoice.ESLAB_THICKNESS_DELTA_PERCENT, 9999.0);
            this.tauDeviationPercentMap.setEarthGrid(defaultTecGrid);
        }
    }

    public TimeScale getTimeOfValidity() {
        return this.timeOfValidity;
    }

    public void setTimeOfValidity(TimeScale newTime, int databaseMode, AlgorithmVersions versions) {
        TimeScale now = new TimeScale();
        if (newTime.diffIn(13, now) > 75.0) {
            throw new RuntimeException("Attempt to set future time " + newTime + " as validity time");
        }
        if (!this.appPassport.realtimePermitted() && now.diffIn(11, newTime) < 48.0) {
            Console.showError("Your data access permission does not include recent data, please upgrade");
            throw new RuntimeException("Data access level exceeds user permissions");
        }
        this.timeOfValidity = newTime;
        this.reconstruct(versions);
        this.rebuildChars(databaseMode);
    }

    public TimeScale getBaselineTime() {
        return this.baselineTime;
    }

    public void setBaselineTime(TimeScale newTime) {
        this.baselineTime = newTime;
    }

    public TimeGrid getDefaultTimeGrid() {
        return this.defaultTimeGrid;
    }

    public EarthGrid getDefaultEarthGrid() {
        return this.defaultEarthGrid;
    }

    private void rebuildChars(int databaseMode) {
        if (DebugParam.debug || DebugParam.verboseLevel >= 1) {
            Console.showMsg("Core starts rebuilding characteristics, content " + databaseMode + " for " + this.timeOfValidity.toHumanUT());
        }
        Characteristic[] characteristicArray = this.chars;
        int n = this.chars.length;
        int n2 = 0;
        while (n2 < n) {
            Characteristic c = characteristicArray[n2];
            this.rebuildOneChar(c, databaseMode);
            ++n2;
        }
    }

    public void rebuildOneChar(Characteristic c, int databaseMode) {
        if (c == null) {
            return;
        }
        if (DebugParam.debug || DebugParam.verboseLevel >= 3) {
            Console.showMsg("Core starts rebuilding " + c.cc.getName() + " content " + databaseMode + " for " + this.timeOfValidity.toHumanUT());
        }
        this.mapsTimeline.setTov(this.timeOfValidity);
        if (c.cc == CharChoice.VTEC && (databaseMode & 0x10) == 0) {
            if (DebugParam.debug || DebugParam.verboseLevel >= 4) {
                Console.showMsg("Download of average VTEC map is bypassed");
            }
        } else {
            this.rebuildOneChar_Climate(c);
            this.mapsTimeline.put(this.timeOfValidity, (Object)MapChoice.getSurfaceChoice(c.cc, MapTypeChoice.CLIMATE), (Object)c.climateMap.clone());
        }
        if ((databaseMode & 0x23) == 0) {
            return;
        }
        if (c.cc == CharChoice.CUSTOM) {
            return;
        }
        this.rebuildOneChar_ObservationsAndWeather(c, databaseMode);
        this.mapsTimeline.put(this.timeOfValidity, (Object)MapChoice.getSurfaceChoice(c.cc, MapTypeChoice.WEATHER), (Object)c.weatherMap.clone());
        c.deviationMap.buildDeviationMap(c.weatherMap.getMap(), c.climateMap.getMap(), this.timeOfValidity, null);
        c.deviationMap_percent.buildDeviationMap_percent(c.weatherMap.getMap(), c.climateMap.getMap(), this.timeOfValidity, null);
        this.mapsTimeline.put(this.timeOfValidity, (Object)MapChoice.getSurfaceChoice(c.cc, MapTypeChoice.DELTA), (Object)c.deviationMap.clone());
        this.mapsTimeline.put(this.timeOfValidity, (Object)MapChoice.getSurfaceChoice(c.cc, MapTypeChoice.DELTA_PERCENT), (Object)c.deviationMap_percent.clone());
        if (DebugParam.debug || DebugParam.verboseLevel >= 4) {
            Console.showMsg("GAMBIT Core: " + c.cc.getName() + " deviation maps computed");
        }
    }

    public void rebuildOneChar_Climate(Characteristic c) {
        CharChoice cc = c.cc;
        switch (cc) {
            case FOF2: 
            case HMF2: 
            case B0: 
            case B1: {
                c.climate.getExpansionBasis().computeTimeDependentConstants(this.timeOfValidity);
                int month = this.timeOfValidity.get(2) + 1;
                double sunspotNumber = IG12.get(this.timeOfValidity.get(1), month).getNumber();
                c.climate.getCoefficients().loadFromClimateFile(month, sunspotNumber);
                int iTime = c.climate.getTimeGrid().findClosestTimeStep(this.timeOfValidity);
                c.climateMap.setMapValues(c.climate.synthesizeValueMap(iTime), this.timeOfValidity);
                break;
            }
            case VTEC: {
                if (this.avtecGetter.downloadAVTEC(this.timeOfValidity.get(1), this.timeOfValidity.get(6)) == null) break;
                this.avtecGetter.fillGambitMap(c.climateMap, this.timeOfValidity);
                break;
            }
            case NMF2: 
            case MUF3000: {
                c.climate.getExpansionBasis().computeTimeDependentConstants(this.timeOfValidity);
                int iTime = c.climate.getTimeGrid().findClosestTimeStep(this.timeOfValidity);
                c.climateMap.setMapValues(c.climate.synthesizeValueMap(iTime), this.timeOfValidity);
                break;
            }
            case TAU: {
                Geomap cNmF2 = this.chars[CharChoice.NMF2.getIndex()].climateMap;
                Geomap cTEC = this.chars[CharChoice.VTEC.getIndex()].climateMap;
                double[] mapNmF2 = cNmF2.getMap_1D();
                double[] mapAVTEC = cTEC.getMap_1D();
                double[] mapTau = new double[mapNmF2.length];
                int i = 0;
                while (i < mapTau.length) {
                    if (mapAVTEC[i] != cTEC.getNoValue() && mapNmF2[i] != cNmF2.getNoValue() && mapAVTEC[i] > this.coreSettings.getMinimumTecForTau() && mapNmF2[i] > this.coreSettings.getMinimumNmF2ForTau()) {
                        mapTau[i] = PlasmaMath.slabThickness_km(mapAVTEC[i], mapNmF2[i]);
                        if (mapTau[i] > this.coreSettings.getMaximumTau()) {
                            mapTau[i] = c.climateMap.getNoValue();
                        }
                    } else {
                        mapTau[i] = c.climateMap.getNoValue();
                    }
                    ++i;
                }
                c.climateMap.setMapValues(mapTau, this.timeOfValidity);
            }
        }
    }

    public abstract void rebuildOneChar_ObservationsAndWeather(Characteristic var1, int var2);

    public void rebuildOneChar(Characteristic c, int databaseMode, TimeScale newTov) {
        this.timeOfValidity = newTov;
        this.rebuildOneChar(c, databaseMode);
    }

    public double[] synthesizeCurrentMap_1D(EarthGrid exportEarthGrid, TimeScale buildToDate, MapChoice mc) {
        return this.synthesizeCurrentMap(exportEarthGrid, buildToDate, mc).getMap_1D();
    }

    public Geomap synthesizeCurrentMap(EarthGrid exportEarthGrid, TimeScale buildToDate, MapChoice mc) {
        Geomap outputMap;
        CharChoice cc = mc.getCC();
        EarthGrid savedGridClimate = this.getClimate(cc).getEarthGrid();
        EarthGrid savedGridWeather = this.getWeather(cc).getEarthGrid();
        this.getClimate(cc).getExpansionBasis().getTimeGrid().setUTs(buildToDate);
        this.getClimate(cc).setEarthGrid(exportEarthGrid);
        this.getWeather(cc).getExpansionBasis().getTimeGrid().setUTs(buildToDate);
        this.getWeather(cc).setEarthGrid(exportEarthGrid);
        int iTime = this.getWeather(cc).getTimeGrid().findClosestTimeStep(buildToDate);
        this.getClimate(cc).getExpansionBasis().computeTimeDependentConstants(buildToDate);
        this.getWeather(cc).getExpansionBasis().computeTimeDependentConstants(buildToDate);
        Geomap climateMap = null;
        Geomap weatherMap = null;
        Geomap differenceMap = null;
        if (mc.isClimateMap() || mc.isDeltaMap()) {
            climateMap = new Geomap(mc, 9999.0);
            climateMap.setEarthGrid(exportEarthGrid);
            climateMap.setMapValues(this.getClimate(cc).synthesizeValueMap(iTime), buildToDate);
        }
        if (mc.isWeatherMap() || mc.isDeltaMap()) {
            weatherMap = new Geomap(mc, 9999.0);
            weatherMap.setEarthGrid(exportEarthGrid);
            weatherMap.setMapValues(this.getWeather(cc).synthesizeValueMap(iTime), buildToDate);
        }
        if (mc.isDeltaMap()) {
            differenceMap = new Geomap(mc, 9999.0);
            differenceMap.setEarthGrid(exportEarthGrid);
            if (mc.isPercentDeltaMap()) {
                differenceMap.buildDeviationMap_percent(weatherMap.getMap(), climateMap.getMap(), buildToDate, null);
            } else {
                differenceMap.buildDeviationMap(weatherMap.getMap(), climateMap.getMap(), buildToDate, null);
            }
            outputMap = differenceMap;
        } else {
            outputMap = mc.isClimateMap() ? climateMap : weatherMap;
        }
        this.getClimate(cc).setEarthGrid(savedGridClimate);
        this.getClimate(cc).getExpansionBasis().getTimeGrid().setUTs(buildToDate);
        this.getWeather(cc).setEarthGrid(savedGridWeather);
        this.getWeather(cc).getExpansionBasis().getTimeGrid().setUTs(buildToDate);
        this.getClimate(cc).getExpansionBasis().computeTimeDependentConstants(this.timeOfValidity);
        this.getWeather(cc).getExpansionBasis().computeTimeDependentConstants(this.timeOfValidity);
        return outputMap;
    }

    public void downloadExtVTECfile(TimeScale toTime, TEC data) {
        this.checkTecEngine();
        File file = new File(MadrigalClient.getFileNameForGPSTEC(toTime));
        if (MadrigalClient.getGpsFile(file, toTime, false)) {
            data.readGPSTec_H5(file.getAbsolutePath(), toTime);
        } else {
            data.reset();
        }
    }

    public TEC rebuildExtVTECmap(TimeScale toTime) {
        this.checkTecEngine();
        if (this.tec.getRefTime() == null || !this.tec.getRefTime().equals(toTime)) {
            this.downloadExtVTECfile(toTime, this.tec);
        }
        this.tec.calculateGridMap(this.isHighResTecMap() ? null : this.tec.getEarthGrid());
        this.mapsTimeline.put(toTime, (Object)MapChoice.EVTEC_GPS, (Object)this.tec.clone());
        return this.tec;
    }

    public Geomap rebuildExtVTECdeltaMap(TimeScale toTime, TimeScale toTime_bg) {
        this.checkTecEngine();
        if (this.tec.getRefTime() == null || !this.tec.getRefTime().equals(toTime)) {
            this.downloadExtVTECfile(toTime, this.tec);
            this.tec.calculateGridMap(this.isHighResTecMap() ? null : this.tec.getEarthGrid());
            this.mapsTimeline.put(toTime, (Object)MapChoice.EVTEC_GPS, (Object)this.tec.clone());
        }
        if (this.tec_bg.getRefTime() == null || !this.tec_bg.getRefTime().equals(toTime_bg)) {
            this.downloadExtVTECfile(toTime_bg, this.tec_bg);
            this.tec_bg.calculateGridMap(this.isHighResTecMap() ? null : this.tec.getEarthGrid());
        }
        this.tecDeviationMap.buildDeviationMap(this.tec.getMap_1D(), this.tec_bg.getMap_1D(), toTime, toTime_bg);
        this.mapsTimeline.put(toTime, (Object)MapChoice.EVTEC_GPS_DELTA, (Object)this.tecDeviationMap.clone());
        this.tecDeviationPercentMap.buildDeviationMap_percent(this.tec.getMap_1D(), this.tec_bg.getMap_1D(), toTime, toTime_bg);
        this.mapsTimeline.put(toTime, (Object)MapChoice.EVTEC_GPS_DELTA_PERCENT, (Object)this.tecDeviationPercentMap.clone());
        return this.tecDeviationMap;
    }

    public Geomap rebuildExtSlabThicknessMap(Geomap output, TimeScale toTime) {
        GeoSynthesizer foF2;
        GeoSynthesizer NmF2;
        if (toTime.equals(this.timeOfValidity)) {
            NmF2 = this.getWeather(CharChoice.NMF2);
            foF2 = this.getWeather(CharChoice.FOF2);
            if (foF2.getCoefficients() == null || foF2.getCoefficients().get() == null) {
                this.rebuildOneChar(this.chars[CharChoice.FOF2.getIndex()], 1);
                this.rebuildOneChar(this.chars[CharChoice.NMF2.getIndex()], 0);
            }
        } else {
            NmF2 = this.getClimate(CharChoice.NMF2);
            foF2 = this.getClimate(CharChoice.FOF2);
            if (foF2.getCoefficients() == null) {
                this.rebuildOneChar(this.chars[CharChoice.FOF2.getIndex()], 0);
                this.rebuildOneChar(this.chars[CharChoice.NMF2.getIndex()], 0);
            }
        }
        if (this.rebuildExtVTECmap(toTime) == null) {
            return null;
        }
        EarthGrid grid = this.tec.getEarthGrid();
        double[] tau = new double[grid.getNumLatitudeNodes() * grid.getNumLongitudeNodes()];
        int iTime = NmF2.getTimeGrid().findClosestTimeStep(toTime);
        while (iTime < 0) {
            iTime += NmF2.getTimeGrid().getNumDiurnalSteps();
        }
        while (iTime >= NmF2.getTimeGrid().getNumDiurnalSteps()) {
            iTime -= NmF2.getTimeGrid().getNumDiurnalSteps();
        }
        int i = 0;
        while (i < this.tec.getMap_1D().length) {
            int iLon;
            int iLat;
            double[] latlon;
            double nmF2;
            tau[i] = output.getNoValue();
            if (this.tec.getMap_1D()[i] != this.tec.getNoValue() && !(this.tec.getMap_1D()[i] < this.coreSettings.getMinimumTecForTau()) && !((nmF2 = NmF2.synthesizeValue((latlon = grid.getCoordGeo_degrees(iLat = i / grid.getNumLongitudeNodes(), iLon = i - iLat * grid.getNumLongitudeNodes()))[0], latlon[1], iTime)) < this.coreSettings.getMinimumNmF2ForTau())) {
                tau[i] = PlasmaMath.slabThickness_km(this.tec.getMap_1D()[i], nmF2);
                if (tau[i] > this.coreSettings.getMaximumTau()) {
                    tau[i] = output.getNoValue();
                }
            }
            ++i;
        }
        output.setMapValues(tau, toTime);
        output.setNeedRecalcGrid(false);
        this.mapsTimeline.put(toTime, (Object)MapChoice.ESLAB_THICKNESS, (Object)output.clone());
        return output;
    }

    public Geomap rebuildExtSlabThicknessDeltaMap(TimeScale toTime, TimeScale toTime_bg) {
        if (!(this.slabThickness_bg.getRefTime() != null && this.slabThickness_bg.getRefTime().equals(toTime_bg) || this.rebuildExtSlabThicknessMap(this.slabThickness_bg, toTime_bg) != null)) {
            return null;
        }
        if (!(this.slabThickness.getRefTime() != null && this.slabThickness.getRefTime().equals(toTime) || this.rebuildExtSlabThicknessMap(this.slabThickness, toTime) != null)) {
            return null;
        }
        System.out.println("Building delta-tau maps for " + this.slabThickness.getRefTime().toHumanUT() + " versus " + this.slabThickness_bg.getRefTime());
        this.tauDeviationMap.buildDeviationMap(this.slabThickness.getMap(), this.slabThickness_bg.getMap(), toTime, toTime_bg);
        this.mapsTimeline.put(toTime, (Object)MapChoice.ESLAB_THICKNESS_DELTA, (Object)this.tauDeviationMap.clone());
        this.tauDeviationPercentMap.buildDeviationMap_percent(this.slabThickness.getMap(), this.slabThickness_bg.getMap(), toTime, toTime_bg);
        this.mapsTimeline.put(toTime, (Object)MapChoice.ESLAB_THICKNESS_DELTA_PERCENT, (Object)this.tauDeviationPercentMap.clone());
        return this.tauDeviationMap;
    }

    public double[] prepareDSTData(TimeScale[][] dstTimes, TimeScale[] startEndTime) {
        int year = startEndTime[0].get(1);
        while (year <= startEndTime[1].get(1)) {
            File file = new File(GambitConstants.DST_FOLDER, GeoMagIndexesManager.getIndexFileName(year, GeoMagIndexChoice.DST));
            FileUtils.copyURLToFile("https://lgdc.uml.edu/common/GAMBITGetFiles?data_type=dst&year=" + year, file);
            ++year;
        }
        int[] dst = GeoMagIndexesManager.getDST(startEndTime[0], startEndTime[1], dstTimes, GambitConstants.DST_FOLDER);
        double[] dstData = new double[dst.length];
        int i = 0;
        while (i < dstData.length) {
            dstData[i] = dst[i];
            ++i;
        }
        return dstData;
    }

    public Characteristic getChar(CharChoice cc) {
        return this.chars[cc.getIndex()];
    }

    public Characteristic getChar(int index) {
        return this.chars[index];
    }

    public Characteristic[] getChars() {
        return this.chars;
    }

    public GeoSynthesizer getClimate(CharChoice cc) {
        return this.chars[cc.getIndex()].climate;
    }

    public LocalData getLocalData(CharChoice cc) {
        return this.chars[cc.getIndex()].localData;
    }

    public GeoSynthesizer getWeather(CharChoice cc) {
        return this.chars[cc.getIndex()].weather;
    }

    public Geomap getDeviationMap(CharChoice cc) {
        return this.chars[cc.getIndex()].deviationMap;
    }

    public Geomap getDeviationMap_percent(CharChoice cc) {
        return this.chars[cc.getIndex()].deviationMap_percent;
    }

    public TEC getTEC() {
        return this.tec;
    }

    public TEC getBackgroundTEC() {
        return this.tec_bg;
    }

    public Geomap getTecDeviationMap() {
        return this.tecDeviationMap;
    }

    public Geomap getTauDeviationMap() {
        return this.tauDeviationMap;
    }

    public Geomap getSlabThickness() {
        return this.slabThickness;
    }

    public Geomap getBackgroundSlabThickness() {
        return this.slabThickness_bg;
    }

    public Geomap getOneMap(TimeScale refTime, MapChoice mapChoice, AlgorithmVersions versions) {
        if (mapChoice.getType().equals((Object)MapTypeChoice.MEDIAN_30DAY) && this.mapsTimeline.get(refTime, (Object)mapChoice) == null) {
            int i;
            Geomap[][] bufferMaps = new Geomap[CharChoice.SIZE][30];
            int m = 0;
            while (m < CharChoice.SIZE) {
                CharChoice ccm = CharChoice.getByIndex(m);
                Geomap weatherMap = (Geomap)this.mapsTimeline.get(refTime, (Object)MapChoice.getSurfaceChoice(ccm, MapTypeChoice.WEATHER));
                if (weatherMap != null) {
                    bufferMaps[m] = new Geomap[30];
                    i = 0;
                    while (i < 30) {
                        bufferMaps[m][i] = new Geomap(mapChoice, this.getChar((int)ccm.getIndex()).climateMap.getNoValue());
                        bufferMaps[m][i].setEarthGrid(weatherMap.getEarthGrid());
                        ++i;
                    }
                }
                ++m;
            }
            Geomap[] medMap = new Geomap[CharChoice.SIZE];
            m = 0;
            while (m < CharChoice.SIZE) {
                CharChoice ccm = CharChoice.getByIndex(m);
                Geomap weatherMap = (Geomap)this.mapsTimeline.get(refTime, (Object)MapChoice.getSurfaceChoice(ccm, MapTypeChoice.WEATHER));
                if (weatherMap != null) {
                    medMap[m] = new Geomap(MapChoice.getSurfaceChoice(ccm, MapTypeChoice.MEDIAN_30DAY), this.getChar((CharChoice)ccm).climateMap.getNoValue());
                    medMap[m].setEarthGrid(weatherMap.getEarthGrid());
                }
                ++m;
            }
            TimeScale startTime = new TimeScale(refTime.getTimeInMillis());
            startTime.add(10, -744);
            TimeScale theTime = new TimeScale(startTime.getTimeInMillis());
            i = 0;
            while (i < 30) {
                Console.showMsg("Filling buffer for past time " + theTime.toHumanUT());
                this.setTimeOfValidity(theTime, 1, versions);
                m = 0;
                while (m < CharChoice.SIZE) {
                    CharChoice ccm = CharChoice.getByIndex(m);
                    Geomap weatherMap = (Geomap)this.mapsTimeline.get(theTime, (Object)MapChoice.getSurfaceChoice(ccm, MapTypeChoice.WEATHER));
                    if (weatherMap != null) {
                        int iTime = this.getWeather(CharChoice.FOF2).getTimeGrid().findClosestTimeStep(theTime);
                        bufferMaps[m][i].setMapValues(weatherMap.getMap_1D(), theTime);
                    }
                    ++m;
                }
                theTime.add(10, 24);
                ++i;
            }
            this.setTimeOfValidity(refTime, 35, versions);
            double[] oneScan = new double[30];
            m = 0;
            while (m < CharChoice.SIZE) {
                if (medMap[m] != null && bufferMaps[m] != null && bufferMaps[m][0] != null) {
                    CharChoice ccm = CharChoice.getByIndex(m);
                    int totalBins = bufferMaps[m][0].getMap_1D().length;
                    double[] mval = new double[totalBins];
                    int k = 0;
                    while (k < totalBins) {
                        double median;
                        i = 0;
                        while (i < 30) {
                            double[] map_1D = bufferMaps[m][i].getMap_1D();
                            oneScan[i] = map_1D[k];
                            ++i;
                        }
                        mval[k] = median = Statistic.median(oneScan);
                        ++k;
                    }
                    medMap[m].setMapValues(mval, refTime);
                    this.mapsTimeline.put(refTime, (Object)MapChoice.getSurfaceChoice(ccm, MapTypeChoice.MEDIAN_30DAY), (Object)medMap[m]);
                }
                ++m;
            }
            Geomap currentMap = (Geomap)this.mapsTimeline.get(refTime, (Object)mapChoice);
            return currentMap;
        }
        if (mapChoice.equals((Object)MapChoice.GK)) {
            CharChoice cc = this.currentMapChoice.getCC();
            ExpansionBasis2D basis = (ExpansionBasis2D)this.getClimate(cc).getExpansionBasis();
            double[][] gridValues = Core.synthesizeGk(basis, mapChoice.parameter(), basis.getEarthGrid());
            Geomap dataMap = new Geomap(mapChoice, this.getChar((int)cc.getIndex()).climateMap.getNoValue());
            dataMap.setEarthGrid(basis.getEarthGrid());
            dataMap.setMapValues(gridValues, refTime);
            return dataMap;
        }
        return (Geomap)this.mapsTimeline.get(refTime, (Object)mapChoice);
    }

    public static double[][] synthesizeGk(ExpansionBasis2D basis, int k, EarthGrid grid) {
        double[][] valueGrid = new double[grid.getNumLatitudeNodes()][grid.getNumLongitudeNodes()];
        int iLat = 0;
        while (iLat < grid.getNumLatitudeNodes()) {
            int iLon = 0;
            while (iLon < grid.getNumLongitudeNodes()) {
                valueGrid[iLat][iLon] = basis.getSpatialBasisFunctionValue(k, iLat, iLon);
                ++iLon;
            }
            ++iLat;
        }
        return valueGrid;
    }

    public GambitCoreSettings getGambitCoreSettings() {
        return this.coreSettings;
    }

    public void setCurrentMapChoice(MapChoice mapChoice) {
        this.currentMapChoice = mapChoice;
    }

    public MapChoice getCurrentMapChoice() {
        return this.currentMapChoice;
    }

    public void setCurrentSitesChoice(SitesChoice sitesChoice) {
        this.currentSitesChoice = sitesChoice;
    }

    public SitesChoice getCurrentSitesChoice() {
        return this.currentSitesChoice;
    }

    public void setCurrentExternalMapChoice(MapChoice mapChoice) {
        this.currentExternalMapChoice = mapChoice;
    }

    public MapChoice getCurrentExternalMapChoice() {
        return this.currentExternalMapChoice;
    }

    public boolean isHighResTecMap() {
        return this.highResTecMap;
    }

    public void setHighResTecMap(boolean highResTecMap) {
        this.highResTecMap = highResTecMap;
    }

    public void reconstruct(AlgorithmVersions selectedVersions) {
    }
}

