/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.project.commandlineparams.CommandLineParam;
import edu.uml.lgdc.time.TimeScale;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;

public class GambitConstants {
    public static final String[] KEYS = new String[]{"sd", "startdate", "enddate", "xpos", "ypos", "charident"};
    public static final CommandLineParam.KeyType[] KEY_TYPES = new CommandLineParam.KeyType[]{CommandLineParam.KeyType.VALUE_ONLY, CommandLineParam.KeyType.VALUE_ONLY, CommandLineParam.KeyType.VALUE_ONLY, CommandLineParam.KeyType.VALUE_ONLY, CommandLineParam.KeyType.VALUE_ONLY, CommandLineParam.KeyType.VALUE_ONLY};
    public static final String VERSION = "GX.User 1.3F";
    public static final String FILE_CREDENTIALS = "# GLOBAL IONOSPHERE RADIO OBSERVATORY (G.I.R.O.)\n# giro.uml.edu\n#\n# IRI-based Real-Time Assimilative Model (IRTAM)\n#\n";
    public static final String OWNER_NAME = "Lowell GIRO Data Center";
    public static final String EXPORT_START_HEADER;
    public static final String TIMESTAMP_HEADER = "yyyyMMdd_HH:mm ";
    public static final String EXPORT_END_HEADER;
    public static final String LOG_LAST_COEFFS_SUBMISSION = "coeffs_proc.log";
    public static final String DATE_FORMAT = "yyyy.MM.dd.hh.mm";
    public static final String FULL_DATE_FORMAT = "yyyy/MM/dd (DDD) HH:mm:ss.SSS";
    public static final int INDEX_MIN = 0;
    public static final int INDEX_MAX = 1;
    public static final int INDEX_AVERAGE = 2;
    public static final double[] ERROR_RANGE_STEP;
    public static final int ERROR_RANGE_NUM_BINS = 61;
    public static final double AVERAGE_ERRORS_FOF2 = 0.38;
    public static final double AVERAGE_ERRORS_NMF2 = 1000.0;
    public static final double AVERAGE_ERRORS_HMF2 = 17.0;
    public static final double[] AVERAGE_ERRORS;
    public static final double REFERENCE_ALTITUDE_KM = 300.0;
    public static final double HUE_BLUE = 0.6666666666666666;
    public static final double HUE_RED = 0.0;
    public static final double USED_AVARAGE_FOR_SITES = 0.0;
    public static final double USED_SIGMA_FOR_SITES = 2.0;
    public static double COLOR_SATURATION_FACTOR;
    public static String TYPE_IMAGES;
    public static final int NUM_LONGITUDE_NODES = 45;
    public static final int NUM_LATITUDE_NODES = 46;
    public static final int LATITUDE_RANGE_DEGREE = 180;
    public static final int LONGITUDE_RANGE_DEGREE = 360;
    public static final int LATITUDE_STEP = 4;
    public static final int LONGITUDE_STEP = 8;
    public static final double LONDEGREE_IN_HOUR = 15.0;
    public static final String USER_FOLDER;
    public static final String OUTPUT_FOLDER;
    public static final String INPUT_FOLDER;
    public static final String MOVIES_OUTPUT_FOLDER;
    public static final String WEBPAGE_MOVIES_FOLDER;
    public static final String TEMP_FOLDER;
    public static final String GPS_TEC_FOLDER;
    public static final String KP_AP_FOLDER;
    public static final String DST_FOLDER;
    public static final String AVTEC_FOLDER;
    public static final String RTTEC_FOLDER;
    public static final String UQRGTEC_FOLDER;
    public static final String GMRTTEC_FOLDER;
    public static final String REPORT_IMAGE_FOLDER;
    public static final String NOWCAST_TIMELINE_FOLDER;
    public static final String STATISTICS_30DAY_FOLDER;
    public static final String ARGENTINA_COEFFS_J6_FOLDER;
    public static final String ARGENTINA_COEFFS_J6_PREF = "uf_uh.grid.";
    public static final String ARGENTINA_COEFFS_J6_EXT = "asc";
    private static final String RTAM_FILENAME_PREF_FOF2 = "IRTAM_foF2";
    private static final String RTAMVSIRI_FILENAME_PREF_FOF2 = "IRTAMvsIRI_foF2";
    private static final String RTAMVSIRIPERCENT_FILENAME_PREF_FOF2 = "IRTAMvsIRI_foF2_per";
    private static final String RTAM_FILENAME_PREF_NMF2 = "IRTAM_NmF2";
    private static final String RTAMVSIRI_FILENAME_PREF_NMF2 = "IRTAMvsIRI_NmF2";
    private static final String RTAMVSIRIPERCENT_FILENAME_PREF_NMF2 = "IRTAMvsIRI_NmF2_per";
    private static final String RTAM_FILENAME_PREF_HMF2 = "IRTAM_hmF2";
    private static final String RTAMVSIRI_FILENAME_PREF_HMF2 = "IRTAMvsIRI_hmF2";
    private static final String RTAMVSIRIPERCENT_FILENAME_PREF_HMF2 = "IRTAMvsIRI_hmF2_per";
    public static final String FILEPREF_GRID = "grid";
    public static final String FILEPREF_GRID_IONEX = "ionex";
    public static final String FILEPREF_SAMELT = "SameLT";
    public static final String FILEPREF_LONGSLICE = "LonSlice";
    public static final String FILE_GUEST_INFO = "guest_info.txt";
    public static final String FILE_GAMBIT_INFO = "gambit_info.txt";
    public static final String FILE_DISTANCES = "distances.txt";
    public static final String FILE_GIRO_INFO = "giro_stations.txt";
    public static final String FILE_MODEL_RESOLUTION = "nowcast_timeline.txt";
    public static final Font LEGEND_DEFAULT_FONT;
    public static final Font COLOR_LEGEND_DEFAULT_FONT;
    public static final int DEFAULT_HEIGHT = 640;
    public static final int DEFAULT_WIDTH = 1060;
    public static final int DEFAULT_WIDTH_PANEL = 385;
    public static final int DEFAULT_WIDTH_DISPLAY = 675;
    public static final int DEFAULT_HEIGHT_DISPLAY = 635;
    public static final int VIEW_TYPE_FLAT = 0;
    public static final int VIEW_TYPE_ROUND = 1;
    public static final int VIEW_TYPE_FLAT_WEB = 2;
    public static final int WORKING_WIDTH = 500;
    public static final int LEGEND_HEIGHT_ON_SCREEN = 100;
    public static final int LEGEND_WIDTH_ON_SCREEN = 170;
    public static final int TWO_LEGENDS_WIDTH_ON_SCREEN = 500;
    public static final int XOFFSET_FOR_TWO_LEGENDS = 120;
    public static final int XOFFSET_FOR_THREE_LEGENDS = 210;
    public static final int YOFFSET_FOR_EXT_LEGEND = -80;
    public static final int XSHIFT_EXTRA_LINUX = 5;
    public static final int WEBVIEW_MOVIE_ROI_WIDTH = 500;
    public static final int WEBVIEW_MOVIE_ROI_HEIGHT = 360;
    public static final int WEBVIEW_MOVIE_ROI_HEIGHT_WITH_LEGEND = 510;
    public static final int WEBVIEW_MOVIE_ROI_XPOSITION = 92;
    public static final int WEBVIEW_MOVIE_ROI_YPOSITION = 75;
    public static final int LEGEND_ROUND_TO_FOR_PERCENT_MAP = 10;
    public static final int LEGEND_ROUND_TO_FOR_HMF2_DEVIATION = 10;
    public static final int LEGEND_ROUND_TO_FOR_HMF2_OBS = 50;
    public static final double MIN_FOF2_MHZ = 2.0;
    public static final double MIN_NMF2_CM3 = 50000.0;
    public static final double MIN_HMF2_KM = 200.0;
    public static final double MIN_B0_KM = 50.0;
    public static final double MIN_B1 = 1.0;
    public static final double MIN_VTEC = 5.0;
    public static final double MIN_TAU_KM = 140.0;
    public static final double MIN_CUSTOM = 600.0;
    public static final double[] USER_MINMAX_FOF2;
    public static final double[] USER_MINMAX_NMF2;
    public static final double[] USER_MINMAX_HMF2;
    public static final double[] USER_MINMAX_B0;
    public static final double[] USER_MINMAX_B1;
    public static final double[] USER_MINMAX_VTEC;
    public static final double[] USER_MINMAX_TAU;
    public static final double[] USER_MINMAX_CUSTOM;
    public static final int REAL_TIME_PERIOD_HOURS = 48;
    public static final boolean OVERWRITE_EXISTING_GPS_TEC = false;

    static {
        if (KEYS.length != KEY_TYPES.length) {
            throw new RuntimeException("KEYS.length != KEY_TYPES.length");
        }
        EXPORT_START_HEADER = "# START_HEADER" + System.lineSeparator();
        EXPORT_END_HEADER = "# END_HEADER" + System.lineSeparator();
        ERROR_RANGE_STEP = new double[]{0.1, 200.0, 2.5};
        AVERAGE_ERRORS = new double[]{0.38, 1000.0, 17.0};
        COLOR_SATURATION_FACTOR = 1.0;
        TYPE_IMAGES = "Images";
        USER_FOLDER = "user" + File.separator;
        OUTPUT_FOLDER = "output" + File.separator;
        INPUT_FOLDER = "input" + File.separator;
        MOVIES_OUTPUT_FOLDER = "Animations" + File.separator;
        WEBPAGE_MOVIES_FOLDER = "RTAM" + File.separator;
        TEMP_FOLDER = String.valueOf(OUTPUT_FOLDER) + "temp" + File.separator;
        GPS_TEC_FOLDER = String.valueOf(INPUT_FOLDER) + "gps_tec" + File.separator;
        KP_AP_FOLDER = String.valueOf(INPUT_FOLDER) + "kp_ap" + File.separator;
        DST_FOLDER = String.valueOf(INPUT_FOLDER) + "dst" + File.separator;
        AVTEC_FOLDER = String.valueOf(INPUT_FOLDER) + "avtec" + File.separator;
        RTTEC_FOLDER = String.valueOf(INPUT_FOLDER) + "rttec" + File.separator;
        UQRGTEC_FOLDER = String.valueOf(INPUT_FOLDER) + "uqrgtec" + File.separator;
        GMRTTEC_FOLDER = String.valueOf(INPUT_FOLDER) + "gmrttec" + File.separator;
        REPORT_IMAGE_FOLDER = String.valueOf(OUTPUT_FOLDER) + "graphs" + File.separator;
        NOWCAST_TIMELINE_FOLDER = "nowcast_timelines" + File.separator;
        STATISTICS_30DAY_FOLDER = "30DAY_STATISTICS" + File.separator;
        ARGENTINA_COEFFS_J6_FOLDER = "hmf2_J6" + File.separator;
        new File(USER_FOLDER).mkdirs();
        new File(OUTPUT_FOLDER).mkdirs();
        new File(INPUT_FOLDER).mkdirs();
        new File(MOVIES_OUTPUT_FOLDER).mkdirs();
        new File(TEMP_FOLDER).mkdirs();
        new File(GPS_TEC_FOLDER).mkdirs();
        LEGEND_DEFAULT_FONT = Font.decode("Arial-BOLD-12");
        COLOR_LEGEND_DEFAULT_FONT = Font.decode("Arial-BOLD-12");
        USER_MINMAX_FOF2 = new double[]{-3.0, 3.0};
        USER_MINMAX_NMF2 = new double[]{-10000.0, 10000.0};
        USER_MINMAX_HMF2 = new double[]{-100.0, 100.0};
        USER_MINMAX_B0 = new double[]{-100.0, 100.0};
        USER_MINMAX_B1 = new double[]{-2.0, 2.0};
        USER_MINMAX_VTEC = new double[]{-20.0, 20.0};
        USER_MINMAX_TAU = new double[]{-100.0, 100.0};
        USER_MINMAX_CUSTOM = new double[]{600.0, 1200.0};
    }

    public static String getFileNamePrefix(MapChoice choice) {
        String prefix = new String();
        switch (choice) {
            case FOF2_CLIMATE: {
                prefix = "IRI_foF2";
                break;
            }
            case FOF2_MEDIAN_30DAY: {
                prefix = "30DayMedian_foF2";
                break;
            }
            case FOF2_WEATHER: {
                prefix = RTAM_FILENAME_PREF_FOF2;
                break;
            }
            case FOF2_DELTA: {
                prefix = RTAMVSIRI_FILENAME_PREF_FOF2;
                break;
            }
            case FOF2_DELTA_PERCENT: {
                prefix = RTAMVSIRIPERCENT_FILENAME_PREF_FOF2;
                break;
            }
            case NMF2_CLIMATE: {
                prefix = "IRI_NmF2";
                break;
            }
            case NMF2_MEDIAN_30DAY: {
                prefix = "30DayMedian_NmF2";
                break;
            }
            case NMF2_WEATHER: {
                prefix = RTAM_FILENAME_PREF_NMF2;
                break;
            }
            case NMF2_DELTA: {
                prefix = RTAMVSIRI_FILENAME_PREF_NMF2;
                break;
            }
            case NMF2_DELTA_PERCENT: {
                prefix = RTAMVSIRIPERCENT_FILENAME_PREF_NMF2;
                break;
            }
            case HMF2_CLIMATE: {
                prefix = "Brunini_hmF2";
                break;
            }
            case HMF2_MEDIAN_30DAY: {
                prefix = "30DayMedian_hmF2";
                break;
            }
            case HMF2_WEATHER: {
                prefix = RTAM_FILENAME_PREF_HMF2;
                break;
            }
            case HMF2_DELTA: {
                prefix = RTAMVSIRI_FILENAME_PREF_HMF2;
                break;
            }
            case HMF2_DELTA_PERCENT: {
                prefix = RTAMVSIRIPERCENT_FILENAME_PREF_HMF2;
                break;
            }
            case GK: {
                prefix = "GK";
                break;
            }
            case FOF2_INTERPOL_DC: {
                prefix = "InterpolatedDC";
                break;
            }
            case FOF2_GKFITERROR_DC: {
                prefix = "InterpolatedDC_Error";
                break;
            }
            case FOF2_FITTED_DC: {
                prefix = "FittedDC";
                break;
            }
            case B0_CLIMATE: {
                prefix = "IRI_B0";
                break;
            }
            case B0_MEDIAN_30DAY: {
                prefix = "30DayMedian_B0";
                break;
            }
            case B0_WEATHER: {
                prefix = "IRTAM_B0";
                break;
            }
            case B0_DELTA: {
                prefix = "IRTAMvsIRI_B0";
                break;
            }
            case B0_DELTA_PERCENT: {
                prefix = "IRTAMvsIRI_B0_per";
                break;
            }
            case B1_CLIMATE: {
                prefix = "IRI_B1";
                break;
            }
            case B1_MEDIAN_30DAY: {
                prefix = "30DayMedian_B1";
                break;
            }
            case B1_WEATHER: {
                prefix = "IRTAM_B1";
                break;
            }
            case B1_DELTA: {
                prefix = "IRTAMvsIRI_B1";
                break;
            }
            case B1_DELTA_PERCENT: {
                prefix = "IRTAMvsIRI_B1_per";
                break;
            }
            case MUF3000_CLIMATE: {
                prefix = "IRI_MUF";
                break;
            }
            case MUF3000_MEDIAN_30DAY: {
                prefix = "30DayMedian_MUF";
                break;
            }
            case MUF3000_WEATHER: {
                prefix = "IRTAM_MUF";
                break;
            }
            case MUF3000_DELTA: {
                prefix = "IRTAMvsIRI_MUF";
                break;
            }
            case MUF3000_DELTA_PERCENT: {
                prefix = "IRTAMvsIRI_MUF_per";
                break;
            }
            case VTEC_CLIMATE: 
            case VTEC_MEDIAN_30DAY: {
                prefix = "AVTEC";
                break;
            }
            case VTEC_WEATHER: {
                prefix = "IGS_VTEC";
                break;
            }
            case VTEC_DELTA: {
                prefix = "IGSvsAvr_VTEC";
                break;
            }
            case VTEC_DELTA_PERCENT: {
                prefix = "IGSvsAvr_VTEC_per";
                break;
            }
            case EVTEC_GPS: {
                prefix = "ExtVTEC";
                break;
            }
            case EVTEC_GPS_DELTA: {
                prefix = "Delta-ExtTEC";
                break;
            }
            case EVTEC_GPS_DELTA_PERCENT: {
                prefix = "Delta-ExtTEC_per";
                break;
            }
            case ESLAB_THICKNESS: {
                prefix = "ExtTau";
                break;
            }
            case ESLAB_THICKNESS_DELTA: {
                prefix = "Delta-ExtTau";
                break;
            }
            case ESLAB_THICKNESS_DELTA_PERCENT: {
                prefix = "Delta-ExtTau_per";
                break;
            }
            case CUSTOM_WEATHER: {
                prefix = "Custom";
                break;
            }
            default: {
                prefix = "AddName";
            }
        }
        return prefix;
    }

    public static TimeScale[] getTimePeriod(CommandLineParam commandLineParam) throws IOException {
        TimeScale[] period = new TimeScale[2];
        if (commandLineParam.isKeyExists("startdate") && commandLineParam.isKeyExists("enddate")) {
            String startDateString = commandLineParam.getKeyValue("startdate");
            String endDateString = commandLineParam.getKeyValue("enddate");
            startDateString = startDateString.replace(':', '.');
            endDateString = endDateString.replace(':', '.');
            period[0] = new TimeScale();
            period[1] = new TimeScale();
            try {
                period[0].set(startDateString, DATE_FORMAT);
                period[1].set(endDateString, DATE_FORMAT);
            }
            catch (ParseException ex) {
                throw new RuntimeException("Unable to parse \"-startdate\" or -\"enddate\"; format is: yyyy.MM.dd.hh.mm");
            }
        } else {
            throw new IOException("No parameters, which are required for program run: \"-startdate\" and/or \"-enddate\".");
        }
        return period;
    }
}

