/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.giro.gambit.core.AlgorithmVersions;
import edu.uml.giro.gambit.core.GambitCoreSettings;
import edu.uml.giro.gambit.core.LocalDataOneSiteAllTimes;
import edu.uml.giro.gambit.core.LocalDataType;
import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGallet;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.giro.gambit.synthesizers.Synthesizer;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.IRIModel;
import edu.uml.lgdc.geospace.PlasmaMath;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.DebugParam;
import edu.uml.lgdc.time.TimeScale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LocalData {
    public static final int MAX_SITES = 150;
    public LocalDataOneSiteAllTimes[] sites = new LocalDataOneSiteAllTimes[150];
    public int totalLocations;
    protected CharChoice cc;
    private GambitCoreSettings coreSettings;
    IRIModel iri = new IRIModel();
    protected TimeGrid timeGrid;

    public CharChoice getCharChoice() {
        return this.cc;
    }

    public TimeGrid getTimeGrid() {
        return this.timeGrid;
    }

    public LocalData(CharChoice cc, TimeGrid timeGrid, GambitCoreSettings settings) {
        this.timeGrid = timeGrid;
        this.cc = cc;
        this.coreSettings = settings;
        int i = 0;
        while (i < 150) {
            this.sites[i] = new LocalDataOneSiteAllTimes(cc, timeGrid);
            ++i;
        }
    }

    public void reset() {
        this.totalLocations = 0;
    }

    public boolean isEmpty() {
        return this.totalLocations == 0;
    }

    public LocalDataOneSiteAllTimes getSite(String ursi) {
        if (ursi == null || ursi.length() != 5) {
            return null;
        }
        int iSite = 0;
        while (iSite < this.totalLocations) {
            if (this.sites[iSite].getLocation().getUrsi().toUpperCase().equals(ursi.toUpperCase())) {
                return this.sites[iSite];
            }
            ++iSite;
        }
        return null;
    }

    public LocalDataOneSiteAllTimes[] getSites() {
        return this.sites;
    }

    public void fillClimateValues(Synthesizer climate) {
        int iSite = 0;
        while (iSite < this.totalLocations) {
            this.sites[iSite].fillClimateValues(climate);
            ++iSite;
        }
    }

    public void deriveClimateValues(GeoSynthesizer climate) {
        int iSite = 0;
        while (iSite < this.totalLocations) {
            this.sites[iSite].deriveClimateValues(climate);
            ++iSite;
        }
    }

    public void fillGlobalWeatherValues(Synthesizer weather) {
        int iSite = 0;
        while (iSite < this.totalLocations) {
            this.sites[iSite].fillGlobalWeatherValues(weather);
            ++iSite;
        }
    }

    public void fillLocalWeatherValues(Synthesizer weather) {
        int iSite = 0;
        while (iSite < this.totalLocations) {
            this.sites[iSite].fillLocalWeatherValues((ExpansionBasis_JonesGallet)weather.getExpansionBasis());
            ++iSite;
        }
    }

    public void deriveGlobalWeatherValues(GeoSynthesizer weather) {
        int iSite = 0;
        while (iSite < this.totalLocations) {
            this.sites[iSite].deriveGlobalWeatherValues(weather);
            ++iSite;
        }
    }

    public void processRawData(TimeScale tov) {
        int iSite = 0;
        while (iSite < this.totalLocations) {
            if (!this.sites[iSite].isUnused()) {
                if (this.coreSettings.isWindowBoundaryMitigationEnabled()) {
                    this.sites[iSite].removeOldestData(120);
                }
                this.sites[iSite].fillObservationGaps();
                if (this.coreSettings.isWindowBoundaryMitigationEnabled()) {
                    this.sites[iSite].smoothDayBoundary(tov, this.timeGrid.timeToDiurnalPhaseIndex(tov));
                }
                this.sites[iSite].calculateO2Cdifferences();
            }
            ++iSite;
        }
    }

    public void deriveFrom(LocalData[] input) {
        this.totalLocations = input[0].totalLocations;
        int iSite = 0;
        while (iSite < this.totalLocations) {
            this.sites[iSite] = new LocalDataOneSiteAllTimes(this.cc, input[0].sites[iSite].timeGrid);
            this.sites[iSite].resetLocalData();
            this.sites[iSite].putLocation(input[0].sites[iSite].getLocation());
            this.sites[iSite].putTov(input[0].sites[iSite].getTov());
            ++iSite;
        }
        switch (this.cc) {
            case NMF2: {
                LocalData foF2data = input[0];
                iSite = 0;
                while (iSite < this.totalLocations) {
                    this.copyConvertToDensity(LocalDataType.ALL_OBSERVED_PROCESSED, foF2data, iSite);
                    this.copyConvertToDensity(LocalDataType.ALL_OBSERVED_RAW, foF2data, iSite);
                    this.copyConvertToDensity(LocalDataType.OBSERVED_EXTRAPOLATED, foF2data, iSite);
                    this.copyConvertToDensity(LocalDataType.OBSERVED_GAP_FILLED, foF2data, iSite);
                    this.copyConvertToDensity(LocalDataType.OBSERVED_GOODCONF_ONLY, foF2data, iSite);
                    this.copyConvertToDensity(LocalDataType.OBSERVED_HIGHCONF_ONLY, foF2data, iSite);
                    this.copyConvertToDensity(LocalDataType.OBSERVED_MANUAL_ONLY, foF2data, iSite);
                    this.copyConvertToDensity(LocalDataType.OBSERVED_UNKNOWN_CONF, foF2data, iSite);
                    this.copyConvertToDensity(LocalDataType.LOCAL_WEATHER, foF2data, iSite);
                    this.sites[iSite].putConfidences(foF2data.sites[iSite].getConfidenceScores());
                    this.sites[iSite].putFlags(foF2data.sites[iSite].getFlags());
                    ++iSite;
                }
                break;
            }
            case MUF3000: {
                if (DebugParam.debug || DebugParam.verboseLevel >= 4) {
                    Console.showMsg("LocalData MUF computation...");
                }
                iSite = 0;
                while (iSite < this.totalLocations) {
                    String ursiBase = input[0].sites[iSite].getLocation().getUrsi();
                    int iSite2 = -1;
                    int s = 0;
                    while (s < input[1].totalLocations) {
                        if (input[1].sites[s].getLocation().getUrsi() == ursiBase) {
                            iSite2 = s;
                            break;
                        }
                        ++s;
                    }
                    if (iSite2 != -1) {
                        this.convertToMUF3000(LocalDataType.ALL_OBSERVED_PROCESSED, input, iSite, iSite2);
                        this.convertToMUF3000(LocalDataType.ALL_OBSERVED_RAW, input, iSite, iSite2);
                        this.convertToMUF3000(LocalDataType.OBSERVED_EXTRAPOLATED, input, iSite, iSite2);
                        this.convertToMUF3000(LocalDataType.OBSERVED_GAP_FILLED, input, iSite, iSite2);
                        this.convertToMUF3000(LocalDataType.OBSERVED_GOODCONF_ONLY, input, iSite, iSite2);
                        this.convertToMUF3000(LocalDataType.OBSERVED_HIGHCONF_ONLY, input, iSite, iSite2);
                        this.convertToMUF3000(LocalDataType.OBSERVED_MANUAL_ONLY, input, iSite, iSite2);
                        this.convertToMUF3000(LocalDataType.OBSERVED_UNKNOWN_CONF, input, iSite, iSite2);
                        this.convertToMUF3000(LocalDataType.LOCAL_WEATHER, input, iSite, iSite2);
                        this.sites[iSite].putConfidences(input[0].sites[iSite].getConfidenceScores());
                        this.sites[iSite].putFlags(input[0].sites[iSite].getFlags());
                        this.sites[iSite].setUnused(false);
                    } else {
                        this.sites[iSite].setUnused(true);
                    }
                    ++iSite;
                }
                if (!DebugParam.debug && DebugParam.verboseLevel < 4) break;
                Console.showMsg("Done.");
                break;
            }
            default: {
                String others = "";
                int k = 0;
                while (k < input.length) {
                    others = String.valueOf(others) + " " + input[k].cc.getName();
                    ++k;
                }
                System.err.println("ERROR-Observations: no rules to derive values of " + this.cc.getName() + " from source observations" + others);
            }
        }
    }

    private void copyConvertToDensity(LocalDataType type, LocalData input, int i) {
        int length = input.sites[i].getDoubleArray(type).length;
        this.sites[i].putDoubleArray(type, this.convertToDensity(Arrays.copyOf(input.sites[i].getDoubleArray(type), length)));
    }

    private double[] convertToDensity(double[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] != 9999.0) {
                values[i] = PlasmaMath.freq2density(values[i]);
            }
            ++i;
        }
        return values;
    }

    private void convertToMUF3000(LocalDataType type, LocalData[] input, int iSite, int iSite2) {
        int length = input[0].sites[iSite].getDoubleArray(type).length;
        double[] muf3000values = new double[length];
        if (this.iri == null) {
            Console.showError("Observation values of MUF(3000) could not be derived: IRI is not available");
            return;
        }
        StationLocation loc = input[0].sites[iSite].getLocation();
        this.iri.setTime(input[0].timeGrid.getUTs()[0]);
        this.iri.setLocation(loc.getLat(), loc.getLon());
        this.iri.setSolarActivity();
        this.iri.setMagneticField();
        double R12 = this.iri.getSolarActivity();
        double diplat = this.iri.igrf.diplat;
        int k = 0;
        while (k < length) {
            double foF2 = input[0].sites[iSite].getDoubleArray(type)[k];
            double hmF2 = input[1].sites[iSite2].getDoubleArray(type)[k];
            muf3000values[k] = 9999.0;
            if (foF2 != 9999.0 || hmF2 != 9999.0) {
                if (foF2 == 9999.0) {
                    foF2 = input[0].sites[iSite].getDoubleArray(LocalDataType.ALL_OBSERVED_PROCESSED)[k];
                }
                if (hmF2 == 9999.0) {
                    hmF2 = input[1].sites[iSite2].getDoubleArray(LocalDataType.ALL_OBSERVED_PROCESSED)[k];
                }
                if (foF2 != 9999.0 && hmF2 != 9999.0) {
                    double foEP = this.iri.calculate_foEonly(loc.getLat(), loc.getLon(), input[0].timeGrid.getUTs()[k]);
                    muf3000values[k] = PlasmaMath.MUF3000(foF2, hmF2, foEP, R12, diplat);
                }
            }
            ++k;
        }
        this.sites[iSite].putDoubleArray(type, muf3000values);
    }

    public void loadFromInputStream(TimeScale tov, InputStream obsIS, TreeMap<Integer, StationLocation> locs, AlgorithmVersions versions) {
        DataInputStream in = new DataInputStream(obsIS);
        boolean ringBufferArchitecture = versions.versionID > 1;
        try {
            this.totalLocations = in.readInt();
            int nTimeSteps = in.readInt();
            int iSite = 0;
            while (iSite < this.totalLocations) {
                short id = in.readShort();
                StationLocation loc = locs.get(id);
                this.sites[iSite] = new LocalDataOneSiteAllTimes(this.cc, this.timeGrid);
                this.sites[iSite].resetLocalData();
                this.sites[iSite].putLocation(loc);
                this.sites[iSite].putTov(tov);
                TimeScale obsTime = this.sites[iSite].getMidnightToday();
                int iTime = 0;
                while (iTime < nTimeSteps) {
                    double obs = in.readFloat();
                    short conf = in.readShort();
                    if (ringBufferArchitecture) {
                        this.sites[iSite].addRawObservedValue(iTime, obs, (int)conf);
                    } else {
                        this.sites[iSite].addRawObservedValue(obsTime, obs, (int)conf);
                        obsTime.add(12, this.timeGrid.getTimeStep_min());
                        if (obsTime.after(tov)) {
                            obsTime.add(12, -1440);
                        }
                    }
                    ++iTime;
                }
                ++iSite;
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSites(LocalDataOneSiteAllTimes[] sites) {
        this.totalLocations = 0;
        this.sites = sites;
        int iSite = 0;
        while (iSite < sites.length) {
            if (sites[iSite] != null) {
                ++this.totalLocations;
            }
            ++iSite;
        }
    }

    public int loadLocalWeatherCoeffs(Map<String, double[]> localWeatherCoeffs) {
        int count = 0;
        if (localWeatherCoeffs != null) {
            for (Map.Entry<String, double[]> entry : localWeatherCoeffs.entrySet()) {
                String ursiCode = entry.getKey();
                LocalDataOneSiteAllTimes site = this.getSite(ursiCode);
                if (site != null) {
                    ++count;
                    site.setLocalWeatherCoefs(entry.getValue());
                    continue;
                }
                Console.showWarn("Local weather data from " + ursiCode + " site are in database, but this site is not listed in the localData");
            }
        }
        return count;
    }

    public void updateSitesObservations(LocalDataOneSiteAllTimes[] sites) {
    }

    public ByteArrayInputStream toInputStream(List<StationLocation> usedLocations, Map<String, Integer> gambitStationIDs) {
        int totalTimeSteps = this.getSite(usedLocations.get(0).getUrsi()).getDataLength();
        float[][] observations = new float[usedLocations.size()][totalTimeSteps];
        short[][] confidences = new short[usedLocations.size()][totalTimeSteps];
        int iSite = 0;
        while (iSite < usedLocations.size()) {
            LocalDataOneSiteAllTimes site = this.getSite(usedLocations.get(iSite).getUrsi());
            double[] siteObs = site.getRawObservations();
            int[] siteConf = site.getConfidenceScores();
            int iTime = 0;
            while (iTime < totalTimeSteps) {
                observations[iSite][iTime] = (float)siteObs[iTime];
                confidences[iSite][iTime] = (short)siteConf[iTime];
                ++iTime;
            }
            ++iSite;
        }
        ByteArrayInputStream obsIS = null;
        ByteArrayOutputStream byteAOS = new ByteArrayOutputStream();
        try {
            DataOutputStream out = new DataOutputStream(byteAOS);
            out.writeInt(usedLocations.size());
            out.writeInt(totalTimeSteps);
            int i = 0;
            while (i < usedLocations.size()) {
                out.writeShort((short)gambitStationIDs.get(usedLocations.get(i).getUrsi()).intValue());
                int j = 0;
                while (j < totalTimeSteps) {
                    out.writeFloat(observations[i][j]);
                    out.writeShort(confidences[i][j]);
                    ++j;
                }
                ++i;
            }
            out.flush();
            obsIS = new ByteArrayInputStream(byteAOS.toByteArray());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return obsIS;
    }

    public String getAllUrsiCodes() {
        String codes = "";
        LocalDataOneSiteAllTimes[] localDataOneSiteAllTimesArray = this.sites;
        int n = this.sites.length;
        int n2 = 0;
        while (n2 < n) {
            LocalDataOneSiteAllTimes site = localDataOneSiteAllTimesArray[n2];
            if (site.getLocation() != null) {
                codes = String.valueOf(codes) + site.getLocation().getUrsi() + " ";
            }
            ++n2;
        }
        return codes;
    }
}

