/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.giro.gambit.core.IonogramScaling;
import edu.uml.giro.gambit.core.LocalDataElements;
import edu.uml.giro.gambit.core.LocalDataType;
import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGallet;
import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGalletWithTrend;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.giro.gambit.synthesizers.Synthesizer;
import edu.uml.lgdc.datatype.RingBuffer;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.time.TimeScale;
import java.util.concurrent.TimeUnit;

public class LocalDataOneSiteAllTimes {
    protected CharChoice cc;
    protected TimeGrid timeGrid;
    private RingBuffer<LocalDataElements> data;
    private StationLocation location;
    private boolean controlPoint = false;
    private boolean unused = false;
    private double[] localWeatherCoefs = null;
    private double[] localClimateCoefs = null;
    public static final int SUFFICIENT_DATA_POINTS = 4;
    public static final int TIME_STEPS_TO_AVERAGE = LocalDataOneSiteAllTimes.getTimeStepAverage(4);
    public static final int TIME_STEPS_TO_SKIP = 12;
    public static final int TIME_STEPS_SEARCH = 5;
    public static final double THRESHOLD_JUMP_OF_OBSERVATIONS_FOF2 = 2.0;
    public static final double THRESHOLD_JUMP_OF_OBSERVATIONS_HMF2 = 20.0;

    public LocalDataOneSiteAllTimes(CharChoice cc, TimeGrid timeGrid) {
        this.cc = cc;
        this.timeGrid = timeGrid;
        this.data = new RingBuffer<LocalDataElements>(LocalDataElements.class, TimeUnit.MINUTES, (int)TimeUnit.DAYS.toMinutes(1L), timeGrid.getTimeStep_min(), timeGrid.getForecastPeriod_minutes());
    }

    private static int getTimeStepAverage(int sufficientPoints) {
        return sufficientPoints / 2 > 3 ? 3 : sufficientPoints / 2;
    }

    public void resetLocalData() {
        this.data.clear();
    }

    public void setControlPoint(boolean value) {
        this.controlPoint = value;
    }

    public boolean isControlPoint() {
        return this.controlPoint;
    }

    public StationLocation getLocation() {
        return this.location;
    }

    public void setUnused(boolean b) {
        this.unused = b;
    }

    public boolean isUnused() {
        return this.unused || this.location == null;
    }

    public void putTov(TimeScale tov) {
        this.data.setTov(tov);
    }

    public TimeScale getTov() {
        return this.data.getTov();
    }

    public TimeScale getMidnightToday() {
        return this.data.getMidnightToday();
    }

    public void putLocation(StationLocation location) {
        this.location = location;
    }

    public void putObservations(double[] observations) {
        int i = 0;
        while (i < observations.length) {
            this.data.put(i, (Object)LocalDataType.ALL_OBSERVED_PROCESSED, (Object)observations[i]);
            ++i;
        }
    }

    public void putRawObservations(double[] observations) {
        int i = 0;
        while (i < observations.length) {
            this.data.put(i, (Object)LocalDataType.ALL_OBSERVED_RAW, (Object)observations[i]);
            ++i;
        }
    }

    public void putConfidences(int[] confidences) {
        int i = 0;
        while (i < confidences.length) {
            this.data.put(i, (Object)LocalDataType.CONFIDENCE_SCORE, (Object)confidences[i]);
            ++i;
        }
    }

    public void putFlags(int[] flags) {
        int i = 0;
        while (i < flags.length) {
            this.data.put(i, (Object)LocalDataType.FLAG, (Object)flags[i]);
            ++i;
        }
    }

    public void putDoubleArray(LocalDataType type, double[] array) {
        int i = 0;
        while (i < array.length) {
            this.data.put(i, (Object)type, (Object)array[i]);
            ++i;
        }
    }

    public double[] getDoubleArray(LocalDataType type) {
        Object[] array = this.data.get((Object)type);
        double[] output = new double[array.length];
        int i = 0;
        while (i < array.length) {
            output[i] = array[i] != null ? (Double)array[i] : 9999.0;
            ++i;
        }
        return output;
    }

    public int[] intArray(LocalDataType type) {
        Object[] array = this.data.get((Object)type);
        int[] output = new int[array.length];
        int i = 0;
        while (i < array.length) {
            output[i] = array[i] != null ? (Integer)array[i] : -1;
            ++i;
        }
        return output;
    }

    public double[] getObservations() {
        return this.getDoubleArray(LocalDataType.ALL_OBSERVED_PROCESSED);
    }

    public double[] getRawObservations() {
        return this.getDoubleArray(LocalDataType.ALL_OBSERVED_RAW);
    }

    public double[] getClimateValues() {
        return this.getDoubleArray(LocalDataType.CLIMATE);
    }

    public double[] getLocalWeatherValues() {
        return this.getDoubleArray(LocalDataType.LOCAL_WEATHER);
    }

    public double[] getGlobalWeatherValues() {
        return this.getDoubleArray(LocalDataType.GLOBAL_WEATHER);
    }

    public double[] getObs2Climate() {
        return this.getDoubleArray(LocalDataType.O2C_DIFFERENCE);
    }

    public double[] getObs2GlobalWeather() {
        return this.getDoubleArray(LocalDataType.O2GW_DIFFERENCE);
    }

    public double[] getObs2LocalWeather() {
        return this.getDoubleArray(LocalDataType.O2LW_DIFFERENCE);
    }

    public int[] getConfidenceScores() {
        return this.intArray(LocalDataType.CONFIDENCE_SCORE);
    }

    public int[] getFlags() {
        return this.intArray(LocalDataType.FLAG);
    }

    public int[] getTimegridMismatches() {
        return this.intArray(LocalDataType.TIMEGRID_MISMATCH_PERCENT);
    }

    public TimeGrid getTimeGrid() {
        return this.timeGrid;
    }

    private static double getThreshold(CharChoice cc) {
        switch (cc) {
            case FOF2: {
                return 2.0;
            }
            case HMF2: {
                return 20.0;
            }
        }
        return Double.MAX_VALUE;
    }

    public CharChoice getCharChoice() {
        return this.cc;
    }

    public void addRawObservedValue(TimeScale time, double observedValue, int confidenceScore) {
        int timeGridDeltaPercent = (int)this.data.timeGridMismatch_min(time) * 100 / this.timeGrid.getTimeStep_min();
        LocalDataElements cell = this.data.getCell(time);
        if (cell.isBetter(observedValue, confidenceScore, timeGridDeltaPercent)) {
            return;
        }
        int iTime = this.data.timeToUserIndex(time);
        this.addRawObservedValue(iTime, observedValue, confidenceScore);
        this.data.put(iTime, (Object)LocalDataType.TIMEGRID_MISMATCH_PERCENT, (Object)timeGridDeltaPercent);
    }

    public void addRawObservedValue(int iTime, double observedValue, int confidenceScore) {
        if (iTime < this.data.getLength() && iTime >= 0) {
            this.data.put(iTime, (Object)LocalDataType.ALL_OBSERVED_RAW, (Object)observedValue);
            this.data.put(iTime, (Object)LocalDataType.CONFIDENCE_SCORE, (Object)confidenceScore);
            if (observedValue != 9999.0) {
                switch (confidenceScore) {
                    case 999: {
                        this.data.put(iTime, (Object)LocalDataType.OBSERVED_MANUAL_ONLY, (Object)observedValue);
                        break;
                    }
                    case 51: {
                        this.data.put(iTime, (Object)LocalDataType.OBSERVED_UNKNOWN_CONF, (Object)observedValue);
                        break;
                    }
                    default: {
                        if (IonogramScaling.isHighQuality(confidenceScore)) {
                            this.data.put(iTime, (Object)LocalDataType.OBSERVED_HIGHCONF_ONLY, (Object)observedValue);
                            break;
                        }
                        if (IonogramScaling.isPoorQuality(confidenceScore)) {
                            this.data.put(iTime, (Object)LocalDataType.OBSERVED_LOWCONF_ONLY, (Object)observedValue);
                            break;
                        }
                        this.data.put(iTime, (Object)LocalDataType.OBSERVED_GOODCONF_ONLY, (Object)observedValue);
                    }
                }
            }
        }
    }

    public boolean sufficientData() {
        int counter = 0;
        double[] rawObservations = this.getRawObservations();
        int[] confidences = this.getConfidenceScores();
        int i = 0;
        while (i < this.timeGrid.getNumDiurnalSteps()) {
            if (!IonogramScaling.isMissing(rawObservations[i]) && !IonogramScaling.isPoorQuality(confidences[i])) {
                ++counter;
            }
            ++i;
        }
        return counter >= 4;
    }

    public void fillClimateValues(Synthesizer climate) {
        int i = 0;
        while (i < this.data.getLength()) {
            this.data.put(i, (Object)LocalDataType.CLIMATE, (Object)climate.synthesizeValue(this.location.getLat(), this.location.getLon(), i));
            ++i;
        }
    }

    public void deriveClimateValues(GeoSynthesizer climate) {
        int i = 0;
        while (i < this.data.getLength()) {
            this.data.put(i, (Object)LocalDataType.CLIMATE, (Object)climate.synthesizeValue(this.location.getLat(), this.location.getLon(), i));
            ++i;
        }
    }

    public void fillGlobalWeatherValues(Synthesizer weather) {
        int i = 0;
        while (i < this.data.getLength()) {
            this.data.put(i, (Object)LocalDataType.GLOBAL_WEATHER, (Object)weather.synthesizeValue(this.location.getLat(), this.location.getLon(), i));
            if (weather.getExpansionBasis() instanceof ExpansionBasis_JonesGalletWithTrend) {
                this.data.put(i, (Object)LocalDataType.GLOBAL_TREND, (Object)weather.synthesizeTrend(this.location.getLat(), this.location.getLon(), i));
            }
            ++i;
        }
    }

    public void deriveGlobalWeatherValues(GeoSynthesizer weather) {
        int i = 0;
        while (i < this.data.getLength()) {
            this.data.put(i, (Object)LocalDataType.GLOBAL_WEATHER, (Object)weather.synthesizeValue(this.location.getLat(), this.location.getLon(), i));
            ++i;
        }
    }

    public void fillLocalWeatherValues(ExpansionBasis_JonesGallet basis) {
        int i = 0;
        while (i < this.data.getLength()) {
            double value = 0.0;
            int iOrder = 0;
            while (iOrder < basis.getTemporalBasisLength()) {
                value += this.localWeatherCoefs[iOrder] * basis.getTemporalBasisFunctionValue(iOrder, i);
                ++iOrder;
            }
            this.data.put(i, (Object)LocalDataType.LOCAL_WEATHER, (Object)value);
            if (basis instanceof ExpansionBasis_JonesGalletWithTrend) {
                value = 0.0;
                iOrder = 0;
                while (iOrder < 2) {
                    value += this.localWeatherCoefs[iOrder] * basis.getTemporalBasisFunctionValue(iOrder, i);
                    ++iOrder;
                }
                this.data.put(i, (Object)LocalDataType.LOCAL_TREND, (Object)value);
            }
            ++i;
        }
    }

    public void removeOldestData(int period_min) {
        int stopIndex = period_min / this.timeGrid.getTimeStep_min();
        int i = 0;
        while (i < stopIndex) {
            this.data.put(i, (Object)LocalDataType.ALL_OBSERVED_RAW, (Object)9999.0);
            ++i;
        }
    }

    public void fillObservationGaps() {
        double[] rawObservations = this.getRawObservations();
        int length = rawObservations.length;
        double[] processedObservations = (double[])rawObservations.clone();
        int[] confidences = this.getConfidenceScores();
        int[] flags = new int[confidences.length];
        double[] climateValues = this.getClimateValues();
        int i = 0;
        while (i < length) {
            if (!IonogramScaling.isMissing(rawObservations[i]) && !IonogramScaling.isPoorQuality(confidences[i])) {
                flags[i] = 1;
            } else {
                int iBefore = i - 1;
                do {
                    if (iBefore >= 0) continue;
                    iBefore = this.timeGrid.getNumDiurnalSteps() - 1;
                } while ((IonogramScaling.isMissing(rawObservations[iBefore]) || IonogramScaling.isPoorQuality(confidences[iBefore])) && --iBefore != i);
                if (iBefore == i && IonogramScaling.isMissing(rawObservations[iBefore])) {
                    return;
                }
                double sumBefore = rawObservations[iBefore];
                int countBefore = 1;
                int j = 1;
                while (j < TIME_STEPS_TO_AVERAGE) {
                    int k = iBefore - j;
                    if (k == -1) break;
                    if (!IonogramScaling.isMissing(rawObservations[k]) && !IonogramScaling.isPoorQuality(confidences[k]) && IonogramScaling.isAcceptedAsIs(flags[k])) {
                        sumBefore += rawObservations[k];
                        ++countBefore;
                    }
                    ++j;
                }
                double delta1 = sumBefore / (double)countBefore - climateValues[iBefore];
                boolean forecast = true;
                int iAfter = i + 1;
                if (iAfter < rawObservations.length) {
                    while (IonogramScaling.isMissing(rawObservations[iAfter]) || IonogramScaling.isPoorQuality(confidences[iAfter])) {
                        if (++iAfter == rawObservations.length) break;
                    }
                    if (iAfter < rawObservations.length) {
                        forecast = false;
                    }
                }
                if (!forecast) {
                    double separation;
                    double sumAfter = rawObservations[iAfter];
                    int countAfter = 1;
                    int j2 = 1;
                    while (j2 < TIME_STEPS_TO_AVERAGE) {
                        int k = iAfter + j2;
                        if (k == length) break;
                        if (!IonogramScaling.isMissing(rawObservations[k]) && !IonogramScaling.isPoorQuality(confidences[k]) && IonogramScaling.isAcceptedAsIs(flags[k])) {
                            sumAfter += rawObservations[k];
                            ++countAfter;
                        }
                        ++j2;
                    }
                    if ((separation = (double)(iAfter - iBefore)) < 0.0) {
                        separation += (double)this.timeGrid.getNumDiurnalSteps();
                    }
                    double delta2 = sumAfter / (double)countAfter - climateValues[iAfter];
                    double slope = (delta2 - delta1) / separation;
                    int distanceToLeft = i - iBefore;
                    if (distanceToLeft < 0) {
                        distanceToLeft += this.timeGrid.getNumDiurnalSteps();
                    }
                    processedObservations[i] = climateValues[i] + (delta1 + (double)distanceToLeft * slope);
                    if (IonogramScaling.isMissing(rawObservations[i])) {
                        flags[i] = 2;
                        this.data.put(i, (Object)LocalDataType.CONFIDENCE_SCORE, (Object)-1);
                        this.data.put(i, (Object)LocalDataType.OBSERVED_GAP_FILLED, (Object)processedObservations[i]);
                    } else {
                        flags[i] = 4;
                        this.data.put(i, (Object)LocalDataType.OBSERVED_LOWC_REPLACED, (Object)processedObservations[i]);
                    }
                } else {
                    processedObservations[i] = climateValues[i] + delta1;
                    flags[i] = 16;
                    this.data.put(i, (Object)LocalDataType.CONFIDENCE_SCORE, (Object)31);
                    this.data.put(i, (Object)LocalDataType.OBSERVED_EXTRAPOLATED, (Object)processedObservations[i]);
                }
            }
            this.data.put(i, (Object)LocalDataType.ALL_OBSERVED_PROCESSED, (Object)processedObservations[i]);
            this.data.put(i, (Object)LocalDataType.FLAG, (Object)flags[i]);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean smoothDayBoundary(TimeScale toTime, int nowIndex) {
        if (this.cc.isDerived()) {
            return false;
        }
        double threshold = LocalDataOneSiteAllTimes.getThreshold(this.cc);
        int pointNeeded = 0;
        int nTimes = this.timeGrid.getNumDiurnalSteps();
        int beforeIndex_conf = (nowIndex + nTimes) % nTimes;
        int afterIndex_conf = (nowIndex + 1) % nTimes;
        double[] observations = this.getObservations();
        int[] confidences = this.getConfidenceScores();
        int[] flags = this.getFlags();
        double[] climateValues = this.getClimateValues();
        int iBefore = 0;
        while (iBefore < 5) {
            int beforeIndex = (nowIndex - iBefore + nTimes) % nTimes;
            if (IonogramScaling.isAcceptedAsIs(flags[beforeIndex]) && !IonogramScaling.isPoorQuality(confidences[beforeIndex])) {
                beforeIndex_conf = beforeIndex;
                ++pointNeeded;
                break;
            }
            ++iBefore;
        }
        if (pointNeeded != 1) {
            return false;
        }
        int iAfter = 1;
        while (iAfter < 5) {
            int afterIndex = (nowIndex + iAfter) % nTimes;
            if (IonogramScaling.isAcceptedAsIs(flags[afterIndex]) && !IonogramScaling.isPoorQuality(confidences[afterIndex])) {
                afterIndex_conf = afterIndex;
                break;
            }
            ++iAfter;
        }
        if (!(Math.abs(observations[afterIndex_conf] - observations[beforeIndex_conf]) > threshold)) return false;
        int endIndex_conf = (nowIndex + 12) % nTimes;
        int i = 0;
        int iEnd = 1;
        while (iEnd < 10) {
            int endIndex = (nowIndex + 12 + (i = iEnd / 2 * -1 * (i != 0 ? i : 1) / Math.abs(i != 0 ? i : 1))) % nTimes;
            if (IonogramScaling.isAcceptedAsIs(flags[endIndex]) && !IonogramScaling.isPoorQuality(confidences[endIndex])) {
                endIndex_conf = endIndex;
                ++pointNeeded;
                break;
            }
            ++iEnd;
        }
        if (pointNeeded != 2) return false;
        double delta1 = observations[beforeIndex_conf] - climateValues[beforeIndex_conf];
        double delta2 = observations[endIndex_conf] - climateValues[endIndex_conf];
        int interval = (endIndex_conf - beforeIndex_conf + nTimes) % nTimes - 1;
        double slope = (delta2 - delta1) / (double)interval;
        int iStep = 0;
        while (iStep < interval) {
            int index = (beforeIndex_conf + iStep + 1) % nTimes;
            double newValue = climateValues[index] + (delta1 + (double)iStep * slope);
            this.data.put(index, (Object)LocalDataType.ALL_OBSERVED_PROCESSED, (Object)newValue);
            this.data.put(index, (Object)LocalDataType.OBSERVED_DAYBOUNDARY_DIXED, (Object)newValue);
            this.data.put(index, (Object)LocalDataType.FLAG, (Object)(flags[index] + 8));
            ++iStep;
        }
        return true;
    }

    public void calculateO2Cdifferences() {
        double[] observations = this.getObservations();
        double[] climateValues = this.getClimateValues();
        int i = 0;
        while (i < observations.length) {
            if (!IonogramScaling.isMissing(observations[i])) {
                this.data.put(i, (Object)LocalDataType.O2C_DIFFERENCE, (Object)(observations[i] - climateValues[i]));
            } else {
                this.data.put(i, (Object)LocalDataType.O2C_DIFFERENCE, (Object)9999.0);
            }
            ++i;
        }
    }

    public void calculateO2LWdifferences() {
        double[] observations = this.getObservations();
        double[] localWeatherValues = this.getLocalWeatherValues();
        int i = 0;
        while (i < observations.length) {
            if (!IonogramScaling.isMissing(observations[i])) {
                this.data.put(i, (Object)LocalDataType.O2LW_DIFFERENCE, (Object)(observations[i] - localWeatherValues[i]));
            } else {
                this.data.put(i, (Object)LocalDataType.O2LW_DIFFERENCE, (Object)9999.0);
            }
            ++i;
        }
    }

    public void calculateO2GWdifferences() {
        double[] observations = this.getObservations();
        double[] globalWeatherValues = this.getGlobalWeatherValues();
        int i = 0;
        while (i < observations.length) {
            if (!IonogramScaling.isMissing(observations[i])) {
                this.data.put(i, (Object)LocalDataType.O2GW_DIFFERENCE, (Object)(observations[i] - globalWeatherValues[i]));
            } else {
                this.data.put(i, (Object)LocalDataType.O2GW_DIFFERENCE, (Object)9999.0);
            }
            ++i;
        }
    }

    public double[] getLocalWeatherCoefs() {
        return this.localWeatherCoefs;
    }

    public void setLocalWeatherCoefs(double[] coefs) {
        this.localWeatherCoefs = coefs;
    }

    public double[] getLocalClimateCoefs() {
        return this.localClimateCoefs;
    }

    public void setLocalClimateCoefs(double[] coefs) {
        this.localClimateCoefs = coefs;
    }

    public int getDataLength() {
        return this.data.getLength();
    }

    public LocalDataElements getDataCell(TimeScale targetTime) {
        return this.data.getCell(targetTime);
    }

    public TimeScale getFirstUT() {
        return this.data.getFirstTime();
    }

    public TimeScale getLastUT() {
        return this.data.getLastTime();
    }
}

