/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.lgdc.format.FC;
import java.util.HashMap;
import java.util.Map;

public enum LocalDataType {
    UNKNOWN(0, "UNKNWN", "Unknown quantity"),
    ALL_OBSERVED_RAW(1, "O-raw", "All observations as observed"),
    ALL_OBSERVED_PROCESSED(2, "O-fill", "All observations as processed for data gaps and day boundary fix"),
    OBSERVED_MANUAL_ONLY(3, "O-mnual", "Manually validated scaling "),
    OBSERVED_HIGHCONF_ONLY(4, "O-hiACL", "High confidence autoscaling"),
    OBSERVED_GOODCONF_ONLY(5, "O-okACL", "Acceptable autoscaling"),
    OBSERVED_LOWCONF_ONLY(6, "O-loACL", "Poor quality autoscaling"),
    OBSERVED_UNKNOWN_CONF(7, "O-unACL", "Unknown quality autoscaling"),
    OBSERVED_GAP_FILLED(8, "O-gapFl", "Missing scaling interpolated"),
    OBSERVED_LOWC_REPLACED(9, "O-loCFl", "Poor autoscaling replaced"),
    OBSERVED_EXTRAPOLATED(10, "O-frcst", "Observation forecast"),
    OBSERVED_DAYBOUNDARY_DIXED(11, "O-dayfx", "Day boundary fixed scaling"),
    TIMEGRID_MISMATCH_PERCENT(12, "GridMis", "Deviation of measurement time from time grid"),
    CONFIDENCE_SCORE(13, "ACL", "Autoscaling Confidence Score"),
    FLAG(14, "O-flag", "Observation status flag"),
    CLIMATE(15, "Climate", "IRI quiet-time climatology"),
    LOCAL_WEATHER(16, "LocalW", "Single-site local IRTAM weather"),
    GLOBAL_WEATHER(17, "GlobalW", "Global IRTAM weather"),
    LOCAL_NOWCAST_HISTORY(18, "LW-his", "Local IRTAM nowcast history"),
    GLOBAL_NOWCAST_HISTORY(19, "GW-his", "Global IRTAM nowcast history"),
    O2C_DIFFERENCE(20, "C-err", "Observations-minus-climate"),
    O2LW_DIFFERENCE(21, "LW-err", "Observations-minus-localWeather"),
    O2GW_DIFFERENCE(22, "GW-err", "Observations-minus-globalWeather"),
    O2LWH_DIFFERENCE(23, "LWH-err", "Observations-minus-localNowcastHistory"),
    O2GWH_DIFFERENCE(24, "GWH-err", "Observations-minus-globalNowcastHistory"),
    LW2C_DIFFERENCE(25, "LW-corr", "Local weather correction to climate"),
    GW2C_DIFFERENCE(26, "GW-corr", "Global weather correction to climate"),
    LW2GW_DIFFERENCE(27, "LW-GW", "Difference between local and global weather"),
    LOCAL_TREND(28, "TrendLW", "Trend term of local weather"),
    GLOBAL_TREND(29, "TrendGW", "Trend term of global weather"),
    DST(30, "DST", "Disturbance Storm-Time index");

    private static final Map<Integer, LocalDataType> MAP_BY_ID;
    private static final Map<String, LocalDataType> MAP_BY_NAME;
    private final int id;
    private final String name;
    private final String description;
    private static final int DEFAULT_COLUMN_LABEL_LENTH = 7;

    static {
        MAP_BY_ID = new HashMap<Integer, LocalDataType>();
        MAP_BY_NAME = new HashMap<String, LocalDataType>();
        LocalDataType[] localDataTypeArray = LocalDataType.values();
        int n = localDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocalDataType contents = localDataTypeArray[n2];
            if (MAP_BY_ID.put(contents.getId(), contents) != null) {
                throw new RuntimeException("design error: duplication of id, " + contents.getId());
            }
            if (MAP_BY_NAME.put(contents.getName(), contents) != null) {
                throw new RuntimeException("design error: duplication of name, " + contents.getName());
            }
            ++n2;
        }
    }

    private LocalDataType(int id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getColumnLabel(int width) {
        return FC.padLeft(this.name, width);
    }

    public String getColumnLabel() {
        return this.getColumnLabel(7);
    }

    public String getDescription() {
        return this.description;
    }

    static LocalDataType get(int id) {
        return MAP_BY_ID.get(id);
    }

    static LocalDataType get(String name) {
        return MAP_BY_NAME.get(name);
    }

    public static LocalDataType fromString(String string) {
        if (string != null) {
            try {
                return LocalDataType.valueOf(LocalDataType.class, string.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return UNKNOWN;
    }

    public static boolean isSiteData(LocalDataType type) {
        return type != DST && type != FLAG && type != CONFIDENCE_SCORE && type != TIMEGRID_MISMATCH_PERCENT;
    }
}

