/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.core;

import edu.uml.lgdc.format.GpsTecH5;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.math.ExtMath;
import edu.uml.lgdc.time.TimeScale;

public class TEC
extends Geomap {
    public static final int INDEX_MIN = 0;
    public static final int INDEX_MAX = 1;
    public static final int INDEX_AVERAGE = 2;
    public static final int INDEX_YEAR = 0;
    public static final int INDEX_MONTH = 1;
    public static final int INDEX_DAY = 2;
    public static final int INDEX_HOUR = 3;
    public static final int INDEX_MINUTE = 4;
    public static final int INDEX_SEC = 5;
    public static final int INDEX_LAT = 9;
    public static final int INDEX_LON = 10;
    public static final int INDEX_TEC = 11;
    public static final int INDEX_DTEC = 12;
    public static final int COLUMNS_NUMBER = 13;
    public static final int GPSMAP_LAT_STEP = 1;
    public static final int GPSMAP_LON_STEP = 1;
    public static final int GPSMAP_LAT_STEP_NUMBER = 181;
    public static final int GPSMAP_LON_STEP_NUMBER = 360;
    public static final double SIGMA_FACTOR = 1.0;
    public static final double NEIGHBORS_RADIUS_KM = 200.0;
    private GpsTecH5.GpsTecInstance[] tecData;
    private boolean networkDataReady = false;

    public TEC(MapChoice mc, double noValue) {
        super(mc, noValue);
    }

    public void readGPSTec_H5(String fileName, TimeScale time) {
        this.networkDataReady = false;
        if (this.refTime == null || !this.refTime.equals(time)) {
            this.refTime = new TimeScale(time.getTimeInMillis());
            try {
                TimeScale st = new TimeScale();
                long[] range = GpsTecH5.parseDataRange(fileName, GpsTecH5.DATASETNAME_GPS, time);
                if ((long)((int)(range[1] - range[0] + 1L)) != range[1] - range[0] + 1L) {
                    throw new RuntimeException("Attempt reading a data set too long");
                }
                this.tecData = GpsTecH5.readLines(fileName, GpsTecH5.DATASETNAME_GPS, range[0], (int)(range[1] - range[0] + 1L));
                System.out.println("New VTEC from " + this.tecData.length + " sites, parse time: " + (new TimeScale().getTimeInMillis() - st.getTimeInMillis()) + " ms");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.networkDataReady = true;
    }

    public void calculateGridMap(EarthGrid gridR) {
        double lon;
        double lat;
        int iWidth;
        double value = 0.0;
        int siteOfInterest = 0;
        double[] gridValues = new double[this.earthGrid.getNumLatitudeNodes() * this.earthGrid.getNumLongitudeNodes()];
        int iHeight = 0;
        while (iHeight < this.earthGrid.getNumLatitudeNodes()) {
            iWidth = 0;
            while (iWidth < this.earthGrid.getNumLongitudeNodes()) {
                gridValues[iHeight * this.earthGrid.getNumLongitudeNodes() + iWidth] = this.noValue;
                ++iWidth;
            }
            ++iHeight;
        }
        if (!this.networkDataReady) {
            System.out.println("Maps are empty or not ready. Check gpsTec[] and gpsSitesPosition[].");
        }
        this.metrics.average = 0.0;
        int iSite = 0;
        while (iSite < this.tecData.length) {
            lat = this.tecData[iSite].lat;
            lon = this.tecData[iSite].lon;
            if (ExtMath.isMultiple(lat, this.earthGrid.getLatitudeStep()) && ExtMath.isMultiple(lon, this.earthGrid.getLongitudeStep())) {
                iHeight = (int)((90.0 - lat) / this.earthGrid.getLatitudeStep());
                iWidth = (int)((180.0 + lon) / this.earthGrid.getLongitudeStep());
                value = this.tecData[iSite].tec;
                if (!Double.isNaN(value)) {
                    gridValues[iHeight * this.earthGrid.getNumLongitudeNodes() + iWidth] = value;
                    this.metrics.min = Math.min(this.metrics.min, value);
                    this.metrics.max = Math.max(this.metrics.max, value);
                    this.metrics.average += value;
                    ++siteOfInterest;
                }
            }
            ++iSite;
        }
        this.metrics.average /= (double)siteOfInterest;
        this.metrics.standardDeviation = 0.0;
        iSite = 0;
        while (iSite < this.tecData.length) {
            lat = this.tecData[iSite].lat;
            lon = this.tecData[iSite].lon;
            if ((double)((int)lat) % this.earthGrid.getLatitudeStep() == 0.0 && (double)((int)lon) % this.earthGrid.getLongitudeStep() == 0.0) {
                this.metrics.standardDeviation += (this.metrics.average - this.tecData[iSite].tec) * (this.metrics.average - this.tecData[iSite].tec);
            }
            ++iSite;
        }
        this.metrics.standardDeviation /= (double)this.tecData.length;
        this.metrics.standardDeviation = Math.sqrt(this.metrics.standardDeviation);
        if (gridR == null || gridR.getNumLatitudeNodes() > this.earthGrid.getNumLatitudeNodes() || gridR.getNumLongitudeNodes() > this.earthGrid.getNumLongitudeNodes()) {
            this.mapValues_1D = gridValues;
        } else {
            double[] gridValuesR = new double[gridR.getNumLatitudeNodes() * gridR.getNumLongitudeNodes()];
            int iNode = 0;
            while (iNode < gridValuesR.length) {
                int iLatR = iNode / gridR.getNumLongitudeNodes();
                int iLonR = iNode - iLatR * gridR.getNumLongitudeNodes();
                int[] iLatLon = this.earthGrid.matchNode(gridR, iLatR, iLonR);
                double[][] neighbors = this.earthGrid.getNeighbors(iLatLon[0], iLatLon[1]);
                double weightCounted = 0.0;
                int iNbr = 0;
                while (iNbr < neighbors.length) {
                    value = gridValues[(int)neighbors[iNbr][0] * this.earthGrid.getNumLongitudeNodes() + (int)neighbors[iNbr][1]];
                    if (value != this.noValue) {
                        int n = iNode;
                        gridValuesR[n] = gridValuesR[n] + value * neighbors[iNbr][2];
                        weightCounted += neighbors[iNbr][2];
                    }
                    ++iNbr;
                }
                if (gridValues[iNode] != this.noValue) {
                    int n = iNode;
                    gridValuesR[n] = gridValuesR[n] + gridValues[iNode];
                    weightCounted += 1.0;
                }
                gridValuesR[iNode] = gridValuesR[iNode] != 0.0 && weightCounted != 0.0 ? gridValuesR[iNode] / weightCounted : this.noValue;
                ++iNode;
            }
            this.mapValues_1D = gridValuesR;
        }
        this.needRecalculateGrid = false;
    }

    @Override
    public TEC clone() {
        TEC m = new TEC(this.mapChoice, this.noValue);
        m.setEarthGrid(this.earthGrid);
        int i = 0;
        while (i < this.mapValues_1D.length) {
            m.mapValues_1D[i] = this.mapValues_1D[i];
            ++i;
        }
        m.setMapValues(m.mapValues_1D, this.refTime);
        if (this.refTime_baseline != null) {
            m.setBaselineTime(this.refTime_baseline);
        }
        m.setTecData((GpsTecH5.GpsTecInstance[])this.tecData.clone());
        return m;
    }

    public void setTecData(GpsTecH5.GpsTecInstance[] tecData) {
        this.tecData = tecData;
    }

    @Override
    public void reset() {
        super.reset();
        this.tecData = null;
        this.networkDataReady = false;
    }

    public boolean isNetworkDataReady() {
        return this.networkDataReady;
    }

    public int countPoints() {
        int count = 0;
        if (this.tecData != null) {
            int iSite = 0;
            while (iSite < this.tecData.length) {
                if (!Double.isNaN(this.tecData[iSite].tec)) {
                    ++count;
                }
                ++iSite;
            }
        }
        return count;
    }
}

