/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.database;

import edu.uml.giro.gambit.database.BlobCacheNode;
import edu.uml.giro.gambit.database.BlobContent;
import edu.uml.lgdc.time.TimeScale;
import java.util.HashMap;

public class BlobCache {
    BlobCacheNode head;
    BlobCacheNode tail;
    HashMap<TimeScale, BlobCacheNode> map = null;
    int cap = 0;

    public BlobCache(int capacity) {
        this.cap = capacity;
        this.map = new HashMap();
    }

    public BlobContent get(TimeScale key) {
        if (this.map.get(key) == null) {
            return null;
        }
        BlobCacheNode t = this.map.get(key);
        this.removeNode(t);
        this.offerNode(t);
        return t.value;
    }

    public void put(TimeScale key, BlobContent value) {
        if (this.map.containsKey(key)) {
            BlobCacheNode t = this.map.get(key);
            t.value = value;
            this.removeNode(t);
            this.offerNode(t);
        } else {
            if (this.map.size() >= this.cap) {
                this.map.remove(this.head.key);
                this.removeNode(this.head);
            }
            BlobCacheNode node = new BlobCacheNode(key, value);
            this.offerNode(node);
            this.map.put(key, node);
        }
    }

    private void removeNode(BlobCacheNode n) {
        if (n.prev != null) {
            n.prev.next = n.next;
        } else {
            this.head = n.next;
        }
        if (n.next != null) {
            n.next.prev = n.prev;
        } else {
            this.tail = n.prev;
        }
    }

    private void offerNode(BlobCacheNode n) {
        if (this.tail != null) {
            this.tail.next = n;
        }
        n.prev = this.tail;
        n.next = null;
        this.tail = n;
        if (this.head == null) {
            this.head = this.tail;
        }
    }
}

