/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.database;

import edu.uml.giro.gambit.core.IonogramScaling;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeMap;

public class DataFunctions {
    public static final int NO_CORRELATION = -2;

    public static void printoutGridValues(double[] vals, int latN, int lonN) {
        int iLat = 0;
        while (iLat < latN) {
            int iLon = 0;
            while (iLon < lonN) {
                System.out.print(String.valueOf(FC.DoubleToString(vals[iLon + iLat * lonN], 5, 2)) + " ");
                ++iLon;
            }
            System.out.println();
            ++iLat;
        }
    }

    public static void addCoeffs(double[][] base, double[][] addition) {
        if (base.length != addition.length) {
            return;
        }
        int i = 0;
        while (i < base.length) {
            int j = 0;
            while (j < base[i].length) {
                double[] dArray = base[i];
                int n = j;
                dArray[n] = dArray[n] + addition[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static double findCorrelation_cyclic(double[] data1, double[] data2, int[] conf1, int[] conf2, double[] coord1, double[] coord2, boolean offset) {
        int j;
        if (data1.length != data2.length) {
            Console.showError("Correlation_cyclic call: Data arrays are not the same length.");
            return 0.0;
        }
        if (coord1[1] > 180.0) {
            coord1[1] = coord1[1] - 360.0;
        }
        if (coord2[1] > 180.0) {
            coord2[1] = coord2[1] - 360.0;
        }
        double mean1 = 0.0;
        double mean2 = 0.0;
        double sdo1 = 0.0;
        double sdo2 = 0.0;
        double correlation = 0.0;
        int num = 0;
        double timeDifference = (coord1[1] - coord2[1]) / 15.0 * 60.0;
        int shift = (int)Math.round(timeDifference / 15.0);
        if (!offset) {
            shift = 0;
        }
        int i = 0;
        while (i < data1.length) {
            j = (i + shift + data1.length) % data1.length;
            if (!IonogramScaling.isPoorQuality(conf1[i]) && !IonogramScaling.isPoorQuality(conf2[j])) {
                mean1 += data1[i];
                mean2 += data2[j];
                ++num;
            }
            ++i;
        }
        if (num < data1.length / 4) {
            return -2.0;
        }
        mean1 /= (double)num;
        mean2 /= (double)num;
        i = 0;
        while (i < data1.length) {
            j = (i + shift + data1.length) % data1.length;
            if (!IonogramScaling.isPoorQuality(conf1[i]) && !IonogramScaling.isPoorQuality(conf2[j])) {
                correlation += (data1[i] - mean1) * (data2[j] - mean2);
                sdo1 += (data1[i] - mean1) * (data1[i] - mean1);
                sdo2 += (data2[j] - mean2) * (data2[j] - mean2);
            }
            ++i;
        }
        if (Double.isNaN(correlation /= Math.sqrt(sdo1 * sdo2))) {
            System.err.println("Check data in correlations");
            return -2.0;
        }
        return correlation;
    }

    public static boolean isBufferUpdated(TimeScale startBufTime, TimeScale endBufTime, TimeScale fromTime, TimeScale endTime, int numForecastDays, boolean forecast) {
        TimeScale end;
        TimeScale timeScale = end = forecast ? new TimeScale(endBufTime.getTimeInMinutes() + (double)(numForecastDays * 1440)) : endBufTime;
        if (startBufTime == null || end == null) {
            return false;
        }
        return !startBufTime.after(fromTime) && !end.before(endTime);
    }

    public static boolean isBufferUpdated(TimeScale startBufTime, TimeScale endBufTime, TimeScale fromTime, TimeScale endTime) {
        return DataFunctions.isBufferUpdated(startBufTime, endBufTime, fromTime, endTime, 0, false);
    }

    public static TreeMap<Integer, StationLocation> getSitesInSector(TreeMap<Integer, StationLocation> locs, double latMin, double latMax, double lonMin, double lonMax) {
        lonMin = lonMin > 180.0 ? lonMin - 360.0 : lonMin;
        lonMax = lonMax > 180.0 ? lonMax - 360.0 : lonMax;
        TreeMap<Integer, StationLocation> locations_sector = new TreeMap<Integer, StationLocation>();
        for (Integer i : locs.keySet()) {
            double lon = locs.get(i).getLon() > 180.0 ? locs.get(i).getLon() - 360.0 : locs.get(i).getLon();
            double lat = locs.get(i).getLat();
            if (lonMin < lonMax) {
                if (!(lon >= lonMin) || !(lon <= lonMax) || !(lat >= latMin) || !(lat <= latMax)) continue;
                locations_sector.put(i, locs.get(i));
                continue;
            }
            if (lonMin > lonMax) {
                if (!(lon >= lonMin) && !(lon <= lonMax) || !(lat >= latMin) || !(lat <= latMax)) continue;
                locations_sector.put(i, locs.get(i));
                continue;
            }
            if (!(lat >= latMin) || !(lat <= latMax)) continue;
            locations_sector.put(i, locs.get(i));
        }
        return locations_sector;
    }

    public static double[][] getDistanceMatrix(TreeMap<Integer, StationLocation> locations) {
        int size = locations.size();
        double[][] dists = new double[size][size];
        int ii = 0;
        int jj = 0;
        for (Integer i : locations.keySet()) {
            jj = 0;
            for (Integer j : locations.keySet()) {
                dists[ii][jj] = EarthGrid.onEarthDistance_deg(locations.get(i).getLat(), locations.get(i).getLon(), locations.get(j).getLat(), locations.get(j).getLon());
                ++jj;
            }
            ++ii;
        }
        return dists;
    }

    public static TreeMap<String, Integer> getSitesFromFile(String filename) {
        TreeMap<String, Integer> ursi = new TreeMap<String, Integer>();
        File fileCheck = new File(filename);
        if (!fileCheck.exists()) {
            return null;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            String temp = br.readLine();
            while (temp != null) {
                ursi.put(temp.trim(), ursi.size());
                temp = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ursi;
    }
}

