/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.database;

import edu.uml.giro.gambit.core.AlgorithmVersions;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.core.LocalDataType;
import edu.uml.giro.gambit.database.BlobCache;
import edu.uml.giro.gambit.database.BlobContent;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseContents;
import edu.uml.lgdc.database.DatabaseFarm;
import edu.uml.lgdc.database.DatabaseInputOutput;
import edu.uml.lgdc.database.FirebirdUtil;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.DebugParam;
import edu.uml.lgdc.time.TimeScale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GambitDatabaseReader
extends DatabaseInputOutput {
    public static final int READ_COEFFS = 1;
    public static final int READ_OBSERVATIONS = 2;
    public static final int WRITE = 4;
    public static final int USE_DIDBASE_ASSIMILATION = 8;
    public static final int READ_UWM_VTEC = 16;
    public static final int READ_SINGLE_SITE_WEATHER = 32;
    public static final int READ = 35;
    public static final int STATUS_OBS_ALREADY_AVAILABLE = 1;
    public static final int STATUS_COEFFS_ALREADY_AVAILABLE = 2;
    public static final int STATUS_AVTEC_ALREADY_AVAILABLE = 4;
    public static final int STATUS_SINGLESITE_ALREADY_AVAILABLE = 8;
    public static TreeMap<Integer, AlgorithmVersions> GAMBIT_DB_VERSIONS;
    public static TreeMap<Integer, StationLocation> GAMBIT_STATIONS;
    public static boolean LOCAL_WEATHER_AVAILABLE;
    BlobCache cache = new BlobCache(32);

    static {
        LOCAL_WEATHER_AVAILABLE = false;
    }

    public GambitDatabaseReader(DatabaseFarm farm) {
        super(farm);
        GAMBIT_DB_VERSIONS = this.downloadAlgorithmVersions();
        GAMBIT_STATIONS = this.downloadAllStationLocs();
        LOCAL_WEATHER_AVAILABLE = this.downloadLocalWeatherAvailable();
    }

    public GambitDatabaseReader(ApplicationPassport appPassport, boolean localWeatherAvailable) {
        super(appPassport, DatabaseContents.IRTAM);
        GAMBIT_DB_VERSIONS = this.downloadAlgorithmVersions();
        GAMBIT_STATIONS = this.downloadAllStationLocs();
        LOCAL_WEATHER_AVAILABLE = localWeatherAvailable;
    }

    public GambitDatabaseReader(ApplicationPassport appPassport) {
        super(appPassport, DatabaseContents.IRTAM);
        LOCAL_WEATHER_AVAILABLE = this.downloadLocalWeatherAvailable();
        GAMBIT_DB_VERSIONS = this.downloadAlgorithmVersions();
        GAMBIT_STATIONS = this.downloadAllStationLocs();
    }

    /*
     * Exception decompiling
     */
    public int downloadExpansionID(String expansionName, int temporalLen, int spatialLen) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int downloadAssimilationID(String assimilationName, int nLats, int nLons) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int downloadIrtamVersionID(String irtamVersionName, int aID, int exID) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] downloadStationUrsiCodes() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TreeMap<Integer, StationLocation> downloadAllStationLocs() {
        TreeMap<Integer, StationLocation> locs = null;
        try {
            locs = this.downloadStations();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return locs;
    }

    /*
     * Exception decompiling
     */
    private TreeMap<Integer, StationLocation> downloadStations() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TreeMap<Integer, AlgorithmVersions> downloadAlgorithmVersions() {
        TreeMap<Integer, AlgorithmVersions> algorithms = new TreeMap<Integer, AlgorithmVersions>();
        algorithms.clear();
        AlgorithmVersions av = new AlgorithmVersions();
        av.versionID = 0;
        av.name = "Latest";
        algorithms.put(0, av);
        String querySelect = "SELECT v.Ident, v.Name as VersionName, a.Name as AssimilationName, a.EarthGridLats, a.EarthGridLons, e.Name as BasisName, e.TemporalBasisLength, e.SpatialBasisLength, v.Description FROM Version v JOIN Assimilation a ON v.AssimilationID=a.Ident JOIN Expansion e ON v.ExpansionID=e.Ident ORDER BY v.Ident ASC";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Connection connect = this.openRead(DatabaseContents.IRTAM);
                try {
                    block21: {
                        Statement statement = connect.createStatement();
                        try {
                            try (ResultSet rs = statement.executeQuery(querySelect);){
                                while (rs.next()) {
                                    av = new AlgorithmVersions();
                                    av.versionID = rs.getInt("Ident");
                                    av.name = rs.getString("VersionName").trim();
                                    av.assimilationName = rs.getString("AssimilationName").trim();
                                    av.nLats = rs.getInt("EarthGridLats");
                                    av.nLons = rs.getInt("EarthGridLons");
                                    av.expansionBasisName = rs.getString("BasisName").trim();
                                    av.temporalExpansionTerms = rs.getInt("TemporalBasisLength");
                                    av.spatialExpansionTerms = rs.getInt("SpatialBasisLength");
                                    algorithms.put(av.versionID, av);
                                }
                            }
                            if (statement == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (statement == null) throw throwable;
                            statement.close();
                            throw throwable;
                        }
                        statement.close();
                    }
                    if (connect == null) return algorithms;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (connect == null) throw throwable;
                    connect.close();
                    throw throwable;
                }
                connect.close();
                return algorithms;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (SQLException e) {
            System.err.println("Could not retrieve algorithm descriptions from GAMBIT database. Assuming old database design");
            av = new AlgorithmVersions();
            av.versionID = 1;
            av.name = "IRTAM 0.1B";
            av.assimilationName = "NECTAR";
            av.nLats = 36;
            av.nLons = 35;
            av.expansionBasisName = "JonesGallet";
            av.temporalExpansionTerms = 13;
            av.spatialExpansionTerms = 76;
            algorithms.put(0, av);
        }
        return algorithms;
    }

    public int getGambitStationIdent(String ursiCode) {
        for (Map.Entry<Integer, StationLocation> gambitSite : GAMBIT_STATIONS.entrySet()) {
            if (!ursiCode.equalsIgnoreCase(gambitSite.getValue().getUrsi())) continue;
            return gambitSite.getKey();
        }
        return -1;
    }

    protected Map<String, Integer> getGambitStationIdents(List<StationLocation> subset) throws SQLException {
        HashMap<String, Integer> stations = new HashMap<String, Integer>();
        if (subset != null) {
            for (StationLocation site : subset) {
                String ursiCode = site.getUrsi();
                stations.put(ursiCode, this.getGambitStationIdent(ursiCode));
            }
        } else {
            for (Map.Entry<Integer, StationLocation> gambitSite : GAMBIT_STATIONS.entrySet()) {
                String gambitUrsi = gambitSite.getValue().getUrsi();
                stations.put(gambitUrsi, gambitSite.getKey());
            }
        }
        return stations;
    }

    protected boolean isStationInList(String ursiCode, List<StationLocation> list) {
        for (StationLocation loc : list) {
            if (!loc.getUrsi().equalsIgnoreCase(ursiCode)) continue;
            return true;
        }
        return false;
    }

    public boolean downloadLocalWeatherAvailable() {
        DBConnect dbConnect = (DBConnect)this.dbConnects.get((Object)DatabaseContents.IRTAM);
        if (dbConnect == null) {
            return true;
        }
        dbConnect.readMetadata(1);
        return dbConnect.isTableExist("SingleSiteCoef14");
    }

    public BlobContent download(GeoSynthesizer weather, LocalData obs, TimeScale refTime, int content) throws SQLException, IOException {
        CharChoice cc = obs.getCharChoice();
        double minutes = refTime.getTimeIn(12);
        double timeStep_min = weather.getTimeGrid().getTimeStep_min();
        double steps = Math.floor(minutes / timeStep_min);
        TimeScale tov = new TimeScale(steps * timeStep_min);
        tov.clear(14);
        BlobContent output = this.cache.get(tov);
        if (output == null) {
            output = new BlobContent();
        }
        if (this.downloadContent(output, cc, weather, obs, tov, content)) {
            this.cache.put(tov, output);
        }
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean downloadContent(BlobContent output, CharChoice cc, GeoSynthesizer weather, LocalData obs, TimeScale tov, int content) throws SQLException, IOException {
        boolean downloadObs;
        boolean globalRequested = (content & 1) != 0;
        boolean obsRequested = (content & 2) != 0;
        boolean localRequested = (content & 0x20) != 0;
        boolean globalAvailable = output.isAvailable(cc, LocalDataType.GLOBAL_WEATHER);
        boolean localAvailable = output.isAvailable(cc, LocalDataType.LOCAL_WEATHER);
        boolean obsAvailable = output.isAvailable(cc, LocalDataType.ALL_OBSERVED_PROCESSED);
        boolean downloadGlobal = globalRequested && !globalAvailable;
        boolean downloadLocal = localRequested && LOCAL_WEATHER_AVAILABLE && !localAvailable;
        boolean bl = downloadObs = obsRequested && !obsAvailable;
        if (!(downloadGlobal || downloadLocal || downloadObs)) {
            return false;
        }
        int countBlobs = 0;
        long coefficientId = 0L;
        int countLocals = 0;
        String query = "";
        ResultSet rs = null;
        try {
            Throwable throwable = null;
            Object var23_24 = null;
            try {
                Connection connect = this.openRead(DatabaseContents.IRTAM);
                try {
                    try (Statement statement = connect.createStatement();){
                        if (downloadGlobal || downloadObs) {
                            query = "SELECT TimeUT,";
                            if (downloadGlobal) {
                                query = String.valueOf(query) + "Data";
                            }
                            if (downloadGlobal && downloadObs) {
                                query = String.valueOf(query) + ",";
                            }
                            if (downloadObs) {
                                query = String.valueOf(query) + "Observations";
                            }
                            query = String.valueOf(query) + " FROM Coefficient WHERE TimeUT='" + tov.toTimestamp() + "' AND CharacteristicID=" + cc.getDidbaseIdent();
                            if (weather.getIrtamVersionIdent() > 1) {
                                query = String.valueOf(query) + " AND VersionID=" + weather.getIrtamVersionIdent();
                            }
                            rs = statement.executeQuery(query);
                            while (rs.next()) {
                                TimeScale time = FirebirdUtil.getTime(rs, 1);
                                if (downloadGlobal) {
                                    output.setGlobalWeatherStream(cc, this.copyInputStream(rs.getBinaryStream("Data")));
                                }
                                if (downloadObs) {
                                    output.setObsStream(cc, this.copyInputStream(rs.getBinaryStream("Observations")));
                                }
                                ++countBlobs;
                            }
                        }
                        if (downloadLocal) {
                            query = "SELECT Ident FROM Coefficient WHERE TimeUT='" + tov.toTimestamp() + "' AND CharacteristicID=" + cc.getDidbaseIdent();
                            rs = statement.executeQuery(query);
                            if (!rs.next()) {
                                Console.showWarn("GAMBIT database cannot find local weather coefficients for " + (Object)((Object)cc) + " at " + tov.toHumanUT());
                            } else {
                                coefficientId = rs.getLong(1);
                            }
                            if (coefficientId > 0L) {
                                if (DebugParam.debug || DebugParam.verboseLevel >= 4) {
                                    Console.showMsg("Downloading single-site local weather coefficients for CID " + coefficientId);
                                }
                                query = "SELECT StationID, A0, B0, A1, B1, A2, B2, A3, B3, A4, B4, A5, B5, A6, B6 FROM SingleSiteCoef14 WHERE CoefficientId = " + coefficientId;
                                rs = statement.executeQuery(query);
                                int stationId = -1;
                                while (rs.next()) {
                                    stationId = rs.getInt(1);
                                    double[] coefs = new double[14];
                                    int i = 0;
                                    while (i < 14) {
                                        coefs[i] = rs.getDouble(i + 2);
                                        ++i;
                                    }
                                    String ursiCode = GAMBIT_STATIONS.get(stationId).getUrsi();
                                    output.addLocalWeatherCoeffs(cc, ursiCode, coefs);
                                    ++countLocals;
                                }
                                if (DebugParam.debug || DebugParam.verboseLevel >= 4) {
                                    Console.showMsg("Total local weather coeff sets downloaded: " + countLocals);
                                }
                            }
                        }
                        rs.close();
                    }
                    if (connect == null) return countBlobs > 0 || countLocals > 0;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (connect == null) throw throwable;
                    connect.close();
                    throw throwable;
                }
                connect.close();
                return countBlobs > 0 || countLocals > 0;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return countBlobs > 0 || countLocals > 0;
    }

    private InputStream copyInputStream(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public TimeScale getLatestTime(CharChoice cc) {
        return this.getLatestTime(cc, GambitDatabaseReader.GAMBIT_DB_VERSIONS.get((Object)Integer.valueOf((int)0)).versionID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimeScale getLatestTime(CharChoice cc, int versionID) {
        TimeScale latest = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Connection gambitConnect = this.openRead(DatabaseContents.IRTAM);
                try {
                    try (Statement statement = gambitConnect.createStatement();){
                        ResultSet rs;
                        String queryStr = "SELECT Max(TimeUT) FROM Coefficient";
                        if (versionID != 0) {
                            queryStr = String.valueOf(queryStr) + " WHERE VersionID=" + versionID;
                        }
                        if ((rs = statement.executeQuery(queryStr)).next()) {
                            latest = FirebirdUtil.getTime(rs, 1);
                        }
                        rs.close();
                    }
                    if (gambitConnect == null) return latest;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (gambitConnect == null) throw throwable;
                    gambitConnect.close();
                    throw throwable;
                }
                gambitConnect.close();
                return latest;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return latest;
    }

    public TimeScale getClosestTime(TimeScale tov, CharChoice cc) {
        return this.getClosestTime(tov, cc, GambitDatabaseReader.GAMBIT_DB_VERSIONS.get((Object)Integer.valueOf((int)0)).versionID);
    }

    /*
     * Exception decompiling
     */
    public TimeScale getClosestTime(TimeScale tov, CharChoice cc, int versionID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean recordExists(TimeScale tov, int versionID) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Statement statement;
                Connection gambitConnect;
                block14: {
                    gambitConnect = this.openRead(DatabaseContents.IRTAM);
                    try {
                        block15: {
                            statement = gambitConnect.createStatement();
                            try {
                                String querySelect = "SELECT TimeUT FROM Coefficient WHERE TimeUT='" + tov.toTimestamp() + "' AND VersionID=" + versionID;
                                ResultSet rs = statement.executeQuery(querySelect);
                                if (!rs.next()) break block14;
                                if (statement == null) break block15;
                            }
                            catch (Throwable throwable2) {
                                if (statement == null) throw throwable2;
                                statement.close();
                                throw throwable2;
                            }
                            statement.close();
                        }
                        if (gambitConnect == null) return true;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (gambitConnect == null) throw throwable;
                        gambitConnect.close();
                        throw throwable;
                    }
                    gambitConnect.close();
                    return true;
                }
                if (statement != null) {
                    statement.close();
                }
                if (gambitConnect == null) return false;
                gambitConnect.close();
                return false;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLatestVersionId(TimeScale tov) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                Statement statement;
                Connection gambitConnect;
                block14: {
                    int n;
                    gambitConnect = this.openRead(DatabaseContents.IRTAM);
                    try {
                        block15: {
                            statement = gambitConnect.createStatement();
                            try {
                                TimeScale from = new TimeScale(tov.getTimeInMillis());
                                from.add(13, -450);
                                TimeScale to = new TimeScale(tov.getTimeInMillis());
                                to.add(13, 450);
                                String queryStr = "SELECT MAX(VersionId) FROM Coefficient WHERE TimeUT<'" + to.toTimestamp() + "' AND TimeUT>'" + from.toTimestamp() + "'";
                                ResultSet rs = statement.executeQuery(queryStr);
                                if (!rs.next()) break block14;
                                n = rs.getInt(1);
                                if (statement == null) break block15;
                            }
                            catch (Throwable throwable2) {
                                if (statement == null) throw throwable2;
                                statement.close();
                                throw throwable2;
                            }
                            statement.close();
                        }
                        if (gambitConnect == null) return n;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (gambitConnect == null) throw throwable;
                        gambitConnect.close();
                        throw throwable;
                    }
                    gambitConnect.close();
                    return n;
                }
                if (statement != null) {
                    statement.close();
                }
                if (gambitConnect == null) return 0;
                gambitConnect.close();
                return 0;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public AlgorithmVersions getHighestVersions() {
        return GAMBIT_DB_VERSIONS.get(GAMBIT_DB_VERSIONS.size() - 1);
    }

    public AlgorithmVersions getBestAvailableVersions() {
        return GAMBIT_DB_VERSIONS.get(0);
    }
}

