/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.database;

import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.lgdc.appuserdb.api.UserCredentials;
import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.format.GpsTecH5;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class MadrigalClient {
    public static final String AND = "&";
    public static final String URL_MADRIGAL = "https://cedar.openmadrigal.org/";
    public static final String URL_MADRIGAL_EXPERIMENTS = "https://cedar.openmadrigal.org/getMadfile.cgi?fileName=";
    public static final String URL_MADRIGAL_EXPERIMENTS_SERVICE = "https://cedar.openmadrigal.org/getExperimentsService.py?";
    public static final String URL_GET_LIST_OF_EXPERIMENTS = "https://cedar.openmadrigal.org/getExperimentFilesService.py?id=";
    public static final String CODE_GPS_EXPERIMENT = "8000";
    public static final String GPS_FILE_TYPE_H5 = "fileType=-2";
    public static final String GPS_QUERY_MASK = "YYYY/gps/DDmmmYY/gpsYYMMDDg.EXT&fileType=-2";
    public static final int CONNECTION_TIMEOUT = 5000;
    public static final int READ_TIMEOUT = 25000;
    private static UserCredentials userCreds = null;

    public static String getFileNameForGPSTEC(TimeScale toTime) {
        return String.valueOf(GambitConstants.GPS_TEC_FOLDER) + "gpstec" + toTime.toFormatUT("yyyyMMdd") + ".h5";
    }

    public static void setUserCredentials(UserCredentials newUserCreds) {
        userCreds = newUserCreds;
    }

    public static UserCredentials getUserCredentials() {
        return userCreds;
    }

    private static String getAffiliation() {
        if (userCreds == null) {
            Console.showError("Cannot connect to Madrigal database without email and affiliation; please configure user credentials");
            return null;
        }
        return "user_fullname=IRTAM&user_email=" + userCreds.getGuestEmail() + AND + "user_affiliation=" + userCreds.getGuestAffiliation();
    }

    private static boolean isAffiliationOk() {
        return userCreds != null && userCreds.getGuestEmail() != null;
    }

    public static boolean getGpsFile(File file, TimeScale time, boolean overwrite) {
        if (!MadrigalClient.isAffiliationOk()) {
            Console.showError("Missing guest email address and affiliation required to access Madrigal database.");
            return false;
        }
        try {
            if (!file.exists() || overwrite) {
                file.delete();
                String url = URL_MADRIGAL_EXPERIMENTS + MadrigalClient.getDefaultFile(MadrigalClient.getExperimentID(time, CODE_GPS_EXPERIMENT)) + AND + GPS_FILE_TYPE_H5 + AND + MadrigalClient.getAffiliation();
                System.out.println("Download GPS TEC file from " + url + " to local file " + file.getAbsolutePath());
                FileUtils.copyURLToFile(url, file);
                if (!GpsTecH5.isGood(file.getAbsolutePath())) {
                    System.out.println("File is not hdf5 formated");
                }
            } else {
                System.out.println("No Madrigal download was needed; using available file " + file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void preloadGpsFiles(TimeScale startTime, TimeScale endTime) {
        File file;
        double START_TIME_MINUTES = startTime.getTimeInMinutes();
        TimeScale time = new TimeScale(START_TIME_MINUTES);
        int iTime = 0;
        while (time.getTimeInMinutes() < endTime.getTimeInMinutes()) {
            file = new File(MadrigalClient.getFileNameForGPSTEC(time));
            MadrigalClient.getGpsFile(file, time, false);
            time.setTimeInMinutes(START_TIME_MINUTES + (double)(++iTime * 1440));
        }
        file = new File(MadrigalClient.getFileNameForGPSTEC(time));
        MadrigalClient.getGpsFile(file, time, false);
    }

    public static void preloadGpsFiles(TimeScale[] times) {
        TimeScale[] timeScaleArray = times;
        int n = times.length;
        int n2 = 0;
        while (n2 < n) {
            TimeScale time = timeScaleArray[n2];
            File file = new File(MadrigalClient.getFileNameForGPSTEC(time));
            MadrigalClient.getGpsFile(file, time, false);
            ++n2;
        }
    }

    private static String getPeriodUrl(TimeScale time) {
        return "startyear=" + time.get(1) + AND + "startmonth=" + (time.get(2) + 1) + AND + "startday=" + time.get(5) + AND + "starthour=" + time.get(10) + AND + "startmin=" + time.get(12) + AND + "startsec=1" + AND + "endyear=" + time.get(1) + AND + "endmonth=" + (time.get(2) + 1) + AND + "endday=" + time.get(5) + AND + "endhour=" + time.get(10) + AND + "endmin=" + time.get(12) + AND + "endsec=1" + AND + "local=1";
    }

    private static String getExperimentID(TimeScale time, String experimentType) {
        String experimentID = "";
        String experimentContent = "";
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception sc) {
                // empty catch block
            }
            URL daylist_url = new URL("https://cedar.openmadrigal.org/getExperimentsService.py?code=" + experimentType + AND + MadrigalClient.getPeriodUrl(time));
            HttpURLConnection con = (HttpURLConnection)daylist_url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36");
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.9");
            con.setRequestProperty("Accept-Encoding", "gzip, deflate, br");
            con.setRequestProperty("Connection", "keep-alive");
            con.setRequestProperty("Upgrade-Insecure-Requests", "1");
            CookieManager cookieManager = new CookieManager();
            CookieHandler.setDefault(cookieManager);
            HttpURLConnection.setFollowRedirects(true);
            int responseCode = con.getResponseCode();
            Console.showMsg("Madrigal responded with code " + responseCode);
            InputStream text = (InputStream)con.getContent();
            text.mark(64);
            int readvalue = -1;
            while ((readvalue = text.read()) >= 0) {
                experimentContent = String.valueOf(experimentContent) + (char)readvalue;
            }
            experimentID = experimentContent.substring(0, experimentContent.indexOf(","));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return experimentID;
    }

    private static String getDefaultFile(String experimentID) {
        String filename;
        block4: {
            filename = "";
            URL explist_url = new URL(URL_GET_LIST_OF_EXPERIMENTS + experimentID);
            InputStream text = (InputStream)explist_url.getContent();
            int readvalue = text.read();
            char readbyte = (char)readvalue;
            while (readvalue != -1) {
                filename = String.valueOf(filename) + readbyte;
                readvalue = text.read();
                readbyte = (char)readvalue;
                if (readbyte != '\n') continue;
                if (filename.contains(",1,")) break;
                filename = "";
                readvalue = text.read();
                readbyte = (char)readvalue;
            }
            if (filename.contains(",1,")) break block4;
            System.out.println("Experiment list does not contain default experiment");
            return "";
        }
        try {
            filename = filename.substring(0, filename.indexOf(44));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filename;
    }
}

