/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.core.SitesChoice;
import edu.uml.giro.gambit.display.GAMBITLegends;
import edu.uml.giro.gambit.display.GambitLayers;
import edu.uml.giro.gambit.display.MinMaxForDisplay;
import edu.uml.giro.gambit.display.WWindowManager;
import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.graph.AnimatedGifEncoder;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Position;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Timer;

public class AnimationActionListener
implements ActionListener {
    private static final int MOVIE_FRAME_DELAY = 100;
    private static final int LAST_MOVIE_FRAME_DELAY = 3000;
    private static final String EXTENSION_TEMP = ".temp";
    private static final String EXTENSION_GIF = ".gif";
    private static final double WHAT_TIME_LOOK_AT = 12.0;
    private static final double LONGITUDE_DEGREE_IN_HOUR = 15.0;
    public static final int REPEAT_FIRST_FRAMES = 3;
    public static final boolean RECALCULATE_MINMAX = false;
    private boolean saveFrames = false;
    private AnimatedGifEncoder gifEncoder = new AnimatedGifEncoder();
    private GambitCore gambitCore;
    private WorldWindow wwindow;
    private GambitLayers gambitLayers;
    private GAMBITLegends legends;
    private TimeScale frameTime = new TimeScale();
    private TimeScale lastButOneTime = new TimeScale();
    private final int startHour;
    private boolean firstStep = true;
    private int missFrames = 0;
    private Position initialPos = null;
    private String animationFolder = "";
    private String gifFileName = "Movie";
    private File animatedGIFFile;
    private File animatedGIFFile_temp;
    private int displayMode = 0;
    private boolean makeAnimatedGIF = false;
    private int currentViewType = 2;
    private static Timer movieTimer;

    public AnimationActionListener(GambitCore gambitCore, GambitLayers layers, Position initialPos, GAMBITLegends legends, int displayMode) {
        this.gambitCore = gambitCore;
        this.wwindow = layers.getWwd();
        this.gambitLayers = layers;
        this.legends = legends;
        this.initialPos = new Position(initialPos.latitude, initialPos.longitude, initialPos.elevation);
        this.displayMode = displayMode;
        this.missFrames = 0;
        this.firstStep = true;
        layers.setCaptureCompleted(false);
        TimeScale tov = gambitCore.mapsTimeline.getTov();
        this.startHour = tov.get(11);
        this.wwindow.redraw();
        WWindowManager.printLayers(this.wwindow);
    }

    public void prepareAnimation(boolean makeGIF, TimeScale tov, int duration_hours, String customFolder, String filename) {
        Geomap map;
        int iTime;
        MapChoice mapChoice = this.gambitCore.getCurrentMapChoice();
        SitesChoice sitesChoice = this.gambitCore.getCurrentSitesChoice();
        MapChoice extMapChoice = this.gambitCore.getCurrentExternalMapChoice();
        CharChoice cc = (this.displayMode & 1) != 0 ? mapChoice.getCC() : sitesChoice.getCC();
        TimeGrid timeGrid = this.gambitCore.getDefaultTimeGrid();
        if (mapChoice.isWeatherMap() && this.gambitCore.getWeather(cc) != null) {
            timeGrid = this.gambitCore.getWeather(cc).getTimeGrid();
        }
        this.frameTime.setTime(tov);
        this.frameTime.add(12, -duration_hours * 60 + timeGrid.getTimeStep_min());
        Console.showMsg("--- Starting the animation preparation: first frame at " + this.frameTime.toHumanUT() + " for " + duration_hours + " hours ---");
        this.lastButOneTime.setTime(this.gambitCore.mapsTimeline.getLastTime());
        this.lastButOneTime.add(13, -this.gambitCore.mapsTimeline.getStep_sec());
        this.makeAnimatedGIF = makeGIF;
        if (this.makeAnimatedGIF) {
            if (customFolder != null) {
                this.animationFolder = customFolder;
            } else {
                this.animationFolder = String.valueOf(GambitConstants.MOVIES_OUTPUT_FOLDER) + File.separator + this.frameTime.toFormatUT("yyyy-MM-dd.HH") + ".." + tov.toFormatUT("yyyy-MM-dd.HH") + File.separator;
                File checkDir = new File(this.animationFolder);
                if (!checkDir.exists()) {
                    checkDir.mkdirs();
                }
            }
            this.gifFileName = String.valueOf(this.animationFolder) + filename;
            this.animatedGIFFile_temp = new File(String.valueOf(this.gifFileName) + EXTENSION_TEMP);
            this.animatedGIFFile = new File(String.valueOf(this.gifFileName) + EXTENSION_GIF);
            try {
                this.gifEncoder.start(this.animatedGIFFile_temp.getPath());
                this.gifEncoder.setDelay(100);
                this.gifEncoder.setRepeat(0);
                this.gifEncoder.setQuality(1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        boolean offTov = false;
        int gambitDatabaseMode = 0;
        TimeScale startTime = new TimeScale(tov.getTimeInMillis());
        startTime.add(10, -duration_hours);
        if (duration_hours == 24) {
            startTime.add(12, timeGrid.getTimeStep_min());
        }
        int startingIndex = timeGrid.findClosestTimeStep(startTime);
        TimeScale baselineStartTime = new TimeScale(this.gambitCore.getBaselineTime().getTimeInMillis());
        baselineStartTime.add(12, -duration_hours + timeGrid.getTimeStep_min());
        TimeScale targetTime = new TimeScale(startTime.getTimeInMillis());
        TimeScale baselineTime = new TimeScale(baselineStartTime.getTimeInMillis());
        if ((this.displayMode & 1) != 0 || (this.displayMode & 2) != 0) {
            if ((this.displayMode & 1) != 0 && !mapChoice.isDebugMap()) {
                iTime = startingIndex;
                while (iTime < timeGrid.getNumDiurnalSteps()) {
                    map = (Geomap)this.gambitCore.mapsTimeline.get(targetTime, (Object)mapChoice);
                    if (map == null || map.isDemagnetized() && GambitLayers.getCenteringOption() != GambitLayers.CenteringOptions.LT12_DEMAG || !map.isDemagnetized() && GambitLayers.getCenteringOption() == GambitLayers.CenteringOptions.LT12_DEMAG) {
                        int dataSelection = 16;
                        if (!mapChoice.isClimateMap()) {
                            ++dataSelection;
                        }
                        this.gambitCore.setTimeOfValidity(targetTime, dataSelection, this.gambitCore.getGambitDatabaseReader().getBestAvailableVersions());
                        offTov = true;
                    }
                    targetTime.add(12, timeGrid.getTimeStep_min());
                    ++iTime;
                }
            }
            gambitDatabaseMode = 0;
            if ((this.displayMode & 2) != 0 && offTov) {
                gambitDatabaseMode += 2;
            }
            this.gambitCore.setTimeOfValidity(tov, gambitDatabaseMode, this.gambitCore.getGambitDatabaseReader().getBestAvailableVersions());
            if (MinMaxForDisplay.getAlgorithm() != MinMaxForDisplay.MinMaxAlgorithm.CUSTOM) {
                MinMaxForDisplay.computeOverAllMaps(this.gambitCore.mapsTimeline, mapChoice, 9999.0);
                MinMaxForDisplay.computeOverAllSites(this.gambitCore, this.gambitCore.getChar((CharChoice)sitesChoice.getCC()).localData, sitesChoice, mapChoice.isPercentDeltaMap());
                if ((this.displayMode & 2) != 0 && (this.displayMode & 1) != 0) {
                    MinMaxForDisplay.mergeMinMaxSets(mapChoice, sitesChoice);
                }
            }
        }
        if ((this.displayMode & 4) != 0) {
            targetTime = new TimeScale(startTime.getTimeInMillis());
            iTime = startingIndex;
            while (iTime < timeGrid.getNumDiurnalSteps()) {
                map = (Geomap)this.gambitCore.mapsTimeline.get(targetTime, (Object)extMapChoice);
                if (map == null) {
                    switch (extMapChoice) {
                        case EVTEC_GPS: {
                            this.gambitCore.rebuildExtVTECmap(targetTime);
                            break;
                        }
                        case EVTEC_GPS_DELTA: 
                        case EVTEC_GPS_DELTA_PERCENT: {
                            this.gambitCore.rebuildExtVTECdeltaMap(targetTime, baselineTime);
                            break;
                        }
                        case ESLAB_THICKNESS: {
                            if (!targetTime.equals(tov)) {
                                this.gambitCore.setTimeOfValidity(targetTime, 1, this.gambitCore.getGambitDatabaseReader().getBestAvailableVersions());
                            }
                            this.gambitCore.rebuildExtSlabThicknessMap(this.gambitCore.getSlabThickness(), targetTime);
                            break;
                        }
                        case ESLAB_THICKNESS_DELTA: 
                        case ESLAB_THICKNESS_DELTA_PERCENT: {
                            if (!targetTime.equals(tov)) {
                                this.gambitCore.setTimeOfValidity(targetTime, 1, this.gambitCore.getGambitDatabaseReader().getBestAvailableVersions());
                            }
                            this.gambitCore.rebuildExtSlabThicknessDeltaMap(targetTime, baselineTime);
                        }
                    }
                }
                targetTime.add(12, timeGrid.getTimeStep_min());
                baselineTime.add(12, timeGrid.getTimeStep_min());
                ++iTime;
            }
            if (MinMaxForDisplay.getAlgorithm() != MinMaxForDisplay.MinMaxAlgorithm.CUSTOM) {
                MinMaxForDisplay.computeOverAllExternalMaps(this.gambitCore.mapsTimeline, extMapChoice, 9999.0);
            }
        }
        if (this.gambitCore.mapsTimeline.isEmpty()) {
            throw new RuntimeException("Can not start animation. Error: no data to play (zero length)");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.makeAnimatedGIF && !this.gambitLayers.isCaptureCompleted() && !this.firstStep) {
            String filename = String.valueOf(GambitConstants.MOVIES_OUTPUT_FOLDER) + GambitConstants.getFileNamePrefix(this.gambitCore.getCurrentMapChoice()) + "_" + this.frameTime.toFilenameAternative() + ".png";
            if (this.currentViewType == 2) {
                View view = this.gambitLayers.getWwd().getView();
                Rectangle viewport = view.getViewport();
                Point p = new Point(0, 0);
                WWindowManager.makeWwdCapture(this.wwindow, filename, this.frameTime, this.gifEncoder, this.saveFrames, p, viewport.width, viewport.height, viewport.height - 100);
            } else {
                WWindowManager.makeWwdCapture(this.wwindow, filename, this.frameTime, this.gifEncoder, this.saveFrames, null, 0, 0, 0);
            }
        }
        if (this.frameTime.equals(this.lastButOneTime)) {
            this.gifEncoder.setDelay(3000);
        }
        if (this.frameTime.equals(this.gambitCore.mapsTimeline.getLastTime())) {
            if (this.makeAnimatedGIF && this.currentViewType == 2) {
                MapChoice mapChoice = (this.displayMode & 1) != 0 ? this.gambitCore.getCurrentMapChoice() : this.gambitCore.getCurrentExternalMapChoice();
                String legendFileName = String.valueOf(this.animationFolder) + "Legend" + GambitConstants.getFileNamePrefix(mapChoice) + ".png";
                int wwdWidth = this.gambitLayers.getWwd().getView().getViewport().width;
                int wwdHeight = this.gambitLayers.getWwd().getView().getViewport().height;
                Point position = new Point(0, 0);
                position.x = (wwdWidth - 500) / 2;
                position.y = this.legends.legendPosition.y - 50;
                WWindowManager.makeWwdCapture(this.wwindow, legendFileName, this.frameTime, null, true, position, 500, 100, 100);
            }
            Console.showMsg("--- Stopping the animation at " + this.frameTime.toHumanUT() + " ---");
            AnimationActionListener.stopAnimationTimer();
            if (!this.gambitLayers.isCaptureCompleted()) {
                try {
                    this.gifEncoder.finish();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.animatedGIFFile != null) {
                    if (this.animatedGIFFile.exists()) {
                        this.animatedGIFFile.delete();
                    }
                    try {
                        FileUtils.moveFile(this.animatedGIFFile_temp, this.animatedGIFFile);
                    }
                    catch (IOException eio) {
                        System.out.println("Cannot rename file from " + this.animatedGIFFile_temp.getPath() + " to " + this.animatedGIFFile.getPath());
                        eio.printStackTrace();
                    }
                }
                this.gambitLayers.setCaptureCompleted(true);
            }
            return;
        }
        if (this.firstStep) {
            ++this.missFrames;
            if (this.missFrames >= 3) {
                this.firstStep = false;
            }
            this.frameTime.add(13, -this.gambitCore.mapsTimeline.getStep_sec());
        }
        this.prepareNextDatasetAndPosition();
    }

    private void prepareNextDatasetAndPosition() {
        this.frameTime.add(13, this.gambitCore.mapsTimeline.getStep_sec());
        Geomap originalSurface = (Geomap)this.gambitCore.mapsTimeline.get(this.frameTime, (Object)this.gambitCore.getCurrentMapChoice());
        GambitLayers.CenteringOptions centering = GambitLayers.getCenteringOption();
        switch (centering) {
            case LT12_DEMAG: {
                if (originalSurface != null) {
                    this.gambitCore.transformMap(originalSurface, 1);
                }
            }
            case LT12: {
                double currentLon = (12.0 - this.frameTime.getTimeSinceMidnightIn(11)) * 15.0;
                WWindowManager.setEyeView(this.gambitLayers.getWwd(), Double.MAX_VALUE, currentLon, -1.0);
                break;
            }
        }
        if (this.gambitCore.getCurrentMapChoice().isDeltaMap()) {
            this.gambitLayers.refreshSolarTerminatorLayer(this.frameTime, 1);
        } else {
            this.gambitLayers.refreshSolarTerminatorLayer(this.frameTime, 0);
        }
        this.gambitLayers.refreshMagneticEquatorLayer(this.frameTime);
        this.gambitLayers.buildDataRenderables(this.frameTime, null, this.displayMode);
    }

    public static void startAnimationTimer(AnimationActionListener anime) {
        movieTimer = new Timer(350, anime);
        movieTimer.start();
    }

    public static void stopAnimationTimer() {
        if (movieTimer != null) {
            movieTimer.stop();
        }
    }
}

