/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.core.Core;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.LocalDataOneSiteAllTimes;
import edu.uml.giro.gambit.core.LocalDataType;
import edu.uml.giro.gambit.display.ChartAttributes;
import edu.uml.giro.gambit.display.ChartCurves;
import edu.uml.giro.gambit.display.MinMaxForDisplay;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.GroundSolar;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.time.TimeScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jcckit.Graphics2DPlotCanvas;
import jcckit.data.DataCurve;
import jcckit.data.DataElement;
import jcckit.data.DataPlot;
import jcckit.data.DataPoint;
import jcckit.graphic.Anchor;
import jcckit.graphic.BasicGraphicAttributes;
import jcckit.graphic.FontStyle;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Text;
import jcckit.plot.Plot;
import jcckit.util.ConfigData;
import jcckit.util.ConfigParameters;
import jcckit.util.PropertiesBasedConfigData;

public class Chart
extends JPanel {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int STATION_AXIS_START = -1;
    public static final int NOT_EVEN_DATA_SET = -1;
    public static final int EMPTY_DATA_SET = -2;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.white;
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.black;
    public static final Color POSITIVE_BAR_COLOR = Color.green;
    public static final Color NEGATIVE_BAR_COLOR = Color.red;
    public static final int DEFAULT_IMAGE_WIDTH = 900;
    public static final int DEFAULT_IMAGE_HEIGHT = 400;
    public static final int MAX_NUM_XTICS = 24;
    public static final int SUN_MARK_DIAMETER = 11;
    private Properties props = new Properties();
    private Double userMin;
    private Double userMax;
    private double[] xData;
    private String dataAxisName;
    private TimeScale plotTime;
    private ChartCurves plotData;
    private StationLocation location;
    private boolean isTimeAxis = false;
    private double[] minmaxTic = new double[2];
    private TreeMap<Long, String> ticLabels = new TreeMap();
    private int[] order;
    private int numXTics;
    private Core core;
    private CharChoice cc;
    private LocalDataOneSiteAllTimes siteData;
    private boolean useMergedMinMax = true;

    public Chart(Core core, CharChoice cc, int stationIndex, ChartCurves plotData, TimeScale[] times, TimeScale plotToTime, StationLocation location, Double min, Double max, boolean useMergedMinMax, String dataAxisName) {
        this.core = core;
        this.cc = cc;
        if (stationIndex != -1) {
            this.siteData = core.getLocalData((CharChoice)cc).sites[stationIndex];
        }
        double[] xData = new double[times.length];
        int i = 0;
        while (i < times.length) {
            xData[i] = times[i].getTimeInMinutes();
            ++i;
        }
        this.isTimeAxis = true;
        this.useMergedMinMax = useMergedMinMax;
        this.setup(plotData, xData, plotToTime, location, min, max, dataAxisName);
    }

    private void setup(ChartCurves plotData, double[] xData, TimeScale plotToTime, StationLocation location, Double min, Double max, String dataAxisName) {
        if (!this.checkDataSetLengths(plotData, xData)) {
            throw new RuntimeException("Check data[] in ONE_STATION_MULTICURVE_REPORT constructor");
        }
        this.order = new int[xData.length];
        double[] temp = Arrays.copyOf(xData, xData.length);
        Arrays.sort(temp);
        int i = 0;
        while (i < xData.length) {
            this.order[Arrays.binarySearch((double[])temp, (double)xData[i])] = i;
            ++i;
        }
        this.plotData = plotData;
        this.xData = xData;
        this.plotTime = plotToTime;
        this.location = location;
        this.userMin = min;
        this.userMax = max;
        this.dataAxisName = dataAxisName;
        this.calculateTics();
        this.createProperties(this.dataAxisName, MinMaxForDisplay.getMinMax(xData, null), this.getMinmax(), true, String.valueOf(location.getUrsi()) + " " + location.getName());
    }

    public double[] getXData() {
        return this.xData;
    }

    private void calculateTics() {
        double[] minmaxX = MinMaxForDisplay.getMinMax(this.xData, null);
        TimeScale left = new TimeScale(minmaxX[0]);
        left = left.startOfHour();
        TimeScale right = new TimeScale(minmaxX[1]);
        right = right.endOfHour();
        right.addMillis(1L);
        this.minmaxTic[0] = left.getTimeInMinutes();
        this.minmaxTic[1] = right.getTimeInMinutes();
        int hourStep = 1;
        this.numXTics = (int)((this.minmaxTic[1] - this.minmaxTic[0]) / (double)(hourStep * 60)) + 1;
        if (this.numXTics > 24) {
            hourStep = (int)Math.ceil((double)this.numXTics * 1.0 / 24.0);
            this.numXTics = (int)((this.minmaxTic[1] - this.minmaxTic[0]) / (double)(hourStep * 60)) + 1;
        }
        this.minmaxTic[1] = new TimeScale(this.minmaxTic[0] + (double)((this.numXTics - 1) * hourStep * 60)).getTimeInMinutes();
        int i = 0;
        while (i < this.numXTics) {
            TimeScale tic = new TimeScale(this.minmaxTic[0] + (double)(i * hourStep * 60));
            this.ticLabels.put((long)tic.getTimeInMinutes(), "" + tic.get(11));
            ++i;
        }
    }

    private boolean checkDataSetLengths(ChartCurves data, double[] xData) {
        String methodName = "checkDataSet(double[][] dataSet)";
        if (data == null) {
            System.out.println("No data set (is null). In " + methodName);
            return false;
        }
        if (xData == null) {
            System.out.println("No times. In " + methodName);
            return false;
        }
        int previousLength = -1;
        for (double[] values : data.curves.values()) {
            int length = values.length;
            if (previousLength != -1 && length != previousLength) {
                System.out.println("Error: not all data set have same length. In " + methodName);
                return false;
            }
            previousLength = length;
        }
        if (xData.length != previousLength) {
            System.out.println("Error: The lengths of times[] and data[] are different. In " + methodName);
            return false;
        }
        if (xData.length < 2) {
            System.out.println("Error: Must be at least two data points. In " + methodName);
            return false;
        }
        return true;
    }

    private void createProperties(String dataAxisName, double[] mmX, double[] mmY, boolean drawLegends, String stationTitle) {
        this.props.put("title", "");
        this.props.put("doubleBuffering", (Object)false);
        this.props.put("horizontalAnchor", "left");
        this.props.put("plot/legendVisible", "" + drawLegends);
        this.props.put("plot/coordinateSystem/xAxis/minimum", "" + mmX[0]);
        this.props.put("plot/coordinateSystem/xAxis/maximum", "" + mmX[1]);
        TimeScale start = new TimeScale(this.xData[this.order[0]]);
        TimeScale end = new TimeScale(this.xData[this.order[this.order.length - 1]]);
        String xLabel = "Universal Time, hours (" + start.toFormatUT("dd-MMM-yyyy");
        if (end.get(6) > start.get(6)) {
            xLabel = String.valueOf(xLabel) + ".." + end.toFormatUT("dd-MMM-yyyy");
        }
        xLabel = String.valueOf(xLabel) + ")";
        this.props.put("plot/coordinateSystem/xAxis/axisLabel", xLabel);
        this.props.put("plot/coordinateSystem/xAxis/automaticTicCalculation", "false");
        this.props.put("plot/coordinateSystem/xAxis/minimumTic", "" + this.minmaxTic[0]);
        this.props.put("plot/coordinateSystem/xAxis/maximumTic", "" + this.minmaxTic[1]);
        this.props.put("plot/coordinateSystem/xAxis/numberOfTics", "" + this.numXTics);
        this.props.put("plot/coordinateSystem/xAxis/ticLabelFormat/className", "jcckit.plot.TicLabelMap");
        this.props.put("plot/coordinateSystem/xAxis/axisLabelAttributes/fontSize", "0.03");
        this.props.put("plot/coordinateSystem/xAxis/ticLabelAttributes/fontSize", "0.024");
        this.props.put("plot/coordinateSystem/xAxis/ticLabelPosition", "-0.002 -0.02");
        String map = "";
        for (Long key : this.ticLabels.keySet()) {
            map = String.valueOf(map) + key + "=" + this.ticLabels.get(key) + ";";
        }
        map = map.substring(0, map.length() - 1);
        this.props.put("plot/coordinateSystem/xAxis/ticLabelFormat/map", map);
        this.props.put("plot/coordinateSystem/xAxis/grid", "true");
        this.props.put("plot/coordinateSystem/xAxis/gridAttributes/lineColor", this.color2String(Color.gray));
        this.props.put("plot/coordinateSystem/yAxis/minimum", "" + mmY[0]);
        this.props.put("plot/coordinateSystem/yAxis/maximum", "" + mmY[1]);
        this.props.put("plot/coordinateSystem/yAxis/axisLabel", dataAxisName);
        this.props.put("plot/coordinateSystem/yAxis/axisLabelAttributes/fontSize", "0.03");
        this.props.put("plot/coordinateSystem/yAxis/ticLabelAttributes/fontSize", "0.024");
        this.props.put("plot/coordinateSystem/yAxis/ticLabelPosition", "-0.02 0.002");
        if (mmY[1] >= 10000.0) {
            this.props.put("plot/coordinateSystem/yAxis/ticLabelFormat", "%2.1e");
            this.props.put("plot/coordinateSystem/yAxis/ticLabelAttributes/fontSize", "0.017");
        } else if (mmY[1] >= 6.0) {
            this.props.put("plot/coordinateSystem/yAxis/ticLabelFormat", "%d");
        }
        if (mmY[1] <= 18.0 && mmY[1] >= 4.0) {
            int step = 1;
            int minimumTic = (int)mmY[0];
            int maximumTic = (int)(mmY[1] / (double)step) * step;
            this.props.put("plot/coordinateSystem/yAxis/automaticTicCalculation", "false");
            this.props.put("plot/coordinateSystem/yAxis/maximumTic", "" + maximumTic);
            this.props.put("plot/coordinateSystem/yAxis/minimumTic", "" + minimumTic);
            this.props.put("plot/coordinateSystem/yAxis/numberOfTics", "" + ((maximumTic - minimumTic) / step + 1));
        }
        this.props.put("plot/coordinateSystem/yAxis/grid", "true");
        this.props.put("plot/coordinateSystem/yAxis/gridAttributes/lineColor", this.color2String(Color.gray));
        String curves = "";
        for (Map.Entry<ChartAttributes, double[]> curve : this.plotData.curves.entrySet()) {
            ChartAttributes attr = curve.getKey();
            String curveID = attr.getDataType().getColumnLabel().replace(" ", "");
            switch (attr.getElementStyle()) {
                case 1: {
                    this.props.put("plot/curveFactory/" + curveID + "/withLine", "true");
                    this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/className", "jcckit.graphic.ShapeAttributes");
                    this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/lineColor", this.color2String(attr.getColor()));
                    switch (attr.getLineStyle()) {
                        case 1: {
                            this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/lineThickness", "0.002");
                            break;
                        }
                        case 2: {
                            this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/lineThickness", "0");
                            break;
                        }
                        case 0: {
                            this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/lineThickness", "0.004");
                            break;
                        }
                        case 3: {
                            this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/lineThickness", "0.003");
                            this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/linePattern", "0.01 0.01");
                            break;
                        }
                        case 4: {
                            this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/lineThickness", "0.005");
                            this.props.put("plot/curveFactory/" + curveID + "/lineAttributes/linePattern", "0.005 0.002");
                        }
                    }
                    break;
                }
                case 2: {
                    this.props.put("plot/curveFactory/" + curveID + "/withLine", "false");
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/className", "jcckit.plot.CircleSymbolFactory");
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/attributes/className", "jcckit.graphic.ShapeAttributes");
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/size", "0.01");
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/attributes/fillColor", this.color2String(attr.getColor()));
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/attributes/lineColor", this.color2String(Color.BLACK));
                    break;
                }
                case 3: {
                    this.props.put("plot/curveFactory/" + curveID + "/withLine", "false");
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/className", "jcckit.plot.SquareSymbolFactory");
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/attributes/className", "jcckit.graphic.ShapeAttributes");
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/size", "0.01");
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/attributes/fillColor", this.color2String(attr.getColor()));
                    this.props.put("plot/curveFactory/" + curveID + "/symbolFactory/attributes/lineColor", this.color2String(Color.BLACK));
                }
            }
            curves = String.valueOf(curves) + curveID + " ";
        }
        if (this.isTimeAxis && this.location != null) {
            String sunset = "Sunset";
            curves = String.valueOf(curves) + sunset + " ";
            this.props.put("plot/curveFactory/" + sunset + "/withLine", "false");
            this.props.put("plot/curveFactory/" + sunset + "/symbolFactory/className", "jcckit.plot.CircleSymbolFactory");
            this.props.put("plot/curveFactory/" + sunset + "/symbolFactory/attributes/className", "jcckit.graphic.ShapeAttributes");
            this.props.put("plot/curveFactory/" + sunset + "/symbolFactory/size", "0.012");
            this.props.put("plot/curveFactory/" + sunset + "/symbolFactory/attributes/fillColor", this.color2String(Color.RED));
            this.props.put("plot/curveFactory/" + sunset + "/symbolFactory/attributes/lineColor", this.color2String(Color.BLACK));
            String sunrise = "Sunrise";
            curves = String.valueOf(curves) + sunrise + " ";
            this.props.put("plot/curveFactory/" + sunrise + "/withLine", "false");
            this.props.put("plot/curveFactory/" + sunrise + "/symbolFactory/className", "jcckit.plot.CircleSymbolFactory");
            this.props.put("plot/curveFactory/" + sunrise + "/symbolFactory/attributes/className", "jcckit.graphic.ShapeAttributes");
            this.props.put("plot/curveFactory/" + sunrise + "/symbolFactory/size", "0.012");
            this.props.put("plot/curveFactory/" + sunrise + "/symbolFactory/attributes/fillColor", this.color2String(Color.yellow));
            this.props.put("plot/curveFactory/" + sunrise + "/symbolFactory/attributes/lineColor", this.color2String(Color.BLACK));
        }
        String tov = "TOV";
        curves = String.valueOf(curves) + tov + " ";
        this.props.put("plot/curveFactory/" + tov + "/withLine", "true");
        this.props.put("plot/curveFactory/" + tov + "/lineAttributes/className", "jcckit.graphic.ShapeAttributes");
        this.props.put("plot/curveFactory/" + tov + "/lineAttributes/lineColor", this.color2String(Color.BLUE));
        this.props.put("plot/curveFactory/" + tov + "/lineAttributes/lineThickness", "0.003");
        this.props.put("plot/curveFactory/" + tov + "/lineAttributes/linePattern", "0.01 0.01");
        String zero = "zeroLine";
        curves = String.valueOf(curves) + zero + " ";
        this.props.put("plot/curveFactory/" + zero + "/withLine", "true");
        this.props.put("plot/curveFactory/" + zero + "/lineAttributes/className", "jcckit.graphic.ShapeAttributes");
        this.props.put("plot/curveFactory/" + zero + "/lineAttributes/lineColor", this.color2String(Color.black));
        this.props.put("plot/curveFactory/" + zero + "/lineAttributes/lineThickness", "0");
        this.props.put("plot/curveFactory/definitions", curves.trim());
        int curvesCount = curves.length() - curves.replaceAll(" ", "").length() + 1;
        this.props.put("plot/legend/boxHeight", "" + (0.03 * (double)curvesCount + 0.01));
        this.props.put("plot/legend/boxWidth", "0.48");
        this.props.put("plot/legend/titleAttributes/fontSize", "0.026");
        this.props.put("plot/legend/titleAttributes/horizontalAnchor", "center");
        this.props.put("plot/legend/titleAttributes/verticalAnchor", "top");
        this.props.put("plot/legend/titleAttributes/fontSize", "0.03");
        this.props.put("plot/legend/titleDistance", "0.02");
        this.props.put("plot/legend/topDistance", "0.07");
        this.props.put("plot/legend/upperRightCorner", "1.44 0.55");
        this.props.put("plot/legend/title", stationTitle);
        this.props.put("plot/initialHintForNextCurve/className", "jcckit.plot.PositionHint");
        this.props.put("plot/initialHintForNextCurve/position", "0 0.1");
        this.props.put("paper", "0 0 1 0.6");
    }

    private double[] getMinmax() {
        boolean merged = this.useMergedMinMax;
        for (ChartAttributes attr : this.plotData.curves.keySet()) {
            if (LocalDataType.isSiteData(attr.getDataType())) continue;
            merged = false;
        }
        double[] minmax = merged ? MinMaxForDisplay.getMergedMinMax() : this.getMinMax(this.plotData);
        minmax[0] = Math.min(minmax[0], 0.0);
        double rangeDiff = minmax[1] - minmax[0];
        double DIFFS_OFFSET_U = (int)(rangeDiff * 0.1);
        double DIFFS_OFFSET_L = minmax[0] >= 0.0 ? 0 : (int)(rangeDiff * 0.1);
        if (this.userMax == null || minmax[1] + DIFFS_OFFSET_U > this.userMax) {
            minmax[1] = minmax[1] + DIFFS_OFFSET_U;
        }
        minmax[0] = this.userMin == null ? minmax[0] - DIFFS_OFFSET_L : this.userMin;
        return minmax;
    }

    public void setUseMergedMinMax(boolean b) {
        this.useMergedMinMax = b;
    }

    public void plot(boolean showStandaloneWindow, String title) {
        System.getProperties().setProperty("java.awt.headless", "true");
        BufferedImage bufImage = new BufferedImage(900, 400, 1);
        this.composeGraph(bufImage, bufImage.getWidth(), bufImage.getHeight(), this.dataAxisName);
        this.paint(bufImage.getGraphics());
        try {
            File graphOutDirectory = new File(String.valueOf(GambitConstants.REPORT_IMAGE_FOLDER) + this.plotTime.toFilenameAternative());
            if (!graphOutDirectory.exists() && !graphOutDirectory.mkdirs()) {
                throw new RuntimeException("Can not create one or more directories in path: " + graphOutDirectory.getAbsolutePath());
            }
            String reportFileName = String.valueOf(graphOutDirectory.getPath()) + "/" + title;
            ImageIO.write((RenderedImage)bufImage, "JPG", new File(String.valueOf(reportFileName) + ".jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.getProperties().setProperty("java.awt.headless", "true");
        if (showStandaloneWindow) {
            this.composeGraph(null, 900, 400, this.dataAxisName);
            JFrame plotframe = new JFrame();
            plotframe.add(this);
            if (title != null) {
                plotframe.setTitle(title);
            }
            plotframe.setSize(900, 400);
            plotframe.setLocation(200, 200);
            plotframe.setVisible(true);
        }
        if (this.core != null) {
            try {
                String reportFileName = String.valueOf(GambitConstants.REPORT_IMAGE_FOLDER) + this.plotTime.toFilenameAternative() + "/" + title;
                File file = new File(reportFileName);
                ChartCurves.logPlotData(reportFileName, this.plotData, this.xData, this.location, this.core.getClimate(this.cc), this.core.getWeather(this.cc), this.siteData.getLocalWeatherCoefs());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void composeGraph(BufferedImage grph, int width, int height, String dataAxisName) {
        DataPlot dataPlot = new DataPlot();
        for (Map.Entry<ChartAttributes, double[]> curve : this.plotData.curves.entrySet()) {
            ChartAttributes attr = curve.getKey();
            double[] values = curve.getValue();
            DataCurve jccCurve = new DataCurve(attr.getDataType().getDescription());
            dataPlot.addElement((DataElement)jccCurve);
            int i = 0;
            while (i < values.length) {
                if (values[this.order[i]] != 9999.0) {
                    jccCurve.addElement((DataElement)new DataPoint(this.xData[this.order[i]], values[this.order[i]]));
                }
                ++i;
            }
        }
        if (this.isTimeAxis && this.location != null) {
            GroundSolar gs = new GroundSolar(this.location.getLat(), this.location.getLon(), 300.0, this.plotTime);
            TimeScale sunrise = gs.getSunriseTimeUT();
            TimeScale sunset = gs.getSunsetTimeUT();
            DataCurve curveSunset = new DataCurve("Sunset");
            dataPlot.addElement((DataElement)curveSunset);
            if (sunset != null) {
                if (sunset.getTimeInMillis() > this.plotTime.getTimeInMillis()) {
                    sunset.add(5, -1);
                }
                curveSunset.addElement((DataElement)new DataPoint(sunset.getTimeInMinutes(), 0.0));
            }
            DataCurve curveSunrise = new DataCurve("Sunrise");
            dataPlot.addElement((DataElement)curveSunrise);
            if (sunrise != null) {
                if (sunrise.getTimeInMillis() > this.plotTime.getTimeInMillis()) {
                    sunrise.add(5, -1);
                }
                curveSunrise.addElement((DataElement)new DataPoint(sunrise.getTimeInMinutes(), 0.0));
            }
        }
        DataCurve tovLine = new DataCurve("Time of IRTAM computation (TOV)");
        dataPlot.addElement((DataElement)tovLine);
        tovLine.addElement((DataElement)new DataPoint(this.plotTime.getTimeInMinutes(), 0.0));
        tovLine.addElement((DataElement)new DataPoint(this.plotTime.getTimeInMinutes(), this.getMinmax()[1]));
        Graphics2DPlotCanvas plotCanvas = new Graphics2DPlotCanvas(new ConfigParameters((ConfigData)new PropertiesBasedConfigData(this.props)));
        plotCanvas.getGraphicsCanvas().setSize(new Dimension(width, height));
        plotCanvas.connect(dataPlot);
        Plot plot = plotCanvas.getPlot();
        GraphPoint licensePosition = new GraphPoint(0.97, 0.027);
        BasicGraphicAttributes textAttributes = new BasicGraphicAttributes(Color.white, Color.gray, 0.0, new double[]{0.01, 0.01}, Color.gray, "SansSerif", FontStyle.ITALIC, 0.017, 0.0, Anchor.LEFT_BOTTOM, Anchor.LEFT_BOTTOM);
        Text license = new Text(licensePosition, "Released under CC BY-NC-SA 4.0 (non-commercial use)", (GraphicAttributes)textAttributes);
        GraphPoint ackPosition = new GraphPoint(0.97, 0.01);
        Text ack = new Text(ackPosition, "Requires acknowledgement of " + this.location.getUrsi() + " data provider", (GraphicAttributes)textAttributes);
        GraphicalComposite combinedText = new GraphicalComposite(null);
        combinedText.addElement((GraphicalElement)ack);
        combinedText.addElement((GraphicalElement)license);
        plot.setAnnotation((GraphicalElement)combinedText);
        if (grph == null) {
            this.setLayout(new BorderLayout());
            this.add((Component)plotCanvas.getGraphicsCanvas(), "Center");
        } else {
            plotCanvas.setDoubleBuffering(false);
            plotCanvas.draw2DInto((Image)grph);
        }
    }

    private double[] getMinMax(ChartCurves plotData) {
        double[] minmax = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        for (double[] values : plotData.curves.values()) {
            MinMaxForDisplay.getMinMax(values, minmax);
        }
        return minmax;
    }

    private String color2String(Color color) {
        return "#" + String.format("%06x", color.getRGB() & 0xFFFFFF);
    }
}

