/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.core.LocalDataType;
import java.awt.Color;

public class ChartAttributes {
    public static final int ELEMENT_BAR = 0;
    public static final int ELEMENT_LINE = 1;
    public static final int ELEMENT_DOTS = 2;
    public static final int ELEMENT_SQUARE = 3;
    public static final int LINE_BOLD = 0;
    public static final int LINE_THIN = 1;
    public static final int LINE_FAINT = 2;
    public static final int LINE_DASHED = 3;
    public static final int LINE_DOTTED = 4;
    LocalDataType dataType;
    Color color;
    int lineStyle;
    int elementStyle;

    public LocalDataType getDataType() {
        return this.dataType;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getElementStyle() {
        return this.elementStyle;
    }

    public ChartAttributes(LocalDataType dataType, Color color, int lineStyle, int elementStyle) {
        this.dataType = dataType;
        this.color = color;
        this.lineStyle = lineStyle;
        this.elementStyle = elementStyle;
    }

    public static ChartAttributes createEmpty() {
        return new ChartAttributes(LocalDataType.UNKNOWN, Color.white, 0, 0);
    }

    public static ChartAttributes parse(String optionName, String attributesAsStr) {
        assert (attributesAsStr != null);
        LocalDataType type = LocalDataType.fromString(optionName);
        String[] tokens = (attributesAsStr = attributesAsStr.trim()).split(",");
        if (tokens.length < 5) {
            return ChartAttributes.createEmpty();
        }
        Color color = new Color(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
        int lineStyle = Integer.parseInt(tokens[3]);
        int elementStyle = Integer.parseInt(tokens[4]);
        return new ChartAttributes(type, color, lineStyle, elementStyle);
    }

    public StringBuilder append(StringBuilder sb) {
        return sb.append(this.color.getRed()).append(',').append(this.color.getGreen()).append(',').append(this.color.getBlue()).append(',').append(this.lineStyle).append(',').append(this.elementStyle).append(',');
    }

    public String toString() {
        return this.append(new StringBuilder(128)).toString();
    }
}

