/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.display.ChartAttributes;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.time.TimeScale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class ChartCurves {
    public LinkedHashMap<ChartAttributes, double[]> curves = new LinkedHashMap();

    public ChartCurves() {
        this.curves.clear();
    }

    public void add(ChartAttributes attr, double[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] != 9999.0) {
                this.curves.put(attr, values);
                return;
            }
            ++i;
        }
    }

    public static void logPlotData(String filename, ChartCurves data, double[] xData, StationLocation location, GeoSynthesizer climate, GeoSynthesizer weather, double[] localWeatherCoeffs) throws IOException {
        int j;
        PrintWriter writer = new PrintWriter(String.valueOf(filename) + ".txt");
        double[] climateCoeffs = null;
        boolean B0 = climate.cc.equals((Object)CharChoice.B0);
        boolean B1 = climate.cc.equals((Object)CharChoice.B1);
        boolean MUF = climate.cc.equals((Object)CharChoice.MUF3000);
        if (!(B0 || B1 || MUF)) {
            climateCoeffs = climate.getDiurnalCoefficients(location.getLat(), location.getLon());
        }
        double[] weatherCoeffs = null;
        if (!MUF) {
            weatherCoeffs = weather.getDiurnalCoefficients(location.getLat(), location.getLon());
        }
        writer.write("# Global Ionosphere Radio Observatory (GIRO)" + System.lineSeparator());
        writer.write("# IRI-based Real-Time Assimilative Model (IRTAM)" + System.lineSeparator());
        writer.write("# Single site data dump: " + location.getName() + ", coord.: " + location.getLat() + " " + location.getLon() + System.lineSeparator());
        writer.write("# Generated by GX.User 1.3F on " + new TimeScale().toFormatISO8601() + System.lineSeparator());
        writer.write("# Ionospheric Characteristic: " + weather.cc.getName() + " [" + weather.cc.getUnits() + "] " + System.lineSeparator());
        TimeScale tov = new TimeScale(xData[0] + 1440.0 - (double)weather.getTimeGrid().getTimeStep_min());
        writer.write("# Time of Validity " + tov.toFormatISO8601() + System.lineSeparator());
        writer.write("# Assimilative Engine: " + weather.getAssimilationMethodName() + System.lineSeparator());
        int count = 0;
        if (climateCoeffs != null) {
            writer.write("# Climate coefficients (IRI) for this site: a0 a1 b1 a2 b2 a3 b3... " + System.lineSeparator() + "#");
            j = 0;
            while (j < climateCoeffs.length) {
                writer.write(" " + FC.DoubleToString(climateCoeffs[j], 15, 8));
                if (++count == 4) {
                    writer.write(String.valueOf(System.lineSeparator()) + "#");
                    count = 0;
                }
                ++j;
            }
            writer.write(System.lineSeparator());
        }
        if (climateCoeffs != null) {
            writer.write("# Global weather coefficients (IRTAM) for this site: a0 b0 a1 b1 a2 b2 a3 b3..." + System.lineSeparator() + "#");
            count = 0;
            j = 0;
            while (j < weatherCoeffs.length) {
                writer.write(" " + FC.DoubleToString(weatherCoeffs[j], 15, 8));
                if (++count == 4) {
                    writer.write(String.valueOf(System.lineSeparator()) + "#");
                    count = 0;
                }
                ++j;
            }
            if (count != 0) {
                writer.write(System.lineSeparator());
            }
        }
        if (localWeatherCoeffs != null) {
            writer.write("# Local weather coefficients (IRTAM) for this site: a0 b0 a1 b1 a2 b2 a3 b3..." + System.lineSeparator() + "#");
            count = 0;
            j = 0;
            while (j < localWeatherCoeffs.length) {
                writer.write(" " + FC.DoubleToString(localWeatherCoeffs[j], 15, 8));
                if (++count == 4) {
                    writer.write(String.valueOf(System.lineSeparator()) + "#");
                    count = 0;
                }
                ++j;
            }
            if (count != 0) {
                writer.write(System.lineSeparator());
            }
        }
        writer.write("#" + System.lineSeparator());
        String line = "yyyyMMdd_HH:mm ";
        for (ChartAttributes attr : data.curves.keySet()) {
            line = String.valueOf(line) + attr.getDataType().getColumnLabel() + " ";
        }
        writer.write(String.valueOf(line) + "\n");
        int i = 0;
        while (i < xData.length) {
            line = String.valueOf(new TimeScale(xData[i]).toFormatUT("yyyyMMdd_HH:mm")) + " ";
            for (Map.Entry<ChartAttributes, double[]> entry : data.curves.entrySet()) {
                double[] values = entry.getValue();
                int width = entry.getKey().getDataType().getColumnLabel().length();
                line = String.valueOf(line) + (values[i] != 9999.0 ? FC.DoubleToString(values[i], width, 2) : String.valueOf(FC.nC2S(' ', width - 1)) + "0") + " ";
            }
            writer.write(String.valueOf(line) + "\n");
            ++i;
        }
        writer.close();
    }

    public static String getAllDataToOneString(ChartCurves curves, int iTime) {
        String output = "";
        for (Map.Entry<ChartAttributes, double[]> entry : curves.curves.entrySet()) {
            output = String.valueOf(output) + FC.DoubleToString(entry.getValue()[iTime], 6, 2) + "   ";
        }
        return output;
    }

    public static String getLegendsToOneString(ChartCurves curves) {
        String output = "";
        for (ChartAttributes attr : curves.curves.keySet()) {
            output = String.valueOf(output) + attr.getDataType().getColumnLabel() + "   ";
        }
        return output;
    }
}

