/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenImage;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceLegend;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.util.ArrayList;

public class ColorLegend
extends AnalyticSurfaceLegend {
    private ColorLegend() {
    }

    public static ColorLegend fromColorGradient(int width, int height, double minValue, double maxValue, double minHue, double maxHue, Color borderColor, Iterable<? extends AnalyticSurfaceLegend.LabelAttributes> labels, AnalyticSurfaceLegend.LabelAttributes titleLabel) {
        ColorLegend legend = new ColorLegend();
        legend.screenImage = new ScreenImage();
        legend.screenImage.setImageSource((Object)legend.createHorizontalColorGradientLegendImage(width, height, minHue, maxHue, borderColor));
        legend.labels = legend.createColorGradientLegendLabels(width, height, minValue, maxValue, labels, titleLabel);
        return legend;
    }

    public static ColorLegend fromColorGradient(double minValue, double maxValue, double minHue, double maxHue, Iterable<? extends AnalyticSurfaceLegend.LabelAttributes> labels, AnalyticSurfaceLegend.LabelAttributes titleLabel) {
        return ColorLegend.fromColorGradient(32, 256, minValue, maxValue, minHue, maxHue, DEFAULT_COLOR, labels, titleLabel);
    }

    protected BufferedImage createHorizontalColorGradientLegendImage(int width, int height, double minHue, double maxHue, Color borderColor) {
        BufferedImage image = new BufferedImage(width, height, 6);
        Graphics2D g2d = image.createGraphics();
        try {
            int x = 0;
            while (x < width) {
                double hue = WWMath.mix((double)(1.0 - (double)x / (double)(width - 1)), (double)maxHue, (double)minHue);
                g2d.setColor(Color.getHSBColor((float)hue, 1.0f, 1.0f));
                g2d.drawLine(x, 0, x, height - 20);
                ++x;
            }
            if (borderColor != null) {
                g2d.setColor(borderColor);
                g2d.drawRect(0, 0, width - 1, height - 20);
            }
        }
        finally {
            g2d.dispose();
        }
        return image;
    }

    protected Iterable<? extends Renderable> createColorGradientLegendLabels(int width, int height, double minValue, double maxValue, Iterable<? extends AnalyticSurfaceLegend.LabelAttributes> labels, AnalyticSurfaceLegend.LabelAttributes titleLabel) {
        ArrayList<AnalyticSurfaceLegend.LabelRenderable> list = new ArrayList<AnalyticSurfaceLegend.LabelRenderable>();
        if (labels != null) {
            for (AnalyticSurfaceLegend.LabelAttributes labelAttributes : labels) {
                if (labelAttributes == null) continue;
                double factor = WWMath.computeInterpolationFactor((double)labelAttributes.getValue(), (double)minValue, (double)maxValue);
                double x = (double)width - (1.0 - factor) * (double)(width - 1);
                list.add(new AnalyticSurfaceLegend.LabelRenderable((AnalyticSurfaceLegend)this, labelAttributes, x, (double)height, "gov.nasa.worldwind.avkey.Center", "gov.nasa.worldwind.avkey.Bottom"));
            }
        }
        if (titleLabel != null) {
            list.add(new AnalyticSurfaceLegend.LabelRenderable((AnalyticSurfaceLegend)this, titleLabel, (double)width / 2.0, -3.0, "gov.nasa.worldwind.avkey.Center", "gov.nasa.worldwind.avkey.Top"));
        }
        return list;
    }

    public static Iterable<? extends AnalyticSurfaceLegend.LabelAttributes> createDefaultColorGradientLabels(double minValue, double maxValue, Format format, Font font, Color color) {
        return ColorLegend.createDefaultColorGradientLabels(minValue, maxValue, format, font, color, 0);
    }

    public static Iterable<? extends AnalyticSurfaceLegend.LabelAttributes> createDefaultColorGradientLabels(double minValue, double maxValue, Format format, Font font, Color color, int exponent) {
        if (format == null) {
            String message = Logging.getMessage((String)"nullValue.Format");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        ArrayList<AnalyticSurfaceLegend.LabelAttributes> labels = new ArrayList<AnalyticSurfaceLegend.LabelAttributes>();
        int numLabels = 5;
        double divisionFactor = Math.pow(10.0, -exponent);
        int i = 0;
        while (i < numLabels) {
            double value = WWMath.mix((double)((double)i / (double)(numLabels - 1)), (double)minValue, (double)maxValue);
            String text = format.format(value * divisionFactor);
            if (!WWUtil.isEmpty((Object)text)) {
                labels.add(ColorLegend.createLegendLabelAttributes((double)value, (String)text, (Font)font, (Color)color, (double)5.0, (double)0.0));
            }
            ++i;
        }
        return labels;
    }
}

