/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.core.Core;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.core.LocalDataAllSitesOneTime;
import edu.uml.giro.gambit.core.LocalDataOneSiteAllTimes;
import edu.uml.giro.gambit.display.ChartAttributes;
import edu.uml.giro.gambit.display.ChartCurves;
import edu.uml.giro.gambit.display.GambitChartSettings;
import edu.uml.giro.gambit.display.MinMaxForDisplay;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.time.TimeScale;
import gov.nasa.worldwind.geom.Position;

public class DisplayDataBuilder {
    static EarthGrid earthGrid = null;
    static TimeGrid timeGrid = null;
    public static String[] wwStationNames = null;
    public static Position[] wwStationPositions = null;
    public static int[] wwStationIndices = null;
    private int harmonicToDisplay = 0;

    public static LocalDataAllSitesOneTime buildCircles(Core core, TimeScale buildToDate) {
        return DisplayDataBuilder.buildCircles(core, core.getLocalData(core.getCurrentSitesChoice().getCC()), buildToDate);
    }

    public static LocalDataAllSitesOneTime buildCircles(Core core, LocalData localData, TimeScale buildToDate) {
        LocalDataAllSitesOneTime sites = new LocalDataAllSitesOneTime(localData, buildToDate);
        MinMaxForDisplay.setCirclesMetrics(sites, core.getCurrentMapChoice(), core.getCurrentSitesChoice());
        return sites;
    }

    public static void fillSiteAttributes(LocalData obs) {
        wwStationNames = new String[obs.totalLocations];
        wwStationPositions = new Position[obs.totalLocations];
        wwStationIndices = new int[obs.totalLocations];
        int iSite = 0;
        while (iSite < obs.totalLocations) {
            StationLocation loc = obs.sites[iSite].getLocation();
            DisplayDataBuilder.wwStationNames[iSite] = String.valueOf(loc.getName()) + " " + loc.getUrsi();
            DisplayDataBuilder.wwStationPositions[iSite] = Position.fromDegrees((double)loc.getLat(), (double)(loc.getLon() < 180.0 ? loc.getLon() : loc.getLon() - 360.0));
            DisplayDataBuilder.wwStationIndices[iSite] = iSite;
            ++iSite;
        }
    }

    public static ChartCurves prepareChartCurves(LocalDataOneSiteAllTimes site, GambitChartSettings chartSettings) {
        ChartCurves curves = new ChartCurves();
        for (ChartAttributes entry : chartSettings.getSelections()) {
            curves.add(entry, site.getDoubleArray(entry.getDataType()));
        }
        return curves;
    }

    public int getHarmonicToDisplay() {
        return this.harmonicToDisplay;
    }

    public void setHarmonicToDisplay(int harmonicToDisplay) {
        this.harmonicToDisplay = harmonicToDisplay;
    }
}

