/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.core.LocalDataType;
import edu.uml.giro.gambit.display.ChartAttributes;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GambitChartSettings
extends SectionDescriptor<GambitChartSettings>
implements Cloneable {
    public static final String SECTION_NAME = "Main Chart Selections";
    public static final String OPTION_DATA_SELECTION = "DataSelection";
    private final List<ChartAttributes> selections = new ArrayList<ChartAttributes>(32);
    private final Map<String, OptionDesc> descriptor = new LinkedHashMap<String, OptionDesc>(32);

    public GambitChartSettings() {
        this.setDefaults();
        this.fillDescriptor();
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getName() {
        return SECTION_NAME;
    }

    @Override
    public GambitChartSettings getThis() {
        return this;
    }

    protected void setDefaults() {
        this.selections.add(new ChartAttributes(LocalDataType.OBSERVED_MANUAL_ONLY, Color.black, 0, 3));
        this.selections.add(new ChartAttributes(LocalDataType.OBSERVED_HIGHCONF_ONLY, Color.blue, 0, 3));
        this.selections.add(new ChartAttributes(LocalDataType.OBSERVED_GOODCONF_ONLY, new Color(153, 153, 255), 0, 2));
        this.selections.add(new ChartAttributes(LocalDataType.OBSERVED_LOWCONF_ONLY, new Color(128, 128, 128), 0, 2));
        this.selections.add(new ChartAttributes(LocalDataType.OBSERVED_UNKNOWN_CONF, new Color(0, 255, 255), 0, 2));
        this.selections.add(new ChartAttributes(LocalDataType.OBSERVED_GAP_FILLED, new Color(204, 255, 255), 0, 2));
        this.selections.add(new ChartAttributes(LocalDataType.OBSERVED_LOWC_REPLACED, Color.white, 0, 2));
        this.selections.add(new ChartAttributes(LocalDataType.OBSERVED_EXTRAPOLATED, Color.white, 0, 2));
        this.selections.add(new ChartAttributes(LocalDataType.CLIMATE, new Color(34, 139, 34), 3, 1));
        this.selections.add(new ChartAttributes(LocalDataType.GLOBAL_WEATHER, Color.red, 0, 1));
        this.selections.add(new ChartAttributes(LocalDataType.LOCAL_WEATHER, Color.orange, 0, 1));
    }

    @Override
    protected void fillDescriptor() {
        LocalDataType[] localDataTypeArray = LocalDataType.values();
        int n = localDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocalDataType type = localDataTypeArray[n2];
            this.descriptor.put(type.name(), new OptionDesc(null, ContentType.DISPLAY));
            ++n2;
        }
    }

    @Override
    public void getFrom(OptionsIO optionsIO) {
        this.selections.clear();
        for (String optionName : optionsIO.getAll(SECTION_NAME)) {
            String option = optionsIO.get(SECTION_NAME, optionName);
            LocalDataType dataType = LocalDataType.valueOf(optionName);
            this.selections.add(ChartAttributes.parse(optionName, option));
        }
    }

    @Override
    public void putTo(OptionsIO optionsIO) {
        for (ChartAttributes entry : this.selections) {
            optionsIO.put(SECTION_NAME, entry.getDataType().toString(), entry.toString());
        }
    }

    public List<ChartAttributes> getSelections() {
        return this.selections;
    }

    public ChartAttributes getSelection(LocalDataType type) {
        for (ChartAttributes selection : this.selections) {
            if (!selection.getDataType().equals((Object)type)) continue;
            return selection;
        }
        return null;
    }
}

