/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.AppSettings;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import java.util.HashMap;
import java.util.Map;

public class GambitDisplaySettings
extends SectionDescriptor<GambitDisplaySettings>
implements Cloneable {
    public static final String SECTION_NAME = "GAMBIT Explorer Display Options";
    public static final String OPTION_GRAY_CIRCLES = "GrayCircles";
    public static final String OPTION_CIRCLE_SIZE_OUTER = "CircleSizeOuter";
    public static final String OPTION_CIRCLE_SIZE_INNER = "CircleSizeInner";
    public static final String OPTION_HIGH_RES_TEC = "HighResTec";
    private boolean grayCircles;
    private double circleSizeOuter;
    private double circleSizeInner;
    private boolean highResTec;
    private final Map<String, OptionDesc> descriptor = new HashMap<String, OptionDesc>(32);

    public GambitDisplaySettings() {
        this.setDefaults();
        this.fillDescriptor();
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getName() {
        return SECTION_NAME;
    }

    @Override
    public GambitDisplaySettings getThis() {
        return this;
    }

    protected void setDefaults() {
        this.grayCircles = false;
        this.highResTec = false;
        this.circleSizeOuter = 0.4;
        this.circleSizeInner = 0.32;
    }

    @Override
    protected void fillDescriptor() {
        this.descriptor.put(OPTION_GRAY_CIRCLES, new OptionDesc((Object)this.grayCircles, ContentType.DISPLAY));
        this.descriptor.put(OPTION_CIRCLE_SIZE_OUTER, new OptionDesc((Object)this.circleSizeOuter, ContentType.DISPLAY));
        this.descriptor.put(OPTION_CIRCLE_SIZE_INNER, new OptionDesc((Object)this.circleSizeInner, ContentType.DISPLAY));
        this.descriptor.put(OPTION_HIGH_RES_TEC, new OptionDesc((Object)this.highResTec, ContentType.DISPLAY));
    }

    @Override
    public void getFrom(OptionsIO optionsIO) {
        try {
            this.grayCircles = AppSettings.getBoolean(optionsIO, SECTION_NAME, OPTION_GRAY_CIRCLES, this.grayCircles);
            this.circleSizeOuter = Double.parseDouble(optionsIO.get(SECTION_NAME, OPTION_CIRCLE_SIZE_OUTER));
            this.circleSizeInner = Double.parseDouble(optionsIO.get(SECTION_NAME, OPTION_CIRCLE_SIZE_INNER));
            this.highResTec = AppSettings.getBoolean(optionsIO, SECTION_NAME, OPTION_HIGH_RES_TEC, this.highResTec);
        }
        catch (IllegalArgumentException e) {
            Console.showError(e.getMessage());
        }
    }

    @Override
    public void putTo(OptionsIO optionsIO) {
        optionsIO.put(SECTION_NAME, OPTION_GRAY_CIRCLES, String.valueOf(this.grayCircles));
        optionsIO.put(SECTION_NAME, OPTION_CIRCLE_SIZE_OUTER, String.valueOf(this.circleSizeOuter));
        optionsIO.put(SECTION_NAME, OPTION_CIRCLE_SIZE_INNER, String.valueOf(this.circleSizeInner));
        optionsIO.put(SECTION_NAME, OPTION_HIGH_RES_TEC, String.valueOf(this.highResTec));
    }

    public boolean isGrayCircles() {
        return this.grayCircles;
    }

    public void setGrayCircles(boolean grayCircles) {
        this.grayCircles = grayCircles;
    }

    public boolean isHighResTec() {
        return this.highResTec;
    }

    public void setHighResTec(boolean highResTec) {
        this.highResTec = highResTec;
    }

    public double getCircleSizeOuter() {
        return this.circleSizeOuter;
    }

    public void setCircleSizeOuter(double circleSizeOuter) {
        this.circleSizeOuter = circleSizeOuter;
    }

    public double getCircleSizeInner() {
        return this.circleSizeInner;
    }

    public void setCircleSizeInner(double circleSizeInner) {
        this.circleSizeInner = circleSizeInner;
    }
}

