/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.apps.GambitUserApp;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.core.IonogramScaling;
import edu.uml.giro.gambit.core.LocalDataAllSitesOneTime;
import edu.uml.giro.gambit.core.LocalDataElements;
import edu.uml.giro.gambit.core.SitesChoice;
import edu.uml.giro.gambit.database.GambitDatabaseReader;
import edu.uml.giro.gambit.display.DisplayDataBuilder;
import edu.uml.giro.gambit.display.GAMBITAnnotations;
import edu.uml.giro.gambit.display.GAMBITLegends;
import edu.uml.giro.gambit.display.GambitDisplaySettings;
import edu.uml.giro.gambit.display.MinMaxForDisplay;
import edu.uml.giro.gambit.display.SolarTerminator;
import edu.uml.giro.gambit.display.WWindowManager;
import edu.uml.lgdc.appuserdb.api.UserCredentials;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.Geopack;
import edu.uml.lgdc.geospace.MagneticEquator;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.time.TimeScale;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.SkyColorLayer;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.ScreenRelativeAnnotation;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class GambitLayers {
    public static final int DISPLAY_SURFACE = 1;
    public static final int DISPLAY_CIRCLES = 2;
    public static final int DISPLAY_EXT_SURFACE = 4;
    public static final int DISPLAY_STATIC_LEGEND = 8;
    public static final int DISPLAY_GREY_SITES = 16;
    private static CenteringOptions centeringOption = CenteringOptions.UT00;
    private static final double LONGITUDE_DEGREE_IN_HOUR = 15.0;
    public static final int DRAW_LATITUDES = 0;
    public static final int DRAW_MERIDIANS = 1;
    public static final int DRAW_NET = 2;
    public static final String[] LAYERS_NAMES = new String[]{"Latitudes", "Meridians", "Lat-Meridional net"};
    public static final int CIRCLE_OUTLINE = 0;
    public static final int CIRCLE_FILL = 1;
    private WorldWindow wwd;
    private static int currentViewType = 0;
    private GambitCore core;
    private GambitDisplaySettings settings;
    private AnalyticSurface surface = new AnalyticSurface();
    private AnalyticSurface externalSurface = new AnalyticSurface();
    public GAMBITLegends legends = new GAMBITLegends((RenderableLayer)LayerSpec.MAIN_SURFACE.getLayer(), (RenderableLayer)LayerSpec.COLOR_CIRCLES.getLayer(), (RenderableLayer)LayerSpec.EXTERNAL_SURFACE.getLayer());
    private AnnotationAttributes annotationAttributes;
    private MagneticEquator equator = new MagneticEquator();
    public IconLayer reportIconLayer;
    private boolean captureCompleted;

    public GambitLayers(WorldWindow wwd, GambitCore core, GambitDisplaySettings settings) {
        this.wwd = wwd;
        this.core = core;
        this.settings = settings;
        LayerList layers = wwd.getModel().getLayers();
        LayerSpec[] layerSpecArray = LayerSpec.values();
        int n = layerSpecArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayerSpec layerSpec = layerSpecArray[n2];
            layers.add(layerSpec.getPosition(), layerSpec.getLayer());
            ++n2;
        }
        this.configureWhiteBackground((SkyColorLayer)LayerSpec.WHITE_BACKGROUND.getLayer());
        this.annotationAttributes = new AnnotationAttributes();
        this.annotationAttributes.setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.annotationAttributes.setEffect("gov.nasa.worldwind.avkey.TextEffectShadow");
        this.annotationAttributes.setTextColor(Color.WHITE);
        this.annotationAttributes.setLeaderGapWidth(14);
        this.annotationAttributes.setCornerRadius(0);
        this.annotationAttributes.setSize(new Dimension(300, 0));
        this.annotationAttributes.setAdjustWidthToText("gov.nasa.worldwind.avkey.SizeFitText");
        this.annotationAttributes.setFont(Font.decode("Arial-BOLD-18"));
        this.annotationAttributes.setBorderWidth(0.0);
        this.annotationAttributes.setHighlightScale(1.0);
        this.annotationAttributes.setOpacity(0.85);
        WWindowManager.refreshLayer(this.getWwd(), LayerSpec.MAGNETIC_EQUATOR);
        WWindowManager.refreshLayer(this.getWwd(), LayerSpec.METADATA);
        WWindowManager.refreshLayer(this.getWwd(), LayerSpec.SOLAR_TERMINATOR);
        WWindowManager.refreshLayer(this.getWwd(), LayerSpec.EXTERNAL_SURFACE);
    }

    private void configureWhiteBackground(SkyColorLayer w) {
        w.setFadeBottomAltitude(1.0E9);
        w.setFadeTopAltitude(1.0E9);
        w.setName("White space");
        w.setEnabled(false);
        w.setOpacity(0.0);
    }

    public void setCurrentViewType(int view) {
        currentViewType = view;
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public void setNewCore(GambitCore core) {
        this.core = core;
    }

    public void setCaptureCompleted(boolean b) {
        this.captureCompleted = b;
    }

    public boolean isCaptureCompleted() {
        return this.captureCompleted;
    }

    public synchronized void buildDataRenderables(TimeScale targetTime, EarthGrid customMainEarthGrid, int displayMode) {
        LayerSpec.MAIN_SURFACE.clear();
        LayerSpec.COLOR_CIRCLES.clear();
        LayerSpec.EXTERNAL_SURFACE.clear();
        MapChoice mainMapChoice = this.core.getCurrentMapChoice();
        MapChoice extMapChoice = this.core.getCurrentExternalMapChoice();
        SitesChoice sitesChoice = this.core.getCurrentSitesChoice();
        boolean sitesAvailable = this.core.getLocalData(sitesChoice.getCC()) != null && !this.core.getLocalData(sitesChoice.getCC()).isEmpty();
        boolean computeMinMax = (displayMode & 8) == 0;
        Geomap mainSurfaceMap = null;
        Geomap extSurfaceMap = null;
        LocalDataAllSitesOneTime sitesData = null;
        int totalItems = 0;
        if ((displayMode & 1) != 0 && (mainSurfaceMap = customMainEarthGrid == null ? this.core.getOneMap(targetTime, mainMapChoice, this.core.getGambitDatabaseReader().getBestAvailableVersions()) : this.core.synthesizeCurrentMap(customMainEarthGrid, targetTime, this.core.getCurrentMapChoice())) != null) {
            if (computeMinMax) {
                MinMaxForDisplay.setSurfaceMetrics(mainSurfaceMap);
            }
            ++totalItems;
        }
        if ((displayMode & 2) != 0 && sitesAvailable) {
            sitesData = DisplayDataBuilder.buildCircles(this.core, targetTime);
            if (computeMinMax) {
                MinMaxForDisplay.setCirclesMetrics(sitesData, mainMapChoice, sitesChoice);
            }
            ++totalItems;
        }
        if ((displayMode & 4) != 0 && (extSurfaceMap = this.core.getOneMap(targetTime, extMapChoice, this.core.getGambitDatabaseReader().getBestAvailableVersions())) != null) {
            if (computeMinMax) {
                MinMaxForDisplay.setExternalMetrics(extSurfaceMap);
            }
            ++totalItems;
        }
        String descriptiveLabel = "GX.User 1.3F";
        UserCredentials userCreds = this.core.getGambitPassport().getUserCredentials();
        String user = userCreds.getUserLogin();
        if (totalItems > 0) {
            double[] minmax;
            boolean mergeMinMax;
            boolean bl = mergeMinMax = (displayMode & 1) != 0 && (displayMode & 2) != 0 && sitesAvailable && mainMapChoice.getCC() != CharChoice.VTEC && mainMapChoice.getCC() != CharChoice.TAU;
            if (mergeMinMax && computeMinMax) {
                MinMaxForDisplay.mergeMinMaxSets(this.core.getCurrentMapChoice(), this.core.getCurrentSitesChoice());
            }
            if ((displayMode & 1) != 0 && mainSurfaceMap != null) {
                minmax = mergeMinMax ? MinMaxForDisplay.getMergedMinMax() : MinMaxForDisplay.getSurfaceMinMax();
                this.buildSurface(targetTime, mainSurfaceMap.getMap_1D(), mainSurfaceMap.getEarthGrid(), minmax);
                this.buildSurfaceLegend(totalItems, minmax);
                if (!this.core.getCurrentMapChoice().isClimateMap()) {
                    descriptiveLabel = String.valueOf(this.core.VERSIONS.name) + " : " + (user != null ? user : "guest");
                }
            }
            if ((displayMode & 2) != 0 && sitesAvailable) {
                minmax = mergeMinMax ? MinMaxForDisplay.getMergedMinMax() : MinMaxForDisplay.getCirclesMinMax();
                boolean grayoutBadData = (displayMode & 0x10) != 0;
                this.buildCircles(targetTime, sitesData, minmax, grayoutBadData);
                this.buildCirclesLegend(totalItems, minmax, (displayMode & 4) != 0);
                if (descriptiveLabel.equals("GX.User 1.3F")) {
                    descriptiveLabel = "GIRO";
                }
            }
            if ((displayMode & 4) != 0 && extSurfaceMap != null) {
                minmax = MinMaxForDisplay.getExtSurfaceMinMax();
                this.buildExternalSurface(targetTime, extSurfaceMap, minmax);
                this.buildExternalSurfaceLegend(totalItems, minmax);
                descriptiveLabel = "Madrigal " + this.core.getTEC().countPoints() + " pp";
            }
        }
        this.buildTopLabels(targetTime, descriptiveLabel);
    }

    public void buildSurface(TimeScale toDate, double[] values, EarthGrid earthGrid, double[] minmax) {
        ArrayList<AnalyticSurface.GridPointAttributes> attributesList = new ArrayList<AnalyticSurface.GridPointAttributes>();
        this.buildTopLabels(toDate, this.getSurfaceContentDescription());
        int iGrid = 0;
        while (iGrid < values.length) {
            if (values[iGrid] != 9999.0) {
                attributesList.add(AnalyticSurface.createColorGradientAttributes((double)values[iGrid], (double)minmax[0], (double)minmax[1], (double)0.6666666666666666, (double)0.0));
            } else {
                attributesList.add(AnalyticSurface.createGridPointAttributes((double)values[iGrid], (Color)Color.GRAY));
            }
            ++iGrid;
        }
        this.surface.setDimensions(earthGrid.getNumLongitudeNodes(), earthGrid.getNumLatitudeNodes());
        this.surface.setValues(attributesList);
        LayerSpec.MAIN_SURFACE.addRenderable(this.surface);
        WWindowManager.setupAnalyticSurface(this.surface, this.wwd, earthGrid.getNumLatitudeNodes(), earthGrid.getNumLongitudeNodes());
        this.surface.setClientLayer(LayerSpec.MAIN_SURFACE.getLayer());
        WWindowManager.refreshLayer(this.wwd, LayerSpec.MAIN_SURFACE);
    }

    public void buildTopLabels(TimeScale targetTime, String content) {
        LayerSpec.METADATA.clear();
        Color textColor = LayerSpec.WHITE_BACKGROUND.isEnabled() ? Color.BLACK : Color.WHITE;
        Color shadowColor = LayerSpec.WHITE_BACKGROUND.isEnabled() ? Color.WHITE : Color.BLACK;
        this.annotationAttributes.setTextColor(textColor);
        ScreenRelativeAnnotation topLabelTime = new ScreenRelativeAnnotation(String.valueOf(targetTime.toHumanUT()) + " UT", 0.99, 1.3);
        topLabelTime.getAttributes().setDefaults(this.annotationAttributes);
        topLabelTime.setKeepFullyVisible(true);
        topLabelTime.setXMargin(5);
        topLabelTime.setYMargin(0);
        LayerSpec.METADATA.addAnnotation((ScreenAnnotation)topLabelTime);
        ScreenRelativeAnnotation topLabelVersion = new ScreenRelativeAnnotation(content, 0.1, 1.3);
        topLabelVersion.setKeepFullyVisible(true);
        topLabelVersion.setXMargin(5);
        topLabelVersion.setYMargin(0);
        topLabelVersion.getAttributes().setDefaults(this.annotationAttributes);
        LayerSpec.METADATA.addAnnotation((ScreenAnnotation)topLabelVersion);
        WWindowManager.refreshLayer(this.wwd, LayerSpec.METADATA);
    }

    public String getSurfaceContentDescription() {
        String content = "";
        if (!this.core.getCurrentMapChoice().isExternalMap()) {
            content = GambitDatabaseReader.GAMBIT_DB_VERSIONS.isEmpty() ? String.valueOf(content) + "GX.User 1.3F" : String.valueOf(content) + GambitDatabaseReader.GAMBIT_DB_VERSIONS.get((Object)Integer.valueOf((int)0)).name;
        } else if (this.core.getCurrentMapChoice().isTecMap()) {
            content = String.valueOf(content) + "<VTEC>";
        }
        content = String.valueOf(content) + " : " + (this.core.getGambitPassport().getUserId() == 0 ? "guest" : this.core.getGambitPassport().getUserCredentials().getUserLogin());
        return content;
    }

    private ArrayList<GAMBITAnnotations.SitesCirclesAnnotation> getCircleRenderables(LocalDataAllSitesOneTime sitesData, double[] minmax, int mode) {
        return this.getCircleRenderables(sitesData, minmax, mode, false);
    }

    private ArrayList<GAMBITAnnotations.SitesCirclesAnnotation> getCircleRenderables(LocalDataAllSitesOneTime sitesData, double[] minmax, int mode, boolean greyoutLowConfidenceData) {
        ArrayList<GAMBITAnnotations.SitesCirclesAnnotation> renderables = new ArrayList<GAMBITAnnotations.SitesCirclesAnnotation>();
        SitesChoice sitesChoice = this.core.getCurrentSitesChoice();
        boolean percent = this.core.getCurrentMapChoice().isPercentDeltaMap();
        double outerSize = this.settings.getCircleSizeOuter();
        double innerSize = this.settings.getCircleSizeInner();
        for (Map.Entry<StationLocation, LocalDataElements> entry : sitesData.getData().entrySet()) {
            StationLocation loc = entry.getKey();
            Position position = Position.fromDegrees((double)loc.getLat(), (double)(loc.getLon() < 180.0 ? loc.getLon() : loc.getLon() - 360.0));
            LocalDataElements data = entry.getValue();
            if (!greyoutLowConfidenceData || IonogramScaling.isAcceptedAsIs(data.getFlag())) {
                double value = sitesData.getValue(data, sitesChoice, percent);
                if (mode == 0) {
                    renderables.add(this.makeSiteCircle(position, Color.BLACK, outerSize));
                    continue;
                }
                renderables.add(this.makeSiteCircle(position, value, minmax[0], minmax[1], innerSize));
                continue;
            }
            if (mode == 0) {
                renderables.add(this.makeSiteCircle(position, Color.BLACK, outerSize));
                continue;
            }
            renderables.add(this.makeSiteCircle(position, Color.GRAY, innerSize));
        }
        return renderables;
    }

    public void buildCircles(TimeScale toDate, LocalDataAllSitesOneTime sitesData, double[] minmax, boolean grayout) {
        if (this.settings.getCircleSizeOuter() > this.settings.getCircleSizeInner()) {
            LayerSpec.COLOR_CIRCLES.addRenderables(this.getCircleRenderables(sitesData, minmax, 0, grayout));
        }
        LayerSpec.COLOR_CIRCLES.addRenderables(this.getCircleRenderables(sitesData, minmax, 1));
        WWindowManager.refreshLayer(this.wwd, LayerSpec.COLOR_CIRCLES);
    }

    public void redrawCirclesValues(LocalDataAllSitesOneTime sitesData) {
    }

    public RenderableLayer buildSitesInSectorLayer(TreeMap<Integer, StationLocation> sitesData, TimeScale time) {
        RenderableLayer layer = new RenderableLayer();
        layer.setName("GIRO sites in sector");
        for (Integer iSite : sitesData.keySet()) {
            double lon = sitesData.get(iSite).getLon() > 180.0 ? sitesData.get(iSite).getLon() - 360.0 : sitesData.get(iSite).getLon();
            Position pos = Position.fromDegrees((double)sitesData.get(iSite).getLat(), (double)lon);
            Geopack geopack = new Geopack();
            double[] m_coords = geopack.getMagneticCoordinates(new double[]{sitesData.get(iSite).getLat(), lon}, time);
            GlobeAnnotation label = new GlobeAnnotation(String.valueOf(sitesData.get(iSite).getUrsi()) + "\n" + "GEO " + FC.DoubleToString(pos.latitude.degrees, 7, 2) + " " + FC.DoubleToString(pos.longitude.degrees, 7, 2) + "\n" + "GM  " + FC.DoubleToString(m_coords[0], 7, 2) + " " + FC.DoubleToString(m_coords[1], 7, 2), pos);
            layer.addRenderable((Renderable)this.makeSiteCircle(pos, Color.WHITE, 0.3));
            layer.addRenderable((Renderable)label);
        }
        return layer;
    }

    public GAMBITAnnotations.SitesCirclesAnnotation makeSiteCircle(Position pos, double val, double min, double max, double scale) {
        Color color = AnalyticSurface.createColorGradientAttributes((double)val, (double)min, (double)max, (double)0.6666666666666666, (double)0.0).getColor();
        return this.makeSiteCircle(pos, color, scale);
    }

    public GAMBITAnnotations.SitesCirclesAnnotation makeSiteCircle(Position pos, Color color, double scale) {
        GAMBITAnnotations.SitesCirclesAnnotation rep = new GAMBITAnnotations.SitesCirclesAnnotation(pos, GAMBITAnnotations.getCirclesSitesAttributes());
        BufferedImage circle = PatternFactory.createPattern((String)"PatternFactory.PatternCircle", (float)0.8f, (Color)color);
        rep.getAttributes().setImageSource((Object)circle);
        rep.getAttributes().setTextColor(color);
        rep.getAttributes().setScale(scale);
        return rep;
    }

    private void buildExternalSurface(TimeScale toDate, Geomap map, double[] minmax) {
        LayerSpec.EXTERNAL_SURFACE.clear();
        int latNodesNum = map.getEarthGrid().getNumLatitudeNodes();
        int lonNodesNum = map.getEarthGrid().getNumLongitudeNodes();
        this.externalSurface.setValues(this.buildTecMap(map.getMap_1D(), minmax[0], minmax[1], map.getNoValue()));
        LayerSpec.EXTERNAL_SURFACE.addRenderable(this.externalSurface);
        WWindowManager.setupAnalyticSurface(this.externalSurface, this.wwd, latNodesNum, lonNodesNum);
        this.externalSurface.setClientLayer(LayerSpec.EXTERNAL_SURFACE.getLayer());
        WWindowManager.refreshLayer(this.wwd, LayerSpec.EXTERNAL_SURFACE);
    }

    private Iterable<? extends AnalyticSurface.GridPointAttributes> buildTecMap(double[] gridValues, double min, double max, double noValue) {
        ArrayList<AnalyticSurface.GridPointAttributes> attributesList = new ArrayList<AnalyticSurface.GridPointAttributes>();
        int iNode = 0;
        while (iNode < gridValues.length) {
            if (gridValues[iNode] != noValue) {
                attributesList.add(AnalyticSurface.createColorGradientAttributes((double)gridValues[iNode], (double)min, (double)max, (double)0.6666666666666666, (double)0.0));
            } else {
                attributesList.add(AnalyticSurface.createGridPointAttributes((double)gridValues[iNode], (Color)Color.GRAY));
            }
            ++iNode;
        }
        return attributesList;
    }

    public void buildSurfaceLegend(int items, double[] minmax) {
        Color color = LayerSpec.WHITE_BACKGROUND.isEnabled() ? Color.BLACK : Color.WHITE;
        this.legends.buildSurfaceLegend(this.wwd, (RenderableLayer)LayerSpec.MAIN_SURFACE.getLayer(), minmax[0], minmax[1], null, this.captureCompleted, currentViewType, color, this.core.getCurrentMapChoice(), items);
    }

    public void buildCirclesLegend(int items, double[] minmax, boolean isExternalMap) {
        Color color = LayerSpec.WHITE_BACKGROUND.isEnabled() ? Color.BLACK : Color.WHITE;
        this.legends.buildCirclesLegend(this.wwd, (RenderableLayer)LayerSpec.COLOR_CIRCLES.getLayer(), minmax[0], minmax[1], false, color, this.core.getCurrentSitesChoice(), this.core.getCurrentMapChoice(), isExternalMap, items);
    }

    public void buildExternalSurfaceLegend(int items, double[] minmax) {
        Color color = LayerSpec.WHITE_BACKGROUND.isEnabled() ? Color.BLACK : Color.WHITE;
        this.legends.buildSurfaceLegend(this.wwd, (RenderableLayer)LayerSpec.EXTERNAL_SURFACE.getLayer(), minmax[0], minmax[1], null, this.captureCompleted, currentViewType, color, this.core.getCurrentExternalMapChoice(), items);
    }

    public void showSurfaceLayerOnly() {
        LayerSpec.MAIN_SURFACE.setEnabled(true);
        LayerSpec.EXTERNAL_SURFACE.setEnabled(false);
        LayerSpec.MAIN_SURFACE.getLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)LayerSpec.MAIN_SURFACE.getLayer());
    }

    public void hideSurfaceLayer() {
        LayerSpec.MAIN_SURFACE.setEnabled(false);
        LayerSpec.MAIN_SURFACE.getLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)LayerSpec.MAIN_SURFACE.getLayer());
    }

    public void showExternalSurfaceLayerOnly() {
        LayerSpec.MAIN_SURFACE.setEnabled(false);
        LayerSpec.EXTERNAL_SURFACE.setEnabled(true);
        LayerSpec.EXTERNAL_SURFACE.getLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)LayerSpec.EXTERNAL_SURFACE.getLayer());
    }

    public void hideExternalSurfaceLayer() {
        LayerSpec.EXTERNAL_SURFACE.setEnabled(false);
        LayerSpec.EXTERNAL_SURFACE.getLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)LayerSpec.EXTERNAL_SURFACE.getLayer());
    }

    public void showCirclesLayer() {
        LayerSpec.COLOR_CIRCLES.setEnabled(true);
        LayerSpec.COLOR_CIRCLES.getLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)LayerSpec.COLOR_CIRCLES.getLayer());
    }

    public void hideCirclesLayer() {
        LayerSpec.COLOR_CIRCLES.setEnabled(false);
        LayerSpec.COLOR_CIRCLES.getLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)LayerSpec.COLOR_CIRCLES.getLayer());
    }

    public boolean isSurfaceEnabled() {
        return LayerSpec.MAIN_SURFACE.isEnabled();
    }

    public boolean isExternalSurfaceEnabled() {
        return LayerSpec.EXTERNAL_SURFACE.isEnabled();
    }

    public void redrawReportIconLayer(TimeScale toTime) {
        CharChoice cc = this.core.getCurrentSitesChoice().getCC();
        DisplayDataBuilder.fillSiteAttributes(this.core.getLocalData(cc));
        if (DisplayDataBuilder.wwStationPositions != null) {
            this.redrawIconLayer(DisplayDataBuilder.wwStationPositions, DisplayDataBuilder.wwStationNames, DisplayDataBuilder.wwStationIndices);
        }
    }

    private void redrawIconLayer(Position[] stationPositions, String[] stationNames, int[] stationIndices) {
        IconLayer newLayer = this.createIconLayer(stationPositions, stationNames, stationIndices);
        if (newLayer.getIcons().iterator().hasNext()) {
            LayerList layers = this.wwd.getModel().getLayers();
            if (this.reportIconLayer != null) {
                layers.remove((Layer)this.reportIconLayer);
            }
            this.reportIconLayer = newLayer;
            WWindowManager.insertAsBottomLayer(this.wwd, (Layer)this.reportIconLayer);
            this.wwd.redraw();
        }
    }

    public IconLayer createIconLayer(Position[] positions, String[] stationsNames, int[] stationIndices) {
        IconLayer layer = new IconLayer();
        layer.setName("Report's icons");
        if (positions == null) {
            layer.setName("Report's icons. No data");
            return layer;
        }
        layer.setPickEnabled(true);
        int i = 0;
        while (i < positions.length) {
            String reportFileName = String.valueOf(GambitConstants.REPORT_IMAGE_FOLDER) + i + ".jpg";
            try {
                WWIcon icon = this.createIcon(GambitConstants.TYPE_IMAGES, positions[i], stationsNames[i], reportFileName);
                icon.setValue("StationIndex", (Object)stationIndices[i]);
                layer.addIcon(icon);
            }
            catch (Exception ex) {
                System.out.println("Fail to add icon for station " + stationsNames[i]);
            }
            ++i;
        }
        return layer;
    }

    private WWIcon createIcon(Object type, Position position, String title, Object data) throws IllegalArgumentException {
        if (position == null) {
            String message = Logging.getMessage((String)"nullValue.PositionIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (data == null) {
            String message = Logging.getMessage((String)"nullValue.DataSetIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (title == null) {
            title = "No Title";
        }
        UserFacingIcon icon = new UserFacingIcon((Object)GambitUserApp.AppFrame.class.getResource("histogram3.gif"), position);
        icon.setSize(new Dimension(40, 60));
        icon.setValue("gov.nasa.worldwind.avkey.DataType", type);
        icon.setValue("gov.nasa.worldwind.avkey.Title", (Object)title);
        icon.setValue("gov.nasa.worldwind.avkey.URL", data);
        return icon;
    }

    public void removeIconLayer() {
        LayerList layers = this.wwd.getModel().getLayers();
        if (this.reportIconLayer != null) {
            layers.remove((Layer)this.reportIconLayer);
        }
    }

    public RenderableLayer buildFootprintLayer(double[] coordsN, double[] coordsS) {
        RenderableLayer layer = new RenderableLayer();
        layer.setName("Footprint");
        double lonN = coordsN[1] > 180.0 ? coordsN[1] - 360.0 : coordsN[1];
        double lonS = coordsS[1] > 180.0 ? coordsS[1] - 360.0 : coordsS[1];
        Position posN = Position.fromDegrees((double)coordsN[0], (double)lonN);
        Position posS = Position.fromDegrees((double)coordsS[0], (double)lonS);
        layer.addRenderable((Renderable)this.makeSiteCircle(posN, Color.WHITE, 0.3));
        layer.addRenderable((Renderable)this.makeSiteCircle(posS, Color.WHITE, 0.3));
        return layer;
    }

    public void refreshSolarTerminatorLayer(TimeScale time, int terminatorType) {
        SolarTerminator.configureSolarTerminatorLayer((RenderableLayer)LayerSpec.SOLAR_TERMINATOR.getLayer(), time, 1);
        WWindowManager.refreshLayer(this.wwd, LayerSpec.SOLAR_TERMINATOR);
    }

    public void refreshMagneticEquatorLayer(TimeScale time) {
        GambitLayers.configureMagneticEquatorLayer((RenderableLayer)LayerSpec.MAGNETIC_EQUATOR.getLayer(), this.equator, time);
        GambitLayers.configureLShellLayer((RenderableLayer)LayerSpec.L_SHELL.getLayer(), this.equator, time, 4.0, 1.0);
        WWindowManager.refreshLayer(this.wwd, LayerSpec.MAGNETIC_EQUATOR);
        WWindowManager.refreshLayer(this.wwd, LayerSpec.L_SHELL);
    }

    public static void configureMagneticEquatorLayer(RenderableLayer layer, MagneticEquator mgeq, TimeScale time) {
        SurfacePolyline[] magEquatorPolyline = new SurfacePolyline[2];
        ShapeAttributes[] polylineAttr = GambitLayers.getMagEquatorAttributes();
        layer.removeAllRenderables();
        mgeq.calculateMagneticEquatorLine(time, 300.0);
        magEquatorPolyline[0] = GambitLayers.getMagneticEquatorLine(mgeq.getMagneticEquatorLine(), time, 1.0, polylineAttr[0]);
        magEquatorPolyline[1] = new SurfacePolyline(magEquatorPolyline[0].getLocations());
        magEquatorPolyline[1].setAttributes(polylineAttr[1]);
        layer.addRenderable((Renderable)magEquatorPolyline[1]);
        layer.addRenderable((Renderable)magEquatorPolyline[0]);
    }

    public static void configureLShellLayer(RenderableLayer layer, MagneticEquator mgeq, TimeScale time, double maxLshell, double stepLshell) {
        SurfacePolyline[] magEquatorPolyline = new SurfacePolyline[2];
        ShapeAttributes[] polylineAttr = GambitLayers.getMagEquatorAttributes();
        layer.removeAllRenderables();
        mgeq.calculateMagneticEquatorLine(time, 300.0);
        double lshell = -Math.abs(maxLshell);
        while (lshell <= Math.abs(maxLshell)) {
            magEquatorPolyline[0] = GambitLayers.getMagneticEquatorLine(mgeq.getMagneticEquatorLine(), time, 1.0, polylineAttr[0]);
            magEquatorPolyline[1] = new SurfacePolyline(magEquatorPolyline[0].getLocations());
            magEquatorPolyline[1].setAttributes(polylineAttr[1]);
            layer.addRenderable((Renderable)magEquatorPolyline[1]);
            layer.addRenderable((Renderable)magEquatorPolyline[0]);
            lshell += stepLshell;
        }
    }

    private static SurfacePolyline getMagneticEquatorLine(double[][] linedata, TimeScale time, double lshell, ShapeAttributes attr) {
        double latLshell = Math.acos(1.0 / Math.sqrt(Math.abs(lshell))) * 180.0 / Math.PI;
        int offsetLShell = (int)(Math.signum(lshell) * latLshell / 1.0);
        ArrayList<LatLon> eq = new ArrayList<LatLon>();
        double lon = 0.0;
        int iLon = 0;
        while (iLon < 180) {
            lon = linedata[1][iLon];
            if (lon >= 180.0) {
                lon -= 360.0;
            }
            eq.add(LatLon.fromDegrees((double)(linedata[0][iLon] + (double)offsetLShell), (double)lon));
            ++iLon;
        }
        SurfacePolyline line = new SurfacePolyline(eq);
        line.setAttributes(attr);
        line.setClosed(true);
        return line;
    }

    private static ShapeAttributes getAttributes() {
        BasicShapeAttributes attrs = new BasicShapeAttributes();
        attrs.setOutlineMaterial(Material.BLACK);
        attrs.setInteriorOpacity(0.0);
        attrs.setOutlineOpacity(0.8);
        attrs.setOutlineWidth(3.0);
        attrs.setDrawInterior(false);
        return attrs;
    }

    private static ShapeAttributes[] getMagEquatorAttributes() {
        BasicShapeAttributes foregroundAttrs = new BasicShapeAttributes();
        foregroundAttrs.setOutlineMaterial(new Material(Color.BLACK));
        foregroundAttrs.setOutlineStipplePattern((short)-21846);
        foregroundAttrs.setOutlineStippleFactor(28);
        foregroundAttrs.setOutlineWidth(6.0);
        foregroundAttrs.setOutlineOpacity(1.0);
        BasicShapeAttributes backgroundAttrs = new BasicShapeAttributes();
        backgroundAttrs.setOutlineMaterial(new Material(Color.WHITE));
        backgroundAttrs.setOutlineOpacity(0.3);
        backgroundAttrs.setOutlineWidth(foregroundAttrs.getOutlineWidth() + 2.0);
        return new ShapeAttributes[]{foregroundAttrs, backgroundAttrs};
    }

    private static ShapeAttributes getAttributes(Material material) {
        BasicShapeAttributes attrs = new BasicShapeAttributes();
        attrs.setOutlineMaterial(Material.BLUE);
        attrs.setInteriorMaterial(Material.WHITE);
        attrs.setInteriorOpacity(0.8);
        attrs.setOutlineOpacity(0.8);
        attrs.setOutlineWidth(80.0);
        attrs.setDrawInterior(true);
        attrs.setEnableAntialiasing(true);
        return attrs;
    }

    private static ShapeAttributes getEquatorAttributes() {
        BasicShapeAttributes attrs = new BasicShapeAttributes();
        attrs.setOutlineMaterial(Material.WHITE);
        attrs.setInteriorOpacity(0.0);
        attrs.setOutlineOpacity(0.8);
        attrs.setOutlineWidth(5.0);
        attrs.setDrawInterior(false);
        return attrs;
    }

    public void refreshLatLonGridLayer() {
        GambitLayers.configureLatLonLayer((RenderableLayer)LayerSpec.LAT_LON_GRID.getLayer(), 2, 46, 45);
        WWindowManager.refreshLayer(this.wwd, LayerSpec.LAT_LON_GRID);
    }

    public static RenderableLayer configureLatLonLayer(RenderableLayer layer, int whatToDraw, int nLats, int nLons) {
        int i;
        EarthGrid.checkLatLon(nLats, nLons);
        if (whatToDraw < 0 || whatToDraw >= LAYERS_NAMES.length) {
            System.out.println("No such drawing");
            return null;
        }
        SurfaceShape[] shapes = null;
        layer.setName(LAYERS_NAMES[whatToDraw]);
        if (whatToDraw == 0 || whatToDraw == 2) {
            shapes = GambitLayers.getLatiudeCircleLines(nLats);
            i = 0;
            while (i < shapes.length) {
                layer.addRenderable((Renderable)shapes[i]);
                ++i;
            }
        }
        if (whatToDraw == 1 || whatToDraw == 2) {
            shapes = GambitLayers.getMeridianLines(nLons);
            i = 0;
            while (i < shapes.length) {
                layer.addRenderable((Renderable)shapes[i]);
                ++i;
            }
        }
        return layer;
    }

    private static SurfaceShape[] getLatiudeCircleLines(int nLats) {
        int nLatsM1 = nLats - 1;
        double latStepDegree = 180.0 / (double)nLatsM1;
        SurfaceShape[] shapes = new SurfaceShape[nLats];
        ShapeAttributes attrs = GambitLayers.getAttributes();
        LatLon northPole = LatLon.fromDegrees((double)90.0, (double)0.0);
        int iLat = 0;
        while (iLat < nLats) {
            double currRadius = (double)iLat * latStepDegree * 111132.94444444444;
            shapes[iLat] = new SurfaceCircle(northPole, currRadius);
            if (iLat == nLatsM1 / 2) {
                shapes[iLat].setAttributes(GambitLayers.getEquatorAttributes());
                shapes[iLat].setHighlightAttributes(GambitLayers.getEquatorAttributes());
            } else {
                shapes[iLat].setAttributes(attrs);
                shapes[iLat].setHighlightAttributes(attrs);
            }
            ++iLat;
        }
        return shapes;
    }

    private static SurfaceShape[] getMeridianLines(int nLons) {
        int nLons_2 = nLons / 2;
        double lonStepDegree = 360.0 / (double)nLons;
        SurfaceShape[] shapes = new SurfaceShape[nLons_2];
        ShapeAttributes attrs = GambitLayers.getAttributes();
        double currRadius = 1.0001965E7;
        int iLon = 0;
        while (iLon < nLons_2) {
            if ((double)iLon * lonStepDegree != 90.0) {
                LatLon equatorPoint = LatLon.fromDegrees((double)0.0, (double)((double)iLon * lonStepDegree));
                shapes[iLon] = new SurfaceCircle(equatorPoint, currRadius);
                shapes[iLon].setAttributes(attrs);
                shapes[iLon].setHighlightAttributes(attrs);
            } else {
                shapes[iLon] = new SurfaceCircle(LatLon.fromDegrees((double)0.0, (double)90.0), currRadius);
                shapes[iLon].setAttributes(GambitLayers.getEquatorAttributes());
                shapes[iLon].setHighlightAttributes(GambitLayers.getEquatorAttributes());
            }
            ++iLon;
        }
        return shapes;
    }

    public void setCenteringOption(CenteringOptions option) {
        centeringOption = option;
        switch (centeringOption) {
            case UT00: {
                WWindowManager.setEyeView(this.wwd, Double.MAX_VALUE, 0.0, -1.0);
                break;
            }
            case LT12: 
            case LT12_DEMAG: {
                TimeScale tov = this.core.getTimeOfValidity();
                double currentLon = (12.0 - tov.getTimeSinceMidnightIn(11)) * 15.0;
                WWindowManager.setEyeView(this.wwd, Double.MAX_VALUE, currentLon, -1.0);
            }
        }
    }

    public static CenteringOptions getCenteringOption() {
        return centeringOption;
    }

    public void recenter() {
        this.setCenteringOption(centeringOption);
    }

    public GAMBITLegends getLegends() {
        return this.legends;
    }

    public static enum CenteringOptions {
        UT00,
        LT12,
        LT12_DEMAG;

    }

    public static enum LayerSpec {
        MAIN_SURFACE(0, "Color Surface", (Layer)new RenderableLayer()),
        EXTERNAL_SURFACE(1, "External Surface", (Layer)new RenderableLayer()),
        COLOR_CIRCLES(2, "Values at GIRO sites", (Layer)new RenderableLayer()),
        METADATA(3, "Top Labels", (Layer)new AnnotationLayer()),
        MAGNETIC_EQUATOR(4, "Magnetic Equator", (Layer)new RenderableLayer()),
        SOLAR_TERMINATOR(5, "Solar Terminator", (Layer)new RenderableLayer()),
        L_SHELL(6, "L-Shell", (Layer)new RenderableLayer()),
        LAT_LON_GRID(7, "Lat-lon Grid", (Layer)new RenderableLayer()),
        WHITE_BACKGROUND(8, "White background", (Layer)new SkyColorLayer());

        private static final Map<Integer, LayerSpec> MAP_BY_POSITION;
        private static final Map<String, LayerSpec> MAP_BY_NAME;
        private final int position;
        private final String name;
        private final Layer layer;

        static {
            MAP_BY_POSITION = new HashMap<Integer, LayerSpec>();
            MAP_BY_NAME = new HashMap<String, LayerSpec>();
            LayerSpec[] layerSpecArray = LayerSpec.values();
            int n = layerSpecArray.length;
            int n2 = 0;
            while (n2 < n) {
                LayerSpec contents = layerSpecArray[n2];
                if (MAP_BY_POSITION.put(contents.getPosition(), contents) != null) {
                    throw new RuntimeException("design error: duplication of positions, " + contents.getPosition());
                }
                if (MAP_BY_NAME.put(contents.getName(), contents) != null) {
                    throw new RuntimeException("design error: duplication of name, " + contents.getName());
                }
                ++n2;
            }
            ((SkyColorLayer)WHITE_BACKGROUND.getLayer()).setSkyColor(Color.WHITE);
        }

        private LayerSpec(int position, String name, Layer layer) {
            this.position = position;
            this.name = name;
            this.layer = layer;
            this.layer.setName(name);
            this.layer.setPickEnabled(false);
        }

        public int getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public Layer getLayer() {
            return this.layer;
        }

        static LayerSpec get(int position) {
            return MAP_BY_POSITION.get(position);
        }

        static LayerSpec get(String name) {
            return MAP_BY_NAME.get(name);
        }

        public void clear() {
            if (this.layer instanceof RenderableLayer) {
                ((RenderableLayer)this.layer).removeAllRenderables();
            }
            if (this.layer instanceof AnnotationLayer) {
                ((AnnotationLayer)this.layer).removeAllAnnotations();
            }
        }

        public void addRenderable(AnalyticSurface surface) {
            ((RenderableLayer)this.layer).addRenderable((Renderable)surface);
        }

        public void addRenderables(ArrayList<GAMBITAnnotations.SitesCirclesAnnotation> annotations) {
            ((RenderableLayer)this.layer).addRenderables(annotations);
        }

        public void addAnnotation(ScreenAnnotation annotation) {
            ((AnnotationLayer)this.layer).addAnnotation((Annotation)annotation);
        }

        public boolean isEnabled() {
            return this.layer.isEnabled();
        }

        public void setEnabled(boolean b) {
            this.layer.setEnabled(b);
        }
    }
}

