/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.core.LocalDataAllSitesOneTime;
import edu.uml.giro.gambit.core.Maps;
import edu.uml.giro.gambit.core.SitesChoice;
import edu.uml.giro.gambit.display.DisplayDataBuilder;
import edu.uml.giro.gambit.display.GambitColorscaleSettings;
import edu.uml.lgdc.datatype.RingBuffer;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.math.SimpleMetrics;
import edu.uml.lgdc.time.TimeScale;

public class MinMaxForDisplay {
    static MinMaxAlgorithm algorithm = MinMaxAlgorithm.MINMAX;
    static double[] minmax_surface = new double[2];
    static double[] minmax_circles = new double[2];
    static double[] minmax_merged = new double[2];
    static double[] minmax_external = new double[2];
    private static double min;
    private static double max;
    private static double average;
    private static double sigma;
    private static double userMin;
    private static double userMax;
    protected static GambitColorscaleSettings settings;
    private static final int INDEX_MIN = 0;
    private static final int INDEX_MAX = 1;

    static {
        settings = null;
    }

    public static void putUserSettings(GambitColorscaleSettings s) {
        settings = s;
    }

    public static void putAlgorithm(MinMaxAlgorithm a) {
        algorithm = a;
    }

    public static MinMaxAlgorithm getAlgorithm() {
        return algorithm;
    }

    public static void setSurfaceMetrics(Geomap dataMap) {
        MinMaxForDisplay.setMetrics(dataMap);
        MinMaxForDisplay.minmax_surface[0] = MinMaxForDisplay.getMinMetric();
        MinMaxForDisplay.minmax_surface[1] = MinMaxForDisplay.getMaxMetric();
        MinMaxForDisplay.adjust(minmax_surface, dataMap.getMapChoice().isDeltaMap());
    }

    public static void setCirclesMetrics(LocalDataAllSitesOneTime sites, MapChoice mapChoice, SitesChoice sitesChoice) {
        MinMaxForDisplay.setMetrics(sites, mapChoice, sitesChoice);
        MinMaxForDisplay.minmax_circles[0] = MinMaxForDisplay.getMinMetric();
        MinMaxForDisplay.minmax_circles[1] = MinMaxForDisplay.getMaxMetric();
        MinMaxForDisplay.adjust(minmax_circles, sitesChoice.isVersusEmpiricalModel() || sitesChoice.isVersusIrtam());
    }

    public static void setExternalMetrics(Geomap dataMap) {
        MinMaxForDisplay.setMetrics(dataMap);
        MinMaxForDisplay.minmax_external[0] = MinMaxForDisplay.getMinMetric();
        MinMaxForDisplay.minmax_external[1] = MinMaxForDisplay.getMaxMetric();
        MinMaxForDisplay.adjust(minmax_external, dataMap.getMapChoice().isDeltaMap());
        MinMaxForDisplay.minmax_external[0] = MinMaxForDisplay.intelliRounded(minmax_external[0], dataMap.getMapChoice().isDeltaMap() ? -1 : 1);
        MinMaxForDisplay.minmax_external[1] = MinMaxForDisplay.intelliRounded(minmax_external[1], 1);
    }

    private static void setMetrics(Geomap dataMap) {
        min = dataMap.getMinValue();
        max = dataMap.getMaxValue();
        average = dataMap.getAverageValue();
        sigma = dataMap.getSDO();
        MapChoice mc = dataMap.getMapChoice();
        CharChoice cc = mc.getCC();
        if (mc.isDeltaMap()) {
            if (mc.isPercentDeltaMap()) {
                MinMaxForDisplay.setUserDeltaPercentLimits(cc);
            } else {
                MinMaxForDisplay.setUserDeltaLimits(cc);
            }
        } else {
            MinMaxForDisplay.setUserCustomLimits(cc);
        }
    }

    private static void setUserCustomLimits(CharChoice cc) {
        double[] dArray;
        if (settings != null) {
            dArray = settings.getCustomMinMax(cc);
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = min;
            dArray = dArray2;
            dArray2[1] = max;
        }
        double[] d = dArray;
        userMin = d[0];
        userMax = d[1];
    }

    private static void setUserDeltaLimits(CharChoice cc) {
        double[] dArray;
        if (settings != null) {
            dArray = settings.getDeltaMinMax(cc);
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = min;
            dArray = dArray2;
            dArray2[1] = max;
        }
        double[] d = dArray;
        userMin = d[0];
        userMax = d[1];
    }

    private static void setUserDeltaPercentLimits(CharChoice cc) {
        double[] dArray;
        if (settings != null) {
            dArray = settings.getPercentMinMax(cc);
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = min;
            dArray = dArray2;
            dArray2[1] = max;
        }
        double[] d = dArray;
        userMin = d[0];
        userMax = d[1];
    }

    private static void setMetrics(LocalDataAllSitesOneTime sites, MapChoice mapChoice, SitesChoice sitesChoice) {
        boolean percent = mapChoice.isPercentDeltaMap();
        SimpleMetrics metrics = sites.getMetrics(sitesChoice, percent);
        min = metrics.min;
        max = metrics.max;
        average = metrics.average;
        sigma = metrics.standardDeviation;
        if (sitesChoice.isObservations()) {
            MinMaxForDisplay.setUserCustomLimits(sitesChoice.getCC());
        } else if (sitesChoice.isVersusEmpiricalModel() || sitesChoice.isVersusIrtam()) {
            if (percent) {
                MinMaxForDisplay.setUserDeltaPercentLimits(sitesChoice.getCC());
            } else {
                MinMaxForDisplay.setUserDeltaLimits(sitesChoice.getCC());
            }
        }
    }

    private static double getMinMetric() {
        switch (algorithm) {
            case MINMAX: {
                return min;
            }
            case ONESIGMA: {
                return average - sigma;
            }
            case CUSTOM: {
                return userMin;
            }
        }
        return 9999.0;
    }

    private static double getMaxMetric() {
        switch (algorithm) {
            case MINMAX: {
                return max;
            }
            case ONESIGMA: {
                return average + sigma;
            }
            case CUSTOM: {
                return userMax;
            }
        }
        return 9999.0;
    }

    public static double[] getSurfaceMinMax() {
        return minmax_surface;
    }

    public static double[] getExtSurfaceMinMax() {
        return minmax_external;
    }

    public static double[] getCirclesMinMax() {
        return minmax_circles;
    }

    public static double[] getMergedMinMax() {
        return minmax_merged;
    }

    public static double[] computeOverAllMaps(RingBuffer<Maps> mapsTimeline, MapChoice mapChoice, double noVal) {
        MinMaxForDisplay.resetSurface();
        int iTime = 0;
        while (iTime < mapsTimeline.getLength()) {
            Geomap map = (Geomap)mapsTimeline.get(iTime, (Object)mapChoice);
            if (map != null) {
                SimpleMetrics metrics = map.getMetrics();
                MinMaxForDisplay.minmax_surface[0] = Math.min(minmax_surface[0], metrics.min);
                MinMaxForDisplay.minmax_surface[1] = Math.max(minmax_surface[1], metrics.max);
            }
            ++iTime;
        }
        MinMaxForDisplay.adjust(minmax_surface, mapChoice.isDeltaMap());
        return minmax_surface;
    }

    public static double[] computeOverAllExternalMaps(RingBuffer<Maps> mapsTimeline, MapChoice mapChoice, double noVal) {
        MinMaxForDisplay.resetExtSurface();
        int iTime = 0;
        while (iTime < mapsTimeline.getLength()) {
            Geomap map = (Geomap)mapsTimeline.get(iTime, (Object)mapChoice);
            if (map != null) {
                SimpleMetrics metrics = map.getMetrics();
                MinMaxForDisplay.minmax_external[0] = Math.min(minmax_external[0], metrics.min);
                MinMaxForDisplay.minmax_external[1] = Math.max(minmax_external[1], metrics.max);
            }
            ++iTime;
        }
        MinMaxForDisplay.adjust(minmax_external, mapChoice.isDeltaMap());
        return minmax_external;
    }

    public static double[] computeOverAllSites(GambitCore core, LocalData localData, SitesChoice sitesChoice, boolean percent) {
        MinMaxForDisplay.resetCircles();
        int iTime = 0;
        while (iTime < localData.sites[0].getDataLength()) {
            TimeScale time = localData.getSites()[0].getTimeGrid().getUTs()[iTime];
            LocalDataAllSitesOneTime sites = DisplayDataBuilder.buildCircles(core, localData, time);
            SimpleMetrics metrics = sites.getMetrics(sitesChoice, percent);
            MinMaxForDisplay.minmax_circles[0] = Math.min(minmax_circles[0], metrics.min);
            MinMaxForDisplay.minmax_circles[1] = Math.max(minmax_circles[1], metrics.max);
            ++iTime;
        }
        MinMaxForDisplay.adjust(minmax_circles, sitesChoice.isVersusEmpiricalModel() || sitesChoice.isVersusIrtam());
        return minmax_circles;
    }

    private static void adjust(double[] minmax, boolean isDelta) {
        minmax[0] = minmax[0] * GambitConstants.COLOR_SATURATION_FACTOR;
        minmax[1] = minmax[1] * GambitConstants.COLOR_SATURATION_FACTOR;
        if (isDelta) {
            double maxDeviation = Math.max(Math.abs(minmax[0]), Math.abs(minmax[1]));
            minmax[0] = -maxDeviation;
            minmax[1] = maxDeviation;
        }
    }

    public static double[] mergeMinMaxSets(MapChoice mapChoice, SitesChoice sitesChoice) {
        if (mapChoice == null) {
            MinMaxForDisplay.minmax_merged[1] = minmax_circles[1];
            MinMaxForDisplay.minmax_merged[0] = minmax_circles[1];
            return minmax_merged;
        }
        if (sitesChoice == null) {
            MinMaxForDisplay.minmax_merged[1] = minmax_surface[1];
            MinMaxForDisplay.minmax_merged[0] = minmax_surface[1];
            return minmax_merged;
        }
        int max_circles = MinMaxForDisplay.intelliRounded(minmax_circles[1], 1);
        int min_circles = MinMaxForDisplay.intelliRounded(minmax_circles[0], -1);
        int max_surface = MinMaxForDisplay.intelliRounded(minmax_surface[1], 1);
        int min_surface = MinMaxForDisplay.intelliRounded(minmax_surface[0], -1);
        int max_max = Math.max(max_circles, max_surface);
        int min_min = Math.min(min_circles, min_surface);
        CharChoice cc = mapChoice.getCC();
        if (mapChoice.isDeltaMap() || mapChoice.isInterpolationStep() && cc != CharChoice.CUSTOM || mapChoice.isFittedStep() && cc != CharChoice.CUSTOM || mapChoice.isFitError() || sitesChoice.isVersusEmpiricalModel() || sitesChoice.isVersusIrtam()) {
            if (Math.abs(min_min) > max_max) {
                max_max = -min_min;
            } else {
                min_min = -max_max;
            }
        }
        MinMaxForDisplay.minmax_merged[1] = max_max;
        MinMaxForDisplay.minmax_merged[0] = min_min;
        return minmax_merged;
    }

    private static int intelliRounded(double val, int sign) {
        if (algorithm == MinMaxAlgorithm.CUSTOM) {
            return (int)val;
        }
        int truncated = 0;
        int factor = 1;
        if (val > 10.0 && val <= 40.0) {
            factor = 2;
        }
        if (val > 40.0 || val < -40.0) {
            factor = 10;
        }
        if (val > 100.0 || val < -100.0) {
            factor = 50;
        }
        if (val < -10.0 && val >= -40.0) {
            factor = 2;
        }
        truncated = (int)(val / (double)factor) * factor;
        if (sign > 0 && val > (double)truncated || sign < 0 && val < (double)truncated) {
            truncated += factor * sign;
        }
        return truncated;
    }

    public static void reset() {
        MinMaxForDisplay.resetCircles();
        MinMaxForDisplay.resetSurface();
    }

    public static void resetCircles() {
        MinMaxForDisplay.minmax_circles[0] = Double.MAX_VALUE;
        MinMaxForDisplay.minmax_circles[1] = -1.7976931348623157E308;
    }

    public static void resetSurface() {
        MinMaxForDisplay.minmax_surface[0] = Double.MAX_VALUE;
        MinMaxForDisplay.minmax_surface[1] = -1.7976931348623157E308;
    }

    public static void resetExtSurface() {
        MinMaxForDisplay.minmax_external[0] = Double.MAX_VALUE;
        MinMaxForDisplay.minmax_external[1] = -1.7976931348623157E308;
    }

    public static void setCircles(double[] minmax) {
        MinMaxForDisplay.minmax_circles[0] = minmax[0];
        MinMaxForDisplay.minmax_circles[1] = minmax[1];
    }

    public static void setSurface(double[] minmax) {
        MinMaxForDisplay.minmax_surface[0] = minmax[0];
        MinMaxForDisplay.minmax_surface[1] = minmax[1];
    }

    public static double[] get() {
        return minmax_merged;
    }

    public static double[] getMinMax(Double[] data, double[] minmax_in) {
        double[] minmax = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        minmax = minmax_in == null ? minmax : minmax_in;
        Double[] doubleArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Double val = doubleArray[n2];
            if (val != null) {
                minmax[0] = Math.min(val, minmax[0]);
                minmax[1] = Math.max(val, minmax[1]);
            }
            ++n2;
        }
        return minmax;
    }

    public static double[] getMinMax(double[] data, double[] minmax_in) {
        double[] minmax = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        minmax = minmax_in == null ? minmax : minmax_in;
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            if (val < minmax[0]) {
                minmax[0] = val;
            }
            if (val > minmax[1] && val != 9999.0) {
                minmax[1] = val;
            }
            ++n2;
        }
        return minmax;
    }

    public static enum MinMaxAlgorithm {
        MINMAX("minmax", "Compute minimum and maximum of display values"),
        ONESIGMA("1sigma", "Compute average plus-minus one standard deviation"),
        CUSTOM("custom", "Set user-defined limits");

        private final String label;
        private final String description;

        private MinMaxAlgorithm(String label, String description) {
            this.label = label;
            this.description = description;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.getLabel();
        }
    }
}

