/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.display;

import edu.uml.giro.gambit.display.GambitLayers;
import edu.uml.giro.gambit.gui.FlatWorldPanel;
import edu.uml.lgdc.graph.AnimatedGifEncoder;
import edu.uml.lgdc.time.TimeScale;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.NASAWFSPlaceNameLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.ScalebarLayer;
import gov.nasa.worldwind.layers.SkyColorLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurface;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceAttributes;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceLegend;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class WWindowManager
extends ApplicationTemplate {
    public static void turnOffPlaceNames(ApplicationTemplate.AppFrame frame) {
        WorldWindow wwd = frame.getWwd();
        for (Layer l : wwd.getModel().getLayers()) {
            if (!(l instanceof PlaceNameLayer)) continue;
            l.setEnabled(false);
        }
        if (frame.getLayerPanel() != null) {
            frame.getLayerPanel().update(wwd);
        }
    }

    public static void turnOffCompass(ApplicationTemplate.AppFrame frame) {
        WorldWindow wwd = frame.getWwd();
        for (Layer l : wwd.getModel().getLayers()) {
            if (!(l instanceof CompassLayer)) continue;
            l.setEnabled(false);
        }
        if (frame.getLayerPanel() != null) {
            frame.getLayerPanel().update(wwd);
        }
    }

    public static void turnOffViewControls(ApplicationTemplate.AppFrame frame) {
        WorldWindow wwd = frame.getWwd();
        for (Layer l : wwd.getModel().getLayers()) {
            if (!(l instanceof ViewControlsLayer)) continue;
            l.setEnabled(false);
        }
        if (frame.getLayerPanel() != null) {
            frame.getLayerPanel().update(wwd);
        }
    }

    public static void turnOffScaleBar(ApplicationTemplate.AppFrame frame) {
        WorldWindow wwd = frame.getWwd();
        for (Layer l : wwd.getModel().getLayers()) {
            if (!(l instanceof ScalebarLayer)) continue;
            l.setEnabled(false);
        }
        if (frame.getLayerPanel() != null) {
            frame.getLayerPanel().update(wwd);
        }
    }

    public static void turnOffWorldMap(ApplicationTemplate.AppFrame frame) {
        WorldWindow wwd = frame.getWwd();
        for (Layer l : wwd.getModel().getLayers()) {
            if (!(l instanceof WorldMapLayer)) continue;
            l.setEnabled(false);
        }
        if (frame.getLayerPanel() != null) {
            frame.getLayerPanel().update(wwd);
        }
    }

    public static void turnOffSky(ApplicationTemplate.AppFrame frame) {
        WorldWindow wwd = frame.getWwd();
        for (Layer l : wwd.getModel().getLayers()) {
            if (!(l instanceof SkyGradientLayer)) continue;
            l.setEnabled(false);
        }
        if (frame.getLayerPanel() != null) {
            frame.getLayerPanel().update(wwd);
        }
    }

    public static void setLayerEnabled(ApplicationTemplate.AppFrame frame, RenderableLayer layer, boolean s) {
        WWindowManager.setLayerEnabled(frame.getWwd(), layer, s);
        if (frame.getLayerPanel() != null) {
            frame.getLayerPanel().update(frame.getWwd());
        }
    }

    public static void setLayerEnabled(WorldWindow wwd, RenderableLayer layer, boolean s) {
        for (Layer l : wwd.getModel().getLayers()) {
            if (l != layer) continue;
            l.setEnabled(s);
            break;
        }
    }

    public static void removeUnusedLayers(ApplicationTemplate.AppFrame frame) {
        WorldWindow wwd = frame.getWwd();
        LayerList ll = wwd.getModel().getLayers();
        for (Layer l : ll) {
            if (l instanceof CompassLayer || l instanceof ViewControlsLayer || l instanceof NASAWFSPlaceNameLayer || l instanceof StarsLayer || l instanceof SkyGradientLayer || l instanceof SkyColorLayer) {
                ll.remove(l);
            }
            if (!l.getName().equals("i-cubed Landsat") && !l.getName().contains("USDA") && !l.getName().contains("USGS") && !l.getName().equals("MS Virtual Earth Aerial") && !l.getName().equals("Bing Imagery") && !l.getName().contains("Street") && !l.getName().equals("Renderable") && !l.getName().contains("May 2004")) continue;
            ll.remove(l);
        }
    }

    public static void setEyeView(WorldWindow wwd, double latitude, double longitude, double altitude) {
        Position currentPos = wwd.getView().getEyePosition();
        wwd.getView().setEyePosition(Position.fromDegrees((double)(latitude == Double.MAX_VALUE ? currentPos.latitude.degrees : latitude), (double)(longitude == Double.MAX_VALUE ? currentPos.longitude.degrees : longitude), (double)(altitude == -1.0 ? currentPos.getAltitude() : altitude)));
    }

    public static int setRoundView(ApplicationTemplate.AppFrame frame, FlatWorldPanel panel) {
        panel.enableFlatGlobe(false);
        WWindowManager.setEyeView(frame.getWwd(), 10.0, 0.0, 1.0E7);
        return 1;
    }

    public static int setFlatView(ApplicationTemplate.AppFrame frame, FlatWorldPanel panel) {
        panel.enableFlatGlobe(true);
        WorldWindow wwd = frame.getWwd();
        WWindowManager.setEyeView(frame.getWwd(), -20.0, 0.0, 5.0E7);
        return 0;
    }

    public static void refreshLayer(WorldWindow wwd, GambitLayers.LayerSpec layerSpec) {
        Layer layer;
        LayerList layers = wwd.getModel().getLayers();
        int position = layers.indexOf((Object)(layer = layerSpec.getLayer()));
        if (position == -1) {
            position = layerSpec.getPosition();
        }
        layers.remove(layer);
        layers.add(position, layerSpec.getLayer());
        wwd.redraw();
    }

    public static void printLayers(WorldWindow wwd) {
        System.out.println("---");
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            System.out.println("#" + layers.indexOf((Object)l) + " " + l.getName().toString() + (l.isEnabled() ? ", enabled" : ", disabled"));
        }
    }

    public static void insertAsBottomLayer(WorldWindow wwd, Layer layer) {
        WWindowManager.insertLayer(wwd, layer, "White space");
    }

    public static void insertLayer(WorldWindow wwd, Layer layer, String placeBefore) {
        int compassPosition = 0;
        LayerList layers = wwd.getModel().getLayers();
        for (Layer l : layers) {
            if (!l.getName().equals(placeBefore)) continue;
            compassPosition = layers.indexOf((Object)l);
        }
        layers.add(compassPosition, layer);
    }

    public static void deleteLayer(RenderableLayer layer, ApplicationTemplate.AppFrame frame) {
        LayerList layers = frame.getWwd().getModel().getLayers();
        if (layer != null) {
            layers.remove((Layer)layer);
        }
    }

    public static void setupAnalyticSurface(AnalyticSurface surface, WorldWindow wwd, int latNodesNum, int lonNodesNum) {
        surface.setSector(Sector.fromDegrees((double)-90.0, (double)90.0, (double)-180.0, (double)180.0));
        surface.setAltitudeMode(1);
        surface.setDimensions(lonNodesNum, latNodesNum);
        AnalyticSurfaceAttributes attr = new AnalyticSurfaceAttributes();
        attr.setDrawShadow(false);
        attr.setInteriorOpacity(0.65);
        attr.setOutlineWidth(3.0);
        surface.setSurfaceAttributes(attr);
    }

    public static RenderableLayer getBlackSurface() {
        RenderableLayer layer = new RenderableLayer();
        AnalyticSurface surface = new AnalyticSurface();
        surface.setSector(Sector.fromDegrees((double)-90.0, (double)90.0, (double)-180.0, (double)180.0));
        surface.setAltitudeMode(2);
        surface.setAltitude(9000.0);
        ArrayList<AnalyticSurface.GridPointAttributes> attributesList = new ArrayList<AnalyticSurface.GridPointAttributes>();
        attributesList.add(AnalyticSurface.createColorGradientAttributes((double)1.0, (double)0.0, (double)1.0, (double)1.0, (double)0.0));
        attributesList.add(AnalyticSurface.createColorGradientAttributes((double)1.0, (double)0.0, (double)1.0, (double)1.0, (double)0.0));
        attributesList.add(AnalyticSurface.createColorGradientAttributes((double)1.0, (double)0.0, (double)1.0, (double)1.0, (double)0.0));
        attributesList.add(AnalyticSurface.createColorGradientAttributes((double)1.0, (double)0.0, (double)1.0, (double)1.0, (double)0.0));
        layer.addRenderable((Renderable)surface);
        return layer;
    }

    public static void removeLegend(AnalyticSurfaceLegend legend, RenderableLayer layer) {
        if (legend == null) {
            return;
        }
        for (Renderable rendObj : layer.getRenderables()) {
            if (rendObj != legend) continue;
            layer.removeRenderable(rendObj);
        }
    }

    public static void makeWwdCapture(WorldWindow wwindow, String fileName, TimeScale time, AnimatedGifEncoder gifEncoder, boolean saveFrames, Point roiLocation, int roiWidth, int roiHeightFrame, int roiHeightMovie) {
        int wwdWidth = ((Component)wwindow).getWidth();
        int wwdHeight = ((Component)wwindow).getHeight();
        Point wwdLocation = ((Component)wwindow).getLocationOnScreen();
        if (roiHeightFrame <= 0 || roiHeightFrame > wwdHeight || roiHeightMovie <= 0 || roiHeightMovie > wwdHeight) {
            roiHeightFrame = wwdHeight;
            roiHeightMovie = wwdHeight;
        }
        if (roiWidth <= 0 || roiWidth > wwdWidth) {
            roiWidth = wwdWidth;
        }
        if (roiLocation != null) {
            roiLocation.x += wwdLocation.x;
            roiLocation.y += wwdLocation.y;
            if (roiLocation.x < wwdLocation.x || roiLocation.x > wwdLocation.x + wwdWidth) {
                roiLocation.x = wwdLocation.x;
            }
            if (roiLocation.y < wwdLocation.y || roiLocation.y > wwdLocation.y + wwdHeight) {
                roiLocation.y = wwdLocation.y;
            }
            if (roiLocation.x + roiWidth > wwdLocation.x + wwdWidth) {
                roiWidth = wwdWidth - (roiLocation.x - wwdLocation.x);
            }
            if (roiLocation.y + roiHeightFrame > wwdLocation.y + wwdHeight) {
                roiHeightFrame = wwdHeight - (roiLocation.y - wwdLocation.y);
            }
            if (roiLocation.y + roiHeightMovie > wwdLocation.y + wwdHeight) {
                roiHeightMovie = wwdHeight - (roiLocation.y - wwdLocation.y);
            }
        } else {
            roiLocation = new Point(0, 0);
            roiLocation.x = roiHeightFrame == wwdHeight ? wwdLocation.x : wwdLocation.x + (wwdHeight - roiHeightFrame) / 2;
            roiLocation.y = roiWidth == wwdWidth ? wwdLocation.y : wwdLocation.y + (wwdWidth - roiWidth) / 2;
        }
        if (roiHeightFrame <= 0 || roiWidth <= 0 || roiLocation.x < wwdLocation.x || roiLocation.y < wwdLocation.y) {
            System.out.println("Unexpected behavior in makeWwdCapture()");
            return;
        }
        try {
            BufferedImage screencapture = new Robot().createScreenCapture(new Rectangle(roiLocation.x, roiLocation.y, roiWidth, roiHeightFrame));
            if (saveFrames) {
                File file = new File(fileName);
                ImageIO.write((RenderedImage)screencapture, "PNG", file);
            }
            if (gifEncoder != null) {
                gifEncoder.setSize(roiWidth, roiHeightMovie);
                gifEncoder.addFrame(screencapture);
            }
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

