/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.expansions;

import edu.uml.giro.gambit.expansions.ExpansionBasis;
import edu.uml.lgdc.time.TimeScale;

public abstract class ExpansionBasis2D
extends ExpansionBasis {
    protected static final int INDEX_ORDER = 0;
    protected static final int INDEX_DEGREE = 1;
    protected static final int INDEX_TERM = 2;
    protected static final int MAX_TEMPORAL_ORDER = 12;
    protected int temporalOrder;
    protected int spatialOrder;
    protected int spatialDegree;

    public boolean setup(int temporalOrder, int spatialOrder, int spatialDegree) {
        return this.setTemporalOrder(temporalOrder) && this.setSpatialOrder(spatialOrder) && this.setSpatialDegree(spatialDegree);
    }

    public boolean setTemporalOrder(int diurnalOrder) {
        this.temporalOrder = diurnalOrder;
        if (diurnalOrder > 12) {
            System.err.println("Requested temporal order of expansion " + diurnalOrder + " is larger than maximum " + 12);
            return false;
        }
        return true;
    }

    public void setNewTime(TimeScale ut) {
        this.timeGrid.setUTs(ut);
    }

    public abstract boolean setSpatialOrder(int var1);

    public abstract boolean setSpatialDegree(int var1);

    public int getTemporalBasisLength() {
        return this.temporalOrder * 2 + 1;
    }

    public abstract int getCompactSpatialBasisLength();

    public abstract int orderDegreeTermToCompact(int var1, int var2, int var3);

    public abstract int[] compactToOrderDegreeTerm(int var1);

    public int getTemporalOrder() {
        return this.temporalOrder;
    }

    protected int getSpatialOrder() {
        return this.spatialOrder;
    }

    protected int getSpatialDegree() {
        return this.spatialDegree;
    }

    public abstract double getTemporalBasisFunctionValue(int var1, int var2);

    public abstract double getSpatialBasisFunctionValue(int var1, int var2, int var3);

    public double getSpaceBasisFunctionValue(int k, Double latitude_deg, Double longitude_deg) {
        int iLat = this.earthGrid.getGridLatIndex(latitude_deg);
        int iLon = this.earthGrid.getGridLonIndex(longitude_deg);
        return this.getSpatialBasisFunctionValue(k, iLat, iLon);
    }
}

