/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.expansions;

import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.lgdc.geospace.IGRF;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.time.TimeScale;

public class ExpansionBasis_JonesGallet
extends ExpansionBasis2D {
    public static final int CCIR_DIURNAL_ORDER = 6;
    public static final int SPATIAL_ORDER = 8;
    public static final int SPATIAL_DEGREE = 11;
    public static final int[] USED_DEGREES;
    public static final int[] NUMBER_FUNCTIONS_PER_ORDER;
    public static final int COMPACT_SPATIAL_LENGTH;
    protected double[][] sinT;
    protected double[][] cosT;
    protected double[][] sinLon;
    protected double[][] cosLon;
    protected double[][] cosLat;
    protected final IGRF igrf = new IGRF();
    protected double[][] modip;
    protected double[][][] sinModip;

    static {
        int[] nArray = new int[9];
        nArray[0] = 11;
        nArray[1] = 11;
        nArray[2] = 8;
        nArray[3] = 4;
        nArray[4] = 1;
        USED_DEGREES = nArray;
        NUMBER_FUNCTIONS_PER_ORDER = ExpansionBasis_JonesGallet.calculateUsedFunctionsPerOrder();
        COMPACT_SPATIAL_LENGTH = ExpansionBasis_JonesGallet.calculateCompactSpatialLength(NUMBER_FUNCTIONS_PER_ORDER);
    }

    public ExpansionBasis_JonesGallet() {
        this.setExpansionBasisName("JonesGallet");
    }

    public ExpansionBasis_JonesGallet(TimeGrid timeGrid) {
        this.setExpansionBasisName("JonesGallet");
        this.setTimeGrid(timeGrid);
    }

    @Override
    public boolean setupTemporalBasisConstants() {
        this.sinT = new double[this.temporalOrder][this.timeGrid.getNumDiurnalSteps()];
        this.cosT = new double[this.temporalOrder][this.timeGrid.getNumDiurnalSteps()];
        int i = 0;
        while (i < this.timeGrid.getNumDiurnalSteps()) {
            double dayPhase_deg = 360.0 * ((double)i / (double)this.timeGrid.getNumDiurnalSteps()) - 180.0;
            double dayPhase_rad = Math.toRadians(dayPhase_deg);
            this.sinT[0][i] = Math.sin(dayPhase_rad);
            this.cosT[0][i] = Math.cos(dayPhase_rad);
            int j = 1;
            while (j < this.temporalOrder) {
                this.sinT[j][i] = this.cosT[0][i] * this.sinT[j - 1][i] + this.sinT[0][i] * this.cosT[j - 1][i];
                this.cosT[j][i] = this.cosT[0][i] * this.cosT[j - 1][i] - this.sinT[0][i] * this.sinT[j - 1][i];
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public double getTemporalBasisFunctionValue(int index, int iTime) {
        if (index == 0) {
            return 1.0;
        }
        TimeScale startUT = this.timeGrid.getUTs()[0];
        double minutesAtStart = startUT.getTimeSinceMidnightIn(12);
        int iDayPhaseOffset = (int)Math.round(minutesAtStart / (double)this.timeGrid.getTimeStep_min());
        int i = (iTime + iDayPhaseOffset) % this.timeGrid.getNumDiurnalSteps();
        double value = index % 2 == 0 ? this.cosT[(index - 1) / 2][i] : this.sinT[(index - 1) / 2][i];
        return value;
    }

    @Override
    public boolean setSpatialOrder(int spatialOrder) {
        this.spatialOrder = spatialOrder;
        if (spatialOrder != 8) {
            System.err.println("ERROR: requested Jones-Gallet spatial order " + spatialOrder + " is not supported");
            return false;
        }
        return true;
    }

    @Override
    public boolean setSpatialDegree(int spatialDegree) {
        this.spatialDegree = spatialDegree;
        if (spatialDegree != 11) {
            System.err.println("ERROR: requested Jones-Gallet spatial degree " + spatialDegree + " is not supported");
            return false;
        }
        return true;
    }

    @Override
    public boolean setupSpatialBasisConstants() {
        int j;
        if (this.earthGrid == null) {
            System.err.println("ERROR: Jones-Gallet expansion basis cannot initialize without defined grid");
            return false;
        }
        this.sinLon = new double[8][this.earthGrid.getNumLongitudeNodes()];
        this.cosLon = new double[8][this.earthGrid.getNumLongitudeNodes()];
        this.cosLat = new double[8][this.earthGrid.getNumLatitudeNodes()];
        int i = 0;
        while (i < this.earthGrid.getNumLongitudeNodes()) {
            double longitude_deg = (double)i * this.earthGrid.getLongitudeStep();
            double longitude_rad = Math.toRadians(longitude_deg);
            this.sinLon[0][i] = Math.sin(longitude_rad);
            this.cosLon[0][i] = Math.cos(longitude_rad);
            j = 1;
            while (j < 8) {
                this.sinLon[j][i] = this.cosLon[0][i] * this.sinLon[j - 1][i] + this.sinLon[0][i] * this.cosLon[j - 1][i];
                this.cosLon[j][i] = this.cosLon[0][i] * this.cosLon[j - 1][i] - this.sinLon[0][i] * this.sinLon[j - 1][i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.earthGrid.getNumLatitudeNodes()) {
            double cosLatitude;
            double latitude_deg = (double)i * this.earthGrid.getLatitudeStep() - 90.0;
            double latitude_rad = Math.toRadians(latitude_deg);
            this.cosLat[0][i] = cosLatitude = Math.cos(latitude_rad);
            j = 1;
            while (j < 8) {
                this.cosLat[j][i] = this.cosLat[j - 1][i] * cosLatitude;
                ++j;
            }
            ++i;
        }
        this.modip = new double[this.earthGrid.getNumLatitudeNodes()][this.earthGrid.getNumLongitudeNodes()];
        this.sinModip = new double[11][this.earthGrid.getNumLatitudeNodes()][this.earthGrid.getNumLongitudeNodes()];
        return true;
    }

    @Override
    public void computeTimeDependentConstants(TimeScale ut) {
        this.recalculateMagneticField(ut);
        this.timeGrid.setUTs(ut);
    }

    protected void recalculateMagneticField(TimeScale ut) {
        int i = 0;
        while (i < this.earthGrid.getNumLatitudeNodes()) {
            double latitude_deg = (double)i * this.earthGrid.getLatitudeStep() - 90.0;
            double latitude_rad = Math.toRadians(latitude_deg);
            double cos_latitude = Math.cos(latitude_rad);
            int j = 0;
            while (j < this.earthGrid.getNumLongitudeNodes()) {
                double longitude_deg = (double)j * this.earthGrid.getLongitudeStep();
                this.igrf.calc(ut, latitude_deg, longitude_deg, 300.0);
                double dip_rad = Math.toRadians(this.igrf.dip);
                double dipdiv = dip_rad / Math.sqrt(dip_rad * dip_rad + cos_latitude);
                dipdiv = Math.min(dipdiv, 1.0);
                this.sinModip[0][i][j] = dipdiv = Math.max(dipdiv, -1.0);
                int k = 1;
                while (k < 11) {
                    this.sinModip[k][i][j] = this.sinModip[k - 1][i][j] * dipdiv;
                    ++k;
                }
                this.modip[i][j] = Math.asin(dipdiv);
                ++j;
            }
            ++i;
        }
    }

    public double getModip(int iLat, int iLon) {
        return this.modip[iLat][iLon];
    }

    protected double sinModipFactor(int degree, int iLat, int iLon) {
        return degree == 0 ? 1.0 : this.sinModip[degree - 1][iLat][iLon];
    }

    @Override
    public int getCompactSpatialBasisLength() {
        return COMPACT_SPATIAL_LENGTH;
    }

    private static int[] calculateUsedFunctionsPerOrder() {
        int[] usedFunctions = new int[USED_DEGREES.length];
        usedFunctions[0] = USED_DEGREES[0] + 1;
        int i = 1;
        while (i <= 8) {
            usedFunctions[i] = (USED_DEGREES[i] + 1) * 2;
            ++i;
        }
        return usedFunctions;
    }

    private static int calculateCompactSpatialLength(int[] usedCoeffs) {
        int compactSpatialLength = 0;
        int i = 0;
        while (i < usedCoeffs.length) {
            compactSpatialLength += usedCoeffs[i];
            ++i;
        }
        return compactSpatialLength;
    }

    @Override
    public int orderDegreeTermToCompact(int sOrder, int sDegree, int sTerm) {
        if (sTerm > 1 && sTerm < 0) {
            return 0;
        }
        if (sOrder > 8 || sDegree > USED_DEGREES[sOrder]) {
            return 0;
        }
        if (sOrder == 0) {
            return sDegree;
        }
        int sCompact = 0;
        int iOrder = 0;
        while (iOrder < sOrder) {
            sCompact += NUMBER_FUNCTIONS_PER_ORDER[iOrder];
            ++iOrder;
        }
        return sCompact += sDegree * 2 + sTerm;
    }

    @Override
    public int[] compactToOrderDegreeTerm(int sCompact) {
        int[] order_degree = new int[3];
        if (sCompact >= COMPACT_SPATIAL_LENGTH) {
            return null;
        }
        int order = 0;
        int counter = NUMBER_FUNCTIONS_PER_ORDER[0] - 1;
        while (sCompact > counter && order <= 8) {
            counter += NUMBER_FUNCTIONS_PER_ORDER[++order];
        }
        int degree = 0;
        if (order == 0) {
            degree = sCompact;
        } else {
            int remaining = counter - sCompact;
            int position = NUMBER_FUNCTIONS_PER_ORDER[order] - remaining - 1;
            degree = position / 2;
        }
        order_degree[0] = order;
        order_degree[1] = degree;
        order_degree[2] = sCompact % 2 == 0 ? 0 : 1;
        return order_degree;
    }

    protected double latitudeFactor(int order, int iLat) {
        return order == 0 ? 1.0 : this.cosLat[order - 1][iLat];
    }

    protected double longitudeFactor(int order, int term, int iLon) {
        if (order == 0) {
            return 1.0;
        }
        return term == 0 ? this.cosLon[order - 1][iLon] : this.sinLon[order - 1][iLon];
    }

    @Override
    public double getSpatialBasisFunctionValue(int sCompact, int iLat, int iLon) {
        if (sCompact >= COMPACT_SPATIAL_LENGTH) {
            return 0.0;
        }
        int[] order_degree_term = this.compactToOrderDegreeTerm(sCompact);
        return this.getGeoFunction(order_degree_term[0], order_degree_term[2], order_degree_term[1], iLat, iLon);
    }

    public double getGeoFunction(int order, int term, int degree, int iLat, int iLon) {
        double value = this.sinModipFactor(degree, iLat, iLon) * this.latitudeFactor(order, iLat) * this.longitudeFactor(order, term, iLon);
        return value;
    }
}

