/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.expansions;

import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGallet;
import edu.uml.lgdc.time.TimeScale;

public class ExpansionBasis_JonesGalletWithTrend
extends ExpansionBasis_JonesGallet {
    public ExpansionBasis_JonesGalletWithTrend() {
        this.setExpansionBasisName("JonesGallet_LinTrend");
    }

    @Override
    public int getTemporalBasisLength() {
        return (this.temporalOrder + 1) * 2;
    }

    @Override
    public double getTemporalBasisFunctionValue(int index, int iTime) {
        if (index == 0) {
            return 1.0;
        }
        if (index == 1) {
            double iTimeAverage = (double)(this.timeGrid.getNumDiurnalSteps() - 1) / 2.0;
            return (double)this.timeGrid.getTimeStep_min() * ((double)iTime - iTimeAverage);
        }
        TimeScale startUT = this.timeGrid.getUTs()[0];
        double minutesAtStart = startUT.getTimeSinceMidnightIn(12);
        int iDayPhaseOffset = (int)Math.round(minutesAtStart / (double)this.timeGrid.getTimeStep_min());
        int i = (iTime + iDayPhaseOffset) % this.timeGrid.getNumDiurnalSteps();
        double value = index % 2 == 0 ? this.sinT[(index - 2) / 2][i] : this.cosT[(index - 2) / 2][i];
        return value;
    }
}

