/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.gui;

import edu.uml.giro.gambit.apps.GambitUserApp;
import edu.uml.lgdc.time.TimeScale;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.WWIcon;

public class ChartIconSelectHandler
implements SelectListener {
    private TimeScale time;
    private WWIcon previous;
    private final GambitUserApp.AppFrame gambitFrame;

    public ChartIconSelectHandler(TimeScale time, GambitUserApp.AppFrame gambit) {
        this.time = new TimeScale(time.getTimeInMillis());
        this.gambitFrame = gambit;
    }

    public void update(TimeScale time, WWIcon previous) {
        this.time = new TimeScale(time.getTimeInMillis());
        this.previous = previous;
    }

    public void selected(SelectEvent e) {
        if (e == null) {
            return;
        }
        PickedObject topPickedObject = e.getTopPickedObject();
        if (e.getEventAction() == "gov.nasa.worldwind.SelectEvent.LeftPress") {
            if (topPickedObject != null && topPickedObject.getObject() instanceof WWIcon) {
                WWIcon selected = (WWIcon)topPickedObject.getObject();
                this.highlightIcon(selected);
            } else {
                this.highlightIcon(null);
            }
        } else if (e.getEventAction() == "gov.nasa.worldwind.SelectEvent.LeftDoubleClick" && topPickedObject != null && topPickedObject.getObject() instanceof WWIcon) {
            WWIcon selected = (WWIcon)topPickedObject.getObject();
            int stationIndex = Integer.parseInt(selected.getValue("StationIndex").toString());
            this.gambitFrame.showChart(this.time, stationIndex, selected.getValue("gov.nasa.worldwind.avkey.Title").toString());
        }
    }

    public void highlightIcon(WWIcon icon) {
        if (this.previous == icon) {
            return;
        }
        if (this.previous != null) {
            this.previous.setHighlighted(false);
            this.previous = null;
        }
        if (icon != null) {
            icon.setHighlighted(true);
        }
    }
}

