/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.gui;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.FlatGlobe;
import gov.nasa.worldwind.globes.GeographicProjection;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.projections.ProjectionEquirectangular;
import gov.nasa.worldwind.globes.projections.ProjectionMercator;
import gov.nasa.worldwind.globes.projections.ProjectionModifiedSinusoidal;
import gov.nasa.worldwind.globes.projections.ProjectionPolarEquidistant;
import gov.nasa.worldwind.globes.projections.ProjectionSinusoidal;
import gov.nasa.worldwind.globes.projections.ProjectionTransverseMercator;
import gov.nasa.worldwind.globes.projections.ProjectionUPS;
import gov.nasa.worldwind.terrain.ZeroElevationModel;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class FlatWorldPanel
extends JPanel {
    private WorldWindow wwd;
    private Globe roundGlobe;
    private FlatGlobe flatGlobe;
    private JComboBox projectionCombo;

    public FlatWorldPanel(WorldWindow wwd) {
        super(new GridLayout(0, 2, 0, 0));
        this.wwd = wwd;
        if (this.isFlatGlobe()) {
            this.flatGlobe = (FlatGlobe)wwd.getModel().getGlobe();
            this.roundGlobe = new Earth();
        } else {
            this.flatGlobe = new EarthFlat();
            this.roundGlobe = wwd.getModel().getGlobe();
        }
        this.flatGlobe.setElevationModel((ElevationModel)new ZeroElevationModel());
        this.makePanel();
    }

    private JPanel makePanel() {
        FlatWorldPanel controlPanel = this;
        controlPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Globe")));
        controlPanel.setToolTipText("Set the current projection");
        JPanel radioButtonPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        JRadioButton roundRadioButton = new JRadioButton("Round");
        roundRadioButton.setSelected(!this.isFlatGlobe());
        roundRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FlatWorldPanel.this.projectionCombo.setEnabled(false);
                FlatWorldPanel.this.enableFlatGlobe(false);
            }
        });
        radioButtonPanel.add(roundRadioButton);
        JRadioButton flatRadioButton = new JRadioButton("Flat");
        flatRadioButton.setSelected(this.isFlatGlobe());
        flatRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FlatWorldPanel.this.projectionCombo.setEnabled(true);
                FlatWorldPanel.this.enableFlatGlobe(true);
            }
        });
        radioButtonPanel.add(flatRadioButton);
        ButtonGroup group = new ButtonGroup();
        group.add(roundRadioButton);
        group.add(flatRadioButton);
        JPanel comboPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        this.projectionCombo = new JComboBox<String>(new String[]{"Mercator", "Lat-Lon", "Modified Sin.", "Sinusoidal", "Transverse Mercator", "North Polar", "South Polar", "UPS North", "UPS South"});
        this.projectionCombo.setEnabled(this.isFlatGlobe());
        this.projectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatWorldPanel.this.updateProjection();
            }
        });
        comboPanel.add(this.projectionCombo);
        controlPanel.add(radioButtonPanel);
        controlPanel.add(comboPanel);
        this.flatGlobe.setProjection((GeographicProjection)new ProjectionMercator());
        return controlPanel;
    }

    private void updateProjection() {
        if (!this.isFlatGlobe()) {
            return;
        }
        this.flatGlobe.setProjection(this.getProjection());
        this.wwd.redraw();
    }

    private GeographicProjection getProjection() {
        String item = (String)this.projectionCombo.getSelectedItem();
        if (item.equals("Mercator")) {
            return new ProjectionMercator();
        }
        if (item.equals("Sinusoidal")) {
            return new ProjectionSinusoidal();
        }
        if (item.equals("Modified Sin.")) {
            return new ProjectionModifiedSinusoidal();
        }
        if (item.equals("Transverse Mercator")) {
            return new ProjectionTransverseMercator(this.wwd.getView().getCurrentEyePosition().getLongitude());
        }
        if (item.equals("North Polar")) {
            return new ProjectionPolarEquidistant("gov.nasa.worldwind.avkey.North");
        }
        if (item.equals("South Polar")) {
            return new ProjectionPolarEquidistant("gov.nasa.worldwdind.avkey.South");
        }
        if (item.equals("UPS North")) {
            return new ProjectionUPS("gov.nasa.worldwind.avkey.North");
        }
        if (item.equals("UPS South")) {
            return new ProjectionUPS("gov.nasa.worldwdind.avkey.South");
        }
        return new ProjectionEquirectangular();
    }

    public boolean isFlatGlobe() {
        return this.wwd.getModel().getGlobe() instanceof FlatGlobe;
    }

    public void enableFlatGlobe(boolean flat) {
        if (this.isFlatGlobe() == flat) {
            return;
        }
        if (!flat) {
            this.wwd.getModel().setGlobe(this.roundGlobe);
            this.wwd.getView().stopMovement();
        } else {
            this.wwd.getModel().setGlobe((Globe)this.flatGlobe);
            this.wwd.getView().stopMovement();
            this.updateProjection();
        }
        this.wwd.redraw();
    }
}

