/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.gui;

import edu.uml.giro.gambit.apps.GambitAppSettings;
import edu.uml.giro.gambit.apps.GambitUserApp;
import edu.uml.giro.gambit.core.AlgorithmVersions;
import edu.uml.giro.gambit.core.Characteristic;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.core.GambitCoreSettings;
import edu.uml.giro.gambit.core.SitesChoice;
import edu.uml.giro.gambit.core.SitesTypeChoice;
import edu.uml.giro.gambit.database.GambitDatabaseReader;
import edu.uml.giro.gambit.display.AnimationActionListener;
import edu.uml.giro.gambit.display.GambitLayers;
import edu.uml.giro.gambit.display.MinMaxForDisplay;
import edu.uml.giro.gambit.gui.DatePanel;
import edu.uml.giro.gambit.reports.ReportChoice;
import edu.uml.giro.gambit.reports.Reports;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.geospace.MapTypeChoice;
import edu.uml.lgdc.time.TimeScale;
import gov.nasa.worldwind.geom.Position;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GAMBITExplorerControlPanel
extends JPanel {
    public static final Font DEFAULT_FONT_BC = new Font("Calibri", 1, 12);
    public static final Font DEFAULT_FONT_DATE = new Font("Calibri", 1, 14);
    public static final int MAX_COLOR_SLIDER = 300;
    public static final int MIN_COLOR_SLIDER = -100;
    private static final int[] MOVIE_DURATIONS = new int[]{24, 12, 6, 4};
    private GambitUserApp.AppFrame gambitFrame;
    private GambitCore core;
    private GambitAppSettings gambitAppSettings;
    GambitLayers gambitLayers;
    private boolean masterAccess;
    private boolean firstClick = true;
    private JLabel lblSoftwareTitle = new JLabel(new ImageIcon(GambitUserApp.AppFrame.class.getResource("Gambit-logo4-small.png")));
    private JButton btnShowConsole;
    private JButton btnSettings;
    private JCheckBox chckbsRecalculate;
    private JCheckBox chckbsResubmit;
    private DatePanel datePanel;
    private JButton btnStepBackward;
    private JButton btnStepForward;
    private JButton btnLargeStepBackward;
    private JButton btnLargeStepForward;
    private JCheckBox chckbxGetGlobalCoeffs;
    private JCheckBox chckbxGetLocalCoeffs;
    private JCheckBox chckbxGetObs;
    private JComboBox<AlgorithmVersions> cbIrtamVersions;
    private JButton btnGetData;
    private JButton btnSiteCharts_save;
    private JCheckBox chckbxSurface;
    private static JComboBox<CharChoice> cbSurfacesChar;
    private static JComboBox<MapTypeChoice> cbSurfacesType;
    private JTextField txtSurfaceParameter;
    private JRadioButton rbtnCenterUT00 = new JRadioButton("UT00", true);
    private JRadioButton rbtnCenterLT12 = new JRadioButton("LT12");
    private JRadioButton rbtnCenterLT12demag = new JRadioButton("LT12dm");
    private ButtonGroup btnCenterGroup = new ButtonGroup();
    private JPanel pnlCenteringOptions = new JPanel();
    private JCheckBox chckbxSites;
    private static JComboBox<CharChoice> cbSitesChar;
    private static JComboBox<SitesTypeChoice> cbSitesType;
    private JCheckBox chckbxSurface_ext;
    private static JComboBox<MapChoice> cbSurfaces_ext;
    private JLabel lblDatePanel_ext;
    private JButton btnCalc_ext;
    private JCheckBox chckbxHiResTec_ext;
    private JCheckBox chckbxCharts;
    private DatePanel datePanelBaseline_ext;
    private TimeScale baselineTime = null;
    private JLabel lblColor;
    private JComboBox<MinMaxForDisplay.MinMaxAlgorithm> cbMinMax;
    private JSlider sliderColor;
    private JTextField txtSliderParameter;
    private JLabel lblReports;
    private JComboBox<ReportChoice> cbReports;
    private JButton btnReport;
    private JButton btnAnimations;
    private JLabel lblReportsTxt = new JLabel();
    private JTextField txtReportParameter;
    private JComboBox<String> cbMovieDurations;
    private JCheckBox chckbxMakeAniGIF;
    private String nameGetData = "Get Data";
    private String nameGetGlobalCoeffs = "Global Cijk";
    private String nameGetLocalCoeffs = "Local Ci";
    private String nameGetObs = "GIRO data";
    private ToolTipManager ttm = ToolTipManager.sharedInstance();

    public GAMBITExplorerControlPanel(GambitUserApp.AppFrame gambitFrame, GambitLayers gambitLayers, GambitCore core, GambitAppSettings gambitAppSettings) {
        this.core = core;
        this.gambitAppSettings = gambitAppSettings;
        this.gambitFrame = gambitFrame;
        this.gambitLayers = gambitLayers;
        this.masterAccess = gambitFrame.isMasterAccess();
        this.makeGAMBITPanel();
    }

    public void setCore(GambitCore core) {
        this.core = core;
    }

    public void setFrame(GambitUserApp.AppFrame frame) {
        this.gambitFrame = frame;
        this.masterAccess = this.gambitFrame.isMasterAccess();
    }

    private JPanel makeGAMBITPanel() {
        JPanel gambitPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        int rH = 10;
        gridBagLayout.rowHeights = new int[]{rH, rH, rH, rH, rH, rH};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gambitPanel.setLayout(gridBagLayout);
        gambitPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("GAMBIT Explorer Control and Display")));
        this.btnShowConsole = new JButton("Console Messages");
        this.btnShowConsole.setToolTipText("<html>Shows console with program output</html>");
        this.btnShowConsole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GAMBITExplorerControlPanel.this.gambitFrame.setConsoleFrameVisible(true);
            }
        });
        this.btnSettings = new JButton("Edit Settings");
        this.btnSettings.setToolTipText("<html>Visualization and data content settings</html>");
        this.btnSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        this.btnSettings.setEnabled(false);
        Box auxBox = Box.createHorizontalBox();
        auxBox.add(Box.createHorizontalStrut(15));
        auxBox.add(this.lblSoftwareTitle);
        auxBox.add(Box.createHorizontalStrut(15));
        auxBox.add(this.btnSettings);
        auxBox.add(Box.createHorizontalStrut(15));
        auxBox.add(this.btnShowConsole);
        auxBox.add(Box.createHorizontalStrut(15));
        auxBox.add(Box.createGlue());
        this.setLayout(new BoxLayout(this, 3));
        this.add(auxBox);
        this.add(gambitPanel);
        int y = 1;
        JLabel lblReferenceTime = new JLabel("IRTAM time of validity (TOV):");
        gambitPanel.add((Component)lblReferenceTime, this.getGenericGBC(0, y, 2, 1));
        this.datePanel = new DatePanel(this.core.getTimeOfValidity());
        this.datePanel.setToolTipText("<html>Specifies requested Time of Validity for all displayed data</html>");
        this.datePanel.setFont(DEFAULT_FONT_DATE);
        GridBagConstraints gbcRefTime = this.getGenericGBC(2, y, 2, 1);
        gbcRefTime.insets = new Insets(0, 4, 0, 4);
        gambitPanel.add((Component)this.datePanel, gbcRefTime);
        this.btnLargeStepBackward = new JButton();
        this.btnLargeStepBackward.setMargin(new Insets(2, 7, 2, 7));
        this.btnLargeStepBackward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GAMBITExplorerControlPanel.this.addToDatePanelTime(10, -1);
                GAMBITExplorerControlPanel.this.downloadAllData();
            }
        });
        this.btnLargeStepBackward.setText("<<");
        this.btnLargeStepBackward.setToolTipText("<html>Goes back one hour, downloads new data, and refreshes current display.</html>");
        this.btnStepBackward = new JButton();
        this.btnStepBackward.setMargin(new Insets(2, 7, 2, 7));
        this.btnStepBackward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GAMBITExplorerControlPanel.this.addToDatePanelTime(12, -15);
                GAMBITExplorerControlPanel.this.downloadAllData();
            }
        });
        this.btnStepBackward.setText("<");
        this.btnStepBackward.setToolTipText("<html>Goes back one time step, downloads new data, and refreshes current display.</html>");
        this.btnStepForward = new JButton();
        this.btnStepForward.setMargin(new Insets(2, 7, 2, 7));
        this.btnStepForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GAMBITExplorerControlPanel.this.addToDatePanelTime(12, 15);
                GAMBITExplorerControlPanel.this.downloadAllData();
            }
        });
        this.btnStepForward.setText(">");
        this.btnStepForward.setToolTipText(this.btnStepBackward.getToolTipText().replace("back", "forward"));
        this.btnLargeStepForward = new JButton();
        this.btnLargeStepForward.setMargin(new Insets(2, 7, 2, 7));
        this.btnLargeStepForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GAMBITExplorerControlPanel.this.addToDatePanelTime(10, 1);
                GAMBITExplorerControlPanel.this.downloadAllData();
            }
        });
        this.btnLargeStepForward.setText(">>");
        this.btnLargeStepForward.setToolTipText(this.btnLargeStepBackward.getToolTipText().replace("back", "forward"));
        Box navigationBox = Box.createHorizontalBox();
        navigationBox.add(this.btnLargeStepBackward);
        navigationBox.add(this.btnStepBackward);
        navigationBox.add(this.btnStepForward);
        navigationBox.add(this.btnLargeStepForward);
        gambitPanel.add((Component)navigationBox, this.getGenericGBC(4, y, 2, 1));
        ++y;
        this.cbIrtamVersions = new JComboBox();
        this.core.getGambitDatabaseReader();
        TreeMap<Integer, AlgorithmVersions> av = GambitDatabaseReader.GAMBIT_DB_VERSIONS;
        for (Integer i : av.keySet()) {
            this.cbIrtamVersions.addItem(av.get(i));
        }
        if (this.cbIrtamVersions.getToolTipText() == null) {
            this.cbIrtamVersions.setToolTipText(av.get((Object)Integer.valueOf((int)0)).description);
        }
        this.cbIrtamVersions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GAMBITExplorerControlPanel.this.cbIrtamVersions.setToolTipText(((AlgorithmVersions)((GAMBITExplorerControlPanel)GAMBITExplorerControlPanel.this).cbIrtamVersions.getSelectedItem()).description);
                GAMBITExplorerControlPanel.this.core.reconstruct((AlgorithmVersions)GAMBITExplorerControlPanel.this.cbIrtamVersions.getSelectedItem());
            }
        });
        this.cbIrtamVersions.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(this.cbIrtamVersions, this.getGenericGBC(0, y, 1, 1));
        this.btnGetData = new JButton(this.nameGetData);
        this.btnGetData.setToolTipText("<html>Acquire data and plots them for time specified above, <br>no calculation of IRTAM maps are done, IRI maps are <br>recalculated for current time. To recalculate IRTAM maps <br>click Assimilate button. The map choice can be done by <br>combobox below  </html>");
        this.btnGetData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new AbstractTask(GAMBITExplorerControlPanel.this, GAMBITExplorerControlPanel.this.chckbsRecalculate.isSelected() ? "Assimilation working using DIDBase data" : "Acquiring data from GAMBIT databases"){

                    @Override
                    public void task() {
                        GAMBITExplorerControlPanel.this.downloadAllData();
                    }

                    @Override
                    protected void afterDone() {
                        if (GAMBITExplorerControlPanel.this.firstClick) {
                            cbSitesType.setSelectedItem((Object)SitesTypeChoice.OBSERVATIONS);
                            cbSurfacesType.setSelectedItem((Object)MapTypeChoice.WEATHER);
                            GAMBITExplorerControlPanel.this.firstClick = false;
                        }
                    }
                }.execute();
                GAMBITExplorerControlPanel.this.btnSiteCharts_save.setEnabled(false);
            }
        });
        GridBagConstraints gbcGetData = this.getGenericGBC(4, y, 2, 1);
        gambitPanel.add((Component)this.btnGetData, gbcGetData);
        this.chckbxGetGlobalCoeffs = new JCheckBox(this.nameGetGlobalCoeffs);
        this.chckbxGetGlobalCoeffs.setSelected(this.gambitAppSettings.getGambitCoreSettings().isDownloadGlobalWeather());
        this.chckbxGetGlobalCoeffs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitCoreSettings().setDownloadGlobalWeather(GAMBITExplorerControlPanel.this.chckbxGetGlobalCoeffs.isSelected());
                GAMBITExplorerControlPanel.this.gambitAppSettings.getOptionsIO().save();
            }
        });
        gambitPanel.add((Component)this.chckbxGetGlobalCoeffs, this.getGenericGBC(2, y, 1, 1));
        this.chckbxGetLocalCoeffs = new JCheckBox(this.nameGetLocalCoeffs);
        this.chckbxGetLocalCoeffs.setSelected(this.gambitAppSettings.getGambitCoreSettings().isDownloadLocalWeather());
        this.chckbxGetLocalCoeffs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitCoreSettings().setDownloadLocalWeather(GAMBITExplorerControlPanel.this.chckbxGetLocalCoeffs.isSelected());
                GAMBITExplorerControlPanel.this.gambitAppSettings.getOptionsIO().save();
            }
        });
        gambitPanel.add((Component)this.chckbxGetLocalCoeffs, this.getGenericGBC(3, y, 1, 1));
        this.chckbxGetObs = new JCheckBox(this.nameGetObs);
        this.chckbxGetObs.setSelected(this.gambitAppSettings.getGambitCoreSettings().isDownloadObservations());
        this.chckbxGetObs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitCoreSettings().setDownloadObservations(GAMBITExplorerControlPanel.this.chckbxGetObs.isSelected());
                GAMBITExplorerControlPanel.this.gambitAppSettings.getOptionsIO().save();
                GAMBITExplorerControlPanel.this.refreshEnablings();
            }
        });
        gambitPanel.add((Component)this.chckbxGetObs, this.getGenericGBC(1, y, 1, 1));
        JLabel lblReanalysis = new JLabel("Re-analysis:");
        lblReanalysis.setVisible(this.masterAccess);
        gambitPanel.add((Component)lblReanalysis, this.getGenericGBC(1, ++y, 1, 1));
        this.chckbsRecalculate = new JCheckBox("Rerun IRTAM");
        this.chckbsRecalculate.setSelected(this.gambitAppSettings.getGambitCoreSettings().isRerunAssimilation());
        this.chckbsRecalculate.setToolTipText("<html>Force the IRTAM to recalculate all coefficients, using<br>observations from DIDBase rather than simply retrieved <br>it from GAMBIT database</html>");
        this.chckbsRecalculate.setSelected(false);
        this.chckbsRecalculate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitCoreSettings().setRerunAssimilation(GAMBITExplorerControlPanel.this.chckbsRecalculate.isSelected());
                GAMBITExplorerControlPanel.this.cbIrtamVersions.setVisible(!GAMBITExplorerControlPanel.this.chckbsRecalculate.isSelected());
                GAMBITExplorerControlPanel.this.gambitAppSettings.getOptionsIO().save();
                GAMBITExplorerControlPanel.this.refreshEnablings();
            }
        });
        if (!this.masterAccess) {
            this.chckbsRecalculate.setEnabled(false);
            this.chckbsRecalculate.setVisible(false);
        }
        gambitPanel.add((Component)this.chckbsRecalculate, this.getGenericGBC(2, y, 1, 1));
        this.chckbsResubmit = new JCheckBox("Resubmit");
        this.chckbsResubmit.setToolTipText("<html>Submits results of IRTAM assimilation to GAMBIT database</html>");
        this.chckbsResubmit.setSelected(this.gambitAppSettings.getGambitCoreSettings().isSubmitAssimilation());
        this.chckbsResubmit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitCoreSettings().setSubmitAssimilation(GAMBITExplorerControlPanel.this.chckbsResubmit.isSelected());
            }
        });
        if (!this.masterAccess) {
            this.chckbsResubmit.setEnabled(false);
            this.chckbsResubmit.setVisible(false);
        }
        gambitPanel.add((Component)this.chckbsResubmit, this.getGenericGBC(3, y, 2, 1));
        JLabel lblDisplayControls = new JLabel("DISPLAY CONTROLS");
        gambitPanel.add((Component)lblDisplayControls, this.getGenericGBC(0, ++y, 6, 1));
        this.chckbxSurface = new JCheckBox("Surface");
        this.chckbxSurface.setSelected(true);
        this.chckbxSurface.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
            }
        });
        gambitPanel.add((Component)this.chckbxSurface, this.getGenericGBC(0, ++y, 1, 1));
        cbSurfacesChar = new JComboBox();
        Enum[] enumArray = CharChoice.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CharChoice cc = enumArray[n2];
            if (!cc.equals((Object)CharChoice.CUSTOM) || this.masterAccess) {
                cbSurfacesChar.addItem(cc);
                if (cbSurfacesChar.getToolTipText() == null) {
                    cbSurfacesChar.setToolTipText(cc.getDescription_tooltip());
                }
            }
            ++n2;
        }
        cbSurfacesChar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapChoice mapChoice = GAMBITExplorerControlPanel.getMapChoice();
                GAMBITExplorerControlPanel.this.core.setCurrentMapChoice(mapChoice);
                cbSurfacesChar.setToolTipText(mapChoice.getDescription());
                CharChoice charChoice = (CharChoice)((Object)cbSurfacesChar.getSelectedItem());
                switch (charChoice) {
                    case FOF2: {
                        cbSitesChar.setSelectedItem((Object)CharChoice.FOF2);
                        break;
                    }
                    case NMF2: {
                        cbSitesChar.setSelectedItem((Object)CharChoice.NMF2);
                        break;
                    }
                    case HMF2: {
                        cbSitesChar.setSelectedItem((Object)CharChoice.HMF2);
                        break;
                    }
                    case MUF3000: {
                        cbSitesChar.setSelectedItem((Object)CharChoice.MUF3000);
                        break;
                    }
                    case B0: {
                        cbSitesChar.setSelectedItem((Object)CharChoice.B0);
                        break;
                    }
                    case B1: {
                        cbSitesChar.setSelectedItem((Object)CharChoice.B1);
                        break;
                    }
                    case CUSTOM: {
                        cbSitesChar.setSelectedItem((Object)CharChoice.CUSTOM);
                        GAMBITExplorerControlPanel.this.core.rebuildOneChar_ObservationsAndWeather(GAMBITExplorerControlPanel.this.core.getChar(charChoice), 0);
                        break;
                    }
                }
                cbSitesChar.setVisible(charChoice != CharChoice.CUSTOM);
                cbSitesType.setVisible(charChoice != CharChoice.CUSTOM);
                GAMBITExplorerControlPanel.this.datePanel.checkOK();
                TimeScale coreTime = GAMBITExplorerControlPanel.this.core.getTimeOfValidity();
                if (coreTime != null && !GAMBITExplorerControlPanel.this.datePanel.getDate().equals(coreTime)) {
                    JOptionPane.showMessageDialog(null, "Target time has been changed. Click " + GAMBITExplorerControlPanel.this.nameGetData + " to get new data.", "Update data", 1);
                }
                GAMBITExplorerControlPanel.this.chckbxSurface.setSelected(true);
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
            }
        });
        cbSurfacesChar.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(cbSurfacesChar, this.getGenericGBC(1, y, 1, 1));
        cbSurfacesType = new JComboBox();
        enumArray = MapTypeChoice.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum stc = enumArray[n2];
            if (this.masterAccess || !((MapTypeChoice)stc).isAccess()) {
                cbSurfacesType.addItem((MapTypeChoice)stc);
                if (cbSurfacesType.getToolTipText() == null) {
                    cbSurfacesType.setToolTipText(((MapTypeChoice)stc).getDescription_tooltip());
                }
            }
            ++n2;
        }
        cbSurfacesType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                final MapChoice mapChoice = GAMBITExplorerControlPanel.getMapChoice();
                GAMBITExplorerControlPanel.this.core.setCurrentMapChoice(mapChoice);
                boolean new30DayComputation = mapChoice.getType() == MapTypeChoice.MEDIAN_30DAY && ((GAMBITExplorerControlPanel)GAMBITExplorerControlPanel.this).core.mapsTimeline.get(GAMBITExplorerControlPanel.this.core.getTimeOfValidity(), (Object)mapChoice) == null;
                new AbstractTask(GAMBITExplorerControlPanel.this, new30DayComputation ? "Computing 30-day medians" : "Switching surface type"){

                    @Override
                    public void task() {
                        cbSurfacesType.setToolTipText(GAMBITExplorerControlPanel.getMapChoice().getDescription());
                        switch ((MapTypeChoice)((Object)cbSurfacesType.getSelectedItem())) {
                            case CLIMATE: 
                            case WEATHER: 
                            case MEDIAN_30DAY: {
                                cbSitesType.setSelectedItem((Object)SitesTypeChoice.OBSERVATIONS);
                                break;
                            }
                            case DELTA: 
                            case DELTA_PERCENT: {
                                cbSitesType.setSelectedItem((Object)SitesTypeChoice.DEVIATIONS_CLIMATE);
                                break;
                            }
                        }
                        GAMBITExplorerControlPanel.this.txtSurfaceParameter.setEnabled(mapChoice.configurable());
                        GAMBITExplorerControlPanel.this.txtSurfaceParameter.setText("" + mapChoice.parameter());
                        GAMBITExplorerControlPanel.this.refreshDataDisplay();
                    }

                    @Override
                    protected void afterDone() {
                    }
                }.execute();
            }
        });
        cbSurfacesType.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(cbSurfacesType, this.getGenericGBC(2, y, 2, 1));
        this.txtSurfaceParameter = new JTextField();
        this.txtSurfaceParameter.setEnabled(GAMBITExplorerControlPanel.getMapChoice().configurable());
        this.txtSurfaceParameter.setText("" + GAMBITExplorerControlPanel.getMapChoice().parameter());
        this.txtSurfaceParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int oldValue = GAMBITExplorerControlPanel.getMapChoice().parameter();
                try {
                    int value = Integer.valueOf(GAMBITExplorerControlPanel.this.txtSurfaceParameter.getText());
                    if (oldValue != value) {
                        GAMBITExplorerControlPanel.getMapChoice().setParameter(value);
                        GAMBITExplorerControlPanel.this.refreshDataDisplay();
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "Parameter for " + GAMBITExplorerControlPanel.getMapChoice().name() + " must be integer.", "", 1);
                    GAMBITExplorerControlPanel.this.txtSurfaceParameter.setText(String.valueOf(oldValue));
                }
            }
        });
        this.txtSurfaceParameter.setText("0");
        gambitPanel.add((Component)this.txtSurfaceParameter, this.getGenericGBC(4, y, 1, 1));
        this.txtSurfaceParameter.setColumns(2);
        this.btnCenterGroup.add(this.rbtnCenterLT12demag);
        this.btnCenterGroup.add(this.rbtnCenterLT12);
        this.btnCenterGroup.add(this.rbtnCenterUT00);
        RadioCenterActionListener radioListener = new RadioCenterActionListener();
        this.rbtnCenterUT00.addActionListener(radioListener);
        this.rbtnCenterLT12.addActionListener(radioListener);
        this.rbtnCenterLT12demag.addActionListener(radioListener);
        this.pnlCenteringOptions.setLayout(new GridLayout(3, 1));
        this.pnlCenteringOptions.add(this.rbtnCenterUT00);
        this.pnlCenteringOptions.add(this.rbtnCenterLT12);
        this.pnlCenteringOptions.add(this.rbtnCenterLT12demag);
        TitledBorder borCenteringOptions = BorderFactory.createTitledBorder("Centering");
        borCenteringOptions.setTitlePosition(2);
        this.pnlCenteringOptions.setBorder(borCenteringOptions);
        gambitPanel.add((Component)this.pnlCenteringOptions, this.getGenericGBC(5, y, 1, 3));
        this.chckbxSites = new JCheckBox("Circles");
        this.chckbxSites.setSelected(true);
        this.chckbxSites.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
            }
        });
        gambitPanel.add((Component)this.chckbxSites, this.getGenericGBC(0, ++y, 1, 1));
        cbSitesChar = new JComboBox();
        Enum[] enumArray2 = CharChoice.values();
        int n3 = enumArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            CharChoice cc = enumArray2[n4];
            cbSitesChar.addItem(cc);
            if (cbSitesChar.getToolTipText() == null) {
                cbSitesChar.setToolTipText(cc.getDescription_tooltip());
            }
            ++n4;
        }
        cbSitesChar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SitesChoice sitesChoice = GAMBITExplorerControlPanel.getSitesChoice();
                GAMBITExplorerControlPanel.this.core.setCurrentSitesChoice(sitesChoice);
                cbSitesChar.setToolTipText(((SitesTypeChoice)((Object)cbSitesType.getSelectedItem())).getDescription_tool());
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
                if (GAMBITExplorerControlPanel.this.chckbxCharts.isSelected()) {
                    GAMBITExplorerControlPanel.this.gambitFrame.showIcons(null);
                }
            }
        });
        cbSitesChar.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(cbSitesChar, this.getGenericGBC(1, y, 1, 1));
        cbSitesType = new JComboBox();
        enumArray2 = SitesTypeChoice.values();
        n3 = enumArray2.length;
        n4 = 0;
        while (n4 < n3) {
            Enum stc = enumArray2[n4];
            cbSitesType.addItem((SitesTypeChoice)stc);
            if (cbSitesType.getToolTipText() == null) {
                cbSitesType.setToolTipText(((SitesTypeChoice)stc).getDescription_tool());
            }
            ++n4;
        }
        cbSitesType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SitesChoice sitesChoice = GAMBITExplorerControlPanel.getSitesChoice();
                GAMBITExplorerControlPanel.this.core.setCurrentSitesChoice(sitesChoice);
                cbSitesType.setToolTipText(((SitesTypeChoice)((Object)cbSitesType.getSelectedItem())).getDescription_tool());
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
            }
        });
        cbSitesType.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(cbSitesType, this.getGenericGBC(2, y, 2, 1));
        this.chckbxCharts = new JCheckBox("Charts");
        this.chckbxCharts.setToolTipText("Provides data charts (IRI, IRTAM, delta) for stations. <br>For access to the chart, double-click corresponding icon on the map.");
        this.chckbxCharts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new AbstractTask(GAMBITExplorerControlPanel.this, "Generating sites charts"){

                    @Override
                    public void task() {
                        GAMBITExplorerControlPanel.this.datePanel.checkOK();
                        GAMBITExplorerControlPanel.this.chckbxGetGlobalCoeffs.setSelected(true);
                        GAMBITExplorerControlPanel.this.chckbxGetLocalCoeffs.setSelected(true);
                        GAMBITExplorerControlPanel.this.chckbxGetObs.setSelected(true);
                        GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitCoreSettings().setDownloadObservations(true);
                        GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitCoreSettings().setDownloadGlobalWeather(true);
                        GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitCoreSettings().setDownloadLocalWeather(true);
                        boolean showCharts = GAMBITExplorerControlPanel.this.chckbxCharts.isSelected();
                        GAMBITExplorerControlPanel.this.btnSiteCharts_save.setEnabled(showCharts);
                        if (showCharts) {
                            GAMBITExplorerControlPanel.this.gambitFrame.showIcons(null);
                        } else {
                            GAMBITExplorerControlPanel.this.gambitFrame.removeReportIconLayer();
                        }
                    }

                    @Override
                    protected void afterDone() {
                    }
                }.execute();
            }
        });
        gambitPanel.add((Component)this.chckbxCharts, this.getGenericGBC(0, ++y, 1, 1));
        this.btnSiteCharts_save = new JButton("Export all chart data");
        this.btnSiteCharts_save.setToolTipText("Saves  data (IRI, IRTAM, delta) for all sites on hard drive<br>see /'" + GambitConstants.REPORT_IMAGE_FOLDER + "yyyyMMdd_HHmm/' for output data");
        this.btnSiteCharts_save.setEnabled(false);
        this.btnSiteCharts_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new AbstractReportTask(GAMBITExplorerControlPanel.this, "Generating sites charts", (ReportChoice)((Object)GAMBITExplorerControlPanel.this.cbReports.getSelectedItem())){

                    @Override
                    public void task() {
                        GAMBITExplorerControlPanel.this.datePanel.checkOK();
                        Reports.exportAllCharts(GAMBITExplorerControlPanel.this.core, (ReportChoice)((Object)GAMBITExplorerControlPanel.this.cbReports.getSelectedItem()), GAMBITExplorerControlPanel.this.core.getTimeOfValidity(), GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitChartSettings());
                    }

                    @Override
                    protected void afterDone() {
                    }
                }.execute();
            }
        });
        gambitPanel.add((Component)this.btnSiteCharts_save, this.getGenericGBC(1, y, 2, 1));
        this.chckbxSurface_ext = new JCheckBox("Ext. maps");
        this.chckbxSurface_ext.setToolTipText("<html>Maps that are not part of the IRTAM, but they are useful to<br>compare with.</html>");
        this.chckbxSurface_ext.setSelected(false);
        this.chckbxSurface_ext.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
            }
        });
        gambitPanel.add((Component)this.chckbxSurface_ext, this.getGenericGBC(0, ++y, 1, 1));
        cbSurfaces_ext = new JComboBox();
        enumArray2 = MapChoice.values();
        n3 = enumArray2.length;
        n4 = 0;
        while (n4 < n3) {
            Enum sc = enumArray2[n4];
            if (((MapChoice)sc).isExternalMap()) {
                cbSurfaces_ext.addItem((MapChoice)sc);
                if (cbSurfaces_ext.getToolTipText() == null) {
                    cbSurfaces_ext.setToolTipText(((MapChoice)sc).getToolTip());
                }
            }
            ++n4;
        }
        cbSurfaces_ext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                cbSurfaces_ext.setToolTipText(GAMBITExplorerControlPanel.getExternalMapChoice().getToolTip());
                GAMBITExplorerControlPanel.this.core.setCurrentExternalMapChoice(GAMBITExplorerControlPanel.getExternalMapChoice());
                if (GAMBITExplorerControlPanel.getExternalMapChoice().isDeltaMap() && GAMBITExplorerControlPanel.this.baselineTime == null) {
                    GAMBITExplorerControlPanel.this.baselineTime = (TimeScale)GAMBITExplorerControlPanel.this.core.getTimeOfValidity().clone();
                    GAMBITExplorerControlPanel.this.baselineTime.addMillis(-86400000L);
                    GAMBITExplorerControlPanel.this.core.setBaselineTime(GAMBITExplorerControlPanel.this.baselineTime);
                    GAMBITExplorerControlPanel.this.datePanelBaseline_ext.setDate(GAMBITExplorerControlPanel.this.baselineTime);
                }
                GAMBITExplorerControlPanel.this.chckbxSurface_ext.setSelected(true);
                if (GAMBITExplorerControlPanel.getExternalMapChoice().isDeltaMap()) {
                    if (!GAMBITExplorerControlPanel.this.datePanelBaseline_ext.isEnabled()) {
                        GAMBITExplorerControlPanel.this.datePanelBaseline_ext.setEnabled(true);
                        GAMBITExplorerControlPanel.this.lblDatePanel_ext.setEnabled(true);
                    }
                } else {
                    GAMBITExplorerControlPanel.this.datePanelBaseline_ext.setEnabled(false);
                    GAMBITExplorerControlPanel.this.lblDatePanel_ext.setEnabled(false);
                }
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
            }
        });
        cbSurfaces_ext.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(cbSurfaces_ext, this.getGenericGBC(1, y, 2, 1));
        this.btnCalc_ext = new JButton("Get ext data");
        this.btnCalc_ext.setToolTipText("Recalculates external surface.");
        this.btnCalc_ext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new AbstractTask(GAMBITExplorerControlPanel.this, "Acquiring data from Madrigal database"){

                    @Override
                    public void task() {
                        GAMBITExplorerControlPanel.this.datePanel.checkOK();
                        if (GAMBITExplorerControlPanel.getExternalMapChoice().isDeltaMap()) {
                            GAMBITExplorerControlPanel.this.datePanelBaseline_ext.checkOK();
                            GAMBITExplorerControlPanel.this.core.setBaselineTime(GAMBITExplorerControlPanel.this.datePanelBaseline_ext.getDate());
                            GAMBITExplorerControlPanel.this.core.rebuildExtVTECdeltaMap(GAMBITExplorerControlPanel.this.core.getTimeOfValidity(), GAMBITExplorerControlPanel.this.core.getBaselineTime());
                            GAMBITExplorerControlPanel.this.core.rebuildExtSlabThicknessDeltaMap(GAMBITExplorerControlPanel.this.core.getTimeOfValidity(), GAMBITExplorerControlPanel.this.core.getBaselineTime());
                        } else {
                            GAMBITExplorerControlPanel.this.core.rebuildExtVTECmap(GAMBITExplorerControlPanel.this.core.getTimeOfValidity());
                            GAMBITExplorerControlPanel.this.core.rebuildExtSlabThicknessMap(GAMBITExplorerControlPanel.this.core.getSlabThickness(), GAMBITExplorerControlPanel.this.core.getTimeOfValidity());
                        }
                        if (!GAMBITExplorerControlPanel.this.chckbxSurface_ext.isSelected()) {
                            GAMBITExplorerControlPanel.this.chckbxSurface_ext.setSelected(true);
                        } else {
                            GAMBITExplorerControlPanel.this.refreshDataDisplay();
                        }
                    }

                    @Override
                    protected void afterDone() {
                    }
                }.execute();
            }
        });
        gambitPanel.add((Component)this.btnCalc_ext, this.getGenericGBC(3, y, 2, 1));
        this.chckbxHiResTec_ext = new JCheckBox("Hi-res");
        this.chckbxHiResTec_ext.setToolTipText("<html>Use high resolution spatial grid without extrapolation.</html>");
        this.chckbxHiResTec_ext.setSelected(false);
        this.chckbxHiResTec_ext.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GAMBITExplorerControlPanel.this.core.setHighResTecMap(GAMBITExplorerControlPanel.this.chckbxHiResTec_ext.isSelected());
                if (GAMBITExplorerControlPanel.this.core.getTEC() != null && GAMBITExplorerControlPanel.this.core.getTEC().isNetworkDataReady()) {
                    GAMBITExplorerControlPanel.this.core.rebuildExtVTECmap(GAMBITExplorerControlPanel.this.core.getTimeOfValidity());
                    GAMBITExplorerControlPanel.this.core.rebuildExtSlabThicknessMap(GAMBITExplorerControlPanel.this.core.getSlabThickness(), GAMBITExplorerControlPanel.this.core.getTimeOfValidity());
                }
                if (GAMBITExplorerControlPanel.this.core.getBackgroundTEC() != null && GAMBITExplorerControlPanel.this.core.getBackgroundTEC().isNetworkDataReady()) {
                    GAMBITExplorerControlPanel.this.core.rebuildExtVTECdeltaMap(GAMBITExplorerControlPanel.this.core.getTimeOfValidity(), GAMBITExplorerControlPanel.this.core.getBaselineTime());
                    GAMBITExplorerControlPanel.this.core.rebuildExtSlabThicknessDeltaMap(GAMBITExplorerControlPanel.this.core.getTimeOfValidity(), GAMBITExplorerControlPanel.this.core.getBaselineTime());
                }
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
            }
        });
        gambitPanel.add((Component)this.chckbxHiResTec_ext, this.getGenericGBC(5, y, 1, 1));
        this.lblDatePanel_ext = new JLabel("Quiet-Time Reference");
        this.lblDatePanel_ext.setEnabled(false);
        this.lblDatePanel_ext.setToolTipText("<html>Baseline time is used for " + (Object)((Object)MapChoice.EVTEC_GPS_DELTA) + " maps. <br> " + (Object)((Object)MapChoice.EVTEC_GPS_DELTA) + " is built as difference between <br>" + "TEC map at reference time (see above) and TEC <br>" + "map at baseline time.</html>");
        gambitPanel.add((Component)this.lblDatePanel_ext, this.getGenericGBC(0, ++y, 2, 1));
        this.datePanelBaseline_ext = new DatePanel(this.core.getTimeOfValidity());
        this.datePanelBaseline_ext.setFont(DEFAULT_FONT_DATE);
        this.datePanelBaseline_ext.setEnabled(false);
        gambitPanel.add((Component)this.datePanelBaseline_ext, this.getGenericGBC(2, y, 2, 1));
        this.lblColor = new JLabel("Color Scale");
        gambitPanel.add((Component)this.lblColor, this.getGenericGBC(0, ++y, 1, 1));
        this.cbMinMax = new JComboBox();
        if (this.cbMinMax.getToolTipText() == null) {
            this.cbMinMax.setToolTipText("<html>Computation of min-max bounds for the color scale</html>");
        }
        enumArray2 = MinMaxForDisplay.MinMaxAlgorithm.values();
        n3 = enumArray2.length;
        n4 = 0;
        while (n4 < n3) {
            Enum mma = enumArray2[n4];
            this.cbMinMax.addItem((MinMaxForDisplay.MinMaxAlgorithm)mma);
            ++n4;
        }
        this.cbMinMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MinMaxForDisplay.MinMaxAlgorithm algorithm = (MinMaxForDisplay.MinMaxAlgorithm)((Object)GAMBITExplorerControlPanel.this.cbMinMax.getSelectedItem());
                MinMaxForDisplay.putAlgorithm(algorithm);
                GAMBITExplorerControlPanel.this.cbMinMax.setToolTipText("<html>" + algorithm.getDescription() + "</html>");
                GAMBITExplorerControlPanel.this.refreshDataDisplay();
            }
        });
        this.cbMinMax.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(this.cbMinMax, this.getGenericGBC(1, y, 1, 1));
        this.sliderColor = new JSlider();
        this.sliderColor.setToolTipText("<html>Changes the color legend for surface(map) and sites display. <br>It act as a factor to an automatically calculated limits. <br>The values of factor is displayed in the text box on the <br>right. The color scale factor can be changed directly in the <br>text box. For example, the color scale equals: <br>0.3 means that the limits will be 1.3 of automatic ones; <br>-0.3 means that the limits will be 0.7 of automatic ones.</html>");
        this.sliderColor.setValue(0);
        this.sliderColor.setMaximum(300);
        this.sliderColor.setMinimum(-100);
        this.sliderColor.setValueIsAdjusting(true);
        this.sliderColor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                JSlider source;
                GAMBITExplorerControlPanel.this.datePanel.checkOK();
                if (GAMBITExplorerControlPanel.this.txtSliderParameter != null) {
                    GAMBITExplorerControlPanel.this.txtSliderParameter.setText("" + (double)GAMBITExplorerControlPanel.this.sliderColor.getValue() / 100.0);
                }
                if (!(source = (JSlider)arg0.getSource()).getValueIsAdjusting()) {
                    GambitConstants.COLOR_SATURATION_FACTOR = (double)(GAMBITExplorerControlPanel.this.sliderColor.getValue() + 100) / 100.0;
                    GAMBITExplorerControlPanel.this.refreshDataDisplay();
                }
            }
        });
        gambitPanel.add((Component)this.sliderColor, this.getGenericGBC(2, y, 2, 1));
        this.txtSliderParameter = new JTextField();
        this.txtSliderParameter.setToolTipText("<html>Set color scale manually</html>");
        this.txtSliderParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                double oldValue = GAMBITExplorerControlPanel.this.sliderColor.getValue();
                try {
                    double value = Double.valueOf(GAMBITExplorerControlPanel.this.txtSliderParameter.getText()) * 100.0;
                    if (oldValue != value) {
                        GAMBITExplorerControlPanel.this.sliderColor.setValue((int)value);
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "Parameter for color slider must be real number between -1.0 and 3.0", "", 1);
                    GAMBITExplorerControlPanel.this.txtSliderParameter.setText("" + oldValue / 100.0);
                }
            }
        });
        this.txtSliderParameter.setText("0");
        gambitPanel.add((Component)this.txtSliderParameter, this.getGenericGBC(4, y, 1, 1));
        this.txtSliderParameter.setColumns(3);
        JLabel lblSelection = new JLabel("Report:");
        gambitPanel.add((Component)lblSelection, this.getGenericGBC(0, ++y, 1, 1));
        this.cbReports = new JComboBox();
        Object[] objectArray = ReportChoice.values();
        int n5 = objectArray.length;
        n3 = 0;
        while (n3 < n5) {
            ReportChoice rc = objectArray[n3];
            if (this.masterAccess || !rc.master_access) {
                if (this.cbReports.getToolTipText() == null) {
                    this.cbReports.setToolTipText(rc.description_tooltip);
                }
                this.cbReports.addItem(rc);
            }
            ++n3;
        }
        this.cbReports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GAMBITExplorerControlPanel.this.cbReports.setToolTipText(((ReportChoice)((Object)((GAMBITExplorerControlPanel)GAMBITExplorerControlPanel.this).cbReports.getSelectedItem())).description_tooltip);
                if (((ReportChoice)((Object)((GAMBITExplorerControlPanel)GAMBITExplorerControlPanel.this).cbReports.getSelectedItem())).configurable) {
                    GAMBITExplorerControlPanel.this.txtReportParameter.setEnabled(true);
                    GAMBITExplorerControlPanel.this.txtReportParameter.setText("" + ((ReportChoice)((Object)GAMBITExplorerControlPanel.this.cbReports.getSelectedItem())).getParameter());
                    GAMBITExplorerControlPanel.this.lblReportsTxt.setEnabled(true);
                    if (GAMBITExplorerControlPanel.this.cbReports.getSelectedItem() == ReportChoice.SAME_LT_ALL_LONG) {
                        GAMBITExplorerControlPanel.this.lblReportsTxt.setText("(LT)");
                    }
                    if (GAMBITExplorerControlPanel.this.cbReports.getSelectedItem() == ReportChoice.MERIDIONAL_SLICE) {
                        GAMBITExplorerControlPanel.this.lblReportsTxt.setText("(LON)");
                    }
                } else {
                    GAMBITExplorerControlPanel.this.txtReportParameter.setEnabled(false);
                    GAMBITExplorerControlPanel.this.txtReportParameter.setText("0");
                    GAMBITExplorerControlPanel.this.lblReportsTxt.setEnabled(false);
                    GAMBITExplorerControlPanel.this.lblReportsTxt.setText("Parameter");
                }
            }
        });
        this.cbReports.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(this.cbReports, this.getGenericGBC(1, y, 2, 1));
        this.btnReport = new JButton("Generate");
        this.btnReport.setToolTipText("<html>Choose report type in the corresponding combo box. <brReports are usually associated with the surface(map)<br>choice given by combobox above. To access information<br>information about the specific report choose it so it <br>appears as current choice in report combobox, then put<br>pointer on combobox and information will pop up.</html>");
        this.btnReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GAMBITExplorerControlPanel.this.datePanel.checkOK();
                final ReportChoice rc = (ReportChoice)((Object)GAMBITExplorerControlPanel.this.cbReports.getSelectedItem());
                int value = ((ReportChoice)((Object)GAMBITExplorerControlPanel.this.cbReports.getSelectedItem())).getParameter();
                try {
                    value = Integer.valueOf(GAMBITExplorerControlPanel.this.txtReportParameter.getText());
                    rc.setParameter(value);
                    new AbstractReportTask(GAMBITExplorerControlPanel.this, "Generating report", rc){

                        @Override
                        protected void task() {
                            GAMBITExplorerControlPanel.this.gambitFrame.getReports().runReport(rc, null, (AlgorithmVersions)GAMBITExplorerControlPanel.this.cbIrtamVersions.getSelectedItem());
                            if (rc.getProgress() != 100) {
                                rc.setProgress(100);
                            }
                            GAMBITExplorerControlPanel.this.ttm.setEnabled(false);
                            GAMBITExplorerControlPanel.this.gambitFrame.setAlwaysOnTop(true);
                            GAMBITExplorerControlPanel.this.gambitFrame.getWwd().redraw();
                        }

                        @Override
                        protected void afterDone() {
                            if (rc == ReportChoice.SAME_LT_ALL_LONG) {
                                GAMBITExplorerControlPanel.this.gambitFrame.showWWdCapture(GAMBITExplorerControlPanel.this.core.getTimeOfValidity());
                            }
                            GAMBITExplorerControlPanel.this.ttm.setEnabled(true);
                            GAMBITExplorerControlPanel.this.gambitFrame.setAlwaysOnTop(false);
                        }
                    }.execute();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "Report parameter must be integer", "", 1);
                    GAMBITExplorerControlPanel.this.txtReportParameter.setText("0");
                }
            }
        });
        gambitPanel.add((Component)this.btnReport, this.getGenericGBC(3, y, 1, 1));
        this.txtReportParameter = new JTextField();
        this.txtReportParameter.setText("0");
        this.txtReportParameter.setColumns(2);
        gambitPanel.add((Component)this.txtReportParameter, this.getGenericGBC(4, y, 1, 1));
        this.lblReportsTxt.setEnabled(false);
        this.lblReportsTxt.setText("Parameter");
        gambitPanel.add((Component)this.lblReportsTxt, this.getGenericGBC(5, y, 1, 1));
        this.btnAnimations = new JButton("Animate");
        this.btnAnimations.setToolTipText("<html>Make animated GIF images of selected characteristic maps for the 24-hour period preceeding TOV</html>");
        this.btnAnimations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new AbstractTask(GAMBITExplorerControlPanel.this, "Data retrieval from remote databases in progress..."){

                    @Override
                    public void task() {
                        GAMBITExplorerControlPanel.this.datePanel.checkOK();
                        GambitLayers gambitLayers = GAMBITExplorerControlPanel.this.gambitFrame.getGambitLayers();
                        Position initialPos = gambitLayers.getWwd().getView().getEyePosition();
                        if (initialPos == null) {
                            initialPos = Position.fromDegrees((double)0.0, (double)0.0, (double)0.0);
                        }
                        int displayMode = 0;
                        if (GAMBITExplorerControlPanel.this.chckbxSurface.isSelected()) {
                            ++displayMode;
                        }
                        if (GAMBITExplorerControlPanel.this.chckbxSites.isSelected()) {
                            displayMode += 2;
                            if (GAMBITExplorerControlPanel.this.gambitAppSettings.getGambitDisplaySettings().isGrayCircles()) {
                                displayMode += 16;
                            }
                        }
                        if (GAMBITExplorerControlPanel.this.chckbxSurface_ext.isSelected()) {
                            displayMode += 4;
                        }
                        AnimationActionListener anime = new AnimationActionListener(GAMBITExplorerControlPanel.this.core, gambitLayers, initialPos, gambitLayers.getLegends(), displayMode += 8);
                        MapChoice mapChoice = GAMBITExplorerControlPanel.this.chckbxSurface_ext.isSelected() ? GAMBITExplorerControlPanel.this.core.getCurrentExternalMapChoice() : GAMBITExplorerControlPanel.this.core.getCurrentMapChoice();
                        anime.prepareAnimation(GAMBITExplorerControlPanel.this.chckbxMakeAniGIF.isSelected(), GAMBITExplorerControlPanel.this.core.getTimeOfValidity(), MOVIE_DURATIONS[GAMBITExplorerControlPanel.this.cbMovieDurations.getSelectedIndex()], null, String.valueOf(GambitConstants.getFileNamePrefix(mapChoice)) + "_" + GAMBITExplorerControlPanel.this.core.getTimeOfValidity().toFormatUT("yyyy-MM-dd"));
                        AnimationActionListener.startAnimationTimer(anime);
                    }

                    @Override
                    protected void afterDone() {
                    }
                }.execute();
            }
        });
        gambitPanel.add((Component)this.btnAnimations, this.getGenericGBC(0, ++y, 1, 1));
        this.cbMovieDurations = new JComboBox();
        objectArray = MOVIE_DURATIONS;
        n5 = MOVIE_DURATIONS.length;
        n3 = 0;
        while (n3 < n5) {
            ReportChoice d = objectArray[n3];
            this.cbMovieDurations.addItem(String.valueOf((int)d) + " hours");
            ++n3;
        }
        if (this.cbMovieDurations.getToolTipText() == null) {
            this.cbMovieDurations.setToolTipText("<html>Duration of the animation in hours</html>");
        }
        this.cbMovieDurations.setEnabled(true);
        this.cbMovieDurations.setFont(DEFAULT_FONT_BC);
        gambitPanel.add(this.cbMovieDurations, this.getGenericGBC(1, y, 1, 1));
        this.chckbxMakeAniGIF = new JCheckBox("Make Animated GIF");
        this.chckbxMakeAniGIF.setToolTipText("<html>Produce animated GIF file</html>");
        this.chckbxMakeAniGIF.setSelected(false);
        if (!this.masterAccess) {
            this.chckbsResubmit.setEnabled(false);
            this.chckbsResubmit.setVisible(false);
        }
        gambitPanel.add((Component)this.chckbxMakeAniGIF, this.getGenericGBC(2, y, 2, 1));
        this.refreshEnablings();
        return gambitPanel;
    }

    protected void refreshEnablings() {
        boolean sitesAvailable;
        boolean bl = sitesAvailable = this.chckbxGetObs.isSelected() || this.chckbsRecalculate.isSelected();
        if (this.chckbxSites != null) {
            this.chckbxSites.setEnabled(sitesAvailable);
        }
        if (cbSitesChar != null) {
            cbSitesChar.setEnabled(sitesAvailable);
        }
        if (cbSitesType != null) {
            cbSitesType.setEnabled(sitesAvailable);
        }
        if (this.chckbxCharts != null) {
            this.chckbxCharts.setEnabled(sitesAvailable);
        }
        if (this.btnSiteCharts_save != null) {
            this.btnSiteCharts_save.setEnabled(sitesAvailable);
        }
    }

    private CompoundBorder getBorder(String name) {
        return new CompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), new TitledBorder(name));
    }

    private GridBagLayout getBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{50, 30, 70, 60, 30};
        int rH = 10;
        gridBagLayout.rowHeights = new int[]{rH, rH};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        return gridBagLayout;
    }

    public static MapChoice getMapChoice() {
        return MapChoice.getSurfaceChoice((CharChoice)((Object)cbSurfacesChar.getSelectedItem()), (MapTypeChoice)((Object)cbSurfacesType.getSelectedItem()));
    }

    public static SitesChoice getSitesChoice() {
        return SitesChoice.getSiteChoice((CharChoice)((Object)cbSitesChar.getSelectedItem()), (SitesTypeChoice)((Object)cbSitesType.getSelectedItem()));
    }

    public static MapChoice getExternalMapChoice() {
        return (MapChoice)((Object)cbSurfaces_ext.getSelectedItem());
    }

    public void setDate(TimeScale time) {
        this.datePanel.setDate(time);
        this.datePanel.checkOK();
    }

    public void addToDatePanelTime(int field, int amount) {
        this.datePanel.checkOK();
        TimeScale time = this.datePanel.getDate();
        time.add(field, amount);
        this.gambitAppSettings.getQuerySettings().setStartTime(time);
        this.gambitAppSettings.getOptionsIO().save();
        this.setDate(time);
    }

    private void downloadAllData() {
        this.datePanel.checkOK();
        GambitCoreSettings settings = this.gambitAppSettings.getGambitCoreSettings();
        int databaseMode = 0;
        if (settings.isDownloadGlobalWeather()) {
            ++databaseMode;
        }
        if (settings.isDownloadObservations()) {
            databaseMode += 2;
        }
        if (settings.isDownloadLocalWeather()) {
            databaseMode += 32;
        }
        if (settings.isRerunAssimilation()) {
            databaseMode += 8;
        }
        if (settings.isSubmitAssimilation()) {
            databaseMode += 4;
        }
        this.core.setTimeOfValidity(this.datePanel.getDate(), databaseMode += 16, (AlgorithmVersions)this.cbIrtamVersions.getSelectedItem());
        TimeScale coreTime = this.core.getTimeOfValidity();
        this.gambitAppSettings.getQuerySettings().setStartTime(coreTime);
        this.gambitAppSettings.getOptionsIO().save();
        this.gambitFrame.updateChartsTime(this.core.getTimeOfValidity());
        if (this.gambitAppSettings.getGambitCoreSettings().isDownloadObservations() || this.gambitAppSettings.getGambitCoreSettings().isDownloadGlobalWeather()) {
            this.chckbxSurface_ext.setSelected(false);
            this.gambitLayers.recenter();
            this.refreshDataDisplay();
            this.firstClick = false;
        }
    }

    private void refreshDataDisplay() {
        int mode = 0;
        if (this.chckbxSurface.isSelected()) {
            ++mode;
        }
        if (this.chckbxSites.isSelected()) {
            mode += 2;
            if (this.gambitAppSettings.getGambitDisplaySettings().isGrayCircles()) {
                mode += 16;
            }
        }
        if (this.chckbxSurface_ext.isSelected()) {
            mode += 4;
        }
        this.gambitLayers.refreshMagneticEquatorLayer(this.core.getTimeOfValidity());
        this.gambitLayers.refreshSolarTerminatorLayer(this.core.getTimeOfValidity(), 1);
        this.gambitLayers.buildDataRenderables(this.core.getTimeOfValidity(), null, mode);
    }

    private GridBagConstraints getGenericGBC(int gridx, int gridy, int width, int height) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        return gbc;
    }

    private GridBagConstraints getLabelGBC(int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = gridy;
        return gbc;
    }

    private GridBagConstraints getComboBoxGBC(int gridy) {
        return this.getGenericGBC(1, gridy, 2, 1);
    }

    private GridBagConstraints getTxtGBC(int gridy) {
        return this.getGenericGBC(4, gridy, 1, 1);
    }

    private JDialog getProgressDialog(String name, JProgressBar pbar) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{350};
        gridBagLayout.rowHeights = new int[]{30, 30};
        JDialog dialog = new JDialog();
        dialog.setUndecorated(true);
        dialog.setLayout(gridBagLayout);
        dialog.getContentPane().setBackground(Color.GRAY);
        JLabel label = new JLabel(name);
        label.setForeground(Color.BLACK);
        label.setFont(new Font("Calibri", 1, 18));
        dialog.getContentPane().add((Component)label, this.getGenericGBC(0, 0, 1, 1));
        if (pbar == null) {
            pbar = new JProgressBar();
        }
        pbar.setValue(0);
        pbar.setIndeterminate(true);
        GridBagConstraints gbc = this.getGenericGBC(0, 1, 1, 1);
        gbc.fill = 1;
        dialog.getContentPane().add((Component)pbar, gbc);
        dialog.setCursor(Cursor.getPredefinedCursor(3));
        dialog.pack();
        dialog.setLocation(this.gambitFrame.getLocation().x + this.gambitFrame.getWidth() / 2 - dialog.getWidth() / 2, this.gambitFrame.getLocation().y + this.gambitFrame.getHeight() / 2 - dialog.getHeight() / 2);
        pbar.setEnabled(true);
        dialog.setVisible(true);
        dialog.setAlwaysOnTop(true);
        return dialog;
    }

    public static File getFileSelection(String defaultName) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(defaultName).getAbsoluteFile());
        JDialog jd = new JDialog();
        int selection = fc.showSaveDialog(jd);
        if (selection != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private abstract class AbstractReportTask
    extends AbstractTask {
        private final ReportChoice rc;

        public AbstractReportTask(String name, ReportChoice rc) {
            super(name);
            this.rc = rc;
        }

        @Override
        protected Void doInBackground() {
            this.monitorProgress(this.rc, this.pbar);
            super.doInBackground();
            return null;
        }

        private void monitorProgress(final ReportChoice rc, final JProgressBar pbar) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        while (rc.getProgress() < 100) {
                            Thread.sleep(1000L);
                            if (pbar.isIndeterminate() && rc.getProgress() > 0) {
                                pbar.setIndeterminate(false);
                                pbar.setStringPainted(true);
                            }
                            pbar.setValue(rc.getProgress());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    private abstract class AbstractTask
    extends SwingWorker<Void, Void> {
        protected final JDialog dialog;
        protected final JProgressBar pbar = new JProgressBar();

        protected AbstractTask(String name) {
            this.dialog = GAMBITExplorerControlPanel.this.getProgressDialog(name, this.pbar);
        }

        @Override
        protected Void doInBackground() {
            GAMBITExplorerControlPanel.this.gambitFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.task();
            return null;
        }

        protected abstract void task();

        @Override
        protected void done() {
            this.dialog.dispose();
            GAMBITExplorerControlPanel.this.gambitFrame.setCursor(Cursor.getPredefinedCursor(0));
            this.afterDone();
        }

        protected abstract void afterDone();
    }

    class RadioCenterActionListener
    implements ActionListener {
        RadioCenterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JRadioButton button = (JRadioButton)arg0.getSource();
            MapChoice mapChoice = GAMBITExplorerControlPanel.getMapChoice();
            CharChoice cc = mapChoice.getCC();
            Characteristic c = GAMBITExplorerControlPanel.this.core.getChar(cc);
            Geomap map = GAMBITExplorerControlPanel.this.core.getOneMap(GAMBITExplorerControlPanel.this.core.getTimeOfValidity(), mapChoice, GAMBITExplorerControlPanel.this.core.getGambitDatabaseReader().getBestAvailableVersions());
            if (map == null) {
                return;
            }
            if (button == GAMBITExplorerControlPanel.this.rbtnCenterUT00) {
                if (GambitLayers.getCenteringOption() == GambitLayers.CenteringOptions.LT12_DEMAG) {
                    GAMBITExplorerControlPanel.this.core.transformMap(map, 2);
                }
                GAMBITExplorerControlPanel.this.gambitLayers.setCenteringOption(GambitLayers.CenteringOptions.UT00);
            }
            if (button == GAMBITExplorerControlPanel.this.rbtnCenterLT12) {
                if (GambitLayers.getCenteringOption() == GambitLayers.CenteringOptions.LT12_DEMAG) {
                    GAMBITExplorerControlPanel.this.core.transformMap(map, 2);
                }
                GAMBITExplorerControlPanel.this.gambitLayers.setCenteringOption(GambitLayers.CenteringOptions.LT12);
            }
            if (button == GAMBITExplorerControlPanel.this.rbtnCenterLT12demag) {
                GAMBITExplorerControlPanel.this.gambitLayers.setCenteringOption(GambitLayers.CenteringOptions.LT12_DEMAG);
                GAMBITExplorerControlPanel.this.core.transformMap(map, 1);
            }
            GAMBITExplorerControlPanel.this.refreshDataDisplay();
            GAMBITExplorerControlPanel.this.gambitFrame.getWwd().redraw();
        }
    }
}

