/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GeoSectorFrame
extends JDialog {
    public static final int COL_WIDTH = 50;
    public static final int ROW_HEIGHT = 28;
    public static final int FRAME_WIDTH = 300;
    public static final int FRAME_HEIGHT = 110;
    private static final Double[] LAST_CHOICE = new Double[]{-90.0, 90.0, -180.0, 180.0};

    public GeoSectorFrame(final Double[] latlon, int xloc, int yloc) {
        latlon[0] = null;
        latlon[1] = null;
        latlon[2] = null;
        latlon[3] = null;
        JPanel panel = new JPanel();
        final GeoSectorFrame frame = this;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{50, 50, 50, 50, 50};
        gridBagLayout.rowHeights = new int[]{28, 28};
        panel.setLayout(gridBagLayout);
        JLabel lblLatMin = new JLabel("Lat. min");
        panel.add((Component)lblLatMin, this.getGBC(0, 0));
        JLabel lblLatMax = new JLabel("Lat. max");
        panel.add((Component)lblLatMax, this.getGBC(2, 0));
        JLabel lblLonMin = new JLabel("Lon. min");
        panel.add((Component)lblLonMin, this.getGBC(0, 1));
        JLabel lblLonMax = new JLabel("Lon. max");
        panel.add((Component)lblLonMax, this.getGBC(2, 1));
        final JTextField txtLatMin = new JTextField("" + LAST_CHOICE[0]);
        panel.add((Component)txtLatMin, this.getGBC(1, 0));
        final JTextField txtLatMax = new JTextField("" + LAST_CHOICE[1]);
        panel.add((Component)txtLatMax, this.getGBC(3, 0));
        final JTextField txtLonMin = new JTextField("" + LAST_CHOICE[2]);
        panel.add((Component)txtLonMin, this.getGBC(1, 1));
        final JTextField txtLonMax = new JTextField("" + LAST_CHOICE[3]);
        panel.add((Component)txtLonMax, this.getGBC(3, 1));
        JButton btnOk = new JButton("Ok");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                latlon[0] = Double.parseDouble(txtLatMin.getText());
                latlon[1] = Double.parseDouble(txtLatMax.getText());
                latlon[2] = Double.parseDouble(txtLonMin.getText());
                latlon[3] = Double.parseDouble(txtLonMax.getText());
                frame.dispose();
            }
        });
        panel.add((Component)btnOk, this.getGBC(4, 0));
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frame.dispose();
            }
        });
        panel.add((Component)btnCancel, this.getGBC(4, 1));
        this.add(panel);
        this.setTitle("Time interval");
        this.setSize(300, 110);
        this.setLocation(xloc, yloc);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setVisible(true);
    }

    private GridBagConstraints getGBC(int gridx, int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        return gbc;
    }

    public static double[] getSector() {
        Double[] sector = new Double[4];
        GeoSectorFrame frame = new GeoSectorFrame(sector, MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        frame.setDefaultCloseOperation(2);
        if (sector[0] != null && sector[1] != null && sector[2] != null && sector[3] != null) {
            double[] sec = new double[4];
            int i = 0;
            while (i < 4) {
                sec[i] = sector[i];
                GeoSectorFrame.LAST_CHOICE[i] = new Double(sector[i]);
                ++i;
            }
            return sec;
        }
        return null;
    }
}

