/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.gui;

import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.lgdc.fileio.FileUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UserInfoFrame
extends JDialog {
    private JPanel panel = new JPanel();
    private JLabel lblMadrigal;
    private JLabel lblMadrigalMail;
    private JLabel lblMadrigalAffiliation;
    private JTextField txtMadrigalMail;
    private JTextField txtMadrigalAffiliation;
    private JLabel lblGambit;
    private JLabel lblGambitUser;
    private JLabel lblGambitPassword;
    private JTextField txtGambitLogin;
    private JTextField txtGambitPassword;
    private JButton btnOk;
    private JButton btnQuit;

    public UserInfoFrame(final HashMap<String, String> info) {
        final UserInfoFrame frame = this;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{68, 80};
        gridBagLayout.rowHeights = new int[]{28, 28};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0};
        this.panel.setLayout(gridBagLayout);
        int y = 0;
        this.lblMadrigal = new JLabel();
        this.lblMadrigal.setText("Madrigal database user information:");
        this.panel.add((Component)this.lblMadrigal, this.getLabelGBC(y));
        this.lblMadrigalMail = new JLabel();
        this.lblMadrigalMail.setText("User email:");
        this.panel.add((Component)this.lblMadrigalMail, this.getLabelGBC(++y));
        this.txtMadrigalMail = new JTextField();
        this.txtMadrigalMail.setText(info.get("GuestEmail"));
        this.panel.add((Component)this.txtMadrigalMail, this.getTxtGBC(y));
        this.lblMadrigalAffiliation = new JLabel();
        this.lblMadrigalAffiliation.setText("User affiliation:");
        this.panel.add((Component)this.lblMadrigalAffiliation, this.getLabelGBC(++y));
        this.txtMadrigalAffiliation = new JTextField();
        this.txtMadrigalAffiliation.setText(info.get("GuestAffiliation"));
        this.panel.add((Component)this.txtMadrigalAffiliation, this.getTxtGBC(y));
        this.lblGambit = new JLabel();
        this.lblGambit.setText("GAMBIT database user information:");
        this.panel.add((Component)this.lblGambit, this.getLabelGBC(++y));
        this.lblGambitUser = new JLabel();
        this.lblGambitUser.setText("User login:");
        this.panel.add((Component)this.lblGambitUser, this.getLabelGBC(++y));
        this.txtGambitLogin = new JTextField();
        this.txtGambitLogin.setText(info.get("UserLogin"));
        this.panel.add((Component)this.txtGambitLogin, this.getTxtGBC(y));
        this.lblGambitPassword = new JLabel();
        this.lblGambitPassword.setText("Password:");
        this.panel.add((Component)this.lblGambitPassword, this.getLabelGBC(++y));
        this.txtGambitPassword = new JTextField();
        this.txtGambitPassword.setText(info.get("UserPassword"));
        this.panel.add((Component)this.txtGambitPassword, this.getTxtGBC(y));
        ++y;
        this.btnOk = new JButton();
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                info.put("GuestEmail", UserInfoFrame.this.txtMadrigalMail.getText());
                info.put("GuestAffiliation", UserInfoFrame.this.txtMadrigalAffiliation.getText());
                info.put("UserLogin", UserInfoFrame.this.txtGambitLogin.getText());
                info.put("UserPassword", UserInfoFrame.this.txtGambitPassword.getText());
                UserInfoFrame.recordUserInfo(String.valueOf(GambitConstants.USER_FOLDER) + "guest_info.txt", String.valueOf(GambitConstants.USER_FOLDER) + "gambit_info.txt", info);
                frame.dispose();
            }
        });
        this.btnOk.setText("   Ok   ");
        this.btnQuit = new JButton();
        this.btnQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.exit(0);
            }
        });
        this.btnQuit.setText("Quit");
        GridBagConstraints gbc = this.getLabelGBC(y);
        gbc.insets = new Insets(20, 70, 10, 5);
        this.panel.add((Component)this.btnOk, gbc);
        GridBagConstraints gbd = this.getTxtGBC(y);
        gbd.insets = new Insets(20, 0, 10, 80);
        this.panel.add((Component)this.btnQuit, gbd);
        this.add(this.panel);
        this.setTitle("User information to access databases");
        this.setSize(400, 250);
        this.setLocation(400, 400);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setVisible(true);
    }

    private GridBagConstraints getLabelGBC(int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = gridy;
        return gbc;
    }

    private GridBagConstraints getTxtGBC(int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 1;
        gbc.gridy = gridy;
        return gbc;
    }

    public static void getUserInfo_madrigal(File fileMadrigal, Map<String, String> info) {
        try {
            long nLines = FileUtils.countLines(fileMadrigal);
            if (nLines == 2L) {
                BufferedReader br = new BufferedReader(new FileReader(fileMadrigal));
                info.put("GuestEmail", br.readLine().trim());
                info.put("GuestAffiliation", br.readLine().trim());
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getUserInfo_gambit(File fileGambit, Map<String, String> info) {
        try {
            long nLines = FileUtils.countLines(fileGambit);
            if (nLines == 2L) {
                BufferedReader br = new BufferedReader(new FileReader(fileGambit));
                info.put("UserLogin", br.readLine().trim());
                info.put("UserPassword", br.readLine().trim());
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void recordUserInfo(String fileMadrigal, String fileGambit, Map<String, String> info) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(fileMadrigal);
            writer.write(String.valueOf(info.get("GuestEmail").trim()) + "\n");
            writer.write(String.valueOf(info.get("GuestAffiliation").trim()) + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            writer = new PrintWriter(fileGambit);
            writer.write(String.valueOf(info.get("UserLogin").trim()) + "\n");
            writer.write(String.valueOf(info.get("UserPassword").trim()) + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

