/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.reports;

import edu.uml.giro.gambit.core.GambitConstants;

public enum ReportChoice {
    STATISTICS("Calculates IRTAM statistics for given time interval.", true, false),
    STATISTICS_DISTURBED("Seek for disturbed periods using DST index and then \n calculates IRTAM statistics for every time interval", true, false),
    STATISTICS_FORECAST("Calculates (obs.-IRTAM) differences with coeffs. \n at time T and data at time (T +/- forecastT)", true, false),
    STATISTICS_FORECAST_DETAILED("Calculates (obs.-IRTAM) differences with coeffs. \n at time T and data at time (T +/- forecastT)", true, false),
    EXPORT_DATAGRID_TXT("Calculates grid values for current choice of Surface \nand writes them to a text file in " + GambitConstants.OUTPUT_FOLDER + " folder as " + "grid" + "_... file", false, false),
    EXPORT_DATAGRID_IONEX("Calculates and exports grid values for current choice of Surface \nand writes them to a file in " + GambitConstants.OUTPUT_FOLDER + " folder as " + "ionex" + "_... file", false, false),
    EXPORT_ALL_SITES("For a given time interval, retrieves from GAMBIT database all sites (observations, models, differences) to output in files", false, false),
    EXPORT_ALL_LOCAL_WEATHER("For a given time interval, retrieves from GAMBIT database all local weather analysis data to output in files", true, false),
    OUTPUT_COEFFICIENTS("Writes coefficients to file for given time interval", false, false),
    EXPORT_ALL_SITES_SUPER_RES("For a given time interval, runs EXPORT_ALL_SITES report at super-res cadence ", true, false),
    OUTPUT_DST("Writes DST index to file for given time interval", true, false),
    SAME_LT_ALL_LONG("Calculates map of current surface(map) choice with same local \ntime at each longitude of the grid; 24 hour data are used, \nUT time specified above will be the latest time in 24 \nhours interval; LT hour should be specified in the text \nbox below. 24 longitude slices are computed\nand joined into a single map.", true, true),
    MERIDIONAL_SLICE("Calculates meridional slice for a specific longitude\n provide longitude in the text box below", true, true),
    GIRO_NETWORK("List all contributing GIRO stations for this IRTAM computation\nOutput file:giro_stations.txt", false, false),
    GIRO_INTERSITE_DISTANCES("Computes ground distances between GIRO observatories", false, false),
    SITES_AVAILABILITY("Site data availability report", true, false),
    SITES_IN_SECTOR("Finds sites in geographical sector", true, false),
    SITES_CORRELATION("Calculates availability of the data by dates", true, false),
    PLOT_DST("Plots DST index for time interval specified", true, false),
    NOWCAST_TIMELINE("Uses nowcast IRTAM values over 24 hour period", false, false),
    PECASUS_MUF3000("MUF3000 export for PECASUS in JSON", false, false),
    UDL_COEFFICIENTS("Export coefficients in JSON for UDL", false, false);

    public final String description;
    public final String description_tooltip;
    public final boolean master_access;
    public final boolean configurable;
    private int parameter;
    private int progress;

    private ReportChoice(String description, boolean master_access, boolean configurable) {
        this.description = description;
        this.master_access = master_access;
        this.description_tooltip = "<html>" + description.replaceAll("\n", "<br>") + "</html>";
        this.configurable = configurable;
        this.parameter = 0;
        this.setProgress(0);
    }

    public int getParameter() {
        return this.parameter;
    }

    public void setParameter(int parameter) {
        this.parameter = parameter;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = Math.max(0, Math.min(progress, 100));
    }
}

