/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.reports;

import edu.uml.giro.gambit.apps.GambitAppSettings;
import edu.uml.giro.gambit.apps.GambitUserApp;
import edu.uml.giro.gambit.coefficients.Coefficients2D;
import edu.uml.giro.gambit.core.AlgorithmVersions;
import edu.uml.giro.gambit.core.Core;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.core.IonogramScaling;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.core.LocalDataOneSiteAllTimes;
import edu.uml.giro.gambit.core.LocalDataType;
import edu.uml.giro.gambit.database.DataFunctions;
import edu.uml.giro.gambit.display.Chart;
import edu.uml.giro.gambit.display.ChartAttributes;
import edu.uml.giro.gambit.display.ChartCurves;
import edu.uml.giro.gambit.display.DisplayDataBuilder;
import edu.uml.giro.gambit.display.GambitChartSettings;
import edu.uml.giro.gambit.display.GambitChartYmaxSettings;
import edu.uml.giro.gambit.display.GambitChartYminSettings;
import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGalletWithTrend;
import edu.uml.giro.gambit.gui.FromDateToDateFrame;
import edu.uml.giro.gambit.gui.GAMBITExplorerControlPanel;
import edu.uml.giro.gambit.gui.SitesSelectFrame;
import edu.uml.giro.gambit.reports.MapDataExporter;
import edu.uml.giro.gambit.reports.PecasusMUF3000;
import edu.uml.giro.gambit.reports.ReportChoice;
import edu.uml.giro.gambit.reports.SiteDataExporter;
import edu.uml.giro.gambit.reports.Statistics;
import edu.uml.giro.gambit.reports.UDLCoefficients;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.lgdc.appuserdb.api.UserCredentials;
import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.Geopack;
import edu.uml.lgdc.geospace.GroundSolar;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.time.TimeScale;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class Reports {
    public static final int HOURS_BEFORE_SAVE_STATISTICS = 24;
    protected GambitUserApp.AppFrame gambitFrame;
    protected GambitCore core;
    protected GambitChartSettings chartSelectionSettings;
    protected UserCredentials userCreds;
    protected static GambitChartYminSettings chartYminSettings;
    protected static GambitChartYmaxSettings chartYmaxSettings;

    public Reports(GambitCore core, GambitAppSettings gambitSettings, UserCredentials userCreds) {
        this.core = core;
        this.userCreds = userCreds;
        if (gambitSettings != null) {
            this.chartSelectionSettings = gambitSettings.getGambitChartSettings();
            chartYmaxSettings = gambitSettings.getGambitChartYmaxSettings();
        }
    }

    public void setFrame(GambitUserApp.AppFrame gambitFrame) {
        this.gambitFrame = gambitFrame;
    }

    public void runReport(ReportChoice rc, HashMap<String, String[]> controlSites, AlgorithmVersions versions) {
        MapChoice srfChc = this.core.getCurrentMapChoice();
        TimeScale time = this.core.getTimeOfValidity();
        int[] latlonN = new int[]{46, 45};
        rc.setProgress(0);
        switch (rc) {
            case EXPORT_DATAGRID_TXT: {
                TimeScale rememberTov = new TimeScale(time.getTimeInMillis());
                TimeScale[] times = FromDateToDateFrame.getDates();
                if (times == null) break;
                String subfolder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + "DATAGRID_" + times[0].toFormatUT("yyyy_MM_dd") + File.separator;
                File checkDir = new File(subfolder);
                if (!checkDir.exists()) {
                    checkDir.mkdir();
                }
                double stTimeMinutes = times[0].getTimeInMinutes();
                double endTimeMinutes = times[1].getTimeInMinutes();
                TimeGrid timeGrid = this.core.getChar((int)0).weather.getTimeGrid();
                double timeMinutes = stTimeMinutes;
                while (timeMinutes <= endTimeMinutes) {
                    TimeScale theTime = new TimeScale(timeMinutes);
                    this.core.setTimeOfValidity(theTime, 35, versions);
                    String filename = String.valueOf(subfolder) + "grid" + "_" + srfChc.getCC().getName() + "_" + srfChc.getType().toString() + "_" + theTime.toFilenameAternative() + ".dat";
                    File selectedFile = new File(filename);
                    if (selectedFile != null) {
                        MapDataExporter.outputGridValues(this.core, selectedFile, theTime, latlonN, "GX.User 1.3F");
                    }
                    timeMinutes += (double)timeGrid.getTimeStep_min();
                }
                this.core.setTimeOfValidity(rememberTov, 35, versions);
                break;
            }
            case EXPORT_DATAGRID_IONEX: {
                boolean written;
                String filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + "ionex" + "_" + srfChc.getCC().getName() + "_" + srfChc.getType().toString() + "_" + time.toFilenameAternative() + ".dat";
                File selectedFile = GAMBITExplorerControlPanel.getFileSelection(filename);
                if (selectedFile == null || (written = MapDataExporter.outputGridValues_ionex(this.core, selectedFile, time, new int[]{46, 72}))) break;
                JOptionPane.showMessageDialog(null, "Map was not created. Check out console output for information.", "Map was not created", 1);
                break;
            }
            case OUTPUT_COEFFICIENTS: {
                TimeScale[] times = FromDateToDateFrame.getDates();
                if (times == null) break;
                String subfolder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + "COEFFS_" + times[0].toFormatUT("yyyy_MM_dd") + File.separator;
                File checkDir = new File(subfolder);
                if (!checkDir.exists()) {
                    checkDir.mkdir();
                }
                double stTimeMinutes = times[0].getTimeInMinutes();
                double endTimeMinutes = times[1].getTimeInMinutes();
                TimeGrid timeGrid = this.core.getChar((int)0).weather.getTimeGrid();
                double timeMinutes = stTimeMinutes;
                while (timeMinutes <= endTimeMinutes) {
                    TimeScale toTime = new TimeScale(timeMinutes);
                    this.core.setTimeOfValidity(toTime, 35, versions);
                    CharChoice[] charChoiceArray = CharChoice.values();
                    int n = charChoiceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CharChoice cc = charChoiceArray[n2];
                        GeoSynthesizer weatherSynth = this.core.getChars()[cc.getIndex()].weather;
                        if (weatherSynth != null && weatherSynth.getCoefficients() != null) {
                            String filename = String.valueOf(subfolder) + "IRTAM_" + cc.getName4char() + "_COEFFS_" + this.core.getTimeOfValidity().toFilenameAternative() + ".ASC";
                            try {
                                PrintWriter writer = new PrintWriter(filename);
                                this.writeCoeffs(weatherSynth, writer, "GX.User 1.3F", this.userCreds);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                    timeMinutes += (double)timeGrid.getTimeStep_min();
                }
                break;
            }
            case EXPORT_ALL_SITES: {
                TimeScale[] times = FromDateToDateFrame.getDates();
                if (times == null) break;
                double stTimeMinutes = times[0].getTimeInMinutes();
                double endTimeMinutes = times[1].getTimeInMinutes();
                String subfolder = "FullSiteExport" + File.separator + times[0].toFormatUT("yyyy-MM-dd.HH") + ".." + times[1].toFormatUT("yyyy-MM-dd.HH");
                File checkDir = new File(String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder);
                if (!checkDir.exists()) {
                    checkDir.mkdirs();
                } else {
                    try {
                        FileUtils.cleanDirectory(checkDir);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                boolean rerunIRTAM = this.core.getGambitCoreSettings().isRerunAssimilation();
                CharChoice[] charChoiceArray = CharChoice.values();
                int cc = charChoiceArray.length;
                int toTime = 0;
                while (toTime < cc) {
                    CharChoice cc2 = charChoiceArray[toTime];
                    if (!cc2.isDerived()) {
                        int timeStep = this.core.getLocalData(cc2).getTimeGrid().getTimeStep_min();
                        double timeMinutes = stTimeMinutes;
                        while (timeMinutes <= endTimeMinutes) {
                            TimeScale toTime2 = new TimeScale(timeMinutes);
                            this.core.setTimeOfValidity(toTime2, 35, versions);
                            SiteDataExporter.exportOneTimeOneCharAllSites(this.core.getLocalData(cc2), toTime2, subfolder, this.chartSelectionSettings, rerunIRTAM);
                            timeMinutes += (double)timeStep;
                        }
                    }
                    ++toTime;
                }
                break;
            }
            case MERIDIONAL_SLICE: {
                String filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + "LonSlice" + "_at_" + (rc.getParameter() > 180 ? rc.getParameter() - 360 : rc.getParameter()) + "_" + srfChc.getCC().getName() + "_" + time.toFilenameAternative() + ".dat";
                File selectedFile = GAMBITExplorerControlPanel.getFileSelection(filename);
                if (selectedFile == null) break;
                this.outputLonSlice(selectedFile, time, rc.getParameter());
                break;
            }
            case GIRO_NETWORK: {
                String filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + "giro_stations.txt";
                File f = new File(filename);
                PrintWriter writer = null;
                try {
                    try {
                        LocalDataOneSiteAllTimes[] sites;
                        writer = new PrintWriter(new FileOutputStream(f, false));
                        writer.write("# GLOBAL IONOSPHERE RADIO OBSERVATORY (G.I.R.O.)\n# giro.uml.edu\n#\n# IRI-based Real-Time Assimilative Model (IRTAM)\n#\n");
                        writer.write("# LIST OF GIRO OBSERVATORIES FOR COMPUTATIONS ON " + time.toFormatISO8601() + "\n#\n");
                        writer.write("# URSI     LAT       LON      GLAT      GLON  Station Name\n");
                        Geopack geopack = new Geopack();
                        double[] geoLatLong = new double[3];
                        double[] magLatLong = new double[3];
                        LocalData localData = this.core.getLocalData(srfChc.getCC());
                        LocalDataOneSiteAllTimes[] localDataOneSiteAllTimesArray = sites = localData.getSites();
                        int n = sites.length;
                        int e = 0;
                        while (e < n) {
                            LocalDataOneSiteAllTimes site = localDataOneSiteAllTimesArray[e];
                            if (site != null && !site.isUnused()) {
                                StationLocation station = site.getLocation();
                                geopack.recalc(time);
                                geoLatLong[0] = station.getLat();
                                geoLatLong[1] = station.getLon();
                                geoLatLong[2] = 0.0;
                                geopack.geomapToMagmap(geoLatLong, magLatLong);
                                writer.write(String.valueOf(station.getUrsi()) + FC.DoubleToString(station.getLat(), 10, 2) + FC.DoubleToString(station.getLon(), 10, 2) + FC.DoubleToString(magLatLong[0], 10, 2) + FC.DoubleToString(magLatLong[1], 10, 2) + " " + station.getName() + "\n");
                            }
                            ++e;
                        }
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                        if (writer == null) break;
                        writer.close();
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        writer.close();
                    }
                    throw throwable;
                }
                if (writer == null) break;
                writer.close();
                break;
            }
            case GIRO_INTERSITE_DISTANCES: {
                File selectedFile = GAMBITExplorerControlPanel.getFileSelection(String.valueOf(GambitConstants.OUTPUT_FOLDER) + "distances.txt");
                if (selectedFile == null) break;
                String[] ursis = null;
                try {
                    ursis = this.core.getGambitDatabaseReader().downloadStationUrsiCodes();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                String[] checkedUrsis = SitesSelectFrame.getCheckedSites(ursis);
                if (checkedUrsis == null) break;
                Reports.outputDistanceMatrix(selectedFile, checkedUrsis, this.core.getGambitDatabaseReader().downloadAllStationLocs());
                break;
            }
            case PLOT_DST: {
                TimeScale[] startEndTime = FromDateToDateFrame.getDates();
                TimeScale[][] dstTimes = new TimeScale[1][];
                ChartCurves plotData = new ChartCurves();
                ChartAttributes attributes = new ChartAttributes(LocalDataType.DST, Color.BLUE, 0, 0);
                plotData.add(attributes, this.core.prepareDSTData(dstTimes, startEndTime));
                Chart graph = new Chart(null, null, 0, plotData, dstTimes[0], startEndTime[1], null, null, null, false, "DST nT");
                graph.plot(true, "DST_index");
                break;
            }
            case SAME_LT_ALL_LONG: {
                break;
            }
            case SITES_IN_SECTOR: {
                break;
            }
            case NOWCAST_TIMELINE: {
                String[] checkedUrsis = new String[]{};
                try {
                    checkedUrsis = SitesSelectFrame.getCheckedSites(this.core.getGambitDatabaseReader().downloadStationUrsiCodes());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (checkedUrsis.length > 1) {
                    JOptionPane.showMessageDialog(null, "Please select a single station", "Selection problem", 1);
                    break;
                }
                String subfolder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + GambitConstants.NOWCAST_TIMELINE_FOLDER;
                File checkDir = new File(subfolder);
                if (!checkDir.exists()) {
                    checkDir.mkdir();
                }
                CharChoice cc = srfChc.getCC();
                LocalDataOneSiteAllTimes site = this.core.getLocalData(cc).getSite(checkedUrsis[0]);
                ChartCurves chartData = DisplayDataBuilder.prepareChartCurves(site, this.chartSelectionSettings);
                File selectedFile = GAMBITExplorerControlPanel.getFileSelection(String.valueOf(subfolder) + time.toFormatUT("yyyy-MM-DD.HHmm") + "_" + checkedUrsis[0] + "_" + cc.getName());
                if (selectedFile == null) {
                    JOptionPane.showMessageDialog(null, "No file selected, only chart will be shown", "", 1);
                }
                chartData.curves.remove((Object)LocalDataType.GLOBAL_TREND);
                chartData.curves.remove((Object)LocalDataType.LOCAL_TREND);
                double[] observations = site.getObservations();
                StationLocation location = site.getLocation();
                double[] nowcastHistory = this.prepareNowcastHistory(time, null, checkedUrsis[0], versions);
                int len = nowcastHistory.length;
                double[] nowcastHistoryErrors = new double[len];
                boolean available = false;
                int iTime = 0;
                while (iTime < len) {
                    if (nowcastHistory[iTime] != 9999.0 && observations[iTime] != 9999.0) {
                        nowcastHistoryErrors[iTime] = observations[iTime] - nowcastHistory[iTime];
                        available = true;
                    } else {
                        nowcastHistoryErrors[iTime] = 9999.0;
                    }
                    ++iTime;
                }
                if (!available) {
                    JOptionPane.showMessageDialog(null, String.valueOf(checkedUrsis[0]) + " site data are not available for this interval", "", 1);
                    break;
                }
                ChartAttributes nowcastAttributes = new ChartAttributes(LocalDataType.GLOBAL_NOWCAST_HISTORY, Color.CYAN, 4, 1);
                chartData.add(nowcastAttributes, nowcastHistory);
                Chart reportPlotMulti = new Chart(this.core, cc, 0, chartData, this.core.getLocalData(cc).getTimeGrid().getUTs(), time, location, chartYminSettings.getYmin(cc), chartYmaxSettings.getYmax(cc), true, String.valueOf(cc.getName()) + " " + cc.getUnits());
                reportPlotMulti.plot(true, "History of IRTAM Nowcast of " + cc.getName() + " for " + location.getName());
                try {
                    ChartCurves.logPlotData(selectedFile.getAbsolutePath(), chartData, reportPlotMulti.getXData(), location, this.core.getWeather(cc), this.core.getClimate(cc), site.getLocalWeatherCoefs());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case PECASUS_MUF3000: {
                String filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + this.core.getTimeOfValidity().toFormatUT("yyyyMMdd_HHmm") + ".json";
                try {
                    TimeScale targetTime = this.core.getTimeOfValidity();
                    PecasusMUF3000.write(Files.newBufferedWriter(Paths.get(filename, new String[0]), new OpenOption[0]), targetTime, this.core, this.userCreds);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case UDL_COEFFICIENTS: {
                String filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + this.core.getTimeOfValidity().toFormatUT("yyyyMMdd_HHmmss") + ".json";
                try {
                    TimeScale targetTime = this.core.getTimeOfValidity();
                    UDLCoefficients.serialize(Files.newBufferedWriter(Paths.get(filename, new String[0]), new OpenOption[0]), targetTime, this.core, this.userCreds, false);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            default: {
                System.err.println("Report " + (Object)((Object)rc) + " is not available");
            }
        }
        rc.setProgress(100);
    }

    public void writeCoeffs(GeoSynthesizer weather, PrintWriter writer, String application, UserCredentials userCreds) throws IOException {
        writer.print(GambitConstants.EXPORT_START_HEADER);
        writer.print("# GLOBAL IONOSPHERE RADIO OBSERVATORY (G.I.R.O.)\n# giro.uml.edu\n#\n# IRI-based Real-Time Assimilative Model (IRTAM)\n#\n");
        writer.println("# IRTAM Coefficients of Temporal-Spatial Expansion");
        writer.println("# Generated by " + application + " on " + new TimeScale().toFormatISO8601());
        writer.println("# Ionospheric Characteristic: " + weather.cc.getName() + " [" + weather.cc.getUnits() + "] ");
        writer.println("# Time of Validity " + this.core.getTimeOfValidity().toFormatISO8601());
        writer.println("# Assimilative Engine: " + this.core.VERSIONS.assimilationName);
        writer.println("# Earth Grid: " + weather.getExpansionBasis().getEarthGrid().getNumLatitudeNodes() + " lats x " + weather.getExpansionBasis().getEarthGrid().getNumLongitudeNodes() + " lons");
        writer.println("# Expansion Basis: " + this.core.VERSIONS.expansionBasisName);
        writer.println("# Basis Lengths: " + ((ExpansionBasis2D)weather.getExpansionBasis()).getTemporalBasisLength() + "(temporal) x " + ((ExpansionBasis2D)weather.getExpansionBasis()).getCompactSpatialBasisLength() + "(spatial)");
        writer.print("# Assimilated stations: ");
        LocalData localData = this.core.getChar((CharChoice)weather.cc).localData;
        int i = 0;
        while (i < localData.totalLocations) {
            if (!localData.sites[i].isUnused() && !localData.sites[i].isControlPoint()) {
                if (i % 10 == 0) {
                    writer.print("\n#");
                }
                writer.print(" " + localData.sites[i].getLocation().getUrsi());
            }
            ++i;
        }
        writer.println();
        writer.println("# Requested by " + userCreds.getUserLogin() + " from " + userCreds.getUserHost());
        writer.print(GambitConstants.EXPORT_END_HEADER);
        int count = 0;
        ExpansionBasis2D basis = (ExpansionBasis2D)weather.getExpansionBasis();
        if (basis instanceof ExpansionBasis_JonesGalletWithTrend) {
            int i2 = 0;
            while (i2 < basis.getCompactSpatialBasisLength()) {
                int j = 0;
                while (j < basis.getTemporalBasisLength() - 1) {
                    int m = j > 0 ? j + 1 : 0;
                    writer.print(Formatter.format(" %15.8e", ((Coefficients2D)weather.getCoefficients()).get()[i2][m]));
                    if (++count == 4) {
                        writer.println();
                        count = 0;
                    }
                    ++j;
                }
                ++i2;
            }
            count = 0;
            i2 = 0;
            while (i2 < basis.getCompactSpatialBasisLength()) {
                writer.print(Formatter.format(" %15.8e", ((Coefficients2D)weather.getCoefficients()).get()[i2][1]));
                if (++count == 4) {
                    writer.println();
                    count = 0;
                }
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < basis.getCompactSpatialBasisLength()) {
                int j = 0;
                while (j < basis.getTemporalBasisLength()) {
                    writer.print(Formatter.format(" %15.8e", ((Coefficients2D)weather.getCoefficients()).get()[i3][j]));
                    if (++count == 4) {
                        writer.println();
                        count = 0;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        writer.close();
    }

    public static double[] calculateGridValues_LT(double[][] values, TimeScale endTime, ReportChoice rc, int offset, int latN, TimeGrid timeGrid) {
        int lt = rc.getParameter();
        int lonNodes = 24;
        if (values.length != 25) {
            System.out.println("Input matrix of values must contain 24 set of gridData (values.length = 24).");
            return null;
        }
        if (lt < 0 || lt >= 24) {
            System.out.println("Local time should be between 0 and 23 inclusively");
            return null;
        }
        endTime.set(12, offset);
        double time_min = endTime.getTimeInMinutes();
        int lonStep = 15;
        double[] values_lt = new double[latN * 24];
        int iTime = 24;
        while (iTime >= 0) {
            TimeScale time = new TimeScale(time_min - (double)(iTime * 60));
            double correction = timeGrid.isTimeOffseted(time, offset) ? offset : 0;
            double lon = ((double)lt - (time.getTimeSinceMidnightIn(11) - correction / 60.0)) * 15.0;
            lon = lon < -180.0 ? 360.0 + lon : lon;
            int iLon = (int)Math.round((lon + 180.0) / (double)lonStep) % 24;
            int iLat = 0;
            while (iLat < latN) {
                values_lt[iLat * 24 + iLon] = values[iTime][iLat * 24 + iLon];
                ++iLat;
            }
            --iTime;
        }
        return values_lt;
    }

    public double[] outputLonSlice(File selectedFile, TimeScale endTime, double lon) {
        if (lon > 180.0) {
            lon -= 360.0;
        }
        Geomap map = (Geomap)this.core.mapsTimeline.get(endTime, (Object)this.core.getCurrentMapChoice());
        double[] values = map.getMap_1D();
        EarthGrid grid = this.core.getDefaultEarthGrid();
        double[] slice = new double[grid.getNumLatitudeNodes()];
        double gridLon = Math.round(lon / grid.getLongitudeStep() * grid.getLongitudeStep());
        if (gridLon != lon) {
            System.out.println("Longitude specified does not match the grid. Slice is calculated for longitude = " + gridLon);
        }
        int iLon = (int)Math.round((gridLon + 180.0) / grid.getLongitudeStep()) % grid.getNumLatitudeNodes();
        int iLat = 0;
        while (iLat < grid.getNumLatitudeNodes()) {
            slice[iLat] = values[iLat * grid.getNumLongitudeNodes() + iLon];
            ++iLat;
        }
        try {
            PrintWriter writer = new PrintWriter(selectedFile.getAbsolutePath());
            writer.write("       Lat     Values\n");
            int iLat2 = 0;
            while (iLat2 < grid.getNumLatitudeNodes()) {
                writer.write(String.valueOf(FC.DoubleToString(90.0 - (double)iLat2 * grid.getLatitudeStep(), 10, 6)) + " " + FC.DoubleToString(slice[iLat2], 10, 6) + "\n");
                ++iLat2;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return slice;
    }

    public static Statistics reportStatistics_interval(Statistics stat, LocalData data, TimeScale toTime, String subfolder) {
        if (data.totalLocations < 1) {
            System.out.println("Sites should contain at least one record.");
            return stat;
        }
        LocalDataOneSiteAllTimes[] sites = data.sites;
        int iSite = 0;
        while (iSite < data.totalLocations - 1) {
            if (sites[iSite].getTimeGrid().getNumDiurnalSteps() != sites[iSite + 1].getTimeGrid().getNumDiurnalSteps() || sites[iSite].getTimeGrid().getTimeStep_min() != sites[iSite + 1].getTimeGrid().getTimeStep_min() || sites[iSite].getCharChoice() != sites[iSite + 1].getCharChoice()) {
                throw new RuntimeException("Check time steps and char names in sites[].");
            }
            ++iSite;
        }
        int charIndex = sites[0].getCharChoice().getIndex();
        int timeStep = sites[0].getTimeGrid().getTimeStep_min();
        int numTimes = sites[0].getTimeGrid().getNumDiurnalSteps();
        int nowPhase = sites[0].getTimeGrid().timeToDiurnalPhaseIndex(toTime);
        double minutes = toTime.getTimeInMinutes();
        int[] backcastPhase = new int[7];
        int i = 0;
        while (i < 7) {
            backcastPhase[i] = sites[0].getTimeGrid().timeToDiurnalPhaseIndex(new TimeScale(minutes - (double)(i * 60)));
            ++i;
        }
        if (nowPhase != backcastPhase[0]) {
            throw new RuntimeException("Check diurnal phase.");
        }
        int iStation = 0;
        while (iStation < sites.length) {
            String ursi = sites[iStation].getLocation().getUrsi().trim();
            int siteIndexStat = stat.getSitesInd(ursi, sites[iStation].getLocation().getLat(), sites[iStation].getLocation().getLon(), toTime);
            int i2 = 0;
            while (i2 < 7) {
                double iri = sites[iStation].getClimateValues()[backcastPhase[i2]];
                double rtam = sites[iStation].getGlobalWeatherValues()[backcastPhase[i2]];
                double obs = sites[iStation].getObservations()[backcastPhase[i2]];
                if (sites[iStation].getObs2Climate()[backcastPhase[i2]] != obs - iri || sites[iStation].getObs2GlobalWeather()[backcastPhase[i2]] != obs - rtam) {
                    throw new RuntimeException("Check model and observation data; differences do not match");
                }
                if (IonogramScaling.isAcceptedAsIs(sites[iStation].getFlags()[backcastPhase[i2]])) {
                    stat.updateAverageErrors(stat.averageError, charIndex, siteIndexStat, i2, obs, rtam, iri);
                    stat.updateLTStat(charIndex, siteIndexStat, ursi, toTime, obs, rtam, iri);
                    stat.updateLTStat_regions(charIndex, ursi, toTime, obs, rtam, iri);
                    if (sites[iStation].isControlPoint()) {
                        stat.updateAverageErrors(stat.averageErrorControl, charIndex, siteIndexStat, i2, obs, rtam, iri);
                    }
                }
                if (IonogramScaling.isManual(sites[iStation].getConfidenceScores()[backcastPhase[i2]])) {
                    stat.updateAverageErrors(stat.averageErrorManual, charIndex, siteIndexStat, i2, obs, rtam, iri);
                }
                stat.updateHistogram(charIndex, siteIndexStat, i2, obs, rtam, iri);
                ++i2;
            }
            stat.updateData(charIndex, siteIndexStat, sites[iStation].getClimateValues()[nowPhase], sites[iStation].getGlobalWeatherValues()[nowPhase], sites[iStation].getObservations()[nowPhase], sites[iStation].getFlags()[nowPhase], sites[iStation].getLocation().getLat(), sites[iStation].getLocation().getLon());
            double rtamErrorNow = sites[iStation].getObs2GlobalWeather()[nowPhase];
            double iriErrorNow = sites[iStation].getObs2Climate()[nowPhase];
            double iriNow = sites[iStation].getClimateValues()[nowPhase];
            double rtamNow = sites[iStation].getGlobalWeatherValues()[nowPhase];
            int conf = sites[iStation].getFlags()[nowPhase];
            double rtamError24H = sites[iStation].getObs2GlobalWeather()[(nowPhase + 1) % numTimes];
            if (stat.timeUpdated[charIndex][siteIndexStat] != null && toTime.getTimeInMinutes() - stat.timeUpdated[charIndex][siteIndexStat].getTimeInMinutes() > (double)(timeStep * 3)) {
                stat.average24Hours[charIndex][siteIndexStat][0] = 0.0;
            }
            if (stat.average24Hours[charIndex][siteIndexStat][0] == 0.0) {
                int iTime = 0;
                while (iTime < numTimes) {
                    double[] dArray = stat.average24Hours[charIndex][siteIndexStat];
                    dArray[0] = dArray[0] + Math.abs(sites[iStation].getObs2GlobalWeather()[iTime]);
                    stat.average24Hours[charIndex][siteIndexStat][2] = Math.max(sites[iStation].getObs2GlobalWeather()[iTime], stat.average24Hours[charIndex][siteIndexStat][2]);
                    ++iTime;
                }
            } else {
                stat.updateSlidingAverage(toTime, charIndex, ursi, rtamErrorNow, rtamError24H, iriErrorNow, rtamNow, iriNow, conf, subfolder);
            }
            stat.updateBackcastStatistic(sites[iStation].getObs2GlobalWeather(), nowPhase, charIndex, siteIndexStat);
            GroundSolar gs = new GroundSolar(sites[iStation].getLocation().getLat(), sites[iStation].getLocation().getLon(), 300.0, toTime);
            TimeScale sunrise = gs.getSunriseTimeUT();
            TimeScale sunset = gs.getSunsetTimeUT();
            int sunsetPhase = 0;
            int sunrisePhase = 0;
            if (sunrise != null && sunset != null) {
                sunsetPhase = sites[iStation].getTimeGrid().timeToDiurnalPhaseIndex(sunset);
                sunrisePhase = sites[iStation].getTimeGrid().timeToDiurnalPhaseIndex(sunrise);
            }
            if (sunrise != null && sunset != null && Math.abs(sunrise.getTimeInMinutes() - sunset.getTimeInMinutes()) > 60.0) {
                int iTime = 0;
                while (iTime < numTimes) {
                    double iri = sites[iStation].getClimateValues()[iTime];
                    double rtam = sites[iStation].getGlobalWeatherValues()[iTime];
                    double obs = sites[iStation].getObservations()[iTime];
                    sunset = sites[iStation].getTimeGrid().snapToClosestGrid(sunset);
                    int timeIndexSunset = iTime - sunsetPhase;
                    timeIndexSunset = (timeIndexSunset + numTimes) % numTimes;
                    stat.updateSunsetSunrise(stat.sunset, charIndex, siteIndexStat, timeIndexSunset, obs, rtam, iri);
                    int timeIndexSunrise = iTime - sunrisePhase;
                    timeIndexSunrise = (timeIndexSunrise + numTimes) % numTimes;
                    stat.updateSunsetSunrise(stat.sunrise, charIndex, siteIndexStat, timeIndexSunrise, obs, rtam, iri);
                    if (iTime == nowPhase) {
                        stat.updateSunsetSunrise(stat.sunset_now, charIndex, siteIndexStat, timeIndexSunset, obs, rtam, iri);
                    }
                    if (iTime == nowPhase) {
                        stat.updateSunsetSunrise(stat.sunrise_now, charIndex, siteIndexStat, timeIndexSunrise, obs, rtam, iri);
                    }
                    ++iTime;
                }
            }
            ++iStation;
        }
        String filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder + "AllData_" + CharChoice.getByIndex(charIndex).getName() + ".txt";
        try {
            stat.writeData(toTime, filename, charIndex, subfolder);
        }
        catch (IOException ex) {
            System.out.println(" Problem opening/closing file " + filename);
            ex.printStackTrace();
        }
        return stat;
    }

    public static double[][][][] findCorrelation(double[][][][] corr, LocalDataOneSiteAllTimes[] sites, TimeScale toTime, String[][] groups, boolean shift) {
        int jS;
        int iS;
        if (corr != null && corr.length != groups.length) {
            throw new RuntimeException("Check length for correlation and group arrays");
        }
        if (corr != null) {
            int iG = 0;
            while (iG < groups.length) {
                if (corr[iG].length != groups[iG].length) {
                    throw new RuntimeException("Check length for correlation and group arrays");
                }
                int iS2 = 0;
                while (iS2 < corr[iG].length - 1) {
                    if (corr[iG][iS2].length != corr[iG][iS2 + 1].length) {
                        throw new RuntimeException("Check length for correlation arrays within group number " + iG);
                    }
                    ++iS2;
                }
                ++iG;
            }
        }
        int[][] indexes = new int[groups.length][];
        double[][][][] correlation = corr == null ? (Object)new double[groups.length][][][] : corr;
        int iG = 0;
        while (iG < groups.length) {
            indexes[iG] = new int[groups[iG].length];
            iS = 0;
            while (iS < groups[iG].length) {
                indexes[iG][iS] = -1;
                ++iS;
            }
            ++iG;
        }
        if (corr != correlation) {
            iG = 0;
            while (iG < groups.length) {
                correlation[iG] = new double[groups[iG].length][groups[iG].length][2];
                iS = 0;
                while (iS < groups[iG].length) {
                    jS = 0;
                    while (jS < groups[iG].length) {
                        correlation[iG][iS][jS][0] = -2.0;
                        correlation[iG][iS][jS][1] = 0.0;
                        ++jS;
                    }
                    ++iS;
                }
                ++iG;
            }
        }
        int iSite = 0;
        while (iSite < sites.length) {
            if (sites[iSite] != null) {
                int iG2 = 0;
                while (iG2 < groups.length) {
                    int iS3 = 0;
                    while (iS3 < groups[iG2].length) {
                        if (groups[iG2][iS3].equals(sites[iSite].getLocation().getUrsi())) {
                            indexes[iG2][iS3] = iSite;
                        }
                        ++iS3;
                    }
                    ++iG2;
                }
            }
            ++iSite;
        }
        iG = 0;
        while (iG < groups.length) {
            iS = 0;
            while (iS < groups[iG].length) {
                jS = 0;
                while (jS < groups[iG].length) {
                    if (indexes[iG][iS] != -1 && indexes[iG][jS] != -1) {
                        double correl;
                        double[] coords1 = new double[]{sites[indexes[iG][iS]].getLocation().getLat(), sites[indexes[iG][iS]].getLocation().getLon()};
                        double[] coords2 = new double[]{sites[indexes[iG][jS]].getLocation().getLat(), sites[indexes[iG][jS]].getLocation().getLon()};
                        if (correlation[iG][iS][jS][0] == -2.0) {
                            correlation[iG][iS][jS][0] = 0.0;
                        }
                        if ((correl = DataFunctions.findCorrelation_cyclic(sites[indexes[iG][iS]].getObs2Climate(), sites[indexes[iG][jS]].getObs2Climate(), sites[indexes[iG][iS]].getFlags(), sites[indexes[iG][jS]].getFlags(), coords1, coords2, shift)) != -2.0) {
                            double[] dArray = correlation[iG][iS][jS];
                            dArray[0] = dArray[0] + correl;
                            double[] dArray2 = correlation[iG][iS][jS];
                            dArray2[1] = dArray2[1] + 1.0;
                        }
                    }
                    ++jS;
                }
                ++iS;
            }
            ++iG;
        }
        return correlation;
    }

    public static void outputDistanceMatrix(File selectedFile, String[] sites, TreeMap<Integer, StationLocation> allLoc) {
        TreeMap<Integer, StationLocation> locations = new TreeMap();
        if (sites != null) {
            int iS = 0;
            while (iS < sites.length) {
                for (Integer iL : allLoc.keySet()) {
                    if (!sites[iS].equals(allLoc.get(iL).getUrsi())) continue;
                    locations.put(iL, allLoc.get(iL));
                }
                ++iS;
            }
        } else {
            locations = allLoc;
        }
        double[][] dist = DataFunctions.getDistanceMatrix(locations);
        try {
            PrintWriter writer = new PrintWriter(selectedFile.getAbsolutePath());
            String ursis = "     ";
            String row = "";
            for (Integer iS : locations.keySet()) {
                ursis = String.valueOf(ursis) + "      " + locations.get(iS).getUrsi();
            }
            writer.write(String.valueOf(ursis) + " \n");
            int iiS = 0;
            for (Integer iS : locations.keySet()) {
                row = locations.get(iS).getUrsi();
                int jS = 0;
                while (jS < locations.size()) {
                    row = String.valueOf(row) + "  " + FC.DoubleToString(dist[iiS][jS], 9, 2);
                    ++jS;
                }
                writer.write(String.valueOf(row) + "\n");
                ++iiS;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportAllCharts(Core core, ReportChoice rc, TimeScale time, GambitChartSettings settings) {
        CharChoice cc = core.getCurrentSitesChoice().getCC();
        boolean rerunIRTAM = core.getGambitCoreSettings().isRerunAssimilation();
        LocalData localData = core.getLocalData(cc);
        DisplayDataBuilder.fillSiteAttributes(localData);
        LocalDataOneSiteAllTimes[] sites = localData.sites;
        int iSite = 0;
        while (iSite < localData.totalLocations) {
            StationLocation location = sites[iSite].getLocation();
            ChartCurves plotData = DisplayDataBuilder.prepareChartCurves(sites[iSite], settings);
            Chart reportplotMulti = new Chart(core, cc, iSite, plotData, localData.getTimeGrid().getUTs(), time, location, chartYminSettings.getYmin(cc), chartYmaxSettings.getYmax(cc), true, String.valueOf(cc.getName()) + " " + cc.getUnits());
            reportplotMulti.plot(false, String.valueOf(location.getName()) + " " + location.getUrsi().toString());
            rc.setProgress((int)(100.0 * (double)iSite / (double)sites.length));
            ++iSite;
        }
        rc.setProgress(100);
    }

    public double[] prepareNowcastHistory(TimeScale endTime, HashMap<String, String[]> controlSites, String ursi, AlgorithmVersions versions) {
        MapChoice srfChc = this.core.getCurrentMapChoice();
        CharChoice cc = srfChc.getCC();
        boolean rerunIRTAM = this.core.getGambitCoreSettings().isRerunAssimilation();
        TimeGrid timeGrid = this.core.getChar((CharChoice)cc).localData.getTimeGrid();
        int timeSteps = timeGrid.getNumDiurnalSteps();
        double[] data = new double[timeSteps];
        int iTime = 0;
        while (iTime < timeSteps) {
            TimeScale time = new TimeScale(endTime.getTimeInMillis() - (long)((timeSteps - iTime - 1) * timeGrid.getTimeStep_min() * 60000));
            this.core.setTimeOfValidity(time, 1 + (rerunIRTAM ? 8 : 0), versions);
            data[iTime] = 9999.0;
            int iSite = 0;
            while (iSite < this.core.getLocalData((CharChoice)cc).totalLocations) {
                if (this.core.getLocalData((CharChoice)cc).sites[iSite].getLocation().getUrsi().equals(ursi)) {
                    LocalDataOneSiteAllTimes site = this.core.getLocalData((CharChoice)cc).sites[iSite];
                    int i = site.getTimeGrid().getNumDiurnalSteps() - 1;
                    data[iTime] = site.getGlobalWeatherValues()[i];
                }
                ++iSite;
            }
            ++iTime;
        }
        return data;
    }

    protected void reportStatisticsPeriods(TimeScale[][] start_endTime, String subfolder, HashMap<String, String[]> controlSites, AlgorithmVersions versions) {
        if (start_endTime.length == 0) {
            return;
        }
        boolean rerunIRTAM = this.core.getGambitCoreSettings().isRerunAssimilation();
        File checkDir = new File(String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder);
        if (!checkDir.exists()) {
            checkDir.mkdir();
        }
        int charsN = this.core.getChars().length;
        TimeScale startTime = (TimeScale)start_endTime[0][0].clone();
        int[] timeSteps = new int[charsN];
        int iChar = 0;
        while (iChar < charsN) {
            timeSteps[iChar] = this.core.getChars()[iChar].weather.getExpansionBasis().getTimeGrid().getNumDiurnalSteps();
            ++iChar;
        }
        Statistics stat = new Statistics(this.core, charsN, 61, GambitConstants.ERROR_RANGE_STEP, timeSteps);
        int iPeriod = 0;
        while (iPeriod < start_endTime.length) {
            double stTimeMinutes = start_endTime[iPeriod][0].getTimeInMinutes();
            double endTimeMinutes = start_endTime[iPeriod][1].getTimeInMinutes();
            int minutesSinceLastSave = 0;
            double timeMinutes = stTimeMinutes;
            while (timeMinutes <= endTimeMinutes) {
                TimeScale toTime = new TimeScale(timeMinutes);
                this.core.setTimeOfValidity(toTime, 35 + (rerunIRTAM ? 8 : 0), versions);
                int iChar2 = 0;
                while (iChar2 < charsN) {
                    stat = Reports.reportStatistics_interval(stat, this.core.getLocalData(CharChoice.getByIndex(iChar2)), toTime, subfolder);
                    ++iChar2;
                }
                if ((minutesSinceLastSave += 15) >= 1440 || timeMinutes + 15.0 >= endTimeMinutes) {
                    int iCh = 0;
                    while (iCh < charsN) {
                        stat.writeStatistics2File(CharChoice.getByIndex(iCh), startTime, toTime, subfolder);
                        ++iCh;
                    }
                    minutesSinceLastSave = 0;
                    stat.updateCoords_magnetic(toTime);
                }
                timeMinutes += 15.0;
            }
            ++iPeriod;
        }
    }
}

