/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.uml.giro.gambit.coefficients.Coefficients2D;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.giro.gambit.expansions.ExpansionBasis_JonesGalletWithTrend;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.lgdc.appuserdb.api.UserCredentials;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.time.TimeScale;
import java.io.IOException;
import java.io.Writer;

public class UDLCoefficients {
    private static Object syncNewRecord = new Object();
    public static final String KEYWORD_IONOCHARS = "IONOCHARS";
    public static final String KEYWORD_ASSIMILATION_ENGINE = "ASSIMILATION_ENGINE";
    public static final String KEYWORD_BASIS = "BASIS";
    public static final String KEYWORD_TOTAL_COEFS_PER_IONOCHAR = "TOTAL_COEFS_PER_IONOCHAR";
    public static final String KEYWORD_PRODUCER = "PRODUCER";
    public static final String KEYWORD_REQUESTER = "REQUESTER";
    public static final String KEYWORD_ANALYSIS_TIME = "ANALYSIS_TIME";

    public static void serialize(Writer writer, TimeScale targetTime, GambitCore core, UserCredentials userCreds, boolean isCompressed) throws IOException {
        CoeffRecord record = new CoeffRecord(core, targetTime, userCreds);
        GsonBuilder builder = new GsonBuilder();
        if (!isCompressed) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        gson.toJson((Object)record, (Appendable)writer);
        writer.close();
    }

    static class CoeffRecord {
        String classificationMarking = "U";
        String system;
        String stationId;
        String startTimeUTC;
        String systemInfo;
        Datum datum;
        String source;
        String dataMode;

        CoeffRecord(GambitCore core, TimeScale targetTime, UserCredentials userCreds) {
            this.system = core.VERSIONS.name;
            this.stationId = "GLOBAL-3D";
            this.startTimeUTC = targetTime.toFormatUT("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
            TimeScale analysisTime = new TimeScale(core.getTimeOfValidity().getTimeInMillis());
            analysisTime.add(13, 465);
            String ionoChars = "IONOCHARS: " + CharChoice.FOF2.getName() + "," + CharChoice.HMF2.getName() + "," + CharChoice.B0.getName() + "," + CharChoice.B1.getName();
            String assimilationEngine = "ASSIMILATION_ENGINE: " + core.VERSIONS.assimilationName;
            String basisDesc = "BASIS: " + core.VERSIONS.expansionBasisName;
            ExpansionBasis2D basis = (ExpansionBasis2D)core.getWeather(CharChoice.FOF2).getExpansionBasis();
            int length_foF2 = basis.getCompactSpatialBasisLength() * basis.getTemporalBasisLength();
            basis = (ExpansionBasis2D)core.getWeather(CharChoice.HMF2).getExpansionBasis();
            int length_hmF2 = basis.getCompactSpatialBasisLength() * basis.getTemporalBasisLength();
            basis = (ExpansionBasis2D)core.getWeather(CharChoice.B0).getExpansionBasis();
            int length_B0 = basis.getCompactSpatialBasisLength() * basis.getTemporalBasisLength();
            basis = (ExpansionBasis2D)core.getWeather(CharChoice.B1).getExpansionBasis();
            int length_B1 = basis.getCompactSpatialBasisLength() * basis.getTemporalBasisLength();
            String totalCoefsPerChar = "TOTAL_COEFS_PER_IONOCHAR: " + length_foF2 + "," + length_hmF2 + "," + length_B0 + "," + length_B1;
            String producerInfo = "PRODUCER: Lowell GIRO Data Center";
            String requesterInfo = "REQUESTER: " + userCreds.getUserLogin() + "|" + userCreds.getUserHost();
            String analysisTimeDesc = "ANALYSIS_TIME: " + analysisTime.toFormatUT("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
            this.systemInfo = String.valueOf(ionoChars) + "; " + assimilationEngine + "; " + basisDesc + "; " + totalCoefsPerChar + "; " + producerInfo + "; " + requesterInfo + "; " + analysisTimeDesc;
            double[] data = new double[length_foF2 + length_hmF2 + length_B0 + length_B1];
            int count = 0;
            GeoSynthesizer weather = core.getWeather(CharChoice.FOF2);
            count = this.populateCoeffs(data, weather, count);
            weather = core.getWeather(CharChoice.HMF2);
            count = this.populateCoeffs(data, weather, count);
            weather = core.getWeather(CharChoice.B0);
            count = this.populateCoeffs(data, weather, count);
            weather = core.getWeather(CharChoice.B1);
            count = this.populateCoeffs(data, weather, count);
            String notes = "This datum element contains four sets of IRTAM-3D expansion coefficients that replace the quiet-time IRI coefficients to produce a global ionospheric weather report. The four sets are: " + length_foF2 + " values for " + CharChoice.FOF2.getName() + ", " + length_hmF2 + " values for " + CharChoice.HMF2.getName() + ", " + length_B0 + " values for " + CharChoice.B0.getName() + ", and " + length_B1 + " values for " + CharChoice.B1.getName() + ". " + "New IRTAM-3D coefficients are released every 15 minutes. " + "For integration of the IRTAM-3D weather with user applications, refer to https://giro.uml.edu/GAMBIT";
            this.datum = new Datum(notes, data);
            this.source = "UMASS-LOWELL";
            this.dataMode = "REAL";
        }

        private int populateCoeffs(double[] coeffs, GeoSynthesizer weather, int count) {
            ExpansionBasis2D basis = (ExpansionBasis2D)weather.getExpansionBasis();
            if (basis instanceof ExpansionBasis_JonesGalletWithTrend) {
                int i = 0;
                while (i < basis.getCompactSpatialBasisLength()) {
                    int j = 0;
                    while (j < basis.getTemporalBasisLength() - 1) {
                        int m = j > 0 ? j + 1 : 0;
                        coeffs[count++] = ((Coefficients2D)weather.getCoefficients()).get()[i][m];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < basis.getCompactSpatialBasisLength()) {
                    coeffs[count++] = ((Coefficients2D)weather.getCoefficients()).get()[i][1];
                    ++i;
                }
            }
            return count;
        }
    }

    static class Datum {
        String notes;
        double[] data;

        Datum(String notes, double[] data) {
            this.notes = notes;
            this.data = data;
        }
    }
}

