/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.synthesizers;

import edu.uml.giro.gambit.coefficients.Coefficients;
import edu.uml.giro.gambit.expansions.ExpansionBasis;
import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.giro.gambit.synthesizers.Synthesizer2D;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.IRIModel;
import edu.uml.lgdc.geospace.PlasmaMath;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.IOException;
import java.io.PrintWriter;

public class GeoSynthesizer
extends Synthesizer2D {
    GeoSynthesizer[] supportSynthesizers;
    IRIModel iri = null;

    public GeoSynthesizer(CharChoice cc, ExpansionBasis basis, Coefficients<?> coeffs, GeoSynthesizer[] supportSynths) {
        super(cc, basis, coeffs);
        if (supportSynths != null) {
            this.supportSynthesizers = new GeoSynthesizer[supportSynths.length];
            int i = 0;
            while (i < this.supportSynthesizers.length) {
                this.supportSynthesizers[i] = supportSynths[i];
                ++i;
            }
        }
    }

    public void setIRI(IRIModel iri) {
        this.iri = iri;
    }

    @Override
    public double synthesizeValue(double lat, double lon, int iTime) {
        switch (this.cc) {
            case FOF2: 
            case HMF2: 
            case B0: 
            case B1: {
                return super.synthesizeValue(lat, lon, iTime);
            }
            case NMF2: {
                return PlasmaMath.freq2density(this.supportSynthesizers[0].synthesizeValue(lat, lon, iTime));
            }
            case MUF3000: {
                if (this.iri == null) {
                    Console.showError("Call to MUF3000 calculation without IRI available");
                    return 0.0;
                }
                double foEP = this.iri.calculate_foEonly(lat, lon, this.supportSynthesizers[0].getTimeGrid().getUTs()[iTime]);
                double diplat = this.iri.igrf.diplat;
                return PlasmaMath.MUF3000(this.supportSynthesizers[0].synthesizeValue(lat, lon, iTime), this.supportSynthesizers[1].synthesizeValue(lat, lon, iTime), foEP, this.iri.getSolarActivity(), diplat);
            }
        }
        String strSynth = "";
        int k = 0;
        while (k < this.supportSynthesizers.length) {
            strSynth = String.valueOf(strSynth) + " " + this.supportSynthesizers[k].cc.getName();
            ++k;
        }
        Console.showError("Unknown derivation request for " + this.cc.getName() + " using support synths for" + strSynth);
        return 0.0;
    }

    @Override
    public double[] synthesizeValueSeries(double lat, double lon) {
        switch (this.cc) {
            case FOF2: 
            case HMF2: 
            case B0: 
            case B1: {
                return super.synthesizeValueSeries(lat, lon);
            }
            case NMF2: {
                double[] values = this.supportSynthesizers[0].synthesizeValueSeries(lat, lon);
                int i = 0;
                while (i < values.length) {
                    values[i] = PlasmaMath.freq2density(values[i]);
                    ++i;
                }
                return values;
            }
            case MUF3000: {
                if (this.iri == null) {
                    Console.showError("Call to MUF3000 calculation without IRI available");
                    return null;
                }
                double[] foF2values = this.supportSynthesizers[0].synthesizeValueSeries(lat, lon);
                double[] hmF2values = this.supportSynthesizers[1].synthesizeValueSeries(lat, lon);
                double[] muf3000values = new double[foF2values.length];
                int i = 0;
                while (i < foF2values.length) {
                    double foEP = this.iri.calculate_foEonly(lat, lon, this.supportSynthesizers[0].getTimeGrid().getUTs()[i]);
                    double R12 = this.iri.getSolarActivity();
                    double diplat = this.iri.igrf.diplat;
                    muf3000values[i] = PlasmaMath.MUF3000(foF2values[i], hmF2values[i], foEP, R12, diplat);
                    ++i;
                }
                return muf3000values;
            }
        }
        String strSynth = "";
        int k = 0;
        while (k < this.supportSynthesizers.length) {
            strSynth = String.valueOf(strSynth) + " " + this.supportSynthesizers[k].cc.getName();
            ++k;
        }
        Console.showError("Unknown derivation request for " + this.cc.getName() + " using support synths for" + strSynth);
        return null;
    }

    @Override
    public double[][] synthesizeValueMap(int iTime) {
        switch (this.cc) {
            case FOF2: 
            case HMF2: 
            case B0: 
            case B1: 
            case CUSTOM: {
                return super.synthesizeValueMap(iTime);
            }
            case NMF2: {
                double[][] values = this.supportSynthesizers[0].synthesizeValueMap(iTime);
                int i = 0;
                while (i < values.length) {
                    int j = 0;
                    while (j < values[0].length) {
                        values[i][j] = PlasmaMath.freq2density(values[i][j]);
                        ++j;
                    }
                    ++i;
                }
                return values;
            }
            case MUF3000: {
                if (this.iri == null) {
                    Console.showError("Call to MUF3000 calculation without IRI available");
                    return null;
                }
                double[][] foF2values = this.supportSynthesizers[0].synthesizeValueMap(iTime);
                double[][] hmF2values = this.supportSynthesizers[1].synthesizeValueMap(iTime);
                double[][] muf3000values = new double[foF2values.length][foF2values[0].length];
                TimeScale time = this.supportSynthesizers[0].getTimeGrid().getUTs()[iTime];
                int i = 0;
                while (i < foF2values.length) {
                    double lat = this.supportSynthesizers[0].getEarthGrid().getGridLatDegree(i);
                    int j = 0;
                    while (j < foF2values[0].length) {
                        double lon = this.supportSynthesizers[0].getEarthGrid().getGridLonDegree(j);
                        double foEP = this.iri.calculate_foEonly(lat, lon, time);
                        double R12 = this.iri.getSolarActivity();
                        double diplat = this.iri.igrf.diplat;
                        muf3000values[i][j] = PlasmaMath.MUF3000(foF2values[i][j], hmF2values[i][j], foEP, R12, diplat);
                        ++j;
                    }
                    ++i;
                }
                return muf3000values;
            }
        }
        String strSynth = "";
        int k = 0;
        while (k < this.supportSynthesizers.length) {
            strSynth = String.valueOf(strSynth) + " " + this.supportSynthesizers[k].cc.getName();
            ++k;
        }
        Console.showError("Unknown derivation request for " + this.cc.getName() + " using support synths for" + strSynth);
        return null;
    }

    public void writeToFile_oneLocation(String filename, double lat, double lon) {
        try {
            PrintWriter writer = new PrintWriter(filename);
            double[] values = this.synthesizeValueSeries(lat, lon);
            TimeGrid timeGrid = ((ExpansionBasis2D)this.basis).getTimeGrid();
            TimeScale[] times = timeGrid.getUTs();
            writer.write("#Global Ionosphere Radio Observatory\n#\n#GAMBIT GX.User 1.3F\n#Time Series Export of " + this.cc.getName() + "\n#GEO latitude=" + lat + "N, longitude=" + lon + "E\n#\n");
            int iTime = 0;
            while (iTime < timeGrid.getNumDiurnalSteps()) {
                writer.write(String.valueOf(times[iTime].toHumanUT()) + " " + FC.DoubleToString(values[iTime], 8, 3) + "\n");
                ++iTime;
            }
            writer.close();
        }
        catch (IOException ex) {
            System.out.println("SingleLocationExport: can't write to file " + filename);
        }
    }

    @Override
    public void setEarthGrid(EarthGrid earthGrid) {
        this.basis.setEarthGrid(earthGrid);
        if (this.supportSynthesizers != null) {
            int i = 0;
            while (i < this.supportSynthesizers.length) {
                this.supportSynthesizers[i].setEarthGrid(earthGrid);
                ++i;
            }
        }
    }
}

