/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.synthesizers;

import edu.uml.giro.gambit.coefficients.Coefficients;
import edu.uml.giro.gambit.expansions.ExpansionBasis;
import edu.uml.giro.gambit.expansions.ExpansionBasis2D;
import edu.uml.giro.gambit.synthesizers.Synthesizer;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.TimeGrid;

public class Synthesizer2D
extends Synthesizer {
    public Synthesizer2D(CharChoice cc, ExpansionBasis basis, Coefficients<?> coeffs) {
        super(cc, basis, coeffs);
    }

    public double[] getDiurnalCoefficients(int iLat, int iLon) {
        int diurnalBasisLength = ((ExpansionBasis2D)this.basis).getTemporalBasisLength();
        int compactSpatialBasisLength = ((ExpansionBasis2D)this.basis).getCompactSpatialBasisLength();
        double[] c = new double[diurnalBasisLength];
        int i = 0;
        while (i < diurnalBasisLength) {
            c[i] = 0.0;
            int k = 0;
            while (k < compactSpatialBasisLength) {
                int n = i;
                c[n] = c[n] + ((double[][])this.coeffs.get())[k][i] * ((ExpansionBasis2D)this.basis).getSpatialBasisFunctionValue(k, iLat, iLon);
                ++k;
            }
            ++i;
        }
        return c;
    }

    public double[] getDiurnalCoefficients(double latitude_deg, double longitude_deg) {
        int iLat = this.basis.getEarthGrid().getGridLatIndex(latitude_deg);
        int iLon = this.basis.getEarthGrid().getGridLonIndex(longitude_deg);
        return this.getDiurnalCoefficients(iLat, iLon);
    }

    public double[] getCompactSpatialCoefficients(int iTime) {
        double[] c = new double[((ExpansionBasis2D)this.basis).getCompactSpatialBasisLength()];
        int k = 0;
        while (k < ((ExpansionBasis2D)this.basis).getCompactSpatialBasisLength()) {
            double sum = 0.0;
            int i = 0;
            while (i < ((ExpansionBasis2D)this.basis).getTemporalBasisLength()) {
                sum += ((double[][])this.coeffs.get())[k][i] * ((ExpansionBasis2D)this.basis).getTemporalBasisFunctionValue(i, iTime);
                ++i;
            }
            c[k] = sum;
            ++k;
        }
        return c;
    }

    @Override
    public double synthesizeValue(double lat, double lon, int iTime) {
        double value = 0.0;
        double[] timeHarmonics = this.getDiurnalCoefficients(lat, lon);
        int iOrder = 0;
        while (iOrder < ((ExpansionBasis2D)this.basis).getTemporalBasisLength()) {
            value += timeHarmonics[iOrder] * ((ExpansionBasis2D)this.basis).getTemporalBasisFunctionValue(iOrder, iTime);
            ++iOrder;
        }
        return value;
    }

    @Override
    public double synthesizeTrend(double lat, double lon, int iTime) {
        double value = 0.0;
        if (!this.cc.isDerived()) {
            double[] timeHarmonics = this.getDiurnalCoefficients(lat, lon);
            int iOrder = 0;
            while (iOrder < 2) {
                value += timeHarmonics[iOrder] * ((ExpansionBasis2D)this.basis).getTemporalBasisFunctionValue(iOrder, iTime);
                ++iOrder;
            }
        }
        return value;
    }

    @Override
    public double[] synthesizeValueSeries(int iLat, int iLon) {
        double[] valueSeries = new double[this.basis.getTimeGrid().getNumDiurnalSteps()];
        ExpansionBasis2D basis2d = (ExpansionBasis2D)this.basis;
        double[] diurnalCoeffs = new double[basis2d.getTemporalBasisLength()];
        int iOrder = 0;
        while (iOrder < basis2d.getTemporalBasisLength()) {
            diurnalCoeffs[iOrder] = 0.0;
            int k = 0;
            while (k < basis2d.getCompactSpatialBasisLength()) {
                int n = iOrder;
                diurnalCoeffs[n] = diurnalCoeffs[n] + ((double[][])this.coeffs.get())[k][iOrder] * basis2d.getSpatialBasisFunctionValue(k, iLat, iLon);
                ++k;
            }
            ++iOrder;
        }
        int iTime = 0;
        while (iTime < this.basis.getTimeGrid().getNumDiurnalSteps()) {
            valueSeries[iTime] = 0.0;
            int iOrder2 = 0;
            while (iOrder2 < basis2d.getTemporalBasisLength()) {
                int n = iTime;
                valueSeries[n] = valueSeries[n] + diurnalCoeffs[iOrder2] * basis2d.getTemporalBasisFunctionValue(iOrder2, iTime);
                ++iOrder2;
            }
            ++iTime;
        }
        return valueSeries;
    }

    public double[] synthesizeValueSeries(double[] diurnalCoeffs) {
        TimeGrid timeGrid = this.basis.getTimeGrid();
        int totalTimeSteps = (int)((long)timeGrid.getNumDiurnalSteps() + timeGrid.getForecastPeriod_minutes() / (long)timeGrid.getTimeStep_min());
        double[] valueSeries = new double[totalTimeSteps];
        int iTime = 0;
        while (iTime < totalTimeSteps) {
            valueSeries[iTime] = 0.0;
            int iOrder = 0;
            while (iOrder < ((ExpansionBasis2D)this.basis).getTemporalBasisLength()) {
                int n = iTime;
                valueSeries[n] = valueSeries[n] + diurnalCoeffs[iOrder] * ((ExpansionBasis2D)this.basis).getTemporalBasisFunctionValue(iOrder, iTime);
                ++iOrder;
            }
            ++iTime;
        }
        return valueSeries;
    }

    @Override
    public double[][] synthesizeValueMap(int iTime) {
        double[][] valueGrid = new double[this.basis.getEarthGrid().getNumLatitudeNodes()][this.basis.getEarthGrid().getNumLongitudeNodes()];
        if (this.coeffs.get() == null) {
            return valueGrid;
        }
        ExpansionBasis2D basis2d = (ExpansionBasis2D)this.basis;
        double[] spatialCoeffs = new double[basis2d.getCompactSpatialBasisLength()];
        int k = 0;
        while (k < basis2d.getCompactSpatialBasisLength()) {
            spatialCoeffs[k] = 0.0;
            int iOrder = 0;
            while (iOrder < basis2d.getTemporalBasisLength()) {
                int n = k;
                spatialCoeffs[n] = spatialCoeffs[n] + ((double[][])this.coeffs.get())[k][iOrder] * basis2d.getTemporalBasisFunctionValue(iOrder, iTime);
                ++iOrder;
            }
            ++k;
        }
        int iLat = 0;
        while (iLat < this.basis.getEarthGrid().getNumLatitudeNodes()) {
            int iLon = 0;
            while (iLon < this.basis.getEarthGrid().getNumLongitudeNodes()) {
                valueGrid[iLat][iLon] = 0.0;
                int k2 = 0;
                while (k2 < basis2d.getCompactSpatialBasisLength()) {
                    double[] dArray = valueGrid[iLat];
                    int n = iLon;
                    dArray[n] = dArray[n] + spatialCoeffs[k2] * basis2d.getSpatialBasisFunctionValue(k2, iLat, iLon);
                    ++k2;
                }
                ++iLon;
            }
            ++iLat;
        }
        return valueGrid;
    }
}

