/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb;

import edu.uml.lgdc.appuserdb.UserManagerAppSettings;
import edu.uml.lgdc.appuserdb.api.AvailableDatabase;
import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.api.UserRole;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.appuserdb.type.Account;
import edu.uml.lgdc.appuserdb.type.Permission;
import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseContents;
import edu.uml.lgdc.project.Console;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class UserManagerApp
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String INI_FILENAME = "UserManagerApp.ini";
    private static final String USERLIST_FILENAME = "LGDC-Registry_Users.list";
    public static final int ROW_HEIGHT = 28;
    public static final int FRAME_WIDTH = 1000;
    public static final int FRAME_HEIGHT = 1200;
    public static final Color NEUTRAL_COLOR = new Color(238, 238, 238);
    private static UserManagerAppSettings userManagerAppSettings = new UserManagerAppSettings("UserManagerApp.ini");
    private static DBConnect didbaseConnection;
    private static DBConnect driftbaseConnection;
    static final int totalApplications;
    static final int totalContentLines;
    static final JCheckBox[] ckbAccess;
    static final JButton[] btnRealTime;
    static final JButton[] btnWriter;
    static final List<Set<JButton>> btnDbAccessPoint;
    static final Box[] boxDbAccessPoints;

    static {
        try {
            LgdcRegistry.setupRegistryAsRegistrar(userManagerAppSettings.getRegistryConnectionSettings());
            didbaseConnection = new DBConnect(userManagerAppSettings.getDatabaseConnectionSettings().getConnectionRequisites("DIDBase"), DatabaseContents.SCALED_VI.getId(), 0);
            driftbaseConnection = new DBConnect(userManagerAppSettings.getDatabaseConnectionSettings().getConnectionRequisites("DriftBase"), DatabaseContents.DFT_VI.getId(), 0);
        }
        catch (SQLException | ParseException ex) {
            throw new RuntimeException(ex);
        }
        totalApplications = Application.values().length;
        totalContentLines = Application.get(totalApplications).getStartLineNumberInAppContentList() + Application.get(totalApplications).getAllDatabaseContents().size();
        ckbAccess = new JCheckBox[totalContentLines];
        btnRealTime = new JButton[totalContentLines];
        btnWriter = new JButton[totalContentLines];
        btnDbAccessPoint = new ArrayList<Set<JButton>>();
        boxDbAccessPoints = new Box[totalContentLines];
    }

    public UserManagerApp() {
        JPanel mainPanel = new JPanel();
        BoxLayout mainLayout = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(mainLayout);
        JPanel userInfoPanel = new JPanel();
        GridBagLayout userInfoLayout = new GridBagLayout();
        userInfoLayout.columnWidths = new int[]{80, 200, 80, 300};
        userInfoPanel.setLayout(userInfoLayout);
        userInfoPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("User Registration Record")));
        JLabel lblName = new JLabel("CONTACT PERSON");
        userInfoPanel.add((Component)lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField tfName = new JTextField();
        tfName.setColumns(80);
        userInfoPanel.add((Component)tfName, new GridBagConstraints(1, 0, 3, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblLogin = new JLabel("LOGIN");
        userInfoPanel.add((Component)lblLogin, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField tfLogin = new JTextField();
        tfLogin.setColumns(12);
        userInfoPanel.add((Component)tfLogin, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblPassword = new JLabel("PASSWORD");
        userInfoPanel.add((Component)lblPassword, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField tfPassword = new JTextField();
        tfPassword.setColumns(12);
        userInfoPanel.add((Component)tfPassword, new GridBagConstraints(3, 1, 1, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblEMail = new JLabel("E-MAIL");
        userInfoPanel.add((Component)lblEMail, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField tfEMail = new JTextField();
        userInfoPanel.add((Component)tfEMail, new GridBagConstraints(1, 2, 3, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblOrganization = new JLabel("ORGANIZATION");
        userInfoPanel.add((Component)lblOrganization, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JTextField tfOrganization = new JTextField();
        userInfoPanel.add((Component)tfOrganization, new GridBagConstraints(1, 3, 2, 1, 0.5, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblWarning = new JLabel("(32 chars max)");
        userInfoPanel.add((Component)lblWarning, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JCheckBox ckbAddToRegistry = new JCheckBox();
        ckbAddToRegistry.setSelected(true);
        userInfoPanel.add((Component)ckbAddToRegistry, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblAddToRegistry = new JLabel("Add to Registry");
        userInfoPanel.add((Component)lblAddToRegistry, new GridBagConstraints(5, 0, 1, 1, 0.2, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JLabel lblRegistryUserId = new JLabel("---");
        userInfoPanel.add((Component)lblRegistryUserId, new GridBagConstraints(6, 0, 1, 1, 0.7, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JCheckBox ckbAddPermissions = new JCheckBox();
        ckbAddPermissions.setSelected(true);
        userInfoPanel.add((Component)ckbAddPermissions, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblAddPermissions = new JLabel("Add Permissions");
        userInfoPanel.add((Component)lblAddPermissions, new GridBagConstraints(5, 1, 1, 1, 0.6, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JCheckBox ckbStandardPermissions = new JCheckBox();
        final JPanel pnlApplicationAccess = new JPanel();
        ckbStandardPermissions.setSelected(false);
        ckbStandardPermissions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pnlApplicationAccess.setVisible(!ckbStandardPermissions.isSelected());
            }
        });
        userInfoPanel.add((Component)ckbStandardPermissions, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblStandardPermissions = new JLabel("Standard");
        userInfoPanel.add((Component)lblStandardPermissions, new GridBagConstraints(7, 1, 1, 1, 0.6, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JCheckBox ckbAddToDidbase = new JCheckBox();
        ckbAddToDidbase.setSelected(true);
        userInfoPanel.add((Component)ckbAddToDidbase, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblAddToDidbase = new JLabel("Add to DIDBase");
        userInfoPanel.add((Component)lblAddToDidbase, new GridBagConstraints(5, 2, 1, 1, 0.2, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JCheckBox ckbAddToDriftbase = new JCheckBox();
        ckbAddToDriftbase.setSelected(true);
        userInfoPanel.add((Component)ckbAddToDriftbase, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel lblAddToDriftbase = new JLabel("Add to DriftBase");
        userInfoPanel.add((Component)lblAddToDriftbase, new GridBagConstraints(5, 3, 1, 1, 0.2, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        Color c1 = new Color(163, 228, 215);
        Color c2 = new Color(174, 214, 241);
        pnlApplicationAccess.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Access to GIRO Applications")));
        GridBagLayout accessLayout = new GridBagLayout();
        pnlApplicationAccess.setLayout(accessLayout);
        int k = 0;
        while (k < totalContentLines) {
            btnDbAccessPoint.add(new HashSet());
            ++k;
        }
        int i = 0;
        while (i < totalApplications) {
            Application app = Application.get(i + 1);
            int startingLineNumber = app.getStartLineNumberInAppContentList();
            JPanel p0 = new JPanel();
            p0.add(new JLabel(app.getName()));
            p0.setBackground(i % 2 == 0 ? c1 : c2);
            pnlApplicationAccess.add((Component)p0, new GridBagConstraints(0, startingLineNumber, 1, app.getAllDatabaseContents().size(), 0.3, 0.0, 17, 1, new Insets(3, 6, 3, 0), 0, 0));
            int j = 0;
            for (DatabaseContents dbContent : app.getAllDatabaseContents()) {
                final int index = startingLineNumber + j;
                UserManagerApp.ckbAccess[index] = new JCheckBox();
                UserManagerApp.btnRealTime[index] = new JButton("RT");
                btnRealTime[index].setMargin(new Insets(0, 5, 0, 5));
                btnRealTime[index].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        btnRealTime[index].setBackground(btnRealTime[index].getBackground().getRGB() != Color.GREEN.getRGB() ? Color.GREEN : NEUTRAL_COLOR);
                    }
                });
                UserManagerApp.btnWriter[index] = new JButton("W");
                btnWriter[index].setMargin(new Insets(0, 5, 0, 5));
                btnWriter[index].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        btnWriter[index].setBackground(btnWriter[index].getBackground().getRGB() != Color.GREEN.getRGB() ? Color.GREEN : NEUTRAL_COLOR);
                    }
                });
                JPanel p1 = new JPanel();
                p1.add(new JLabel(dbContent.getName()));
                p1.setBackground(i % 2 == 0 ? c1 : c2);
                pnlApplicationAccess.add((Component)p1, new GridBagConstraints(1, index, 1, 1, 0.2, 0.0, 17, 1, new Insets(3, 6, 3, 0), 0, 0));
                JPanel p3 = new JPanel();
                p3.add(btnRealTime[index]);
                p3.setBackground(i % 2 == 0 ? c1 : c2);
                pnlApplicationAccess.add((Component)p3, new GridBagConstraints(3, index, 1, 1, 0.1, 0.0, 17, 1, new Insets(3, 0, 3, 0), 0, 0));
                JPanel p4 = new JPanel();
                p4.add(btnWriter[index]);
                p4.setBackground(i % 2 == 0 ? c1 : c2);
                pnlApplicationAccess.add((Component)p4, new GridBagConstraints(4, index, 1, 1, 0.1, 0.0, 17, 1, new Insets(3, 0, 3, 0), 0, 0));
                List<AvailableDatabase> allAvailable = LgdcRegistry.getDatabaseAvailability(dbContent);
                UserManagerApp.boxDbAccessPoints[index] = Box.createVerticalBox();
                boxDbAccessPoints[index].setBackground(i % 2 == 0 ? c1 : c2);
                for (AvailableDatabase available : allAvailable) {
                    final JButton button = new JButton(available.toString());
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            button.setBackground(button.getBackground().getRGB() != Color.GREEN.getRGB() ? Color.GREEN : NEUTRAL_COLOR);
                        }
                    });
                    boxDbAccessPoints[index].add(button);
                }
                JPanel p5 = new JPanel();
                p5.add(boxDbAccessPoints[index]);
                p5.setBackground(i % 2 == 0 ? c1 : c2);
                pnlApplicationAccess.add((Component)p5, new GridBagConstraints(5, startingLineNumber + j, 1, 1, 0.4, 0.0, 17, 1, new Insets(3, 0, 3, 0), 0, 0));
                ++j;
            }
            ++i;
        }
        JScrollPane scrAccess = new JScrollPane(pnlApplicationAccess);
        JPanel pnlUserControls = new JPanel();
        GridLayout userControlsLayout = new GridLayout();
        JButton btnSearch = new JButton("Search");
        JButton btnClear = new JButton("Clear");
        JButton btnAdd = new JButton("Add user and permissions");
        JButton btnUpdate = new JButton("Update");
        JButton btnExport = new JButton("Export All");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Account acc = new Account(tfLogin.getText(), tfPassword.getText().toCharArray(), tfEMail.getText(), tfName.getText(), tfOrganization.getText());
                try {
                    int registryUserId = LgdcRegistry.findUserId(acc.getUsername());
                    if (registryUserId == -1 && ckbAddToRegistry.isSelected()) {
                        registryUserId = UserManagerApp.this.addNewUserToRegistry(acc);
                    }
                    lblRegistryUserId.setText("UID = " + registryUserId);
                    if (ckbAddToDidbase.isSelected()) {
                        UserManagerApp.this.addRetroDatabaseUser(didbaseConnection, acc);
                    }
                    if (ckbAddToDriftbase.isSelected()) {
                        UserManagerApp.this.addRetroDatabaseUser(driftbaseConnection, acc);
                    }
                    UserManagerApp.this.addUserToBackupList(acc, registryUserId);
                    if (ckbAddPermissions.isSelected()) {
                        if (ckbStandardPermissions.isSelected()) {
                            Permission permission = new Permission(tfLogin.getText(), Application.GAMBIT_EXPLORER_USERAPP, UserRole.BROWSER, false, 8);
                            LgdcRegistry.addPermission(permission);
                            permission = new Permission(tfLogin.getText(), Application.SKY6_APP, UserRole.BROWSER, false, 8);
                            LgdcRegistry.addPermission(permission);
                            permission = new Permission(tfLogin.getText(), Application.SKY6_APP, UserRole.BROWSER, false, 15);
                            LgdcRegistry.addPermission(permission);
                            permission = new Permission(tfLogin.getText(), Application.SKY6_APP, UserRole.BROWSER, false, 2);
                            LgdcRegistry.addPermission(permission);
                        } else {
                            int i = 0;
                            while (i < Application.values().length) {
                                Application app = Application.get(i + 1);
                                int startingLineNumber = app.getStartLineNumberInAppContentList();
                                int j = 0;
                                for (DatabaseContents dbContent : app.getAllDatabaseContents()) {
                                    int index = startingLineNumber + j++;
                                    int k = 0;
                                    while (k < boxDbAccessPoints[index].getComponentCount()) {
                                        JButton theButton = (JButton)boxDbAccessPoints[index].getComponent(k);
                                        if (theButton.getBackground().getRGB() != NEUTRAL_COLOR.getRGB()) {
                                            String text = theButton.getText();
                                            int dbCredentialsId = Integer.valueOf(text.substring(0, 2));
                                            Permission permission = new Permission(tfLogin.getText(), app, btnWriter[index].getBackground().getRGB() != NEUTRAL_COLOR.getRGB() ? UserRole.EXPERT : UserRole.BROWSER, btnRealTime[index].getBackground().getRGB() != NEUTRAL_COLOR.getRGB(), dbCredentialsId);
                                            System.out.println(String.valueOf(permission.toString()) + " content:" + dbContent.getName());
                                            LgdcRegistry.addPermission(permission);
                                        }
                                        ++k;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        pnlUserControls.add(btnSearch);
        pnlUserControls.add(btnClear);
        pnlUserControls.add(btnAdd);
        pnlUserControls.add(btnUpdate);
        pnlUserControls.add(btnExport);
        pnlUserControls.setLayout(userControlsLayout);
        mainPanel.add(userInfoPanel);
        mainPanel.add(pnlUserControls);
        mainPanel.add(scrAccess);
        this.add(mainPanel);
        this.setTitle("GIRO Registry User Manager");
        this.setSize(1000, 1200);
        this.setVisible(true);
    }

    protected int addNewUserToRegistry(Account acc) throws SQLException {
        int userId = LgdcRegistry.findUserId(acc.getUsername());
        if (userId == -1) {
            LgdcRegistry.addUser(acc);
            userId = LgdcRegistry.findUserId(acc.getUsername());
            Console.showMsg("Succesffuly added user to Registry, new ID is " + userId);
        } else {
            Console.showWarn("Existing user found unders this login name, userID is " + userId);
        }
        return userId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addUserToBackupList(Account acc, int userId) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileWriter fw = new FileWriter(USERLIST_FILENAME, true);
                try {
                    block20: {
                        BufferedWriter bw = new BufferedWriter(fw);
                        try {
                            try (PrintWriter out = new PrintWriter(bw);){
                                out.println("====================");
                                out.println("#" + userId);
                                out.println(acc.getUsername());
                                out.println(new String(acc.getPass()));
                                out.println(acc.getEmail());
                                out.println(acc.getContactPerson());
                                out.println(acc.getOrganization());
                            }
                            if (bw == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bw == null) throw throwable;
                            bw.close();
                            throw throwable;
                        }
                        bw.close();
                    }
                    if (fw == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                fw.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addRetroDatabaseUser(DBConnect dbConnect, Account acc) {
        String commandAdd = "CREATE USER " + acc.getUsername() + " PASSWORD " + "'" + new String(acc.getPass()) + "' FIRSTNAME '" + acc.getOrganization() + "' LASTNAME '" + acc.getEmail() + "'";
        String commandRole = "GRANT COMMON TO " + acc.getUsername();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                Connection connection = dbConnect.getConnection();
                try {
                    try (Statement statement = connection.createStatement();){
                        statement.execute(commandAdd);
                        statement.execute(commandRole);
                        if (!dbConnect.getRequisites().isFirebird()) {
                            dbConnect.commit();
                        }
                        Console.showMsg("Successful addition of user to " + dbConnect.getRequisites().getHost());
                    }
                    if (connection == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (connection == null) throw throwable;
                    connection.close();
                    throw throwable;
                }
                connection.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("violation of PRIMARY")) {
                Console.showWarn("User " + acc.getUsername() + " exists already");
                return;
            }
            Console.showError("Adding " + dbConnect.getRequisites().getTitle() + " user failed");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UserManagerApp app = new UserManagerApp();
        app.setDefaultCloseOperation(2);
    }
}

