/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.api;

import edu.uml.lgdc.format.Formatter;
import java.util.Objects;

public class AvailableDatabase {
    private final int dbCredentialId;
    private final String title;
    private final String protocol;
    private final String host;
    private final String username;

    public AvailableDatabase(int dbCredentialId, String title, String protocol, String host, String username) {
        this.dbCredentialId = dbCredentialId;
        this.title = Objects.requireNonNull(title);
        this.protocol = Objects.requireNonNull(protocol).trim();
        this.host = Objects.requireNonNull(host).trim();
        this.username = Objects.requireNonNull(username).trim();
    }

    public int getDbCredentialId() {
        return this.dbCredentialId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return Formatter.format("%02d: %s@%s | %s", this.dbCredentialId, this.username, this.host, this.protocol);
    }
}

