/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.api;

import edu.uml.lgdc.appuserdb.UserDbConnectSettings;
import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.appuserdb.api.AvailableDatabase;
import edu.uml.lgdc.appuserdb.api.UserCredentials;
import edu.uml.lgdc.appuserdb.api.UserRole;
import edu.uml.lgdc.appuserdb.api.UserState;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.appuserdb.type.Account;
import edu.uml.lgdc.appuserdb.type.Permission;
import edu.uml.lgdc.database.ConnectionRequisites;
import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseContents;
import edu.uml.lgdc.database.DatabaseFarm;
import edu.uml.lgdc.database.FirebirdUtil;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.OptionsIOini;
import edu.uml.lgdc.security.SecUtils;
import edu.uml.lgdc.security.UserPass;
import edu.uml.lgdc.security.UserPassRole;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class LgdcRegistry {
    public static final String URL_REGISTRY_SERVLET;
    private static final boolean deployment = true;
    private static DBConnect registrarDbConnect;
    private static final SecureRandom secureRandom;
    private static int dbErrorHandlingMode;
    private static final int TMP_PASS_TIME_PERIOD_SEC = 3600;
    static final int HASH_LENGTH = 64;
    public static final String START_USER_EXCEPTION = "LGDC: user ";
    public static final String START_GUEST_EXCEPTION = "LGDC: guest ";
    private static final Map<ApplicationPassport, DatabaseFarm> databaseFarms;
    private static final Map<DatabaseContents, List<AvailableDatabase>> databaseAvailability;
    public static final String QUERY_GET_DBCREDS_START = "SELECT d.AllContent AS \"AllContents\", ur.Name AS \"RoleName\", p.RealTimeOK AS \"RealTime\", d.Ident AS \"DBId\", d.DbTitle AS \"Title\", d.Protocol AS \"Protocol\", d.Host AS \"Host\", d.DbFile AS \"File\", dc.DbUser AS \"DbUser\", dc.DbPass AS \"DbPass\", dc.dbRole AS \"DbRole\", d.Driver AS \"Driver\" FROM Permission p JOIN Application a ON p.AppId=a.Ident JOIN UserRole ur ON p.UserRoleId=ur.Ident JOIN DbCredential dc ON p.DbCredId=dc.Ident JOIN DatabaseFarm d ON dc.DbId=d.Ident WHERE a.Name='";
    public static final String QUERY_GET_DBCREDS_END = " ORDER BY d.ContentId";

    static {
        registrarDbConnect = null;
        secureRandom = new SecureRandom();
        dbErrorHandlingMode = 3;
        URL_REGISTRY_SERVLET = "https://lgdc.uml.edu/registry/login";
        databaseFarms = new HashMap<ApplicationPassport, DatabaseFarm>(5);
        databaseAvailability = new TreeMap<DatabaseContents, List<AvailableDatabase>>();
    }

    public static int getDbErrorHandlingMode() {
        return dbErrorHandlingMode;
    }

    public static void setDbErrorHandlingMode(int dbErrorHandlingMode) {
        LgdcRegistry.dbErrorHandlingMode = dbErrorHandlingMode;
    }

    public static synchronized int userLogin(String username, char[] password, String ipAddress, Application application, String appVersion, String osName) throws SQLException {
        if (registrarDbConnect == null) {
            throw new RuntimeException("User login without established connection to Registry");
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection registryConnection = registrarDbConnect.getConnection();){
            LgdcRegistry.fillDatabaseAvailability(registryConnection);
            UserState userState = LgdcRegistry.getUserStatus(registryConnection, username);
            switch (userState) {
                case NORMAL: {
                    int userId = LgdcRegistry.queryUserId(registryConnection, username, password);
                    if (userId == -1) {
                        throw new SQLException(START_USER_EXCEPTION + username + " password is incorrect");
                    }
                    int appId = LgdcRegistry.findApplication(registryConnection, application);
                    LgdcRegistry.recordUserConnection(registryConnection, userId, ipAddress, appId, appVersion, osName);
                    return userId;
                }
                case NOT_EXISTS: {
                    throw new SQLException(START_USER_EXCEPTION + username + " registration not found in the LGDC Registry");
                }
                case LOCKED: {
                    throw new SQLException(START_USER_EXCEPTION + username + " is locked for access, please contact LGDC for more information.");
                }
                case TEMP_PASS: {
                    throw new SQLException("LGDC: user confirmation needed; please sign in using given temporary password, then set new password, and sign in again using new password");
                }
                case TEMP_PASS_EXPIRED: {
                    throw new SQLException("LGDC: temporary password is now expired. Please request another temporary password from LGDC.");
                }
            }
            throw new RuntimeException("Design error: overlooked choice of enum " + ((Object)((Object)userState)).getClass().getSimpleName() + ", " + (Object)((Object)userState));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UserState getUserStatus(Connection connection, String username) throws SQLException {
        UserState userState;
        Throwable throwable;
        boolean update;
        block26: {
            update = false;
            String query = "SELECT Locked, TmpPass, TmpPassTime FROM AppUser WHERE name='" + username + "'";
            Throwable throwable2 = null;
            throwable = null;
            try {
                Statement statement = connection.createStatement();
                try {
                    block25: {
                        try (ResultSet rs = statement.executeQuery(query);){
                            if (rs.next()) {
                                boolean locked = rs.getInt(1) != 0;
                                String tmpPass = rs.getString(2);
                                if (rs.wasNull()) {
                                    tmpPass = null;
                                }
                                TimeScale tmpPassTime = FirebirdUtil.getTime(rs, 3);
                                if (locked) {
                                    userState = UserState.LOCKED;
                                    break block25;
                                }
                                if (tmpPass == null) {
                                    userState = UserState.NORMAL;
                                    break block25;
                                }
                                if (tmpPass.length() == 0 || new TimeScale().diffWholeIn(13, tmpPassTime) > 3600L) {
                                    userState = UserState.TEMP_PASS_EXPIRED;
                                    if (tmpPass.length() == 0) {
                                        update = true;
                                    }
                                    break block25;
                                }
                                userState = UserState.TEMP_PASS;
                                break block25;
                            }
                            userState = UserState.NOT_EXISTS;
                        }
                    }
                    if (statement == null) break block26;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    if (statement == null) throw throwable2;
                    statement.close();
                    throw throwable2;
                }
                statement.close();
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                    throw throwable2;
                }
                if (throwable2 == throwable4) throw throwable2;
                throwable2.addSuppressed(throwable4);
                throw throwable2;
            }
        }
        if (!update) return userState;
        String sql = "UPDATE AppUser SET TmpPass='', TmpPassTime=NULL WHERE name='" + username + "'";
        throwable = null;
        Object var7_10 = null;
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(sql);
            return userState;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private static int findApplication(Connection connection, Application application) throws SQLException {
        String query = "SELECT Ident FROM Application WHERE name='" + Objects.requireNonNull(application).getName() + "'";
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ResultSet rs;
            Statement statement;
            block16: {
                int n;
                block18: {
                    block17: {
                        statement = connection.createStatement();
                        rs = statement.executeQuery(query);
                        if (!rs.next()) break block16;
                        n = rs.getInt(1);
                        if (rs == null) break block17;
                        rs.close();
                    }
                    if (statement == null) break block18;
                    statement.close();
                }
                return n;
            }
            try {
                throw new SQLException("LGDC: application " + application.getName() + " has not been registered in the user database.");
                {
                    catch (Throwable throwable2) {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private static int queryUserId(Connection connection, String username, char[] password) throws SQLException {
        String query = "SELECT Ident, Salt, HashedPass FROM AppUser WHERE name='" + username + "'";
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            int n;
            ResultSet rs;
            Statement statement;
            block20: {
                block19: {
                    statement = connection.createStatement();
                    rs = statement.executeQuery(query);
                    int userId = -1;
                    if (rs.next()) {
                        userId = rs.getInt(1);
                        byte[] salt = rs.getBlob(2).getBytes(1L, 64);
                        byte[] storedPasswordHash = rs.getBlob(3).getBytes(1L, 64);
                        try {
                            byte[] toCompare = SecUtils.getSHA512(password, salt);
                            if (!Arrays.equals(storedPasswordHash, toCompare)) {
                                userId = -1;
                            }
                        }
                        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
                            throw new SQLException(ex);
                        }
                    }
                    n = userId;
                    if (rs == null) break block19;
                    rs.close();
                }
                if (statement == null) break block20;
                statement.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void recordUserConnection(Connection connection, int userId, String ipAddress, int appId, String appVersion, String osName) throws SQLException {
        String destination = "INSERT INTO LogActivity(AppId, UserId,IpNumber,TimeUT";
        String values = ") VALUES(" + appId + ", " + userId + ", '" + ipAddress + "', '" + new TimeScale().toTimestamp() + "'";
        if (appVersion != null) {
            destination = String.valueOf(destination) + ",AppVersion";
            values = String.valueOf(values) + ", '" + appVersion + "'";
        }
        if (osName != null) {
            destination = String.valueOf(destination) + ",osName";
            values = String.valueOf(values) + ", '" + osName + "'";
        }
        String update = String.valueOf(destination) + values + ")";
        Throwable throwable = null;
        Object var10_11 = null;
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(update);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void addUser(Account acc) throws SQLException {
        LgdcRegistry.addUser(acc.getUsername(), acc.getPass(), acc.getEmail(), acc.getContactPerson(), acc.getOrganization());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addUser(String name, char[] password, String eMail, String contactName, String organization) throws SQLException {
        byte[] hashedPassword;
        byte[] salt = LgdcRegistry.getSaltRandomly();
        try {
            hashedPassword = SecUtils.getSHA512(password, salt);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new SQLException(ex);
        }
        String query = "INSERT INTO AppUser (Name,HashedPass,Salt,Email,ContactName,Organization) VALUES ('" + name + "',?,?,'" + eMail + "','" + contactName + "','" + organization + "')";
        ByteArrayInputStream isHashedPassword = new ByteArrayInputStream(hashedPassword);
        ByteArrayInputStream isSalt = new ByteArrayInputStream(salt);
        Throwable throwable = null;
        Object var11_13 = null;
        try {
            Connection registryConnection = registrarDbConnect.getConnection();
            try {
                try (PreparedStatement prepStatement = registryConnection.prepareStatement(query);){
                    prepStatement.setBinaryStream(1, (InputStream)isHashedPassword, 64);
                    prepStatement.setBinaryStream(2, (InputStream)isSalt, 64);
                    prepStatement.executeUpdate();
                }
                if (registryConnection == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (registryConnection == null) throw throwable;
                registryConnection.close();
                throw throwable;
            }
            registryConnection.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static byte[] getSaltRandomly() {
        byte[] bytes = new byte[64];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    public static void addPermission(Permission permission) throws SQLException {
        LgdcRegistry.addPermission(permission.getUsername(), permission.getApplication(), permission.getUserRole(), permission.getRealtimeOK(), permission.getDbCredentialsId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addPermission(String username, Application application, UserRole role, boolean realtime, int dbCredentialsId) throws SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Connection registryConnection = registrarDbConnect.getConnection();
            try {
                try (Statement statement = registryConnection.createStatement();){
                    int appId = LgdcRegistry.findApplication(registryConnection, application);
                    int userId = LgdcRegistry.findUserId(registryConnection, username);
                    Console.showMsg("UserID is " + userId);
                    String update = "INSERT INTO Permission (AppId,UserId,UserRoleId,RealTimeOK,DbCredId) VALUES (" + appId + "," + userId + "," + role.getId() + "," + (realtime ? "1" : "0") + "," + dbCredentialsId + ")";
                    statement.executeUpdate(update);
                }
                if (registryConnection == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (registryConnection == null) throw throwable;
                registryConnection.close();
                throw throwable;
            }
            registryConnection.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private static int findUserId(Connection registryConnection, String username) throws SQLException {
        String query = "SELECT Ident FROM AppUser WHERE name='" + username + "'";
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ResultSet rs;
            Statement statement;
            block16: {
                int n;
                block18: {
                    block17: {
                        statement = registryConnection.createStatement();
                        rs = statement.executeQuery(query);
                        if (!rs.next()) break block16;
                        n = rs.getInt(1);
                        if (rs == null) break block17;
                        rs.close();
                    }
                    if (statement == null) break block18;
                    statement.close();
                }
                return n;
            }
            try {
                throw new SQLException("LGDC: user \"" + username + "\" is unknown.");
                {
                    catch (Throwable throwable2) {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public static int findUserId(String username) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String loadUserSettings(String username, Application application) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saveUserSettings(String username, Application application, String settings) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection registryConnection = registrarDbConnect.getConnection();){
            int appId = LgdcRegistry.findApplication(registryConnection, application);
            int userId = LgdcRegistry.findUserId(registryConnection, username);
            settings = settings == null ? "" : settings.trim();
            String sql = "UPDATE Permission SET Settings=? WHERE UserId=" + userId + " AND AppId=" + appId;
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (PreparedStatement pstmt = registryConnection.prepareStatement(sql);){
                CharArrayReader reader = new CharArrayReader(settings.toCharArray());
                pstmt.setClob(1, reader);
                pstmt.executeUpdate();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static DBConnect setupRegistryAsRegistrar(String iniFilename) throws SQLException, ParseException {
        return LgdcRegistry.setupRegistryAsRegistrar(LgdcRegistry.getUserDbConnectSettings(iniFilename));
    }

    public static DBConnect setupRegistryAsAdministrator(String iniFilename) throws SQLException, ParseException {
        return LgdcRegistry.setupRegistryAsAdministrator(LgdcRegistry.getUserDbConnectSettings(iniFilename));
    }

    public static DBConnect setupRegistryAsRegistrar(UserDbConnectSettings userDbConnectSettings) throws SQLException, ParseException {
        String pass;
        String url = userDbConnectSettings.getUrl();
        UserPassRole registrar = userDbConnectSettings.getRegistrar();
        String user = registrar.getUser();
        String string = pass = registrar.getPass() != null ? new String(registrar.getPass()) : null;
        if (user.isEmpty() && pass == null) {
            String[] userPass = LgdcRegistry.getUserPass("enter registrar credential");
            user = userPass[0];
            pass = userPass[1];
        }
        ConnectionRequisites reqs = new ConnectionRequisites("Registry", url, user, pass, registrar.getRole(), userDbConnectSettings.getDriver());
        registrarDbConnect = new DBConnect(reqs, DatabaseContents.NONE.getId(), -1);
        LgdcRegistry.fillDatabaseAvailability(registrarDbConnect.getConnection());
        return registrarDbConnect;
    }

    private static DBConnect setupRegistryAsAdministrator(UserDbConnectSettings userDbConnectSettings) throws SQLException, ParseException {
        String pass;
        String url = userDbConnectSettings.getUrl();
        UserPassRole admin = userDbConnectSettings.getAdministrator();
        String user = admin.getUser();
        String string = pass = admin.getPass() != null ? new String(admin.getPass()) : null;
        if (user.isEmpty() && pass == null) {
            String[] userPass = LgdcRegistry.getUserPass("Enter administrator credential");
            user = userPass[0];
            pass = userPass[1];
        }
        ConnectionRequisites reqs = new ConnectionRequisites("Registry", url, user, pass, admin.getRole(), userDbConnectSettings.getDriver());
        DBConnect dbconnect = new DBConnect(reqs, DatabaseContents.NONE.getId(), -1);
        return dbconnect;
    }

    public static UserDbConnectSettings getUserDbConnectSettings(String iniFilename) {
        UserDbConnectSettings userDbConnectSettings = new UserDbConnectSettings();
        HashMap allDescriptors = new HashMap();
        allDescriptors.put(userDbConnectSettings.getName(), userDbConnectSettings);
        new OptionsIOini(allDescriptors, iniFilename);
        return userDbConnectSettings;
    }

    private static String[] getUserPass(String title) {
        UserPass userPass = UserPass.ask("enter registrar credential");
        if (userPass != null) {
            String user = userPass.getUser();
            String pass = userPass.getPass() != null ? new String(userPass.getPass()) : null;
            return new String[]{user, pass};
        }
        throw new RuntimeException("user/pass not specified");
    }

    private static void recordGuestConnection(Connection connection, int guestId, String ipAddress, int appId, String appVersion, String osName) throws SQLException {
        String destination = "INSERT INTO LogActivity(AppId,GuestId,IpNumber,TimeUT";
        String values = ") VALUES(" + appId + ", " + guestId + ", '" + ipAddress + "', '" + new TimeScale().toTimestamp() + "'";
        if (appVersion != null) {
            destination = String.valueOf(destination) + ",AppVersion";
            values = String.valueOf(values) + ", '" + appVersion + "'";
        }
        if (osName != null) {
            destination = String.valueOf(destination) + ",osName";
            values = String.valueOf(values) + ", '" + osName + "'";
        }
        String update = String.valueOf(destination) + values + ")";
        Throwable throwable = null;
        Object var10_11 = null;
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(update);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static int guestLogin(String email, String organization, String ipAddress, Application application, String appVersion, String osName) throws SQLException {
        block11: {
            if (registrarDbConnect == null) {
                throw new RuntimeException("User login without established connection to Registry");
            }
            Throwable throwable = null;
            Object var7_8 = null;
            Connection registryConnection = registrarDbConnect.getConnection();
            try {
                int guestId = LgdcRegistry.queryGuest(registryConnection, email, organization);
                if (guestId == -1) {
                    guestId = LgdcRegistry.addGuestRegistration(registryConnection, email, organization);
                }
                int appId = LgdcRegistry.findApplication(registryConnection, application);
                LgdcRegistry.recordGuestConnection(registryConnection, guestId, ipAddress, appId, appVersion, osName);
                if (registryConnection == null) break block11;
            }
            catch (Throwable throwable2) {
                try {
                    if (registryConnection != null) {
                        registryConnection.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            registryConnection.close();
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    private static int queryGuest(Connection connection, String email, String organization) throws SQLException {
        String query = "SELECT Ident FROM AppGuest WHERE organization='" + organization + "' AND email='" + email + "'";
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            int n;
            ResultSet rs;
            Statement statement;
            block16: {
                block15: {
                    statement = connection.createStatement();
                    rs = statement.executeQuery(query);
                    n = rs.next() ? rs.getInt(1) : -1;
                    if (rs == null) break block15;
                    rs.close();
                }
                if (statement == null) break block16;
                statement.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static int addGuestRegistration(Connection connection, String email, String organization) throws SQLException {
        String query = "INSERT INTO AppGuest (Email, Organization) VALUES ('" + email + "','" + organization + "')";
        Throwable throwable = null;
        Object var5_6 = null;
        try (Statement statement = connection.createStatement();){
            statement.execute(query);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return LgdcRegistry.queryGuest(connection, email, organization);
    }

    /*
     * Exception decompiling
     */
    public static String loadGuestSettings(Application application) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saveGuestSettings(Application application, String settings) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection registryConnection = registrarDbConnect.getConnection();){
            int appId = LgdcRegistry.findApplication(registryConnection, application);
            settings = settings == null ? "" : settings.trim();
            String sql = "UPDATE Permission SET Settings=? WHERE UserId IS NULL AND AppId=" + appId;
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (PreparedStatement pstmt = registryConnection.prepareStatement(sql);){
                CharArrayReader reader = new CharArrayReader(settings.toCharArray());
                pstmt.setClob(1, reader);
                pstmt.executeUpdate();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fillDatabaseAvailability(Connection registryConnection) throws SQLException {
        databaseAvailability.clear();
        Application[] applicationArray = Application.values();
        int n = applicationArray.length;
        int n2 = 0;
        block7: while (n2 < n) {
            Application app = applicationArray[n2];
            Iterator<DatabaseContents> iterator = app.getAllDatabaseContents().iterator();
            while (true) {
                ArrayList<AvailableDatabase> availableDatabases;
                DatabaseContents appContents;
                block18: {
                    if (!iterator.hasNext()) {
                        ++n2;
                        continue block7;
                    }
                    appContents = iterator.next();
                    String sql = "SELECT D.Ident, F.AllContent, F.DbTitle, F.Protocol, F.Host, F.DbFile, D.DbUser, D.DbPass, D.DbRole, F.Driver FROM DbCredential D, DatabaseFarm F WHERE D.DbId=F.Ident";
                    availableDatabases = new ArrayList<AvailableDatabase>();
                    Throwable throwable = null;
                    Object var10_11 = null;
                    try {
                        Statement stmt = registryConnection.createStatement();
                        try {
                            try (ResultSet rs = stmt.executeQuery(sql);){
                                while (rs.next()) {
                                    int databaseCredentialsId = rs.getInt(1);
                                    long allContents = rs.getLong(2);
                                    if (!appContents.isIncluded(allContents)) continue;
                                    String title = rs.getString(3);
                                    String protocol = rs.getString(4);
                                    String host = rs.getString(5);
                                    String file = rs.getString(6);
                                    String login = rs.getString(7);
                                    String pass = rs.getString(8);
                                    String role = rs.getString(9);
                                    String driver = rs.getString(10);
                                    availableDatabases.add(new AvailableDatabase(databaseCredentialsId, title, protocol, host, login));
                                }
                            }
                            if (stmt == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (stmt == null) throw throwable;
                            stmt.close();
                            throw throwable;
                        }
                        stmt.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                databaseAvailability.put(appContents, availableDatabases);
            }
            break;
        }
        return;
    }

    public static List<AvailableDatabase> getDatabaseAvailability(DatabaseContents contents) {
        for (Map.Entry<DatabaseContents, List<AvailableDatabase>> entry : databaseAvailability.entrySet()) {
            if (!entry.getKey().isIncluded(contents.getId())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static synchronized Map<ApplicationPassport, DatabaseFarm> buildDatabaseFarmsByUrl(Application application, UserCredentials userCreds, String appVersion, String osName) throws SQLException {
        if (userCreds.isGuest()) {
            return LgdcRegistry.buildDatabaseFarms(application, userCreds, String.valueOf(URL_REGISTRY_SERVLET) + "?app=" + application.getName() + "&e=" + userCreds.getGuestEmail() + "&a=" + userCreds.getGuestAffiliation() + "&v=" + appVersion + "&o=" + osName);
        }
        return LgdcRegistry.buildDatabaseFarms(application, userCreds, String.valueOf(URL_REGISTRY_SERVLET) + "?app=" + application.getName() + "&n=" + userCreds.getUserLogin() + "&w=" + userCreds.getUserPassword() + "&v=" + appVersion + "&o=" + osName);
    }

    private static Map<ApplicationPassport, DatabaseFarm> buildDatabaseFarms(Application application, UserCredentials userCreds, String URL2) {
        HashMap<ApplicationPassport, DatabaseFarm> farms = new HashMap<ApplicationPassport, DatabaseFarm>(3);
        try {
            String inputLine;
            String encodedURL = URL2.replaceAll(" ", "+");
            URL link2userdb = new URL(encodedURL);
            URLConnection conn = link2userdb.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            DatabaseFarm databaseFarm = new DatabaseFarm();
            ApplicationPassport appPassport = null;
            while ((inputLine = br.readLine()) != null) {
                if (inputLine.startsWith("#") || inputLine.startsWith("<")) continue;
                String[] tokens = inputLine.split("\\s*=\\s*");
                if (tokens.length != 6) {
                    Console.showError("Call to LGDC Registry returned reply of unknown format, skipping the line");
                    continue;
                }
                int userId = Integer.parseInt(tokens[0]);
                long allContents = Long.parseLong(tokens[1]);
                UserRole applicationRole = UserRole.get(tokens[2].trim());
                if (applicationRole == null) {
                    Console.showError("LGDC Registry provided unknown Role for application " + application.getName());
                    continue;
                }
                boolean realtime = Integer.parseInt(tokens[3]) == 1;
                int databaseId = Integer.parseInt(tokens[4]);
                ConnectionRequisites requisites = ConnectionRequisites.parse(tokens[5]);
                DBConnect newConnect = new DBConnect(requisites, allContents, databaseId);
                if (appPassport == null) {
                    appPassport = new ApplicationPassport(application, applicationRole, realtime, userId, userCreds);
                    databaseFarms.put(appPassport, databaseFarm);
                }
                databaseFarm.addConnect(newConnect);
            }
        }
        catch (MalformedURLException e) {
            Console.showError("Malformed URL to LGDC user authentication service");
        }
        catch (IOException e) {
            String errorMessage = e.getMessage();
            String pattern = "response code: ";
            int codePos = errorMessage.indexOf(pattern);
            if (codePos > 0) {
                int code = Integer.valueOf(errorMessage.substring(codePos + pattern.length(), codePos + pattern.length() + 3).trim());
                Console.showError("LGDC user authentication service reported internal error " + code);
            }
            Console.showError("LGDC user authentication service is inaccessible...\n" + errorMessage);
        }
        LgdcRegistry.addDatabaseFarms(farms);
        return farms;
    }

    public static synchronized void addDatabaseFarm(ApplicationPassport newPassport, DatabaseFarm newFarm) {
        if (newPassport.getApplication() == null) {
            Console.showError("Attempt to register database for unknown application");
        } else {
            if (databaseFarms.containsKey(newPassport)) {
                Console.showError("LGDC LOGIN: Attempting to add another farm to " + (Object)((Object)newPassport.getApplication()));
                DatabaseFarm oldFarm = databaseFarms.get(newPassport);
                for (DBConnect dbconnect : oldFarm.getAllDatabases()) {
                    if (dbconnect == null) continue;
                    dbconnect.close();
                }
                oldFarm.clear();
                databaseFarms.remove(oldFarm);
                Object var2_2 = null;
            }
            databaseFarms.put(newPassport, newFarm);
        }
    }

    private static synchronized void addDatabaseFarms(Map<ApplicationPassport, DatabaseFarm> farms) {
        for (Map.Entry<ApplicationPassport, DatabaseFarm> newEntry : farms.entrySet()) {
            ApplicationPassport newPassport = newEntry.getKey();
            DatabaseFarm newFarm = newEntry.getValue();
            LgdcRegistry.addDatabaseFarm(newPassport, newFarm);
        }
    }

    public static boolean activateDatabaseFarms(ApplicationPassport appPassport, Map<DatabaseContents, Integer> preferredDatabases) {
        if (!databaseFarms.containsKey(appPassport)) {
            return false;
        }
        DatabaseFarm farm = databaseFarms.get(appPassport);
        farm.activateDefaultConnections();
        return true;
    }

    public static Map<ApplicationPassport, DatabaseFarm> getDatabaseFarms() {
        return databaseFarms;
    }

    public static ApplicationPassport lookupApplicationPassport(DatabaseFarm myFarm) {
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            DatabaseFarm farm = oneFarm.getValue();
            if (!farm.equals(myFarm)) continue;
            return oneFarm.getKey();
        }
        return null;
    }

    public static DatabaseFarm lookupDatabaseFarm(ApplicationPassport myPassport, long allContents, boolean onlyActiveOnes) {
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            DatabaseFarm farm;
            ApplicationPassport appPassport = oneFarm.getKey();
            if (!appPassport.equals(myPassport) || ((farm = oneFarm.getValue()).getAllContents(onlyActiveOnes) & allContents) != allContents) continue;
            return farm;
        }
        return null;
    }

    public static DatabaseFarm lookupDatabaseFarm(Application application, DatabaseContents content) {
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            ApplicationPassport appPassport = oneFarm.getKey();
            DatabaseFarm farm = oneFarm.getValue();
            if (appPassport.getApplication() != application || !farm.isAvailable(content)) continue;
            return farm;
        }
        return null;
    }

    public static Map<ApplicationPassport, DatabaseFarm> getDatabaseFarms(Application application) {
        HashMap<ApplicationPassport, DatabaseFarm> farms = new HashMap<ApplicationPassport, DatabaseFarm>();
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            DatabaseFarm farm = oneFarm.getValue();
            ApplicationPassport appPassport = oneFarm.getKey();
            if (appPassport.getApplication() != application) continue;
            farms.put(appPassport, farm);
        }
        return farms;
    }

    public static DatabaseFarm getDatabaseFarm(Application application, DatabaseContents content, UserRole role) {
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            DatabaseFarm farm;
            ApplicationPassport appPassport = oneFarm.getKey();
            if (appPassport.getApplication() != application || appPassport.getRole() != role || !(farm = oneFarm.getValue()).isAvailable(content)) continue;
            return farm;
        }
        return null;
    }

    public static void releaseDatabaseFarms(ApplicationPassport myPassport) {
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            ApplicationPassport appPassport = oneFarm.getKey();
            if (appPassport != myPassport) continue;
            oneFarm.getValue().close();
            databaseFarms.remove(appPassport);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isRealtimeAllowed(Application application, int userId, UserRole userRole) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isRealtimeAllowed(Application application, DatabaseFarm farm) {
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            ApplicationPassport appPassport = oneFarm.getKey();
            DatabaseFarm thisfarm = oneFarm.getValue();
            if (appPassport.getApplication() != application || !farm.equals(thisfarm)) continue;
            return appPassport.realtimePermitted();
        }
        return false;
    }

    public static Connection getRegistrarConnection() throws SQLException {
        if (registrarDbConnect == null) {
            throw new RuntimeException("Registrar connection request without Registry pool");
        }
        return registrarDbConnect.getConnection();
    }

    public static String reportAllConnections() {
        String output = "";
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            ApplicationPassport appPassport = oneFarm.getKey();
            DatabaseFarm thisfarm = oneFarm.getValue();
            Map<DatabaseContents, Integer> activeConnections = thisfarm.getActiveConnections();
            List<DBConnect> connectFarm = thisfarm.getAllDatabases();
            for (Map.Entry<DatabaseContents, Integer> oneConnection : activeConnections.entrySet()) {
                DatabaseContents contents = oneConnection.getKey();
                int index = oneConnection.getValue();
                DBConnect connect = connectFarm.get(index);
                output = String.valueOf(output) + "Application " + (Object)((Object)appPassport.getApplication()) + " in role " + (Object)((Object)appPassport.getRole()) + " for " + (Object)((Object)contents) + " and DB #" + connect.getDatabaseId() + " (" + connect.getRequisites().getProtocol() + ")\n";
            }
        }
        return output;
    }

    public static void releaseAllResources() {
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : databaseFarms.entrySet()) {
            ApplicationPassport appPassport = oneFarm.getKey();
            DatabaseFarm farm = oneFarm.getValue();
            Console.showMsg("Releasing resources of " + (Object)((Object)appPassport.getApplication()) + " farm in " + (Object)((Object)appPassport.getRole()) + " role.");
            farm.close();
            farm.clear();
        }
        databaseFarms.clear();
        if (registrarDbConnect != null) {
            registrarDbConnect.close();
        }
    }
}

