/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.api;

import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.project.Console;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class UserCredentials {
    public static final String USER_LOGIN = "UserLogin";
    public static final String USER_PASSWORD = "UserPassword";
    public static final String GUEST_EMAIL = "GuestEmail";
    public static final String GUEST_AFF = "GuestAffiliation";
    public static final String USER_HOST = "UserHost";
    private final Map<String, String> userCredentials = new HashMap<String, String>();

    public void read(Application application, File guestFile, File userFile) throws FileNotFoundException {
        FileInputStream guestFis = null;
        FileInputStream userFis = null;
        if (guestFile != null && guestFile.isFile()) {
            guestFis = new FileInputStream(guestFile);
        }
        if (userFile != null && userFile.isFile()) {
            userFis = new FileInputStream(userFile);
        }
        if (userFis == null && guestFis == null) {
            throw new RuntimeException("Connection credentials are not defined for " + application.getName() + "; cannot continue...");
        }
        this.read(application, guestFis, userFis);
        this.userCredentials.put(USER_HOST, this.readMyHostInformation());
        this.validate();
    }

    public String readMyHostInformation() {
        String ipAddress = "";
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            ipAddress = "IP";
            while (n.hasMoreElements()) {
                NetworkInterface e = n.nextElement();
                Enumeration<InetAddress> a = e.getInetAddresses();
                while (a.hasMoreElements()) {
                    InetAddress addr = a.nextElement();
                    if (addr.getHostAddress().contains(":") || addr.getHostAddress().contains("127.")) continue;
                    ipAddress = String.valueOf(ipAddress) + ":" + addr.getHostAddress();
                }
            }
        }
        catch (SocketException e1) {
            Console.showError("Local network request of host information failed");
        }
        return ipAddress;
    }

    private void validate() {
        if (this.isGuest()) {
            try {
                InternetAddress email = new InternetAddress(this.getGuestEmail());
                email.validate();
            }
            catch (AddressException e) {
                Console.showError("Guest email does not pass syntax validation. Please retry");
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private void read(Application application, InputStream isGuest, InputStream isUser) {
        this.userCredentials.clear();
        try {
            this.read(isUser, this.userCredentials, USER_LOGIN, USER_PASSWORD);
        }
        catch (IOException e) {
            Console.showWarn("Registered user credentials are not specified, defaulting to the guest access");
        }
        try {
            this.read(isGuest, this.userCredentials, GUEST_EMAIL, GUEST_AFF);
        }
        catch (IOException e) {
            Console.showWarn("Guest credentials are not available");
        }
        if (this.userCredentials.isEmpty()) {
            throw new RuntimeException("Neither user nor guest credentials could be found for " + application.getName());
        }
    }

    public boolean isGuest() {
        return !this.userCredentials.containsKey(USER_LOGIN);
    }

    public Map<String, String> getCredentials() {
        return this.userCredentials;
    }

    public String getUserLogin() {
        return this.userCredentials.get(USER_LOGIN);
    }

    public String getUserPassword() {
        return this.userCredentials.get(USER_PASSWORD);
    }

    public String getGuestEmail() {
        return this.userCredentials.get(GUEST_EMAIL);
    }

    public String getGuestAffiliation() {
        return this.userCredentials.get(GUEST_AFF);
    }

    public String getUserHost() {
        return this.userCredentials.get(USER_HOST);
    }

    public void setUserHost(String ipAddress) {
        this.userCredentials.put(USER_HOST, ipAddress);
    }

    public void setUserCredentials(String username, String password) {
        this.userCredentials.put(USER_LOGIN, username);
        this.userCredentials.put(USER_PASSWORD, password);
        this.userCredentials.put(USER_HOST, this.readMyHostInformation());
    }

    public void set(String userLogin, String userPassword, String guestEmail, String guestAffiliation, String ipAddress) {
        this.userCredentials.clear();
        if (userLogin != null && userLogin.length() > 0) {
            this.userCredentials.put(USER_LOGIN, userLogin);
        }
        if (userPassword != null && userPassword.length() > 0) {
            this.userCredentials.put(USER_PASSWORD, userPassword);
        }
        if (guestEmail != null && guestEmail.length() > 0) {
            this.userCredentials.put(GUEST_EMAIL, guestEmail);
        }
        if (guestAffiliation != null && guestAffiliation.length() > 0) {
            this.userCredentials.put(GUEST_AFF, guestAffiliation);
        }
        if (ipAddress != null && ipAddress.length() > 0) {
            this.userCredentials.put(USER_HOST, ipAddress);
        }
    }

    private void read(InputStream is, Map<String, String> info, String firstLineKey, String secondLineKey) throws IOException {
        if (is == null) {
            return;
        }
        boolean firstItemDone = false;
        Throwable throwable = null;
        Object var8_8 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                if (firstItemDone) {
                    info.put(secondLineKey, line);
                    break;
                }
                info.put(firstLineKey, line);
                firstItemDone = true;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return !this.isGuest() ? "| User account: " + this.getUserLogin() : "| Guest account: " + this.getGuestAffiliation();
    }
}

